/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoNormalEnc;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOSaldoConta
extends CoreBaseDAO {
    private final ResultTransformer SALDO_CONTABIL_RESULT_TRANSFORMER = new SaldoContabilResultTransformer();
    private final ResultTransformer MAP_RESULT_TRANSFORMER = AliasToEntityMapResultTransformer.INSTANCE;

    @Override
    public Class getVOClass() {
        return SaldoContaContabil.class;
    }

    public SaldoContaContabil findSaldoContaUnica(String codigoConta, java.util.Date dataInicial, java.util.Date dataFinal, Long idGrupoEmpresa, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldoContaOuTipoCentroResultado) {
        List<SaldoContaContabil> saldos = this.findSaldoContaContabilGeral(codigoConta, codigoConta, dataInicial, dataFinal, idGrupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldoContaOuTipoCentroResultado, EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, null);
        SaldoContaContabil res = null;
        if (saldos != null && saldos.size() > 0) {
            res = saldos.get(0);
        }
        if (res == null) {
            res = new SaldoContaContabil();
        }
        return res;
    }

    public List<SaldoContaContabil> findSaldosContaUnica(String codigoConta, java.util.Date dataInicial, java.util.Date dataFinal, Long idGrupoEmpresa, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldoContaOuTipoCentroResultado) {
        List<SaldoContaContabil> saldos = this.findSaldoContaContabilGeral(codigoConta, codigoConta, dataInicial, dataFinal, idGrupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldoContaOuTipoCentroResultado, EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, null);
        return saldos;
    }

    public SaldoContaContabil findSaldoContaUnicaEncerramento(String codigoConta, java.util.Date dataEncerramento, Long idGrupoEmpresa, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldoContaOuTipoCentroResultado) {
        List<SaldoContaContabil> saldos = this.findSaldoContaContabilGeralEncerramento(codigoConta, codigoConta, dataEncerramento, idGrupoEmpresa, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldoContaOuTipoCentroResultado, EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, null);
        SaldoContaContabil res = null;
        if (saldos != null && saldos.size() > 0) {
            res = saldos.get(0);
        }
        if (res == null) {
            res = new SaldoContaContabil();
        }
        return res;
    }

    private List findSaldoContaContabilGeral(String codContaInicial, String codContaFinal, java.util.Date dataIn, java.util.Date dataFim, Long idGrupoEmpresa, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldoPorContaCentroRes, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivelRet, ResultTransformer rs, EnumConstantsOrdenacao ordenacao, EnumConstantsTipoSaldoNormalEnc tipoSaldoNormalEnc) {
        if (dataIn == null) {
            dataIn = new java.util.Date();
        }
        if (dataFim == null) {
            dataFim = new java.util.Date();
        }
        if (tipoSaldoPorContaCentroRes == null) {
            tipoSaldoPorContaCentroRes = EnumConstantsTipoSaldo.TIPO_SALDO_GERAL;
        }
        if (tipoSaldoRet == null) {
            tipoSaldoRet = EnumConstantsTipoSaldoRetorno.TODOS_SALDOS;
        }
        if (nivelRet == null) {
            nivelRet = EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS;
        }
        if (ordenacao == null) {
            ordenacao = EnumConstantsOrdenacao.ORDEM_NUMERICA;
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select s.r_id_plano_conta as ID_PLANO_CONTA, s.r_cod_conta as COD, s.r_descricao_conta as DESCRICAO_CONTA, s.r_marca as MARCA, s.r_saldo_anterior as SALDO_ANTERIOR, s.r_valor_debito as VALOR_DEBITO, s.r_valor_credito as VALOR_CREDITO, s.r_saldo_atual as SALDO_ATUAL, s.R_COD_NAT_PLANO_CONTA COD_NAT_PLANO_CONTA from proc_saldo_contabil(:p_cod_inicial,:p_cod_final,:p_data_inicial,:p_data_final, :p_id_grupo_empresa_in,:p_id_grupo_empresa_final,:p_id_centro_resultado_in,:p_id_centro_resultado_fim, :p_tipo_saldo,:p_tipo_ret_saldo,:P_NIVEL_RET_CONTA, :p_tipo_saldo_normal_enc) s ";
        query = ordenacao == EnumConstantsOrdenacao.ORDEM_ALFABETICA ? (String)query + " order by s.r_descricao_conta" : (String)query + " order by s.r_cod_conta";
        NativeQuery q = s.createSQLQuery((String)query);
        q.setParameter("p_cod_inicial", (Object)codContaInicial);
        q.setParameter("p_cod_final", (Object)codContaFinal);
        q.setDate("p_data_inicial", (java.util.Date)new Date(dataIn.getTime()));
        q.setDate("p_data_final", (java.util.Date)new Date(dataFim.getTime()));
        q.setLong("p_id_grupo_empresa_in", idGrupoEmpresa.longValue());
        q.setLong("p_id_grupo_empresa_final", idGrupoEmpresa.longValue());
        q.setParameter("p_id_centro_resultado_in", (Object)idCentroResultadoInicial);
        q.setParameter("p_id_centro_resultado_fim", (Object)idCentroResultadoFinal);
        q.setInteger("p_tipo_saldo", tipoSaldoPorContaCentroRes.getValue());
        q.setInteger("p_tipo_ret_saldo", tipoSaldoRet.getValue());
        q.setInteger("P_NIVEL_RET_CONTA", nivelRet.getValue());
        q.setInteger("p_tipo_saldo_normal_enc", tipoSaldoNormalEnc.getValue());
        q.setResultTransformer(rs);
        return q.list();
    }

    public List<Map> findSaldoContaContabilGeralMap(String contaInicial, String contaFinal, java.util.Date dataInicial, java.util.Date dataFinal, Long identificador, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataInicial, dataFinal, identificador, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, this.MAP_RESULT_TRANSFORMER, ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_NORMAL);
    }

    public List<SaldoContaContabil> findSaldoContaContabilGeral(String contaInicial, String contaFinal, java.util.Date dataInicial, java.util.Date dataFinal, Long identificador, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataInicial, dataFinal, identificador, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, this.SALDO_CONTABIL_RESULT_TRANSFORMER, ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_NORMAL);
    }

    public List<SaldoContaContabil> findSaldoContaContabilGeralEncerramento(String contaInicial, String contaFinal, java.util.Date dataEncerramento, Long identificador, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataEncerramento, dataEncerramento, identificador, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, this.SALDO_CONTABIL_RESULT_TRANSFORMER, ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_ENCERRAMENTO);
    }

    public List<Map> findSaldoContaContabilGeralEncerramentoMap(String contaInicial, String contaFinal, java.util.Date dataEncerramento, Long identificador, Long idCentroResultadoInicial, Long idCentroResultadoFinal, EnumConstantsTipoSaldo tipoSaldo, EnumConstantsTipoSaldoRetorno tipoSaldoRet, EnumConstantsNivelContaRet nivel, EnumConstantsOrdenacao ordenacao) {
        return this.findSaldoContaContabilGeral(contaInicial, contaFinal, dataEncerramento, dataEncerramento, identificador, idCentroResultadoInicial, idCentroResultadoFinal, tipoSaldo, tipoSaldoRet, nivel, this.MAP_RESULT_TRANSFORMER, ordenacao, EnumConstantsTipoSaldoNormalEnc.TIPO_SALDO_ENCERRAMENTO);
    }

    private class SaldoContabilResultTransformer
    implements ResultTransformer {
        private final String idPlanoConta = "ID_PLANO_CONTA";
        private int idPlanoContaInd = -1;
        private final String codPlanoConta = "COD";
        private int codPlanoContaInd = -1;
        private final String descricaoPlanoConta = "DESCRICAO_CONTA";
        private int descricaoPlanoContaInd = -1;
        private final String marca = "MARCA";
        private int marcaInd = -1;
        private final String valorDebito = "VALOR_DEBITO";
        private int valorDebitoInd = -1;
        private final String valorCredito = "VALOR_CREDITO";
        private int valorCreditoInd = -1;
        private final String saldoAnterior = "SALDO_ANTERIOR";
        private int saldoAnteriorInd = -1;
        private final String saldoAtual = "SALDO_ATUAL";
        private int saldoAtualInd = -1;
        private final String codNatPlanoConta = "COD_NAT_PLANO_CONTA";
        private int codNatPlanoContaInd = -1;
        private boolean isConfigured = false;

        private SaldoContabilResultTransformer() {
        }

        private void configure(String[] strings) {
            if (!this.isConfigured) {
                for (int i = 0; i < strings.length; ++i) {
                    String o = strings[i];
                    if (o.equalsIgnoreCase("ID_PLANO_CONTA")) {
                        this.idPlanoContaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase("COD")) {
                        this.codPlanoContaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase("DESCRICAO_CONTA")) {
                        this.descricaoPlanoContaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase("MARCA")) {
                        this.marcaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase("VALOR_DEBITO")) {
                        this.valorDebitoInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase("VALOR_CREDITO")) {
                        this.valorCreditoInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase("SALDO_ANTERIOR")) {
                        this.saldoAnteriorInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase("SALDO_ATUAL")) {
                        this.saldoAtualInd = i;
                        continue;
                    }
                    if (!o.equalsIgnoreCase("COD_NAT_PLANO_CONTA")) continue;
                    this.codNatPlanoContaInd = i;
                }
                this.isConfigured = true;
            }
        }

        public Object transformTuple(Object[] os, String[] strings) {
            SaldoContaContabil s = new SaldoContaContabil();
            this.configure(strings);
            if (this.idPlanoContaInd >= 0 && os[this.idPlanoContaInd] != null) {
                s.setIdPlanoConta(Long.valueOf(((Number)os[this.idPlanoContaInd]).longValue()));
            }
            if (this.codPlanoContaInd >= 0 && os[this.codPlanoContaInd] != null) {
                s.setCodigoPlanoConta((String)os[this.codPlanoContaInd]);
            }
            if (this.descricaoPlanoContaInd >= 0 && os[this.descricaoPlanoContaInd] != null) {
                s.setDescricaoPlanoConta((String)os[this.descricaoPlanoContaInd]);
            }
            if (this.marcaInd >= 0 && os[this.marcaInd] != null) {
                s.setMarca(Integer.valueOf(((Number)os[this.marcaInd]).intValue()));
            }
            if (this.valorDebitoInd >= 0 && os[this.valorDebitoInd] != null) {
                s.setValorDebito(Double.valueOf(((Number)os[this.valorDebitoInd]).doubleValue()));
            }
            if (this.valorCreditoInd >= 0 && os[this.valorCreditoInd] != null) {
                s.setValorCredito(Double.valueOf(((Number)os[this.valorCreditoInd]).doubleValue()));
            }
            if (this.valorCreditoInd >= 0 && os[this.valorCreditoInd] != null) {
                s.setValorCredito(Double.valueOf(((Number)os[this.valorCreditoInd]).doubleValue()));
            }
            if (this.saldoAnteriorInd >= 0 && os[this.saldoAnteriorInd] != null) {
                s.setSaldoAnterior(Double.valueOf(((Number)os[this.saldoAnteriorInd]).doubleValue()));
            }
            if (this.saldoAtualInd >= 0 && os[this.saldoAtualInd] != null) {
                s.setSaldoAtual(Double.valueOf(((Number)os[this.saldoAtualInd]).doubleValue()));
            }
            if (this.codNatPlanoContaInd >= 0 && os[this.codNatPlanoContaInd] != null) {
                s.setCodigoNatPlanoConta((String)os[this.codNatPlanoContaInd]);
            }
            return s;
        }

        public List transformList(List list) {
            return list;
        }
    }
}

