/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueGC;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubEspecie;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOSaldoEstProprio
extends CoreBaseDAO {
    private final SaldoResultTransformer SALDO_RESULT_TRANSFORMER = new SaldoResultTransformer();
    private final SaldoBasicoResultTransformer SALDO_BASICO_RESULT_TRANSFORMER = new SaldoBasicoResultTransformer();

    @Override
    public Class getVOClass() {
        return null;
    }

    public List getSaldoProdutoPorGradePorQtdeMaxMinRessuprimento(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, 0L, 9999999L, null, tipoSaldo, tipoQtde, tipoCarregamento, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_RESULT_TRANSFORMER);
        ArrayList<SaldoEstoqueGeral> lista = new ArrayList<SaldoEstoqueGeral>();
        if (saldos != null) {
            for (SaldoEstoqueGeral s : saldos) {
                Double saldoQuantidade = s.getQuantidade();
                Produto p = s.getGradeCor().getProdutoGrade().getProduto();
                if (tipoPesquisa != null && tipoPesquisa == 0 && saldoQuantidade < p.getQtdMax()) {
                    lista.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 4 && saldoQuantidade > p.getQtdMax()) {
                    lista.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 1 && saldoQuantidade < p.getQtdMin()) {
                    lista.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 2) {
                    lista.add(s);
                    continue;
                }
                if (!(saldoQuantidade < p.getPontoRessupEstoque())) continue;
                lista.add(s);
            }
        }
        return lista;
    }

    public List getSaldoProdutoPorGradeGrupoAnaliseEstoquePorQtdeMaxMinRessuprimento(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, 0L, 9999999L, null, tipoSaldo, tipoQtde, tipoCarregamento, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_RESULT_TRANSFORMER);
        ArrayList<SaldoEstoqueGeral> lista = new ArrayList<SaldoEstoqueGeral>();
        if (saldos != null) {
            Map gruposAnalise = this.findAllGrupoAnaliseEstoquePorGradeCor(saldos);
            for (SaldoEstoqueGeral s : saldos) {
                Double saldoQuantidade = s.getQuantidade();
                Long idGradeCor = s.getGradeCor().getIdentificador();
                GrupoAnaliseEstoqueGC grupoAnalise = (GrupoAnaliseEstoqueGC)gruposAnalise.get(idGradeCor);
                if (grupoAnalise == null) continue;
                s.getGradeCor().getProdutoGrade().getProduto().setQtdMax(grupoAnalise.getEstoqueMaximo());
                s.getGradeCor().getProdutoGrade().getProduto().setQtdMin(grupoAnalise.getEstoqueMinimo());
                s.getGradeCor().getProdutoGrade().getProduto().setPontoRessupEstoque(grupoAnalise.getEstoqueRessuprimento());
                if (tipoPesquisa != null && tipoPesquisa == 0 && (grupoAnalise.getEstoqueMaximo() == null || saldoQuantidade < grupoAnalise.getEstoqueMaximo())) {
                    lista.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 4 && (grupoAnalise.getEstoqueMaximo() == null || saldoQuantidade > grupoAnalise.getEstoqueMaximo())) {
                    lista.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 1 && (grupoAnalise.getEstoqueMinimo() == null || saldoQuantidade < grupoAnalise.getEstoqueMinimo())) {
                    lista.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 2) {
                    lista.add(s);
                    continue;
                }
                if (grupoAnalise.getEstoqueRessuprimento() != null && !(saldoQuantidade < grupoAnalise.getEstoqueRessuprimento())) continue;
                lista.add(s);
            }
        }
        return lista;
    }

    private Map findAllGrupoAnaliseEstoquePorGradeCor(List<SaldoEstoqueGeral> saldos) {
        ArrayList<Map> grupoAnaliseTemp = new ArrayList<Map>();
        ArrayList<Long> idsGradeCorTemp = new ArrayList<Long>();
        for (SaldoEstoqueGeral itemAtual : saldos) {
            Long gradeCor = itemAtual.getGradeCor().getIdentificador();
            if (idsGradeCorTemp.contains(gradeCor)) continue;
            idsGradeCorTemp.add(gradeCor);
        }
        int divisor = 2;
        while (idsGradeCorTemp.size() / divisor > 1400) {
            ++divisor;
        }
        int quantidadeMaxPorLista = (idsGradeCorTemp.size() - 1) / divisor;
        ArrayList<List<Long>> idsGradeList = new ArrayList<List<Long>>(idsGradeCorTemp.stream().collect(Collectors.partitioningBy(x -> idsGradeCorTemp.indexOf(x) > quantidadeMaxPorLista)).values());
        for (List list : idsGradeList) {
            grupoAnaliseTemp.addAll(this.buildDadosGrupoAnaliseEstoqueGC(list));
        }
        HashMap<Long, GrupoAnaliseEstoqueGC> grupoAnaliseHash = new HashMap<Long, GrupoAnaliseEstoqueGC>();
        for (Map itemAtual : grupoAnaliseTemp) {
            GrupoAnaliseEstoqueGC grupo = new GrupoAnaliseEstoqueGC();
            grupo.setIdentificador((Long)itemAtual.get("ID_GRUPO_ANALISE_ESTOQUE_GC"));
            grupo.setEstoqueMaximo((Double)itemAtual.get("MAX_ESTOQUE"));
            grupo.setEstoqueMinimo((Double)itemAtual.get("MIN_ESTOQUE"));
            grupo.setEstoqueRessuprimento((Double)itemAtual.get("ESTOQUE_RESSUPRIMENTO"));
            Long idGradeCor = (Long)itemAtual.get("ID_GRADE_COR");
            grupoAnaliseHash.put(idGradeCor, grupo);
        }
        return grupoAnaliseHash;
    }

    private List<Map> buildDadosGrupoAnaliseEstoqueGC(List<Long> idsGradeCor) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "SELECT g.identificador          AS ID_GRUPO_ANALISE_ESTOQUE_GC, g.gradeCor.identificador AS ID_GRADE_COR, g.estoqueMaximo          AS MAX_ESTOQUE, g.estoqueMinimo          AS MIN_ESTOQUE, g.estoqueRessuprimento   AS ESTOQUE_RESSUPRIMENTO\nfrom GrupoAnaliseEstoqueGC g where g.gradeCor.identificador IN(:ids)";
        Query q = s.createQuery(query);
        q.setParameter("ids", idsGradeCor);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List getSaldoProdutoNecessidadeCompraProduto(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long gradeInicial, Long gradeFinal, Long idGrupoProdutos, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Short produtosSemMovimentacao, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoCentroEstPropTerc) {
        ArrayList lista = new ArrayList();
        lista.addAll(this.getSaldoProdutoNecessidadeCompraProdutoComMovimentacoes(data, produtoInicial, produtoFinal, especieInicial, especieFinal, subEspecieInicial, subEspecieFinal, centroEstInicial, centroEstFinal, fabricanteInicial, fabricanteFinal, gradeInicial, gradeFinal, idGrupoProdutos, tipoProdutoInicial, tipoProdutoFinal, tipoPesquisa, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoCentroEstPropTerc));
        lista.addAll(this.getSaldoProdutoNecessidadeCompraProdutoSemMovimentacoes(data, null, null, especieInicial != null ? especieInicial : 0L, especieFinal != null ? especieFinal : 9999999L, subEspecieInicial != null ? subEspecieInicial : 0L, subEspecieFinal != null ? subEspecieFinal : 9999999L, null, null, fabricanteInicial != null ? fabricanteInicial : 0L, fabricanteFinal != null ? fabricanteFinal : 9999999L, 0L, 999999999L, idGrupoProdutos, tipoProdutoInicial, tipoProdutoInicial, (short)3, idEmpresa, produtosSemMovimentacao));
        return lista;
    }

    public List findLotesAbertos(Produto p, GradeCor g, Empresa e, Short tipoCentroEstoquePropTerc) throws ExceptionDatabase {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new Date(), idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, 4, 2, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstoquePropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            for (SaldoEstoqueGeral s : saldos) {
                if (s.getLoteFabricacao() == null) continue;
                lotes.add(s.getLoteFabricacao());
            }
        }
        return lotes;
    }

    public LoteFabricacao findMelhorLote(GradeCor g, Date data, Empresa e, Short tipoCentroEstoquePropTerc) throws ExceptionDatabase {
        Long idGrade;
        Long idEmpresa;
        Long idProduto = g != null ? g.getProdutoGrade().getProduto().getIdentificador() : null;
        SaldoEstoqueGeral s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa = e != null ? e.getIdentificador() : null, idEmpresa, null, null, idGrade = g != null ? g.getIdentificador() : null, idGrade, null, 4, 2, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstoquePropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, 4, 1, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstoquePropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        return null;
    }

    public LoteFabricacao findMelhorLotePorCentroEstoque(GradeCor g, Date data, Empresa e, CentroEstoque c, Short tipoCentroEstPropTerc) throws ExceptionDatabase {
        Long idGrade;
        Long idCentroEstoque;
        Long idEmpresa;
        Long idProduto = g != null ? g.getProdutoGrade().getProduto().getIdentificador() : null;
        SaldoEstoqueGeral s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa = e != null ? e.getIdentificador() : null, idEmpresa, idCentroEstoque = c != null ? c.getIdentificador() : null, idCentroEstoque, idGrade = g != null ? g.getIdentificador() : null, idGrade, null, 4, 2, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstPropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        s = this.findSaldoProdutoPorGradeCentroEstoqueLoteUnico(idProduto, idProduto, data, idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, 4, 1, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstPropTerc, null);
        if (s != null && s.getLoteFabricacao() != null) {
            return s.getLoteFabricacao();
        }
        return null;
    }

    public List findLotes(Produto p, GradeCor g, Empresa e, Short tipoCentroEstoquePropTerc) throws ExceptionDatabase {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new Date(), idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, 4, 1, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstoquePropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            for (SaldoEstoqueGeral s : saldos) {
                if (s.getLoteFabricacao() == null || lotes.contains(s.getLoteFabricacao())) continue;
                lotes.add(s.getLoteFabricacao());
            }
        }
        return lotes;
    }

    public List findLotesPorCentroEstoque(Produto p, GradeCor g, Empresa e, CentroEstoque c, Short tipoCentroEstPropTerc) throws ExceptionDatabase {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        Long idCentroEstoque = c != null ? c.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new Date(), idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, 4, 1, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstPropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            for (SaldoEstoqueGeral s : saldos) {
                if (s.getLoteFabricacao() == null) continue;
                lotes.add(s.getLoteFabricacao());
            }
        }
        return lotes;
    }

    public List findLotesAbertosPorCentroEstoque(Produto p, GradeCor g, Empresa e, CentroEstoque c, Short tipoCentroEstPropTerc) throws ExceptionDatabase {
        if (p == null && g != null) {
            p = g.getProdutoGrade().getProduto();
        }
        Long idProduto = p != null ? p.getIdentificador() : null;
        Long idGrade = g != null ? g.getIdentificador() : null;
        Long idEmpresa = e != null ? e.getIdentificador() : null;
        Long idCentroEstoque = c != null ? c.getIdentificador() : null;
        List<SaldoEstoqueGeral> saldos = this.findSaldoProdutoPorGradeCentroEstoqueLoteLista(idProduto, idProduto, new Date(), idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, 4, 2, 2, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), tipoCentroEstPropTerc, null);
        ArrayList<LoteFabricacao> lotes = new ArrayList<LoteFabricacao>();
        if (saldos != null) {
            for (SaldoEstoqueGeral s : saldos) {
                if (s.getLoteFabricacao() == null) continue;
                lotes.add(s.getLoteFabricacao());
            }
        }
        return lotes;
    }

    public List findSaldoProdutoValorMaior0ListagemAnaliseEstoque(Long idProdInicial, Long idProdFinal, Date dataIn, Long idEmpresa, Short tipoEstoque, Long localizacaoInicial, Long localizacaoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long fabricanteInicial, Long fabricanteFinal, Short tipoCentroEstoque, Long centroEstoqueInicial, Long centroEstoqueFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(" select \n s.id_empresa as ID_EMPRESA,\n s.DATA_SALDO as DATA_SALDO,\n s.SALDO_QTD as SALDO_QTD,\n s.SALDO_VALOR as SALDO_VALOR,\n s.VALOR_PRECO_MEDIO as VALOR_PRECO_MEDIO,\n p.id_produto as ID_PRODUTO,\n p.nome as NOME_PRODUTO,\n p.codigo_auxiliar as CODIGO_AUXILIAR,\n e.id_especie as ID_ESPECIE,\n e.nome as ESPECIE,\n f.id_fabricante as ID_FABRICANTE,\n f.nome as FABRICANTE,\n se.id_sub_especie as ID_SUB_ESPECIE,\n se.nome as NOME_ESPECIE\n from \n saldo_produto_detalhado(:tipoInicial, :tipoFinal,\n :idProdInicial, :idProdFinal,\n :dataSaldo,\n null, null,\n :id_especie_inicial, :id_especie_final,\n :id_sub_esp_inicial, :id_sub_esp_final,\n :id_loc_inicial,     :id_loc_final,\n :fabricanteInicial, :fabricanteFinal,\n :idEmp, :idEmp,\n :centroEstoqueInicial, :centroEstoqueFinal,\n null,\n :tipoSaldo,\n :tipoSaldoQtde,\n :tipoCarregamento,\n null,\n :tipoCentroEstoque,\n null) s\n inner join produto p on p.id_produto=s.id_produto \n inner join especie e on e.id_especie=p.id_especie \n inner join fabricante f on f.id_fabricante = p.id_fabricante\n inner join sub_especie se on (se.id_sub_especie = p.id_sub_especie)\n where s.SALDO_VALOR>0 \n");
        q.setParameter("tipoInicial", (Object)tipoEstoque);
        q.setParameter("tipoFinal", (Object)tipoEstoque);
        q.setParameter("idProdInicial", (Object)idProdInicial);
        q.setParameter("idProdFinal", (Object)idProdFinal);
        q.setDate("dataSaldo", dataIn);
        q.setParameter("id_especie_inicial", (Object)especieInicial);
        q.setParameter("id_especie_final", (Object)especieFinal);
        q.setParameter("id_sub_esp_inicial", (Object)subEspecieInicial);
        q.setParameter("id_sub_esp_final", (Object)subEspecieFinal);
        q.setParameter("id_loc_inicial", (Object)localizacaoInicial);
        q.setParameter("id_loc_final", (Object)localizacaoFinal);
        q.setParameter("fabricanteInicial", (Object)fabricanteInicial);
        q.setParameter("fabricanteFinal", (Object)fabricanteFinal);
        q.setParameter("idEmp", (Object)idEmpresa);
        q.setParameter("centroEstoqueInicial", (Object)centroEstoqueInicial);
        q.setParameter("centroEstoqueFinal", (Object)centroEstoqueFinal);
        q.setInteger("tipoSaldo", 1);
        q.setInteger("tipoSaldoQtde", 1);
        q.setInteger("tipoCarregamento", 3);
        q.setParameter("tipoCentroEstoque", (Object)tipoCentroEstoque);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List l = q.list();
        return l;
    }

    public List<HashMap> findProdutosRessuprimentoEstoque(Date dataRessuprimento, Fabricante fabricante, Especie especie, SubEspecie subEspecie, GrupoProdutos grupoProdutos, ClassificacaoAnaliseEstoque classificacao, Empresa empresa, Integer tipoProduto, Short tipoCentroEstoquePropTerc) {
        Session session = CoreBdUtil.getInstance().getSession();
        NativeQuery query = session.createSQLQuery(" SELECT       gc.ID_GRADE_COR           AS ID_GRADE_COR, COALESCE(S.SALDO_QTD,0)         AS SALDO_QTD, COALESCE(S.SALDO_VALOR,0)       AS SALDO_VALOR, GC.LEAD_TIME             AS LEAD_TIME, GC.ESTOQUE_MAXIMO        AS ESTOQUE_MAXIMO, GC.ESTOQUE_MINIMO        AS ESTOQUE_MINIMO, GC.ESTOQUE_RESSUPRIMENTO AS ESTOQUE_RESSUPRIMENTO  FROM GRUPO_ANALISE_ESTOQUE_GC GC INNER JOIN GRADE_COR G ON G.ID_GRADE_COR=GC.ID_GRADE_COR  INNER JOIN PRODUTO_GRADE PG ON PG.ID_PRODUTO_GRADE=G.ID_PRODUTO_GRADE  INNER JOIN PRODUTO P ON P.ID_PRODUTO = PG.ID_PRODUTO  INNER JOIN PRODUTO_TIPO_COMPRA PT ON P.id_produto_tipo_compra = PT.id_produto_tipo_compra  INNER JOIN GRUPO_ANALISE_ESTOQUE GE ON GC.ID_GRUPO_ANALISE_ESTOQUE = GE.ID_GRUPO_ANALISE_ESTOQUE INNER JOIN GRUPO_ANAL_ESTOQUE_EMP GEMP ON GEMP.ID_GRUPO_ANALISE_ESTOQUE = GE.ID_GRUPO_ANALISE_ESTOQUE left JOIN SALDO_PRODUTO_DETALHADO(:tipoProduto, :tipoProduto,            0, 9999999,            :DATA_RESSUPRIMENTO,            0, 9999999,\n            :ESPECIE_INICIAL, :ESPECIE_FINAL,            :SUB_ESPECIE_INICIAL, :SUB_ESPECIE_FINAL,            0, 9999999,            :FABRICANTE_INICIAL, :FABRICANTE_FINAL,            :EMP, :EMP,            0, 9999999,            null,            :tipoSaldo,            :tipoSaldoQtde,            :tipoCarregamento,            :tipoDisponibilidade,            :tipoCentroEstoquePropTerc,            null) S ON GC.ID_GRADE_COR  = S.ID_GRADE_COR AND GEMP.ID_EMPRESA = :EMP AND (PT.TIPO = :ponto_estoque or pt.tipo=:indifere) and(:tipoProduto is null or(P.ENTRADA_SAIDA = :tipoProduto)) and(:idGrupoProdutos is null or (p.id_grupo_produtos = :idGrupoProdutos)) and(:idClassificacao is null or (GE.ID_CLASSIFI_ANALISE_ESTOQUE = :idClassificacao)) WHERE (p.ID_FABRICANTE BETWEEN :FABRICANTE_INICIAL AND :FABRICANTE_FINAL) AND (P.ID_ESPECIE BETWEEN :ESPECIE_INICIAL AND :ESPECIE_FINAL) AND (P.ID_SUB_ESPECIE BETWEEN :SUB_ESPECIE_INICIAL AND :SUB_ESPECIE_FINAL)");
        if (tipoProduto != null) {
            query.setInteger("tipoProduto", tipoProduto.intValue());
        } else {
            query.setParameter("tipoProduto", null);
        }
        if (grupoProdutos != null) {
            query.setInteger("idGrupoProdutos", grupoProdutos.getIdentificador().intValue());
        } else {
            query.setParameter("idGrupoProdutos", null);
        }
        if (classificacao != null) {
            query.setInteger("idClassificacao", classificacao.getIdentificador().intValue());
        } else {
            query.setParameter("idClassificacao", null);
        }
        query.setParameter("ponto_estoque", (Object)1);
        query.setParameter("indifere", (Object)2);
        query.setDate("DATA_RESSUPRIMENTO", dataRessuprimento);
        query.setLong("EMP", empresa.getIdentificador().longValue());
        query.setInteger("ESPECIE_INICIAL", especie != null ? especie.getIdentificador().intValue() : 0);
        query.setInteger("ESPECIE_FINAL", especie != null ? especie.getIdentificador().intValue() : 9999999);
        query.setInteger("SUB_ESPECIE_INICIAL", subEspecie != null ? subEspecie.getIdentificador().intValue() : 0);
        query.setInteger("SUB_ESPECIE_FINAL", subEspecie != null ? subEspecie.getIdentificador().intValue() : 9999999);
        query.setInteger("FABRICANTE_INICIAL", fabricante != null ? fabricante.getIdentificador().intValue() : 0);
        query.setInteger("FABRICANTE_FINAL", fabricante != null ? fabricante.getIdentificador().intValue() : 9999999);
        query.setInteger("tipoSaldo", 2);
        query.setInteger("tipoSaldoQtde", 1);
        query.setInteger("tipoCarregamento", EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD.getValue());
        query.setShort("tipoDisponibilidade", EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL.getValue().shortValue());
        query.setShort("tipoCentroEstoquePropTerc", tipoCentroEstoquePropTerc.shortValue());
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return query.list();
    }

    public Object reprocessarEstoque(Date d, Long idInicial, Long idFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery("EXECUTE PROCEDURE PROCESSA_SALDO_ESTOQUE (:data,:id_inicial,:id_final)");
        q.setDate("data", d);
        q.setParameter("id_inicial", (Object)idInicial);
        q.setParameter("id_final", (Object)idFinal);
        return q.executeUpdate();
    }

    private List getSaldoProdutoNecessidadeCompraProdutoComMovimentacoes(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long gradeInicial, Long gradeFinal, Long idGrupoProdutos, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoCentroEstPropTerc) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, gradeInicial, gradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, paramsAdic, tipoDisponibilidade, tipoCentroEstPropTerc, null, this.SALDO_RESULT_TRANSFORMER);
        ArrayList<SaldoEstoqueGeral> lista = new ArrayList<SaldoEstoqueGeral>();
        ArrayList retorno = new ArrayList();
        if (saldos == null) {
            return retorno;
        }
        for (SaldoEstoqueGeral s : saldos) {
            Produto p = s.getGradeCor().getProdutoGrade().getProduto();
            if (idGrupoProdutos != null && p.getGrupoProdutos() == null || idGrupoProdutos != null && p.getGrupoProdutos() != null && !p.getGrupoProdutos().getIdentificador().equals(idGrupoProdutos) || p.getProdutoTipoCompra() == null || p.getProdutoTipoCompra().getTipo() != 1 && p.getProdutoTipoCompra().getTipo() != 2) continue;
            if (tipoPesquisa != null && tipoPesquisa == 0 && (s.getQuantidade() == null && p.getQtdMax() > 0.0 || s.getQuantidade() > p.getQtdMax())) {
                lista.add(s);
                continue;
            }
            if (tipoPesquisa != null && tipoPesquisa == 1 && (s.getQuantidade() == null && p.getQtdMin() > 0.0 || s.getQuantidade() < p.getQtdMin())) {
                lista.add(s);
                continue;
            }
            if (!(s.getQuantidade() == null && p.getPontoRessupEstoque() > 0.0) && !(s.getQuantidade() < p.getPontoRessupEstoque())) continue;
            lista.add(s);
        }
        for (SaldoEstoqueGeral s : lista) {
            if (s.getGradeCor().getProdutoGrade().getProduto().getAtivo() != 1) continue;
            HashMap<String, Number> h = new HashMap<String, Number>();
            h.put("ID_GRADE_COR", s.getGradeCor().getIdentificador().intValue());
            h.put("SALDO_QTD", s.getQuantidade());
            h.put("QTD_MAX", s.getGradeCor().getProdutoGrade().getProduto().getQtdMax());
            h.put("QTD_MIN", s.getGradeCor().getProdutoGrade().getProduto().getQtdMin());
            h.put("ID_TIPO_ITEM_SPED", s.getGradeCor().getProdutoGrade().getProduto().getTipoIemSped().getIdentificador());
            h.put("PONTO_RESSUPRIMENTO", s.getGradeCor().getProdutoGrade().getProduto().getPontoRessupEstoque());
            h.put("ID_PRODUTO", s.getGradeCor().getProdutoGrade().getProduto().getIdentificador());
            retorno.add(h);
        }
        return retorno;
    }

    private List getSaldoProdutoNecessidadeCompraProdutoSemMovimentacoes(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long gradeInicial, Long gradeFinal, Long idGrupoProdutos, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Short produtosSemMovimentacao) {
        if (produtosSemMovimentacao == 1) {
            Object st = " select  p.id_produto as ID_PRODUTO, p.codigo_auxiliar as CODIGO_AUXILIAR, p.nome as PRODUTO, p.qtd_min as QTD_MIN, p.qtd_max as QTD_MAX, p.ponto_resuprimento_est as PONTO_RESSUPRIMENTO, u.sigla as UNIDADE_MEDIDA, g.id_grade_cor as ID_GRADE_COR, e.nome as ESPECIE, su.nome as SUB_ESPECIE, p.id_tipo_item_sped as ID_TIPO_ITEM_SPED from  produto p  inner join produto_grade pg  on pg.id_produto = p.id_produto inner join grade_cor g on g.id_produto_grade = pg.id_produto_grade  inner join especie e        on e.id_especie = p.id_especie inner join SUB_ESPECIE su   on su.id_SUB_ESPECIE = p.id_SUB_ESPECIE inner join unidade_medida u on p.id_unidade_medida = u.id_unidade_medida where  (:tipo_inicial is null or p.entrada_saida=:tipo_inicial) and p.ativo = :sim and p.id_especie between :id_especie_inicial and :id_especie_final and p.id_sub_especie between :id_subespecie_inicial and :id_subespecie_final and (:id_grupo_produtos is null or p.id_grupo_produtos = :id_grupo_produtos) and (p.id_fabricante is null or p.id_fabricante between :id_fabricante_inicial and :id_fabricante_final) and not exists (select ss.id_grade_cor from saldo_est_proprio ss where ss.id_grade_cor = g.id_grade_cor)";
            st = tipoPesquisa != null && tipoPesquisa == 0 ? (String)st + " and (p.qtd_max>0)" : (tipoPesquisa != null && tipoPesquisa == 1 ? (String)st + " and (p.qtd_min>0)" : (String)st + " and (p.ponto_resuprimento_est >0)");
            st = (String)st + " order by p.nome";
            Session s = CoreBdUtil.getInstance().getSession();
            NativeQuery q = s.createSQLQuery((String)st);
            q.setParameter("tipo_inicial", (Object)tipoProdutoInicial);
            q.setParameter("id_especie_inicial", (Object)especieInicial);
            q.setParameter("id_especie_final", (Object)especieFinal);
            q.setParameter("id_subespecie_inicial", (Object)subEspecieInicial);
            q.setParameter("id_subespecie_final", (Object)subEspecieFinal);
            q.setParameter("id_fabricante_inicial", (Object)fabricanteInicial);
            q.setParameter("id_fabricante_final", (Object)fabricanteFinal);
            q.setShort("sim", (short)1);
            if (idGrupoProdutos != null) {
                q.setInteger("id_grupo_produtos", idGrupoProdutos.intValue());
            } else {
                q.setParameter("id_grupo_produtos", null);
            }
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            if (lista != null && !lista.isEmpty()) {
                for (HashMap h : lista) {
                    Integer valor = 0;
                    h.put("SALDO_QTD", valor);
                    h.put("SALDO_VALOR", valor);
                    h.put("VLR_PRECO_MEDIO", valor);
                }
            }
            return lista;
        }
        return new ArrayList();
    }

    public List getSaldoProdutoEstoqueDisponivelOrNaoDisponivielProprioOrTerceiros(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Long gradeInicial, Long gradeFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, gradeInicial, gradeFinal, null, 2, 1, 2, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_RESULT_TRANSFORMER);
        ArrayList lista = new ArrayList();
        if (saldos != null) {
            ArrayList<SaldoEstoqueGeral> temp = new ArrayList<SaldoEstoqueGeral>();
            for (SaldoEstoqueGeral s : saldos) {
                Produto p = s.getGradeCor().getProdutoGrade().getProduto();
                Double saldoQtde = s.getQuantidade() != null ? s.getQuantidade() : 0.0;
                if (tipoPesquisa != null && tipoPesquisa == 0 && saldoQtde > p.getQtdMax()) {
                    temp.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 1 && saldoQtde < p.getQtdMin()) {
                    temp.add(s);
                    continue;
                }
                if (tipoPesquisa != null && tipoPesquisa == 2) {
                    temp.add(s);
                    continue;
                }
                if (!(saldoQtde < p.getPontoRessupEstoque())) continue;
                temp.add(s);
            }
            for (SaldoEstoqueGeral s : temp) {
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("SALDO_QTD", s.getQuantidade());
                h.put("SALDO_VALOR", s.getValor());
                h.put("VLR_PRECO_MEDIO", s.getValorMedio());
                h.put("GRADE", s.getGradeCor().getCor().getNome());
                h.put("ID_PRODUTO", s.getProduto().getIdentificador());
                h.put("CODIGO_AUXILIAR", s.getProduto().getCodigoAuxiliar());
                h.put("PRODUTO", s.getProduto());
                h.put("QTD_MIN", s.getProduto().getQtdMin());
                h.put("QTD_MAX", s.getProduto().getQtdMax());
                h.put("PTO_RESSUPRIMENTO", s.getProduto().getPontoRessupEstoque());
                h.put("UNIDADE_MEDIDA", s.getProduto().getUnidadeMedida().getSigla());
                h.put("ID_GRADE_COR", s.getGradeCor().getIdentificador());
                h.put("ESPECIE", s.getProduto().getEspecie().getNome());
                h.put("SUBESPECIE", s.getProduto().getSubEspecie().getNome());
                lista.add(h);
            }
        }
        return lista;
    }

    public List getSaldoProdutoEstoqueDisponivelOrNaoDisponivielProprioOrTerceirosBasico(Date data, Long produtoInicial, Long produtoFinal, Long especieInicial, Long especieFinal, Long subEspecieInicial, Long subEspecieFinal, Long centroEstInicial, Long centroEstFinal, Long fabricanteInicial, Long fabricanteFinal, Long localizacaoInicial, Long localizacaoFinal, Long gradeInicial, Long gradeFinal, Integer tipoProdutoInicial, Integer tipoProdutoFinal, Short tipoPesquisa, Long idEmpresa, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        HashMap<String, Long> paramsAdic = new HashMap<String, Long>();
        paramsAdic.put("ID_ESPECIE_INICIAL", especieInicial);
        paramsAdic.put("ID_ESPECIE_FINAL", especieFinal);
        paramsAdic.put("ID_SUB_ESPECIE_INICIAL", subEspecieInicial);
        paramsAdic.put("ID_SUB_ESPECIE_FINAL", subEspecieFinal);
        paramsAdic.put("ID_FABRICANTE_INICIAL", fabricanteInicial);
        paramsAdic.put("ID_FABRICANTE_FINAL", fabricanteFinal);
        paramsAdic.put("ID_LOCALIZACAO_INICIAL", localizacaoInicial);
        paramsAdic.put("ID_LOCALIZACAO_FINAL", localizacaoFinal);
        List saldos = this.findSaldoEstoqueGeral(tipoProdutoInicial, tipoProdutoFinal, produtoInicial, produtoFinal, data, idEmpresa, idEmpresa, centroEstInicial, centroEstFinal, gradeInicial, gradeFinal, null, 2, 1, 2, paramsAdic, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_BASICO_RESULT_TRANSFORMER);
        ArrayList<HashMap> lista = new ArrayList<HashMap>();
        if (saldos != null) {
            ArrayList<SaldoEstoqueGeralBasico> temp = new ArrayList<SaldoEstoqueGeralBasico>();
            for (SaldoEstoqueGeralBasico s : saldos) {
                Long idProduto = s.getIdProduto();
                HashMap h = this.getDadosProdutoPorIdProduto(idProduto);
                Double saldoQtde = s.getQuantidade() != null ? s.getQuantidade() : 0.0;
                if (tipoPesquisa != null && tipoPesquisa == 0 && saldoQtde > (Double)h.get("QTD_MAX")) {
                    temp.add(s);
                } else if (tipoPesquisa != null && tipoPesquisa == 1 && saldoQtde < (Double)h.get("QTD_MIN")) {
                    temp.add(s);
                } else if (tipoPesquisa != null && tipoPesquisa == 2) {
                    temp.add(s);
                } else if (saldoQtde < (Double)h.get("PONTO_RESSUPRIMENTO")) {
                    temp.add(s);
                }
                h.put("SALDO_QTD", s.getQuantidade());
                h.put("SALDO_VALOR", s.getValor());
                h.put("VLR_PRECO_MEDIO", s.getValorMedio());
                h.put("ID_PRODUTO", s.getIdProduto());
                h.put("ID_GRADE_COR", s.getIdGradeCor());
                lista.add(h);
            }
        }
        return lista;
    }

    public List<SaldoEstoqueGeral> findSaldoProduto(Long idProdInicial, Long idProdFinal, Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, null, null, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeral>();
        }
        return saldos;
    }

    public List<SaldoEstoqueGeralBasico> findSaldoProdutoBasico(Long idProdInicial, Long idProdFinal, Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, null, null, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_BASICO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeralBasico>();
        }
        return saldos;
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoUnicoBasico(Long idProduto, Date dataIn, Long idEmpresa, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro, Long idCentroInicial, Long idCentroFinal, Long idLote, Long idGradeIn, Long idGradeFim) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProduto, idProduto, dataIn, idEmpresa, idEmpresa, idCentroInicial, idCentroFinal, idGradeIn, idGradeFim, idLote, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_BASICO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return null;
        }
        return (SaldoEstoqueGeralBasico)saldos.get(0);
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoUnicoBasico(Long idProduto, Date data, Long idEmpresa, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        return this.findSaldoProdutoUnicoBasico(idProduto, data, idEmpresa, tipoSaldo, tipoQtde, tipoCarregamento, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, null, null, null, null, null);
    }

    public List<SaldoEstoqueGeral> findSaldoProdutoPorGrade(Long idProdInicial, Long idProdFinal, Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idGradeInicial, Long idGradeFinal, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro, HashMap paramsAdicionais) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, idGradeInicial, idGradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, paramsAdicionais, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeral>();
        }
        return saldos;
    }

    public List<SaldoEstoqueGeralBasico> findSaldoProdutoPorGradeBasico(Long idProdInicial, Long idProdFinal, Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idGradeInicial, Long idGradeFinal, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, null, null, idGradeInicial, idGradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_BASICO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeralBasico>();
        }
        return saldos;
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoPorGradeUnicoBasico(Long idProduto, Date dataIn, Long idEmpresa, Long idGrade, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProduto, idProduto, dataIn, idEmpresa, idEmpresa, null, null, idGrade, idGrade, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_BASICO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return null;
        }
        return (SaldoEstoqueGeralBasico)saldos.get(0);
    }

    public List<SaldoEstoqueGeralBasico> findSaldoProdutoPorGradeCentroEstoqueBasico(Long idProdInicial, Long idProdFinal, Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idGradeInicial, Long idGradeFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdInicial, idProdFinal, dataIn, idEmpresaInicial, idEmpresaFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idGradeInicial, idGradeFinal, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_BASICO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeralBasico>();
        }
        return saldos;
    }

    public SaldoEstoqueGeralBasico findSaldoProdutoPorGradeCentroEstoqueUnicoBasico(Long idProduto, Date dataIn, Long idEmpresa, Long idGrade, Long idCentroEstoque, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProduto, idProduto, dataIn, idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, idGrade, idGrade, null, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_BASICO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return null;
        }
        return (SaldoEstoqueGeralBasico)saldos.get(0);
    }

    public SaldoEstoqueGeral findSaldoProdutoPorGradeCentroEstoqueLoteUnico(Long idProdutoInicial, Long idProdutoFinal, Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long centroInicial, Long centroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) throws ExceptionDatabase {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, centroInicial, centroFinal, idGradeCorInicial, idGradeCorFinal, idLoteFabricacao, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            SaldoEstoqueGeral sal = new SaldoEstoqueGeral();
            return sal;
        }
        return (SaldoEstoqueGeral)saldos.get(0);
    }

    public List<SaldoEstoqueGeral> findSaldoProdutoPorGradeCentroEstoqueLoteLista(Long idProdutoInicial, Long idProdutoFinal, Date data, Long idEmpresaInicial, Long idEmpresaFinal, Long centroInicial, Long centroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, Integer tipoSaldo, Integer tipoQtde, Integer tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTerc, Long idParceiro) throws ExceptionDatabase {
        List saldos = this.findSaldoEstoqueGeral(0, 999999, idProdutoInicial, idProdutoFinal, data, idEmpresaInicial, idEmpresaFinal, centroInicial, centroFinal, idGradeCorInicial, idGradeCorFinal, idLoteFabricacao, tipoSaldo, tipoQtde, tipoCarregamento, null, tipoDisponibilidade, tipoEstoqueCentroEstoquePropTerc, idParceiro, this.SALDO_RESULT_TRANSFORMER);
        if (saldos == null || saldos.isEmpty()) {
            return new ArrayList<SaldoEstoqueGeral>();
        }
        return saldos;
    }

    private List findSaldoEstoqueGeral(Integer tipoInicial, Integer tipoFinal, Long idProdInicial, Long idProdFinal, Date dataIn, Long idEmpresaInicial, Long idEmpresaFinal, Long idCentroInicial, Long idCentroFinal, Long idGradeCorInicial, Long idGradeCorFinal, Long idLoteFabricacao, Integer tipoSaldo, Integer tipoSaldoQtde, Integer tipoCarregamento, HashMap paramsAdicionais, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoquePropTercPropTerc, Long idParceiro, ResultTransformer result) {
        Session s = CoreBdUtil.getInstance().getSession();
        if (dataIn == null) {
            dataIn = new Date();
        }
        NativeQuery q = s.createSQLQuery(" select  s.id_empresa as ID_EMPRESA, s.DATA_SALDO as DATA_SALDO, s.SALDO_QTD as SALDO_QTD, s.SALDO_VALOR as SALDO_VALOR, s.VALOR_PRECO_MEDIO as VALOR_PRECO_MEDIO, s.id_produto as ID_PRODUTO, s.id_lote_fabricacao as ID_LOTE_FABRICACAO, s.id_grade_cor as ID_GRADE_COR, s.id_c_estoque as ID_CENTRO_ESTOQUE, s.qtd_entrada_dia - qtd_entrada_dia_interno as  QTD_ENTRADA_DIA, s.qtd_saida_dia - qtd_saida_dia_interno as QTD_SAIDA_DIA from  saldo_produto_detalhado(:tipoInicial, :tipoFinal, :idProdInicial, :idProdFinal, :dataSaldo, :idGradeCorInicial, :idGradeCorFinal, :idEspecieInicial, :idEspecieFinal, :idSubEspecieInicial, :idSubEspecieFinal, :idLocalizacaoInicial, :idLocalizacaoFinal, :idFabricanteInicial, :idFabricanteFinal, :idEmpInicial, :idEmpFinal, :idCentroInicial, :idCentroFinal, :id_lote_fab, :tipo_saldo, :tipo_saldo_qtd, :tipo_carregamento, :tipo_disponibilidade, :tipo_estoque_c_estoque, :id_parceiro) s order by s.id_produto, s.id_grade_cor, s.data_fabricacao,s.LOTE");
        q.setParameter("idEmpInicial", (Object)idEmpresaInicial);
        q.setParameter("idEmpFinal", (Object)idEmpresaFinal);
        q.setDate("dataSaldo", dataIn);
        q.setParameter("idProdInicial", (Object)idProdInicial);
        q.setParameter("idProdFinal", (Object)idProdFinal);
        if (idCentroInicial != null && idCentroFinal != null) {
            q.setParameter("idCentroInicial", (Object)idCentroInicial);
            q.setParameter("idCentroFinal", (Object)idCentroFinal);
        } else {
            q.setParameter("idCentroInicial", null);
            q.setParameter("idCentroFinal", null);
        }
        q.setParameter("tipoInicial", (Object)tipoInicial);
        q.setParameter("tipoFinal", (Object)tipoFinal);
        q.setParameter("id_lote_fab", (Object)idLoteFabricacao);
        q.setParameter("tipo_saldo", (Object)tipoSaldo);
        q.setParameter("tipo_saldo_qtd", (Object)tipoSaldoQtde);
        if (tipoCarregamento == null) {
            tipoCarregamento = 3;
        }
        q.setInteger("tipo_carregamento", tipoCarregamento.intValue());
        q.setParameter("tipo_disponibilidade", (Object)tipoDisponibilidade);
        q.setParameter("tipo_estoque_c_estoque", (Object)tipoEstoqueCentroEstoquePropTercPropTerc);
        q.setParameter("id_parceiro", (Object)idParceiro);
        if (idGradeCorInicial != null && idGradeCorFinal != null) {
            q.setLong("idGradeCorInicial", idGradeCorInicial.longValue());
            q.setLong("idGradeCorFinal", idGradeCorFinal.longValue());
        } else {
            q.setParameter("idGradeCorInicial", null);
            q.setParameter("idGradeCorFinal", null);
        }
        if (paramsAdicionais != null) {
            q.setParameter("idEspecieInicial", (Object)((Long)paramsAdicionais.get("ID_ESPECIE_INICIAL")));
            q.setParameter("idEspecieFinal", (Object)((Long)paramsAdicionais.get("ID_ESPECIE_FINAL")));
            q.setParameter("idSubEspecieInicial", (Object)((Long)paramsAdicionais.get("ID_SUB_ESPECIE_INICIAL")));
            q.setParameter("idSubEspecieFinal", (Object)((Long)paramsAdicionais.get("ID_SUB_ESPECIE_FINAL")));
            q.setParameter("idLocalizacaoInicial", (Object)((Long)paramsAdicionais.get("ID_LOCALIZACAO_INICIAL")));
            q.setParameter("idLocalizacaoFinal", (Object)((Long)paramsAdicionais.get("ID_LOCALIZACAO_FINAL")));
            q.setParameter("idFabricanteInicial", (Object)((Long)paramsAdicionais.get("ID_FABRICANTE_INICIAL")));
            q.setParameter("idFabricanteFinal", (Object)((Long)paramsAdicionais.get("ID_FABRICANTE_FINAL")));
        } else {
            q.setParameter("idEspecieInicial", null);
            q.setParameter("idEspecieFinal", null);
            q.setParameter("idSubEspecieInicial", null);
            q.setParameter("idSubEspecieFinal", null);
            q.setParameter("idLocalizacaoInicial", null);
            q.setParameter("idLocalizacaoFinal", null);
            q.setParameter("idFabricanteInicial", null);
            q.setParameter("idFabricanteFinal", null);
        }
        q.setResultTransformer(result);
        return q.list();
    }

    public List<HashMap> findSaidasProdutoConferenciaDeEstoque(Short leachFabricante, Long idProdInicial, Long idProdFinal, Date dataSaldo, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Long idFabricanteInicial, Long idFabricanteFinal, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idGradeCorInicial, Long idGradeCorFinal, Integer tipoInicial, Integer tipoFinal, String ordenacao, Long idEmpresa, Short opcaoImpressao, Short tipoEstoqueCentroEstoque) {
        List dados = this.dadosRelatorioConfEstoque(leachFabricante, idProdInicial, idProdFinal, dataSaldo, idLocalizacaoInicial, idLocalizacaoFinal, idCentroEstoqueInicial, idCentroEstoqueFinal, idFabricanteInicial, idFabricanteFinal, idEspecieInicial, idEspecieFinal, idSubEspecieInicial, idSubEspecieFinal, idGradeCorInicial, idGradeCorFinal, tipoInicial, tipoFinal, ordenacao, idEmpresa, tipoEstoqueCentroEstoque);
        if (dataSaldo == null) {
            dataSaldo = new Date();
        }
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        Integer monthData = DateUtil.monthFromDate(dataSaldo);
        Integer yearData = DateUtil.yearFromDate(dataSaldo);
        for (HashMap hash : dados) {
            Integer idProduto = (Integer)hash.get("ID_PRODUTO");
            Number saldoQtd = (Number)hash.get("SALDO_QTD");
            Long idCentroEstoque = ((Integer)hash.get("ID_CENTRO_ESTOQUE")).longValue();
            hash.put("ID_CENTRO_ESTOQUE", idCentroEstoque);
            Number saidaMes = 0;
            Number saidaMesAnt = 0;
            if (idCentroEstoque != null) {
                saidaMes = (Number)this.gerarSaidaMesComCentroEstoque(monthData, yearData, idProduto, idEmpresa, idCentroEstoque, idGradeCorInicial, idGradeCorFinal, dataSaldo, tipoEstoqueCentroEstoque);
                saidaMesAnt = (Number)this.gerarSaidaMesAnteriorComCentroEstoque(idProduto, idEmpresa, idCentroEstoque, idGradeCorInicial, idGradeCorFinal, dataSaldo, monthData, yearData, tipoEstoqueCentroEstoque);
                hash.put("SAIDA_MES", ContatoFormatUtil.arrredondarNumeroBigDecimal((Double)saidaMes.doubleValue(), (int)2));
                hash.put("SAIDA_MES_ANT", ContatoFormatUtil.arrredondarNumeroBigDecimal((Double)saidaMesAnt.doubleValue(), (int)2));
            } else {
                saidaMes = (Number)this.gerarSaidaMesSemCentroEstoque(monthData, yearData, idProduto, idEmpresa, idGradeCorInicial, idGradeCorFinal, dataSaldo, tipoEstoqueCentroEstoque);
                saidaMesAnt = (Number)this.gerarSaidaMesAnteriorSemCentroEstoque(idProduto, idEmpresa, idGradeCorInicial, idGradeCorFinal, dataSaldo, monthData, yearData, tipoEstoqueCentroEstoque);
                hash.put("SAIDA_MES", ContatoFormatUtil.arrredondarNumeroBigDecimal((Double)saidaMes.doubleValue(), (int)2));
                hash.put("SAIDA_MES_ANT", ContatoFormatUtil.arrredondarNumeroBigDecimal((Double)saidaMesAnt.doubleValue(), (int)2));
            }
            if (opcaoImpressao == 2 && ContatoFormatUtil.arrredondarNumero((Double)saidaMes.doubleValue(), (int)2) > 0.0) {
                aux.add(hash);
                continue;
            }
            if (opcaoImpressao == 1 && ContatoFormatUtil.arrredondarNumero((Double)saldoQtd.doubleValue(), (int)2) > 0.0) {
                aux.add(hash);
                continue;
            }
            if (opcaoImpressao != 0) continue;
            aux.add(hash);
        }
        return aux;
    }

    private Object gerarSaidaMesSemCentroEstoque(Integer mes, Integer ano, Integer idProduto, Long idEmpresa, Long idGradeCorInicial, Long idGradeCorFinal, Date dataSaldo, Short tipoEstoqueCentroEstoque) {
        String sql = "SELECT COALESCE(SUM(S.QTD_SAIDA_DIA - S.QTD_SAIDA_DIA_INTERNO), 0) FROM SALDO_EST_PROPRIO S INNER JOIN GRADE_COR GC ON GC.ID_GRADE_COR = S.ID_GRADE_COR INNER JOIN PRODUTO_GRADE PG ON PG.ID_PRODUTO_GRADE = GC.ID_PRODUTO_GRADE WHERE PG.ID_PRODUTO = :ID_PRODUTO  AND S.ID_EMPRESA = :ID_EMPRESA AND (:ID_GRADE_COR_INICIAL IS NULL OR S.ID_GRADE_COR BETWEEN :ID_GRADE_COR_INICIAL AND :ID_GRADE_COR_FINAL) AND EXTRACT(month from S.DATA_SALDO) = :MONTH  AND EXTRACT(year from S.DATA_SALDO) = :YEAR AND S.DATA_SALDO <= :DATA_SALDO and s.tipo_saldo=:tipoEstoqueCentroEstoque";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(sql);
        q.setParameter("ID_PRODUTO", (Object)idProduto);
        q.setParameter("ID_EMPRESA", (Object)idEmpresa);
        q.setParameter("ID_GRADE_COR_INICIAL", (Object)idGradeCorInicial);
        q.setParameter("ID_GRADE_COR_FINAL", (Object)idGradeCorFinal);
        q.setParameter("DATA_SALDO", (Object)dataSaldo);
        q.setParameter("tipoEstoqueCentroEstoque", (Object)tipoEstoqueCentroEstoque);
        q.setParameter("MONTH", (Object)mes);
        q.setParameter("YEAR", (Object)ano);
        return q.uniqueResult();
    }

    private Object gerarSaidaMesComCentroEstoque(Integer mes, Integer ano, Integer idProduto, Long idEmpresa, Long idCentroEstoque, Long idGradeCorInicial, Long idGradeCorFinal, Date dataSaldo, Short tipoEstoqueCentroEstoque) {
        String sql = "SELECT COALESCE(SUM(S.QTD_SAIDA_DIA - S.QTD_SAIDA_DIA_INTERNO), 0) FROM SALDO_EST_PROPRIO S INNER JOIN GRADE_COR GC ON GC.ID_GRADE_COR = S.ID_GRADE_COR INNER JOIN PRODUTO_GRADE PG ON PG.ID_PRODUTO_GRADE = GC.ID_PRODUTO_GRADE WHERE PG.ID_PRODUTO = :ID_PRODUTO  AND S.ID_EMPRESA = :ID_EMPRESA AND S.ID_CENTRO_ESTOQUE = :ID_CENTRO_ESTOQUE  AND (:ID_GRADE_COR_INICIAL IS NULL OR S.ID_GRADE_COR BETWEEN :ID_GRADE_COR_INICIAL AND :ID_GRADE_COR_FINAL) AND EXTRACT(month from S.DATA_SALDO) = :MONTH  AND EXTRACT(year from S.DATA_SALDO) = :YEAR AND S.DATA_SALDO <= :DATA_SALDO and s.tipo_saldo=:tipoEstoqueCentroEstoque";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(sql);
        q.setParameter("ID_PRODUTO", (Object)idProduto);
        q.setParameter("ID_EMPRESA", (Object)idEmpresa);
        q.setParameter("ID_CENTRO_ESTOQUE", (Object)idCentroEstoque);
        q.setParameter("ID_GRADE_COR_INICIAL", (Object)idGradeCorInicial);
        q.setParameter("ID_GRADE_COR_FINAL", (Object)idGradeCorFinal);
        q.setParameter("DATA_SALDO", (Object)dataSaldo);
        q.setParameter("tipoEstoqueCentroEstoque", (Object)tipoEstoqueCentroEstoque);
        q.setParameter("MONTH", (Object)mes);
        q.setParameter("YEAR", (Object)ano);
        return q.uniqueResult();
    }

    private Object gerarSaidaMesAnteriorComCentroEstoque(Integer idProduto, Long idEmpresa, Long idCentroEstoque, Long idGradeCorInicial, Long idGradeCorFinal, Date dataSaldo, Integer monthData, Integer yearData, Short tipoEstoqueCentroEstoque) {
        int mes = DateUtil.monthFromDate(dataSaldo) - 1;
        int ano = yearData;
        if (mes == 0) {
            mes = 12;
            ano = yearData - 1;
        }
        String sql = " SELECT COALESCE(SUM(S.QTD_SAIDA_DIA - S.QTD_SAIDA_DIA_INTERNO), 0) FROM SALDO_EST_PROPRIO S  INNER JOIN GRADE_COR GC on GC.ID_GRADE_COR = S.ID_GRADE_COR  INNER JOIN PRODUTO_GRADE PG on PG.ID_PRODUTO_GRADE = GC.ID_PRODUTO_GRADE  WHERE PG.ID_PRODUTO = :ID_PRODUTO  AND S.ID_EMPRESA = :ID_EMPRESA  AND S.ID_CENTRO_ESTOQUE = :ID_CENTRO_ESTOQUE  AND (:ID_GRADE_COR_INICIAL is null or S.ID_GRADE_COR between :ID_GRADE_COR_INICIAL and :ID_GRADE_COR_FINAL)  AND EXTRACT(MONTH FROM S.DATA_SALDO) = :MONTH  AND EXTRACT(YEAR FROM S.DATA_SALDO) = :YEAR  AND S.DATA_SALDO <= :DATA_SALDO  and s.tipo_saldo =:tipoEstoqueCentroEstoque";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(sql);
        q.setParameter("ID_PRODUTO", (Object)idProduto);
        q.setParameter("ID_EMPRESA", (Object)idEmpresa);
        q.setParameter("ID_CENTRO_ESTOQUE", (Object)idCentroEstoque);
        q.setParameter("ID_GRADE_COR_INICIAL", (Object)idGradeCorInicial);
        q.setParameter("ID_GRADE_COR_FINAL", (Object)idGradeCorFinal);
        q.setParameter("DATA_SALDO", (Object)dataSaldo);
        q.setInteger("tipoEstoqueCentroEstoque", (int)tipoEstoqueCentroEstoque.shortValue());
        q.setInteger("MONTH", mes);
        q.setInteger("YEAR", ano);
        return q.uniqueResult();
    }

    private Object gerarSaidaMesAnteriorSemCentroEstoque(Integer idProduto, Long idEmpresa, Long idGradeCorInicial, Long idGradeCorFinal, Date dataSaldo, Integer monthData, Integer yearData, Short tipoEstoqueCentroEstoque) {
        int mes = DateUtil.monthFromDate(dataSaldo) - 1;
        int ano = yearData;
        if (mes == 0) {
            mes = 12;
            ano = yearData - 1;
        }
        String sql = " SELECT COALESCE(SUM(S.QTD_SAIDA_DIA - S.QTD_SAIDA_DIA_INTERNO), 0) FROM SALDO_EST_PROPRIO S  INNER JOIN GRADE_COR GC on GC.ID_GRADE_COR = S.ID_GRADE_COR  INNER JOIN PRODUTO_GRADE PG on PG.ID_PRODUTO_GRADE = GC.ID_PRODUTO_GRADE  WHERE PG.ID_PRODUTO = :ID_PRODUTO  AND S.ID_EMPRESA = :ID_EMPRESA  AND (:ID_GRADE_COR_INICIAL is null or S.ID_GRADE_COR between :ID_GRADE_COR_INICIAL and :ID_GRADE_COR_FINAL)  AND EXTRACT(MONTH FROM S.DATA_SALDO) = :MONTH  AND EXTRACT(YEAR FROM S.DATA_SALDO) = :YEAR  AND S.DATA_SALDO <= :DATA_SALDO  and s.tipo_saldo = :tipoEstoqueCentroEstoque";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(sql);
        q.setParameter("ID_PRODUTO", (Object)idProduto);
        q.setParameter("ID_EMPRESA", (Object)idEmpresa);
        q.setParameter("ID_GRADE_COR_INICIAL", (Object)idGradeCorInicial);
        q.setParameter("ID_GRADE_COR_FINAL", (Object)idGradeCorFinal);
        q.setParameter("DATA_SALDO", (Object)dataSaldo);
        q.setInteger("tipoEstoqueCentroEstoque", (int)tipoEstoqueCentroEstoque.shortValue());
        q.setInteger("MONTH", mes);
        q.setInteger("YEAR", ano);
        return q.uniqueResult();
    }

    public List<HashMap> getMovimentacoesEntradaSaidaPorPeriodoAndGradeQuantitativo(Date dataIn, Date dataFim, Long idEmpresa, Short filtrarProduto, Long idProdutoInicial, Long idProdutoFinal, Short tipoCentroEstPropTerc) {
        String query = "select coalesce(s.qtd_entrada_dia - s.qtd_entrada_dia_interno,0) as QUANTIDADE_ENTRADA, coalesce(s.qtd_saida_dia - s.qtd_saida_dia_interno,0)   as QUANTIDADE_SAIDA, s.id_produto as ID_PRODUTO, s.id_grade_cor as ID_GRADE_COR, s.id_centro_estoque as ID_CENTRO_ESTOQUE, s.data_saldo        as DATA_SALDO, s.id_saldo_est_proprio   as ID_SALDO_EST_PROPRIO from saldo_est_proprio s where s.data_saldo between :data_inicial and :data_final and s.id_empresa = :id_empresa and (:filtrarProduto=0 or s.id_produto between :id_produto_inicial and :id_produto_final) and s.tipo_saldo=:tipoCentroEstPropTerc";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery(query);
        q.setDate("data_inicial", dataIn);
        q.setDate("data_final", dataFim);
        q.setLong("id_empresa", idEmpresa.longValue());
        q.setShort("filtrarProduto", filtrarProduto.shortValue());
        q.setLong("id_produto_inicial", idProdutoInicial.longValue());
        q.setLong("id_produto_final", idProdutoFinal.longValue());
        q.setShort("tipoCentroEstPropTerc", tipoCentroEstPropTerc.shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        return lista;
    }

    private List dadosRelatorioConfEstoque(Short leachFabricante, Long idProdInicial, Long idProdFinal, Date dataSaldo, Long idLocalizacaoInicial, Long idLocalizacaoFinal, Long idCentroEstoqueInicial, Long idCentroEstoqueFinal, Long idFabricanteInicial, Long idFabricanteFinal, Long idEspecieInicial, Long idEspecieFinal, Long idSubEspecieInicial, Long idSubEspecieFinal, Long idGradeCorInicial, Long idGradeCorFinal, Integer tipoInicial, Integer tipoFinal, String ordenacao, Long idEmpresa, Short tipoEstoqueCentroEstoque) {
        Object sql = " SELECT DISTINCT  L.id_localizacao,  L.nome AS NOME_LOCALIZACAO,  PR.ID_PRODUTO,  PR.CODIGO_AUXILIAR,  PR.NOME AS NOME_PRODUTO,  U.SIGLA,  N.CODIGO,  S.SALDO_QTD,  S.ID_C_ESTOQUE AS ID_CENTRO_ESTOQUE,  c.descricao as centro_estoque,  pr.observacao as OBS_PRODUTO,  pr.qtd_min as F_QTD_MIN  FROM SALDO_PRODUTO_DETALHADO(:ID_TIPO_INICIAL, :ID_TIPO_FINAL, :ID_PROD_INICIAL, :ID_PROD_FINAL,  :DATA_SALDO,  :ID_GRADE_COR_INICIAL, :ID_GRADE_COR_FINAL, :ID_ESPECIE_INICIAL, :ID_ESPECIE_FINAL,  :ID_SUB_ESPECIE_INICIAL, :ID_SUB_ESPECIE_FINAL,  :ID_LOCALIZACAO_INICIAL, :ID_LOCALIZACAO_FINAL,  :ID_FABRICANTE_INICIAL, :ID_FABRICANTE_FINAL,  :ID_EMPRESA, :ID_EMPRESA,  :ID_CENTRO_ESTOQUE_INICIAL, :ID_CENTRO_ESTOQUE_FINAL,  :ID_LOTE_FAB, :TIPO_SALDO, :TIPO_SALDO_QUANTIDADE, :TIPO_CARREGAMENTO, :TIPO_DISPONIBILIDADE,:TIPO_ESTOQUE_C_ESTOQUE,:ID_PARCEIRO) S INNER JOIN PRODUTO       PR ON PR.ID_PRODUTO       = S.ID_PRODUTO  INNER JOIN localizacao    L ON L.id_localizacao   = PR.id_localizacao  INNER JOIN UNIDADE_MEDIDA U ON U.ID_UNIDADE_MEDIDA = PR.ID_UNIDADE_MEDIDA  LEFT  JOIN centro_estoque c on c.id_centro_estoque = s.id_c_estoque  LEFT  JOIN NCM            N ON N.ID_NCM = PR.ID_NCM  WHERE (:LEACH_FABRICANTE <> 1 or (pr.id_fabricante between :ID_FABRICANTE_INICIAL AND :ID_FABRICANTE_FINAL))";
        sql = (String)sql + " ORDER BY " + ordenacao;
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery((String)sql);
        q.setParameter("ID_TIPO_INICIAL", (Object)tipoInicial);
        q.setParameter("ID_TIPO_FINAL", (Object)tipoFinal);
        q.setParameter("ID_PROD_INICIAL", (Object)idProdInicial);
        q.setParameter("ID_PROD_FINAL", (Object)idProdFinal);
        q.setParameter("DATA_SALDO", (Object)dataSaldo);
        q.setParameter("ID_GRADE_COR_INICIAL", (Object)idGradeCorInicial);
        q.setParameter("ID_GRADE_COR_FINAL", (Object)idGradeCorFinal);
        q.setParameter("ID_ESPECIE_INICIAL", (Object)idEspecieInicial);
        q.setParameter("ID_ESPECIE_FINAL", (Object)idEspecieFinal);
        q.setParameter("ID_SUB_ESPECIE_INICIAL", (Object)idSubEspecieInicial);
        q.setParameter("ID_SUB_ESPECIE_FINAL", (Object)idSubEspecieFinal);
        q.setParameter("ID_LOCALIZACAO_INICIAL", (Object)idLocalizacaoInicial);
        q.setParameter("ID_LOCALIZACAO_FINAL", (Object)idLocalizacaoFinal);
        q.setParameter("ID_FABRICANTE_INICIAL", (Object)idFabricanteInicial);
        q.setParameter("ID_FABRICANTE_FINAL", (Object)idFabricanteFinal);
        q.setParameter("ID_EMPRESA", (Object)idEmpresa);
        q.setParameter("ID_CENTRO_ESTOQUE_INICIAL", (Object)idCentroEstoqueInicial);
        q.setParameter("ID_CENTRO_ESTOQUE_FINAL", (Object)idCentroEstoqueFinal);
        q.setParameter("TIPO_SALDO", (Object)3);
        q.setParameter("TIPO_SALDO_QUANTIDADE", (Object)1);
        q.setParameter("TIPO_CARREGAMENTO", (Object)2);
        q.setParameter("ID_LOTE_FAB", null);
        q.setParameter("TIPO_DISPONIBILIDADE", null);
        q.setParameter("TIPO_ESTOQUE_C_ESTOQUE", (Object)tipoEstoqueCentroEstoque);
        q.setParameter("ID_PARCEIRO", null);
        q.setParameter("LEACH_FABRICANTE", (Object)leachFabricante);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private HashMap getDadosProdutoPorIdProduto(Long idProduto) {
        String query = "select p.pontoRessupEstoque as PONTO_RESSUPRIMENTO, p.qtdMin as QTD_MIN, p.qtdMax as QTD_MAX  from Produto p  where p.identificador = :idProduto";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        q.setLong("idProduto", idProduto.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setMaxResults(1);
        return (HashMap)q.uniqueResult();
    }

    public Long getMaxIdProdAnaliseEstoque() {
        String query = "select max(p.identificador)  from Produto p ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query);
        return (Long)q.uniqueResult();
    }

    private class SaldoResultTransformer
    implements ResultTransformer {
        private String idEmp = "ID_EMPRESA";
        private int idEmpInd = -1;
        private String idLoteFab = "ID_LOTE_FABRICACAO";
        private int idLoteFabInd = -1;
        private String idGradeCor = "ID_GRADE_COR";
        private int idGradeCorInd = -1;
        private String qtdEntDia = "QTD_ENTRADA_DIA";
        private int qtdEntDiaInd = -1;
        private String qtdSaida = "QTD_SAIDA_DIA";
        private int qtdSaidaInd = -1;
        private String saldoQtd = "SALDO_QTD";
        private int saldoQtdInd = -1;
        private String saldoValor = "SALDO_VALOR";
        private int saldoValorInd = -1;
        private String vlrPrecoMedio = "VALOR_PRECO_MEDIO";
        private int vlrPrecoMedioInd = -1;
        private String dtSaldo = "DATA_SALDO";
        private int dtSaldoInd = -1;
        private boolean isConfigured = false;
        private String idCentroEstoque = "ID_CENTRO_ESTOQUE";
        private String idCentroEstoque_2 = "ID_C_ESTOQUE";
        private int idCentroEstoqueInd = -1;
        private String idProduto = "ID_PRODUTO";
        private int idProdutoInd = -1;

        private SaldoResultTransformer() {
        }

        private void configure(String[] strings) {
            if (!this.isConfigured) {
                for (int i = 0; i < strings.length; ++i) {
                    String o = strings[i];
                    if (o.equalsIgnoreCase(this.idEmp)) {
                        this.idEmpInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idLoteFab)) {
                        this.idLoteFabInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idGradeCor)) {
                        this.idGradeCorInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.qtdEntDia)) {
                        this.qtdEntDiaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.qtdSaida)) {
                        this.qtdSaidaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.saldoValor)) {
                        this.saldoValorInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.vlrPrecoMedio)) {
                        this.vlrPrecoMedioInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.dtSaldo)) {
                        this.dtSaldoInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.saldoQtd)) {
                        this.saldoQtdInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idCentroEstoque)) {
                        this.idCentroEstoqueInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idCentroEstoque_2)) {
                        this.idCentroEstoqueInd = i;
                        continue;
                    }
                    if (!o.equalsIgnoreCase(this.idProduto)) continue;
                    this.idProdutoInd = i;
                }
                this.isConfigured = true;
            }
        }

        public Object transformTuple(Object[] os, String[] strings) {
            try {
                SaldoEstoqueGeral s = new SaldoEstoqueGeral();
                this.configure(strings);
                if (this.dtSaldoInd >= 0) {
                    s.setDataSaldo((Date)os[this.dtSaldoInd]);
                }
                if (this.idEmpInd >= 0 && os[this.idEmpInd] != null) {
                    s.setEmpresa((Empresa)CoreDAOFactory.getInstance().getDAOEmpresa().findByPrimaryKey(((Integer)os[this.idEmpInd]).longValue()));
                }
                if (this.idGradeCorInd >= 0 && os[this.idGradeCorInd] != null) {
                    CoreDAOFactory.getInstance();
                    s.setGradeCor((GradeCor)CoreDAOFactory.getInstance().getDAOGradeCor().findByPrimaryKey(((Integer)os[this.idGradeCorInd]).longValue()));
                }
                if (this.idLoteFabInd >= 0 && os[this.idLoteFabInd] != null) {
                    s.setLoteFabricacao((LoteFabricacao)CoreDAOFactory.getInstance().getDAOLoteFabricacao().findByPrimaryKey(((Integer)os[this.idLoteFabInd]).longValue()));
                }
                if (this.saldoQtdInd >= 0 && os[this.saldoQtdInd] != null) {
                    s.setQuantidade(Double.valueOf(((Number)os[this.saldoQtdInd]).doubleValue()));
                }
                if (this.qtdEntDiaInd >= 0 && os[this.qtdEntDiaInd] != null) {
                    s.setQuantidadeEntrada(Double.valueOf(((Number)os[this.qtdEntDiaInd]).doubleValue()));
                }
                if (this.qtdSaidaInd >= 0 && os[this.qtdSaidaInd] != null) {
                    s.setQuantidadeSaida(Double.valueOf(((Number)os[this.qtdSaidaInd]).doubleValue()));
                }
                if (this.saldoValorInd >= 0 && os[this.saldoValorInd] != null) {
                    s.setValor(Double.valueOf(((Number)os[this.saldoValorInd]).doubleValue()));
                }
                if (this.vlrPrecoMedioInd >= 0 && os[this.vlrPrecoMedioInd] != null) {
                    s.setValorMedio(Double.valueOf(((Number)os[this.vlrPrecoMedioInd]).doubleValue()));
                }
                if (this.idCentroEstoqueInd >= 0 && os[this.idCentroEstoqueInd] != null) {
                    s.setCentroEstoque((CentroEstoque)CoreDAOFactory.getInstance().getDAOCentroEstoque().findByPrimaryKey(((Integer)os[this.idCentroEstoqueInd]).longValue()));
                }
                if (this.idProdutoInd >= 0 && os[this.idProdutoInd] != null) {
                    s.setProduto((Produto)CoreDAOFactory.getInstance().getDAOProduto().findByPrimaryKey(((Integer)os[this.idProdutoInd]).longValue()));
                }
                return s;
            }
            catch (ExceptionDatabase ex) {
                throw new RuntimeException("Erro ao converter os saldos\n" + ex.getMessage());
            }
        }

        public List transformList(List list) {
            return list;
        }
    }

    private class SaldoBasicoResultTransformer
    implements ResultTransformer {
        private String idEmp = "ID_EMPRESA";
        private int idEmpInd = -1;
        private String idLoteFab = "ID_LOTE_FABRICACAO";
        private int idLoteFabInd = -1;
        private String idGradeCor = "ID_GRADE_COR";
        private int idGradeCorInd = -1;
        private String qtdEntDia = "QTD_ENTRADA_DIA";
        private int qtdEntDiaInd = -1;
        private String qtdSaida = "QTD_SAIDA_DIA";
        private int qtdSaidaInd = -1;
        private String saldoQtd = "SALDO_QTD";
        private int saldoQtdInd = -1;
        private String saldoValor = "SALDO_VALOR";
        private int saldoValorInd = -1;
        private String vlrPrecoMedio = "VALOR_PRECO_MEDIO";
        private int vlrPrecoMedioInd = -1;
        private String dtSaldo = "DATA_SALDO";
        private int dtSaldoInd = -1;
        private boolean isConfigured = false;
        private String idCentroEstoque = "ID_CENTRO_ESTOQUE";
        private String idCentroEstoque_2 = "ID_C_ESTOQUE";
        private int idCentroEstoqueInd = -1;
        private String idProduto = "ID_PRODUTO";
        private int idProdutoInd = -1;

        private SaldoBasicoResultTransformer() {
        }

        private void configure(String[] strings) {
            if (!this.isConfigured) {
                for (int i = 0; i < strings.length; ++i) {
                    String o = strings[i];
                    if (o.equalsIgnoreCase(this.idEmp)) {
                        this.idEmpInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idLoteFab)) {
                        this.idLoteFabInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idGradeCor)) {
                        this.idGradeCorInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.qtdEntDia)) {
                        this.qtdEntDiaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.qtdSaida)) {
                        this.qtdSaidaInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.saldoValor)) {
                        this.saldoValorInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.vlrPrecoMedio)) {
                        this.vlrPrecoMedioInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.dtSaldo)) {
                        this.dtSaldoInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.saldoQtd)) {
                        this.saldoQtdInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idCentroEstoque)) {
                        this.idCentroEstoqueInd = i;
                        continue;
                    }
                    if (o.equalsIgnoreCase(this.idCentroEstoque_2)) {
                        this.idCentroEstoqueInd = i;
                        continue;
                    }
                    if (!o.equalsIgnoreCase(this.idProduto)) continue;
                    this.idProdutoInd = i;
                }
                this.isConfigured = true;
            }
        }

        public Object transformTuple(Object[] os, String[] strings) {
            SaldoEstoqueGeralBasico s = new SaldoEstoqueGeralBasico();
            this.configure(strings);
            if (this.dtSaldoInd >= 0) {
                s.setDataSaldo((Date)os[this.dtSaldoInd]);
            }
            if (this.idEmpInd >= 0 && os[this.idEmpInd] != null) {
                s.setIdEmpresa(Long.valueOf(((Number)os[this.idEmpInd]).longValue()));
            }
            if (this.idGradeCorInd >= 0 && os[this.idGradeCorInd] != null) {
                s.setIdGradeCor(Long.valueOf(((Number)os[this.idGradeCorInd]).longValue()));
            }
            if (this.idLoteFabInd >= 0 && os[this.idLoteFabInd] != null) {
                s.setIdLoteFabricacao(Long.valueOf(((Number)os[this.idLoteFabInd]).longValue()));
            }
            if (this.saldoQtdInd >= 0 && os[this.saldoQtdInd] != null) {
                s.setQuantidade(Double.valueOf(((Number)os[this.saldoQtdInd]).doubleValue()));
            }
            if (this.qtdEntDiaInd >= 0 && os[this.qtdEntDiaInd] != null) {
                s.setQuantidadeEntrada(Double.valueOf(((Number)os[this.qtdEntDiaInd]).doubleValue()));
            }
            if (this.qtdSaidaInd >= 0 && os[this.qtdSaidaInd] != null) {
                s.setQuantidadeSaida(Double.valueOf(((Number)os[this.qtdSaidaInd]).doubleValue()));
            }
            if (this.saldoValorInd >= 0 && os[this.saldoValorInd] != null) {
                s.setValor(Double.valueOf(((Number)os[this.saldoValorInd]).doubleValue()));
            }
            if (this.vlrPrecoMedioInd >= 0 && os[this.vlrPrecoMedioInd] != null) {
                s.setValorMedio(Double.valueOf(((Number)os[this.vlrPrecoMedioInd]).doubleValue()));
            }
            if (this.idCentroEstoqueInd >= 0 && os[this.idCentroEstoqueInd] != null) {
                s.setIdCentroEstoque(Long.valueOf(((Number)os[this.idCentroEstoqueInd]).longValue()));
            }
            if (this.idProdutoInd >= 0 && os[this.idProdutoInd] != null) {
                s.setIdProduto(Long.valueOf(((Number)os[this.idProdutoInd]).longValue()));
            }
            return s;
        }

        public List transformList(List list) {
            return list;
        }
    }
}

