/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.SaldoEstProprioDia;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOSaldoEstProprioDia
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return SaldoEstProprioDia.class;
    }

    public List searchSaldoDiaToSync(Date dataSaldo, Long idEmpresa) {
        Session session = CoreBdUtil.getInstance().getSession();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select s.gradeCor.identificador as gradeCor,");
        sqlQuery.append("s.empresa.identificador as empresa, ");
        sqlQuery.append("s.dataSaldo as dataSaldo, ");
        sqlQuery.append("s.quantidade as quantidade ");
        sqlQuery.append("from SaldoEstProprioDia s where s.dataSaldo = :data and s.empresa.identificador = :idEmpresa");
        Query query = session.createQuery(sqlQuery.toString());
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        query.setDate("data", dataSaldo);
        query.setLong("idEmpresa", idEmpresa.longValue());
        return query.list();
    }

    public List searchSaldoToSync(Date dataSaldo, Long idEmpresa) {
        Session session = CoreBdUtil.getInstance().getSession();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select gc.ID_GRADE_COR as gradeCor, ");
        sqlQuery.append(" s.ID_EMPRESA_SALDO as empresa,");
        sqlQuery.append(" s.DATA_POSICAO_SALDO as dataSaldo,");
        sqlQuery.append(" s.SALDO_QTD as quantidade");
        sqlQuery.append(" from SALDO_PRODUTO_UNIFICADO(:idEmpresa, :data, 0, 99999999, 0, 999999, 0, 999999, 0, 999999, 0, 0, 1) s ");
        sqlQuery.append(" inner join PRODUTO_GRADE pg on pg.ID_PRODUTO = s.ID_PRODUTO");
        sqlQuery.append(" inner join GRADE_COR gc on gc.ID_PRODUTO_GRADE = pg.ID_PRODUTO_GRADE");
        NativeQuery query = session.createSQLQuery(sqlQuery.toString());
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        query.setDate("data", dataSaldo);
        query.setLong("idEmpresa", idEmpresa.longValue());
        return query.list();
    }

    public void clearSaldoDia() {
        Session session = CoreBdUtil.getInstance().getSession();
        String strQuery = "delete from saldo_est_proprio_dia";
        NativeQuery query = session.createSQLQuery(strQuery);
        query.executeUpdate();
    }
}

