/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.ItemTabelaIRRFPlr;
import com.touchcomp.basementor.model.vo.TabelaIRRFPlr;
import contatocore.util.ContatoDateUtil;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.CoreRequestContext;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class DAOTabelaIRRFPlr
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return TabelaIRRFPlr.class;
    }

    public Boolean verificarPeriodo(CoreRequestContext request) {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Long idIRRFPlr = (Long)request.getAttribute("idIRRFPlr");
        Session s = null;
        NativeQuery q = null;
        s = CoreBdUtil.getInstance().getSession();
        q = s.createSQLQuery(" select * from tabela_irrf_plr t2 where :dataFinal >=  t2.data_inicial and :dataInicial <= t2.data_final and t2.id_tabela_irrf_plr != :idIRRFPlr ");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("idIRRFPlr", idIRRFPlr.longValue());
        List results = q.list();
        if (results.isEmpty()) {
            return true;
        }
        return false;
    }

    public TabelaIRRFPlr pegarTabelaPorPeriodo(CoreRequestContext request) {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        q = s.createQuery(" from tabelaIRRFPlr t where :periodo between t.dataInicial and t.dataFinal");
        q.setDate("periodo", this.converterPeriodoParaDate((String)request.getAttribute("periodo")));
        TabelaIRRFPlr tabela = (TabelaIRRFPlr)q.uniqueResult();
        return tabela;
    }

    private Date converterPeriodoParaDate(String periodo) {
        String aux = "01/" + periodo;
        return ContatoDateUtil.strToDate((String)aux);
    }

    public TabelaIRRFPlr pegarTabelaAtual(CoreRequestContext request) {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        q = s.createQuery(" from TabelaIRRFPlr t where t.identificador = (select max (t2.identificador) from TabelaIRRFPlr t2) ");
        TabelaIRRFPlr tabela = (TabelaIRRFPlr)q.uniqueResult();
        return tabela;
    }

    public TabelaIRRFPlr findTabelaPorDataPagamento(Date dataPagamento) {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        String hql = "from TabelaIRRFPlr t where :dataPagamento between t.dataInicial and t.dataFinal";
        q = s.createQuery(hql);
        q.setDate("dataPagamento", dataPagamento);
        return (TabelaIRRFPlr)q.uniqueResult();
    }

    public ItemTabelaIRRFPlr findItemTabelaMenorIndice(TabelaIRRFPlr t) {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        String hql = " from ItemTabelaIRRFPlr i  where i.indice = (select min(it.indice)                    from ItemTabelaIRRFPlr it                    where it.tabelaIRRFPlr = :tabelaIRRFPlr)  and  i.tabelaIRRFPlr = :tabelaIRRFPlr";
        q = s.createQuery(hql);
        q.setEntity("tabelaIRRFPlr", (Object)t);
        return (ItemTabelaIRRFPlr)q.uniqueResult();
    }
}

