/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseGrupoProdutos;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import java.util.Date;
import java.util.Map;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOTabelaPrecoBase
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return TabelaPrecoBase.class;
    }

    public TabelaPrecoBaseProduto getPrecosBase(Produto produto, Long idTabelaBase, Moeda moeda) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select b.identificador as ID_TAB_PRECO_BASE, tpv.identificador as ID_TAB_PRECO_BASE_VINC from TabelaPrecoBase b left join b.tabelaPrecoVinculada tpv where b.identificador =:idTabelaBase and b.moeda = :moeda";
        Query q = s.createQuery((String)(hql = (String)hql + " order by b.identificador desc")).setMaxResults(1).setEntity("moeda", (Object)moeda).setLong("idTabelaBase", idTabelaBase.longValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map found = (Map)q.uniqueResult();
        if (found == null) {
            return null;
        }
        Long idTab = (Long)found.get("ID_TAB_PRECO_BASE");
        Long idTabVinc = (Long)found.get("ID_TAB_PRECO_BASE_VINC");
        hql = "select t from TabelaPrecoBaseProduto t inner join t.tabelaPrecoBase b where t.produto=:produto  and t.ativo = :ativo and b.identificador=:idTab";
        q = s.createQuery((String)hql).setMaxResults(1).setEntity("produto", (Object)produto).setLong("idTab", idTab.longValue()).setShort("ativo", (short)1);
        TabelaPrecoBaseProduto t = (TabelaPrecoBaseProduto)q.uniqueResult();
        if (t != null) {
            return t;
        }
        if (idTabVinc == null) {
            return null;
        }
        q.setLong("idTab", idTabVinc.longValue());
        t = (TabelaPrecoBaseProduto)q.uniqueResult();
        if (t != null) {
            return t;
        }
        return null;
    }

    public TabelaPrecoBaseProduto getTabelaPrecoBaseProd(TabelaPrecoBase tabelaPrecoBase, Produto produto) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select b.identificador as ID_TAB_PRECO_BASE, tpv.identificador as ID_TAB_PRECO_BASE_VINC from TabelaPrecoBaseProduto t left join t.tabelaPrecoBase b left join b.tabelaPrecoVinculada tpv where b = :tabelaPrecoBase";
        Query q = s.createQuery((String)(hql = (String)hql + " order by b.identificador desc")).setMaxResults(1).setEntity("tabelaPrecoBase", (Object)tabelaPrecoBase).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map found = (Map)q.uniqueResult();
        if (found == null) {
            return null;
        }
        Long idTab = (Long)found.get("ID_TAB_PRECO_BASE");
        Long idTabVinc = (Long)found.get("ID_TAB_PRECO_BASE_VINC");
        hql = "select t from TabelaPrecoBaseProduto t inner join t.tabelaPrecoBase b where t.produto=:produto  and t.ativo = :ativo and b.identificador=:idTab";
        q = s.createQuery((String)hql).setMaxResults(1).setEntity("produto", (Object)produto).setLong("idTab", idTab.longValue()).setShort("ativo", (short)1);
        TabelaPrecoBaseProduto t = (TabelaPrecoBaseProduto)q.uniqueResult();
        if (t != null) {
            return t;
        }
        if (idTabVinc == null) {
            return null;
        }
        q.setLong("idTab", idTabVinc.longValue());
        t = (TabelaPrecoBaseProduto)q.uniqueResult();
        if (t != null) {
            return t;
        }
        return null;
    }

    public TabelaPrecoBaseGrupoProdutos getPrecosBaseGrupoProdutos(GrupoProdutos grupoProdutos, Long idTabelaBase, Moeda moeda) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select t from TabelaPrecoBaseGrupoProdutos t  where t.grupoProdutos = :grupoProdutos and :data between t.tabelaPrecoBase.dataInicial and t.tabelaPrecoBase.dataFinal and t.tabelaPrecoBase.identificador = :idTabelaBase and t.ativo=:sim and t.tabelaPrecoBase.moeda = :moeda and (t.tabelaPrecoBase.tabelaUsoInterno is null or t.tabelaPrecoBase.tabelaUsoInterno <> :sim)";
        return (TabelaPrecoBaseGrupoProdutos)s.createQuery(hql).setMaxResults(1).setEntity("grupoProdutos", (Object)grupoProdutos).setEntity("moeda", (Object)moeda).setDate("data", DateUtil.getCurrentDate()).setLong("idTabelaBase", idTabelaBase.longValue()).setLong("sim", 1L).uniqueResult();
    }

    public Object findPrecoUnitarioProduto(Long identificador, Date data) {
        String hql = "select t.valorVenda from TabelaPrecoBaseProduto t where :data between t.tabelaPrecoBase.dataInicial and t.tabelaPrecoBase.dataFinal and t.produto.identificador=:ident and (t.tabelaPrecoBase.tabelaUsoInterno is null or t.tabelaPrecoBase.tabelaUsoInterno <> :sim) ";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setLong("ident", identificador.longValue());
        q.setDate("data", data);
        q.setMaxResults(1);
        return q.uniqueResult();
    }

    public CoreRequestContext findPrecosTabelaPessoaComissao(Pessoa pessoaCli, Pessoa pessoaRep, Produto produto) {
        CoreRequestContext result = new CoreRequestContext();
        Object[] dadosPrecoPessoa = null;
        Double percPesMinimo = 0.0;
        Double percPesMaximo = 0.0;
        if (pessoaCli != null) {
            dadosPrecoPessoa = this.getPrecosClienteComissao(pessoaCli, produto);
        }
        if ((dadosPrecoPessoa == null || dadosPrecoPessoa.length == 0) && pessoaRep != null) {
            dadosPrecoPessoa = this.getPrecosRepresentanteComissao(pessoaRep, produto);
        }
        if (dadosPrecoPessoa != null && dadosPrecoPessoa.length > 0) {
            percPesMinimo = (Double)dadosPrecoPessoa[0];
            percPesMaximo = (Double)dadosPrecoPessoa[1];
        }
        result.setAttribute("percPesMinimo", percPesMinimo);
        result.setAttribute("percPesMaximo", percPesMaximo);
        return result;
    }

    private Object[] getPrecosClienteComissao(Pessoa pessoa, Produto produto) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select t.percMinoracaoComissao, t.percMaxMinorComissao from TabelaPrecoPessoaProduto t where t.produto=:produto and  t.tabPrecoPessoa.pessoa = :pessoa";
        Object[] dadosPrecoPessoa = (Object[])s.createQuery(hql).setMaxResults(1).setEntity("produto", (Object)produto).setEntity("pessoa", (Object)pessoa).uniqueResult();
        return dadosPrecoPessoa;
    }

    private Object[] getPrecosRepresentanteComissao(Pessoa pessoa, Produto produto) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "";
        hql = "select t.percMinoracaoComissao, t.percMaxMinorComissao from TabelaPrecoPessoaProduto t where t.produto=:produto and  t.tabPrecoPessoa.pessoa = :pessoa";
        Object[] dadosPrecoPessoa = (Object[])s.createQuery(hql).setMaxResults(1).setEntity("produto", (Object)produto).setEntity("pessoa", (Object)pessoa).uniqueResult();
        if (dadosPrecoPessoa != null && dadosPrecoPessoa.length > 0) {
            return dadosPrecoPessoa;
        }
        return dadosPrecoPessoa;
    }

    public Double getPercComissaoMultiplasComissoesTabelaBase(Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Double valorUnitario) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select c.percComissao  from TabelaPrecoBaseProdutoComissao c  inner join c.tabelaPrecoBaseProduto t inner join t.tabelaPrecoBase b left join b.ufs u left join u.unidadeFederativa ud  where t.produto=:produto and :data between b.dataInicial and b.dataFinal and b.tabelaPrincipal = :principal and t.ativo = :sim and u.ativo = :sim and b.moeda = :moeda and :valorUnitario between c.valorVendaInicial and c.valorVendaFinal and c.ativo = :sim and (b.tabelaUsoInterno is null or b.tabelaUsoInterno <> :sim)";
        if (uf != null) {
            hql = (String)hql + " and ud=:uf";
        }
        Query q = s.createQuery((String)hql).setMaxResults(1).setEntity("produto", (Object)produto).setDate("data", dataEmissao).setShort("principal", (short)1).setEntity("moeda", (Object)moeda).setShort("sim", (short)1).setDouble("valorUnitario", valorUnitario.doubleValue());
        if (uf != null) {
            q.setEntity("uf", (Object)uf);
        }
        return (Double)q.uniqueResult();
    }
}

