/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOTabelaPrecoBaseProduto
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return TabelaPrecoBaseProduto.class;
    }

    public TabelaPrecoBaseProduto getTabelaPrecoProduto(TabelaPrecoBase tabelaBase, Produto prod) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(this.getVOClass());
        c.add((Criterion)Restrictions.eq((String)"produto", (Object)prod));
        c.add((Criterion)Restrictions.eq((String)"tabelaPrecoBase", (Object)tabelaBase));
        c.setMaxResults(1);
        return (TabelaPrecoBaseProduto)c.uniqueResult();
    }

    public List<HashMap> buscarProdTabelaByDesc(String text, TabelaPrecoBase tabela, Empresa empresa) {
        if (text.length() > 115) {
            return new LinkedList<HashMap>();
        }
        String hql = " select distinct      p.identificador as IDENTIFICADOR,      p.codigoAuxiliar as COD_AUXILIAR,      p.nome as NOME_PROD,      f.nome as FABRICANTE,      u.sigla as UNID_MEDIDA,      t.valorVenda as PRECO_VENDA,      t.valorCusto as PRECO_CUSTO  from TabelaPrecoBaseProduto t  inner join t.tabelaPrecoBase tb  inner join tb.empresa e  inner join t.produto p  inner join p.unidadeMedida u  inner join p.fabricante f  where upper(p.nome) like :nome  and e.identificador = :empresa  and ( tb.identificador = :tabelaBase ) and p.ativo = :ativo  order by p.nome ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setString("nome", "%" + text.toUpperCase() + "%");
        q.setLong("empresa", empresa.getIdentificador().longValue());
        q.setShort("ativo", (short)1);
        q.setLong("tabelaBase", tabela.getIdentificador().longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> buscarProdTabelaById(Long idProduto, TabelaPrecoBase tabela, Empresa empresa) {
        String hql = " select distinct      p.identificador as IDENTIFICADOR,      p.codigoAuxiliar as COD_AUXILIAR,      p.nome as NOME_PROD,      u.sigla as UNID_MEDIDA,      t.valorVenda as PRECO_VENDA,      t.valorCusto as PRECO_CUSTO  from TabelaPrecoBaseProduto t  inner join t.tabelaPrecoBase tb  inner join tb.empresa e  inner join t.produto p  inner join p.unidadeMedida u  where p.identificador = :idProduto  and e.identificador = :empresa  and ( tb.identificador = :tabelaBase ) and p.ativo = :ativo  order by p.nome ";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setLong("idProduto", idProduto.longValue());
        q.setLong("empresa", empresa.getIdentificador().longValue());
        q.setShort("ativo", (short)1);
        q.setLong("tabelaBase", tabela.getIdentificador().longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

