/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.TabelaPrecoCodigo;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import java.util.Date;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOTabelaPrecoCodigo
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return TabelaPrecoCodigo.class;
    }

    public CoreRequestContext findPrecosBaseCodigo(String codAux, Date dataEmissao, UnidadeFederativa uf, Moeda moeda) throws ExceptionService {
        CoreRequestContext result = new CoreRequestContext();
        Object[] dadosPrecoProduto = this.getPrecosBasePrincipal(codAux, dataEmissao, uf, moeda);
        Double percMinimo = 0.0;
        Double percMaximo = 0.0;
        Double valorVenda = 0.0;
        Double percComissao = 0.0;
        Double percBonusRep = 0.0;
        Double valorCusto = 0.0;
        if (dadosPrecoProduto == null || dadosPrecoProduto.length == 0) {
            throw new ExceptionService("Produto sem Tabela de Pre\u00e7o Codigo, tabela de pre\u00e7o expirada, ou sem tabela principal.");
        }
        if (dadosPrecoProduto != null && dadosPrecoProduto.length > 0) {
            percMinimo = (Double)dadosPrecoProduto[1];
            percMaximo = (Double)dadosPrecoProduto[2];
            valorVenda = (Double)dadosPrecoProduto[0];
            percComissao = (Double)dadosPrecoProduto[3];
            percBonusRep = (Double)dadosPrecoProduto[4];
            valorCusto = (Double)dadosPrecoProduto[5];
        }
        if (percMinimo == null) {
            percMinimo = 0.0;
        }
        if (percMaximo == null) {
            percMaximo = 0.0;
        }
        if (valorVenda == null) {
            valorVenda = 0.0;
        }
        if (percComissao == null) {
            percComissao = 0.0;
        }
        result.setAttribute("percComissao", percComissao);
        result.setAttribute("valorVenda", valorVenda);
        result.setAttribute("percBonusRep", percBonusRep);
        result.setAttribute("valorMinimo", valorVenda - valorVenda * (percMinimo / 100.0));
        result.setAttribute("valorMaximo", valorVenda + valorVenda * (percMaximo / 100.0));
        result.setAttribute("valorCusto", valorCusto);
        return result;
    }

    private Object[] getPrecosBasePrincipal(String codAux, Date dataEmissao, UnidadeFederativa uf, Moeda moeda) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct t.valorVenda,t.percentualMinimo,t.percentualMaximo, t.percentualComissaoPadrao,t.percentualBonusRep, t.valorCusto, b.identificador  from TabelaPrecoCodigoCodigo t inner join t.tabelaPrecoCodigo b left join b.tabelaPrecoCodigoUf u left join u.unidadeFederativa ud  where t.codigo = :codigo and :data between b.dataInicial and b.dataFinal and b.tabelaPrincipal = :principal and t.ativo = :sim and u.ativo = :sim and b.moeda = :moeda";
        if (uf != null) {
            hql = (String)hql + " and ud=:uf";
        }
        hql = (String)hql + " order by b.identificador desc";
        Query q = s.createQuery((String)hql).setMaxResults(1).setString("codigo", codAux).setDate("data", dataEmissao).setShort("principal", (short)1).setEntity("moeda", (Object)moeda).setShort("sim", (short)1);
        if (uf != null) {
            q.setEntity("uf", (Object)uf);
        }
        Object[] dadosPrecoProduto = (Object[])q.uniqueResult();
        return dadosPrecoProduto;
    }
}

