/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.constants.enums.ticketfiscal.EnumConstTicketFiscalStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOTicketFiscal
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return TicketFiscal.class;
    }

    public List findTicketFiscal(Date dataInicial, Date dataFinal, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM TicketFiscal t WHERE t.dataAbertura BETWEEN :dataInicial AND :dataFinal AND t.empresa = :empresa");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List pesquisarTicketFiscalEmAberto() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM TicketFiscal t WHERE t.status = :status");
        q.setShort("status", EnumConstTicketFiscalStatus.ABERTO.value);
        return q.list();
    }

    public TicketFiscal verificarPlacaEmAberto(String placa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM TicketFiscal t WHERE t.placa = :placa AND t.status = :status");
        q.setString("placa", placa);
        q.setShort("status", EnumConstTicketFiscalStatus.ABERTO.value);
        return (TicketFiscal)q.uniqueResult();
    }

    public TicketFiscal pesquisarTicketFiscalNumero(Empresa empresa, Integer numero, String serie) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM TicketFiscal t WHERE t.numero = :numero AND t.serie = :serie AND t.empresa = :empresa");
        q.setInteger("numero", numero.intValue());
        q.setString("serie", serie);
        q.setEntity("empresa", (Object)empresa);
        return (TicketFiscal)q.uniqueResult();
    }

    public Double pesquisarTicketPedidoSaldo(Pedido pedido) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT SUM(t.quantidade) FROM PedidoTicketFiscal t INNER JOIN t.ticketFiscal f INNER JOIN t.pedido p WHERE p = :pedido AND f.status = :status");
        q.setEntity("pedido", (Object)pedido);
        q.setShort("status", EnumConstTicketFiscalStatus.FECHADA.value);
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        return (Double)q.uniqueResult();
    }

    public Double pesquisarTicketPorPedidoAndGrade(Pedido pedido, GradeItemPedido gradeItemPedido) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT SUM(t.quantidade) FROM PedidoTicketFiscal t INNER JOIN t.ticketFiscal f INNER JOIN t.pedido p WHERE p = :pedido AND t.gradeItemPedido = :gradeItemPedido AND f.status = :status");
        q.setEntity("pedido", (Object)pedido);
        q.setEntity("gradeItemPedido", (Object)gradeItemPedido);
        q.setShort("status", EnumConstTicketFiscalStatus.FECHADA.value);
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        return (Double)q.uniqueResult();
    }

    public List<HashMap> pesquisarTicketPorPedido(Pedido pedido) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT t.pedido.identificador as ID_PEDIDO, t.gradeItemPedido.identificador as ID_GRADE_ITEM_PEDIDO, t.quantidade as QUANTIDADE  FROM PedidoTicketFiscal t INNER JOIN t.ticketFiscal f INNER JOIN t.pedido p WHERE p = :pedido AND f.status = :status");
        q.setEntity("pedido", (Object)pedido);
        q.setShort("status", EnumConstTicketFiscalStatus.FECHADA.value);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> pesquisarGradesPedido(Pedido pedido) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT distinct g.identificador as ID_GRADE_ITEM_PEDIDO, g.gradeCor.identificador as ID_GRADE_COR, g.quantidade as QUANTIDADE  FROM Pedido p INNER JOIN p.itemPedido i INNER JOIN i.gradeItemPedido g WHERE p = :pedido");
        q.setEntity("pedido", (Object)pedido);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }
}

