/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.LiberacaoTitulos;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOTitulo
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Titulo.class;
    }

    public Double findSaldoTitulosAbertos(Long id, Date dataEmissao, Short pagRec) {
        Session s = null;
        Query q = null;
        Double rec = 0.0;
        Double pag = 0.0;
        s = CoreBdUtil.getInstance().getSession();
        if (pagRec == 1 || pagRec == 3) {
            String hql = "select coalesce(sum(t.valor),0)- coalesce(sum(b.valor),0) from BaixaTitulo b right join b.titulo t  where t.pessoa.identificador=:id and t.pagRec=:rec and t.dataEmissao=:dataEmissao and t.provisao=0";
            q = s.createQuery(hql);
            q.setLong("id", id.longValue());
            q.setDate("dataEmissao", dataEmissao);
            q.setShort("rec", (short)1);
            rec = (Double)q.uniqueResult();
        }
        if (pagRec == 0 || pagRec == 3) {
            q = s.createQuery("select coalesce(sum(t.valor),0)- coalesce(sum(b.valor),0) from BaixaTitulo b right join b.titulo t  where t.pessoa.identificador=:id and t.pagRec=:rec and t.dataEmissao=:dataEmissao and t.provisao=0");
            q.setLong("id", id.longValue());
            q.setDate("dataEmissao", dataEmissao);
            q.setShort("rec", (short)0);
            pag = (Double)q.uniqueResult();
        }
        return rec - pag;
    }

    public Double findSaldoTitulosAberto(Long idPessoa) throws ExceptionDatabase {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        q = s.createQuery("select coalesce(sum(t.valor),0) from Titulo t where t.pessoa.identificador=:pessoa and t.pagRec=:rec and t.provisao=:provisao");
        q.setLong("pessoa", idPessoa.longValue());
        q.setShort("rec", (short)1);
        q.setShort("provisao", (short)1);
        Double valorTot = (Double)q.uniqueResult();
        q = s.createQuery("select coalesce(sum(b.valor),0) from BaixaTitulo b where b.titulo.pessoa.identificador=:pessoa and b.titulo.pagRec=:rec and b.titulo.provisao=:provisao");
        q.setLong("pessoa", idPessoa.longValue());
        q.setShort("rec", (short)1);
        q.setShort("provisao", (short)1);
        Double valorBaixa = (Double)q.uniqueResult();
        return valorTot - valorBaixa;
    }

    public Boolean existeBorderosPorTitulo(Titulo t) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = " select distinct count(b) from BorderoTitulos b inner join b.itemBorderoCobranca ibc  inner join ibc.titulo t  where t=:tit ";
        Query q = s.createQuery(st);
        q.setEntity("tit", (Object)t);
        Long count = (Long)q.uniqueResult();
        return count != null && count > 0L;
    }

    public List findBaixasPorTitulo(Titulo vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q = "select distinct b from BaixaTitulo b  where b.titulo.identificador = :idTitulo";
        Query query = s.createQuery(q);
        query.setLong("idTitulo", vo.getIdentificador().longValue());
        return query.list();
    }

    public List findBorderoPorTitulo(Titulo t) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = " select distinct b AS BORDERO, 1 AS PAG_REC from BorderoTitulos b inner join b.itemBorderoCobranca ibc  inner join ibc.titulo t  where t=:tit ";
        Query q = s.createQuery(st);
        q.setEntity("tit", (Object)t);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findBorderoPagamentoPorTitulo(Titulo t) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = " select distinct b as BORDERO, 0 as PAG_REC from BorderoPagamento b inner join b.itemBordero item  left join item.itemLiberacao il  left join item.titulo tt  where (il.titulo = :tit or tt =:tit)";
        Query q = s.createQuery(st);
        q.setEntity("tit", (Object)t);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List findRemessaPorTitulo(Titulo t) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = "";
        st = t.getPagRec() == 0 ? " select distinct re.identificador  from RemessaCnabPagamento re inner join re.itemRemessaPagamento itemRemessa inner join itemRemessa.itemBordero item where item.itemLiberacao.titulo=:tit  order by re.identificador desc" : " select distinct re.identificador  from RemessaCnabCobranca re inner join re.itemRemessaCobranca itemRemessa inner join itemRemessa.itemBordero item where item.titulo = :tit  order by re.identificador desc";
        Query q = s.createQuery(st);
        q.setEntity("tit", (Object)t);
        return q.list();
    }

    public Boolean existeBorderoPagamentoPorTitulo(Titulo t) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = " select distinct count(b) from BorderoPagamento b inner join b.itemBordero item where item.itemLiberacao.titulo =:tit ";
        Query q = s.createQuery(st);
        q.setEntity("tit", (Object)t);
        Long count = (Long)q.uniqueResult();
        return count != null && count > 0L;
    }

    public Boolean existeBaixaTitulo(Titulo t) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q = "select count(b) from BaixaTitulo b  where b.titulo = :titulo";
        Query query = s.createQuery(q);
        query.setEntity("titulo", (Object)t);
        Long count = (Long)query.uniqueResult();
        return count != null && count > 0L;
    }

    public Object findValorTitulosNotaPropria(NotaFiscalPropria vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String q = "select coalesce(sum(t.valor),0d)  from NotaFiscalPropria n inner join n.infPagamentoNfPropria i  inner join i.titulos t where n.identificador = :idNota";
        Query query = s.createQuery(q);
        query.setLong("idNota", vo.getIdentificador().longValue());
        return (Double)query.uniqueResult();
    }

    public Boolean existeTitulosVencidos(Long idPessoa, Date dataEmissao) throws ExceptionDatabase {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        q = s.createQuery("select coalesce(sum(t.valor),0) from Titulo t where t.pessoa.identificador=:pessoa  and t.pagRec=:rec  and t.provisao=:provisao and t.dataVencimento < :dataEmissao");
        q.setLong("pessoa", idPessoa.longValue());
        q.setShort("rec", (short)1);
        q.setShort("provisao", (short)1);
        q.setDate("dataEmissao", dataEmissao);
        Double valorTot = (Double)q.uniqueResult();
        if (valorTot > 0.0) {
            q = s.createQuery("select coalesce(sum(b.valor),0) from BaixaTitulo b where b.titulo.pessoa.identificador=:pessoa  and b.titulo.pagRec=:rec  and b.titulo.provisao=:provisao  and b.titulo.dataVencimento < :dataEmissao");
            q.setLong("pessoa", idPessoa.longValue());
            q.setShort("rec", (short)1);
            q.setShort("provisao", (short)1);
            q.setDate("dataEmissao", dataEmissao);
            Double valorBaixa = (Double)q.uniqueResult();
            if (valorTot > valorBaixa) {
                return true;
            }
        }
        return false;
    }

    public void atualizaArquivoDocumento(Titulo titulo) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("update Titulo t set t.arquivoDoc = null where t = :titulo");
        q.setEntity("titulo", (Object)titulo);
        q.executeUpdate();
    }

    public List findCentroCustoAnalitico(Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String str = " SELECT c  FROM CentroCusto c INNER JOIN c.centroCustoEmpresa e WHERE c.marca = :marca AND e.empresa.identificador = :empresa";
        Query q = s.createQuery(str);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("marca", (short)1);
        return q.list();
    }

    public Object findUltimoTituloPorPessoa(Pessoa pessoa) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select max(identificador) from Titulo t where t.pessoa = :pessoa";
        Query query = s.createQuery(hql);
        query.setEntity("pessoa", (Object)pessoa);
        query.setMaxResults(1);
        Long id = (Long)query.uniqueResult();
        if (id != null) {
            Titulo titulo = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(id);
            return titulo;
        }
        return null;
    }

    public Object findTitulosPorDataEmissaoVencimento(Date dataEmissaoInicial, Date dataEmissaoFinal, Date dataVencimentoInicial, Date dataVencimentoFinal, Short exibirTitulosNotaPropria, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select distinct t from Titulo t where t.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal  and t.dataVencimento between :dataVencInicial and :dataVencFinal and t.provisao = :realizado and t.pagRec = :recebimento  and t.empresa = :empresa and t.valor > (select coalesce((sum(b.valor)),0) from BaixaTitulo  b                  where b.titulo.identificador = t.identificador)";
        if (exibirTitulosNotaPropria.equals((short)1)) {
            query = (String)query + " and t.infPagamentoNfPropria.notaFiscalPropria is not null";
        }
        Query q = s.createQuery((String)query);
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setDate("dataVencInicial", dataVencimentoInicial);
        q.setDate("dataVencFinal", dataVencimentoFinal);
        q.setShort("realizado", (short)1);
        q.setShort("recebimento", (short)1);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public List<LiberacaoTitulos> findLiberacaoTituloPorTitulo(Titulo t) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = "select distinct t from LiberacaoTitulos t  inner join t.itemLiberacao item inner join item.titulo tt  where tt = :titulo";
        Query q = s.createQuery(query);
        q.setEntity("titulo", (Object)t);
        return q.list();
    }

    public List<Titulo> findTitulosNFPropria(Long numeroNota, Short parcela) {
        Object hql = " select distinct t  from NotaFiscalPropria np  inner join np.infPagamentoNfPropria inf inner join inf.titulos t   where np.numeroNota = :numeroNota ";
        if (parcela != null) {
            hql = (String)hql + " and t.numParcTituloEstnota = :parcela";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setLong("numeroNota", numeroNota.longValue());
        if (parcela != null) {
            q.setShort("parcela", parcela.shortValue());
        }
        return q.list();
    }

    public List<Titulo> findTitulosNFTerceiros(Long numeroNota, Short parcela) {
        Object hql = " select distinct t  from NotaFiscalTerceiros nt  inner join nt.infPagamentoNfTerceiros inf inner join inf.titulos t   where nt.numeroNota = :numeroNota ";
        if (parcela != null) {
            hql = (String)hql + " and t.numParcTituloEstnota = :parcela";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setLong("numeroNota", numeroNota.longValue());
        if (parcela != null) {
            q.setShort("parcela", parcela.shortValue());
        }
        return q.list();
    }

    public List<Titulo> findTitulosNFPropriaFaturamentoEntrada(Long nrNota, Short parcela) {
        Object hql = " select distinct t  from NotaFiscalPropria np  inner join np.infPagamentoNfPropria inf inner join inf.titulos t   where np.numeroNota = :numeroNota  and (np.naturezaOperacao.entradaSaida = :entSaiEntrada  or  np.naturezaOperacao.entradaSaida = :entSaiFaturamentoEntrada)";
        if (parcela != null) {
            hql = (String)hql + " and t.numParcTituloEstnota = :parcela";
        }
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)hql);
        q.setLong("numeroNota", nrNota.longValue());
        q.setShort("entSaiEntrada", (short)0);
        q.setShort("entSaiFaturamentoEntrada", (short)2);
        if (parcela != null) {
            q.setShort("parcela", parcela.shortValue());
        }
        return q.list();
    }

    public CarteiraCobranca findCarteiraCobrancaByColaborador(InstituicaoValores instValor, Empresa empresa) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        String q = "SELECT CC.ID_CARTEIRA_COBRANCA FROM EMPRESA_FINANCEIRA         EF JOIN EMP_FINANCEIRO_CONTA_VALOR EV ON EV.ID_EMP_FINANCEIRO = EF.ID_EMPRESA_FINANCEIRA JOIN CONTA_VALORES              CV ON CV.ID_CONTA_VALOR    = EV.ID_CONTA_VALORES JOIN AGENCIA_VALORES            AV ON AV.ID_AGENCIA_VALOR  = CV.ID_AGENCIA_VALOR JOIN CARTEIRA_COBRANCA          CC ON CC.ID_CONTA_VALOR    = CV.ID_CONTA_VALOR LEFT JOIN EMPRESA               EM ON EM.ID_EMP            = CC.ID_EMPRESA LEFT JOIN EMPRESA_DADOS         ED ON ED.ID_EMPRESA_DADOS  = EM.ID_EMPRESA_DADOS WHERE      AV.ID_INSTITUICAO_VALOR  = :ID_INST_VALOR AND CC.PAGAMENTO_CNAB        = :PAGAMENTO_CNAB AND ED.ID_GRUPO_EMPRESA      = :ID_GRUPO_EMPRESA AND CC.ATIVO                 = :ATIVO";
        NativeQuery query = s.createSQLQuery(q);
        query.setLong("ID_INST_VALOR", instValor.getIdentificador().longValue());
        query.setLong("ID_GRUPO_EMPRESA", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        query.setShort("PAGAMENTO_CNAB", (short)1);
        query.setShort("ATIVO", (short)1);
        Integer idCarteiraCobranca = (Integer)query.uniqueResult();
        if (idCarteiraCobranca != null && idCarteiraCobranca > 0) {
            CarteiraCobranca carteira = (CarteiraCobranca)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOCarteiraCobranca(), idCarteiraCobranca.longValue());
            return carteira;
        }
        return null;
    }

    public Object findTitulosAbertosPorPessoaAndPagRec(Pessoa pessoa, Short pagRec, Empresa empresa) {
        String hql = " select distinct t  from Titulo t  where t.pessoa = :pessoa and t.pagRec = :pagRec and t.valorSaldo > 0 and t.provisao = 1 and t.empresa = :empresa";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(hql);
        q.setEntity("pessoa", (Object)pessoa);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("pagRec", pagRec.shortValue());
        return q.list();
    }

    public Boolean existeApuracaoComissaoPorTitulo(Titulo t) {
        boolean exists;
        Session s = CoreBdUtil.getInstance().getSession();
        String st = " select distinct count(b) from ApuracaoComissaoRepresentanteTitulosFat b inner join b.tituloRepresentante ibc  inner join ibc.titulo t  where t=:tit ";
        Query q = s.createQuery(st);
        q.setEntity("tit", (Object)t);
        Long count = (Long)q.uniqueResult();
        boolean bl = exists = count != null && count > 0L;
        if (exists) {
            return exists;
        }
        s = CoreBdUtil.getInstance().getSession();
        st = " select distinct count(b) from ApuracaoComissaoRepresentanteTitulosVenc b inner join b.tituloRepresentante ibc  inner join ibc.titulo t  where t=:tit ";
        q = s.createQuery(st);
        q.setEntity("tit", (Object)t);
        count = (Long)q.uniqueResult();
        boolean bl2 = exists = count != null && count > 0L;
        if (exists) {
            return exists;
        }
        return exists;
    }
}

