/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.FabricanteFornecedor;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.FornecedorCotacao;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LeadTimeFornecedor;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import java.util.ArrayList;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class DAOUnidadeFaturamentoFornecedor
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return UnidadeFatFornecedor.class;
    }

    public List<UnidadeFatFornecedor> findFornecedoresSugeridosProduto(Produto produto) {
        ArrayList<UnidadeFatFornecedor> ret = new ArrayList<UnidadeFatFornecedor>();
        ret.addAll(this.findFornecedoresSugeridosProdutoNotaTerceiros(produto));
        ret.addAll(this.findFornecedoresSugeridosProdutoOrdemCompra(produto));
        ret.addAll(this.findFornecedoresSugeridosProdutoCotacao(produto));
        ret.addAll(this.findFornecedoresSugeridosProdutoCotacaoCompra(produto));
        ret.addAll(this.findFornecedoresSugeridosProdutoFabricante(produto));
        ret.addAll(this.findFornecedoresSugeridosProdutoLeadTime(produto));
        return ret;
    }

    public List<UnidadeFatFornecedor> findFornecedoresSugeridosProdutoNotaTerceiros(Produto produto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(NotaFiscalTerceiros.class);
        criteria = criteria.createAlias("unidadeFatFornecedor", "unidadeFatFornecedor");
        criteria = criteria.createAlias("itemNotaTerceiros", "item");
        criteria = criteria.createAlias("item.produto", "produto");
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"unidadeFatFornecedor")));
        criteria.add((Criterion)Restrictions.eq((String)"produto.identificador", (Object)produto.getIdentificador()));
        return criteria.list();
    }

    public List<UnidadeFatFornecedor> findFornecedoresSugeridosProdutoOrdemCompra(Produto produto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(OrdemCompra.class);
        criteria = criteria.createAlias("unidadeFatFornecedor", "unidadeFatFornecedor");
        criteria = criteria.createAlias("itemOrdemCompra", "item");
        criteria = criteria.createAlias("item.produto", "produto");
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"unidadeFatFornecedor")));
        criteria.add((Criterion)Restrictions.eq((String)"produto.identificador", (Object)produto.getIdentificador()));
        return criteria.list();
    }

    public List<UnidadeFatFornecedor> findFornecedoresSugeridosProdutoCotacao(Produto produto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(FornecedorCotacao.class);
        criteria = criteria.createAlias("unidadeFatFornecedor", "unidadeFatFornecedor");
        criteria = criteria.createAlias("itemFornecedorCotacao", "item");
        criteria = criteria.createAlias("item.produto", "produto");
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"unidadeFatFornecedor")));
        criteria.add((Criterion)Restrictions.eq((String)"produto.identificador", (Object)produto.getIdentificador()));
        return criteria.list();
    }

    public List<UnidadeFatFornecedor> findFornecedoresSugeridosProdutoCotacaoCompra(Produto produto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(FornecedorItemCotacaoCompra.class);
        criteria = criteria.createAlias("unidadeFaturamentoFornecedor", "unidadeFaturamentoFornecedor");
        criteria = criteria.createAlias("itemCotacaoCompra", "item");
        criteria = criteria.createAlias("item.gradeCor", "gradeCor");
        criteria = criteria.createAlias("gradeCor.produtoGrade", "produtoGrade");
        criteria = criteria.createAlias("produtoGrade.produto", "produto");
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"unidadeFaturamentoFornecedor")));
        criteria.add((Criterion)Restrictions.eq((String)"produto.identificador", (Object)produto.getIdentificador()));
        return criteria.list();
    }

    public List<UnidadeFatFornecedor> findFornecedoresSugeridosProdutoFabricante(Produto produto) {
        ArrayList fornecedores = produto != null && produto.getFabricante() != null && produto.getFabricante().getFornecedores() != null ? produto.getFabricante().getFornecedores() : new ArrayList();
        ArrayList<UnidadeFatFornecedor> ret = new ArrayList<UnidadeFatFornecedor>();
        for (FabricanteFornecedor fornecedor : fornecedores) {
            ret.add(this.findUnidadeFaturamentoFornecedor(fornecedor.getFornecedor()));
        }
        return ret;
    }

    public List<UnidadeFatFornecedor> findFornecedoresSugeridosProdutoLeadTime(Produto produto) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(LeadTimeFornecedor.class);
        criteria = criteria.createAlias("leadTimeFornProduto", "leadTimeFornProduto");
        criteria = criteria.createAlias("leadTimeFornProduto.gradeCor", "gradeCor");
        criteria = criteria.createAlias("gradeCor.produtoGrade", "pg");
        criteria = criteria.createAlias("pg.produto", "produto");
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)"unidadeFatFornecedor")));
        criteria.add((Criterion)Restrictions.eq((String)"produto.identificador", (Object)produto.getIdentificador()));
        return criteria.list();
    }

    public UnidadeFatFornecedor findUnidadeFaturamentoFornecedor(Fornecedor fornecedor) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(UnidadeFatFornecedor.class);
        criteria = criteria.createAlias("fornecedor", "fornecedor");
        criteria.add((Criterion)Restrictions.eq((String)"fornecedor.identificador", (Object)fornecedor.getIdentificador()));
        criteria.setMaxResults(1);
        return (UnidadeFatFornecedor)criteria.uniqueResult();
    }

    public UnidadeFatFornecedor findFornecedorPorComplemento(Complemento complemento) {
        Criteria criteria = CoreBdUtil.getInstance().getSession().createCriteria(UnidadeFatFornecedor.class);
        criteria = criteria.createAlias("fornecedor", "fornecedor");
        criteria = criteria.createAlias("fornecedor.pessoa", "pessoa");
        criteria = criteria.createAlias("pessoa.complemento", "complemento");
        criteria.add((Criterion)Restrictions.eq((String)"complemento.idComp", (Object)complemento.getIdComp()));
        criteria.setMaxResults(1);
        return (UnidadeFatFornecedor)criteria.uniqueResult();
    }
}

