/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import java.sql.Timestamp;
import java.util.Date;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class DAOUnidadeFederativa
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return UnidadeFederativa.class;
    }

    public UnidadeFederativa buscarUnidadeFederativa(String unidadeFederativa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM UnidadeFederativa u WHERE u.sigla = :unidadeFederativa");
        q.setString("unidadeFederativa", unidadeFederativa);
        return (UnidadeFederativa)q.uniqueResult();
    }

    public Object findUnidFederativaSincronizacaoDadosCupom(Timestamp ultimaSincronizacao) {
        Object hql = "select un.identificador as ID_UF, un.codIbge as COD_IBGE, un.descricao as DESCRICAO, un.sigla as SIGLA, un.pais.identificador as ID_PAIS from UnidadeFederativa un";
        if (ultimaSincronizacao != null) {
            hql = (String)hql + " where un.dataAtualizacao >= :ultimaSincronizacao";
        }
        Query q = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        if (ultimaSincronizacao != null) {
            q.setTimestamp("ultimaSincronizacao", (Date)ultimaSincronizacao);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Object findAliquotaIcmsInterUF(UnidadeFederativa origem, UnidadeFederativa destino) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM UnidadeFederativaOrigDest u WHERE u.unidadeFedDestino = :destino and u.unidadeFedOrigem=:origem");
        q.setEntity("origem", (Object)origem);
        q.setEntity("destino", (Object)destino);
        return q.uniqueResult();
    }

    public Object findUFPorCodigoIBGE(String codigoIBGE, Long idUF) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "FROM UnidadeFederativa u WHERE u.codIbge = :codIBGE";
        if (idUF != null) {
            query = (String)query + " and u.identificador <> :idUF";
        }
        Query q = s.createQuery((String)query);
        q.setString("codIBGE", codigoIBGE);
        if (idUF != null) {
            q.setLong("idUF", idUF.longValue());
        }
        return q.list();
    }
}

