/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.dao.impl;

import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.Veiculo;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class DAOVeiculo
extends CoreBaseDAO {
    @Override
    public Class getVOClass() {
        return Veiculo.class;
    }

    public Veiculo buscarVeiculo(String veiculoPlaca) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("FROM Veiculo v WHERE upper(v.placa) = :veiculoPlaca and v.ativo = 1");
        q.setString("veiculoPlaca", veiculoPlaca.toUpperCase());
        return (Veiculo)q.uniqueResult();
    }

    public Veiculo buscarVeiculoPrincipal(ConjuntoTransportador conj) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select ctv.veiculo from ConjuntoTransportador c inner join c.conjuntoTranspVeiculo ctv where c.identificador = :conjuntoTransportador and ctv.placaPrincipal = 1 and ctv.veiculo.ativo = 1");
        q.setLong("conjuntoTransportador", conj.getIdentificador().longValue());
        return (Veiculo)q.uniqueResult();
    }

    public List<Veiculo> buscarVeiculosNaoPrincipais(ConjuntoTransportador conj) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select ctv.veiculo from ConjuntoTransportador c inner join c.conjuntoTranspVeiculo ctv where c.identificador = :conjuntoTransportador and ctv.placaPrincipal = 0 and ctv.veiculo.ativo = 1 ");
        q.setLong("conjuntoTransportador", conj.getIdentificador().longValue());
        return q.list();
    }

    public List<Equipamento> pesquisarEquipamento(String placa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT v.equipamento FROM Veiculo v WHERE v.placa = :placa and v.ativo = 1 ");
        q.setString("placa", placa.toUpperCase());
        return q.list();
    }
}

