/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.database.mentor.spring;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.database.interceptors.DatabaseInterceptor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import mentorcore.database.mentor.spring.ConfSpringVoClassProvider;
import mentorcore.database.mentor.spring.defaultimpl.ConfSpringVoClassProviderAll;
import mentorcore.properties.LocalProperties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class ConfHibernate {
    private static final TLogger logger = TLogger.get(ConfHibernate.class);
    @Autowired
    private Environment environment;
    private static String urlConexao;
    private static ConfSpringVoClassProvider provider;

    @Primary
    @Bean
    public LocalSessionFactoryBean sessionFactory() throws Exception {
        LocalSessionFactoryBean sessionFactory = new LocalSessionFactoryBean();
        sessionFactory.setDataSource(this.dataSource());
        sessionFactory.setAnnotatedClasses(provider.getVoClasses());
        sessionFactory.setHibernateProperties(this.getHibernateProps());
        sessionFactory.setEntityInterceptor((Interceptor)DatabaseInterceptor.getInstance());
        return sessionFactory;
    }

    private Properties getHibernateProps() {
        Properties properties = this.getProperties();
        properties.put("hibernate.dialect", this.environment.getRequiredProperty("hibernate.dialect"));
        if (!properties.containsKey("hibernate.show_sql")) {
            properties.put("hibernate.show_sql", (Object)true);
        }
        if (!properties.containsKey("hibernate.format_sql")) {
            properties.put("hibernate.format_sql", (Object)false);
        }
        properties.put("hibernate.hbm2ddl.auto", "none");
        properties.put("hibernate.hbm2ddl.auto", "");
        properties.put("hibernate.id.new_generator_mappings", "false");
        properties.put("hibernate.event.merge.entity_copy_observer", "allow");
        properties.put("hibernate.ejb.use_class_enhancer", "true");
        properties.put("hibernate.enable_lazy_load_no_trans", "true");
        return properties;
    }

    @Primary
    @Bean
    public DataSource dataSource() throws PropertyVetoException, ExceptionInvalidData {
        if (ConfHibernate.getUrlConexao() != null) {
            String url = ConfHibernate.getUrlConexao();
        } else {
            String url = this.environment.getRequiredProperty("jdbc.url");
        }
        String pass = LocalProperties.getInstance().getDBPass("masterkey");
        String user = LocalProperties.getInstance().getDBUser("SYSDBA");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(this.environment.getRequiredProperty("jdbc.driverClassName"));
        ds.setUsername(user);
        ds.setPassword(pass);
        if (ConfHibernate.getUrlConexao() != null) {
            ds.setUrl(ConfHibernate.getUrlConexao());
        } else {
            ds.setUrl(this.environment.getRequiredProperty("jdbc.url"));
        }
        ds.setInitialSize(1);
        ds.setMinIdle(1);
        ds.setMaxTotal(15);
        ds.setMaxIdle(1);
        ds.setMaxOpenPreparedStatements(50);
        return ds;
    }

    @Primary
    @Bean(name={"transactionManager"})
    @Autowired
    public HibernateTransactionManager transactionManager(@Qualifier(value="sessionFactory") SessionFactory s) {
        HibernateTransactionManager txManager = new HibernateTransactionManager();
        txManager.setSessionFactory(s);
        return txManager;
    }

    public static String getUrlConexao() {
        return urlConexao;
    }

    public static void setUrlConexao(String aUrlConexao) {
        urlConexao = aUrlConexao;
    }

    private Properties getProperties() {
        File f = new File("hibernate_mentor.properties");
        Properties props = new Properties();
        if (f.exists()) {
            try {
                props.load(new FileInputStream(f));
            }
            catch (IOException ex) {
                Logger.getLogger(ConfHibernate.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return props;
    }

    public static ConfSpringVoClassProvider getProvider() {
        return provider;
    }

    public static void setProvider(ConfSpringVoClassProvider aProvider) {
        provider = aProvider;
    }

    static {
        provider = new ConfSpringVoClassProviderAll();
    }
}

