/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.exceptions;

import com.touchcomp.basementorservice.components.bderrors.CompBDErrors;

public class ExceptionDatabase
extends Exception {
    private static final long serialVersionUID = -2668097896460476332L;
    private String completeStraceError;

    public ExceptionDatabase() {
    }

    public ExceptionDatabase(String message) {
        super(ExceptionDatabase.processMessage(message, null));
    }

    public ExceptionDatabase(String message, Throwable cause) {
        super(ExceptionDatabase.processMessage(message, cause), cause);
        this.processStraceError(cause);
    }

    private static String processMessage(String message, Throwable e) {
        try {
            return CompBDErrors.getProcessedMessage((Throwable)e);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    private void processStraceError(Throwable tr) {
        StringBuilder sb = new StringBuilder();
        sb.append(tr.getMessage());
        while (tr != null) {
            for (StackTraceElement s : tr.getStackTrace()) {
                sb.append("\t" + String.valueOf(s));
                sb.append("\n");
            }
            sb.append(tr.getMessage());
            tr = tr.getCause();
        }
        this.completeStraceError = sb.toString();
    }

    public String getCompleteStraceError() {
        return this.completeStraceError;
    }
}

