/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.exceptions;

import com.touchcomp.basementorservice.components.bderrors.CompBDErrors;

public class ExceptionService
extends Exception {
    private static final long serialVersionUID = -7526670093987693289L;
    private String completeStraceError;

    public ExceptionService() {
    }

    public ExceptionService(String message) {
        super(ExceptionService.processMessage(message, null));
    }

    public ExceptionService(String message, Throwable cause) {
        super(ExceptionService.processMessage(message, cause), cause);
        this.processStraceError(cause);
    }

    public ExceptionService(Throwable cause) {
        super(ExceptionService.processMessage(cause.getMessage(), cause));
        this.processStraceError(cause);
    }

    private static String processMessage(String message, Throwable e) {
        try {
            if (e == null) {
                return message;
            }
            return CompBDErrors.getProcessedMessage((Throwable)e);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public String getCompleteStraceError() {
        return this.completeStraceError;
    }

    private void processStraceError(Throwable tr) {
        if (tr == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tr.getMessage());
        while (tr != null) {
            for (StackTraceElement s : tr.getStackTrace()) {
                sb.append("\t" + String.valueOf(s));
                sb.append("\n");
            }
            sb.append(tr.getMessage());
            tr = tr.getCause();
        }
        this.completeStraceError = sb.toString();
    }
}

