/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.finder;

import com.touchcomp.basementor.constants.enums.criteria.EnumConstBaseOrder;
import java.util.LinkedList;
import java.util.List;
import mentorcore.finder.BaseFilter;
import mentorcore.finder.BaseOrder;
import mentorcore.finder.enums.BaseEnumType;
import org.hibernate.transform.ResultTransformer;

public class BaseCriteria {
    private BaseFilter baseFilter;
    private List<BaseOrder> orders;
    private String voClass;
    private List<String> fields = new LinkedList<String>();
    private ResultTransformer resultTransformer;
    private Integer maxResults = -1;
    private Integer firstResult = -1;

    private BaseCriteria(String voClass) {
        this.voClass = voClass;
        this.orders = new LinkedList<BaseOrder>();
    }

    public BaseCriteria ascend(String field) {
        BaseOrder aux = new BaseOrder(field, EnumConstBaseOrder.ASCEND);
        this.getOrders().add(aux);
        return this;
    }

    public BaseCriteria descend(String field) {
        BaseOrder aux = new BaseOrder(field, EnumConstBaseOrder.DESCEND);
        this.getOrders().add(aux);
        return this;
    }

    public List<BaseOrder> getOrders() {
        return this.orders;
    }

    public void setOrders(List<BaseOrder> orders) {
        this.orders = orders;
    }

    public String getVoClass() {
        return this.voClass;
    }

    public void setVoClass(String voClass) {
        this.voClass = voClass;
    }

    public static BaseCriteria create(String voClass) {
        return new BaseCriteria(voClass);
    }

    public static BaseCriteria create(Class voClass) {
        return new BaseCriteria(voClass.getCanonicalName());
    }

    public ResultTransformer getResultTransformer() {
        return this.resultTransformer;
    }

    public void setResultTransformer(ResultTransformer resultTransformer) {
        this.resultTransformer = resultTransformer;
    }

    public BaseFilter and() {
        if (this.baseFilter == null) {
            this.baseFilter = new BaseFilter(BaseEnumType.CONJUNCTION);
        }
        return this.baseFilter;
    }

    public BaseFilter or() {
        if (this.baseFilter == null) {
            this.baseFilter = new BaseFilter(BaseEnumType.DISJUNCTION);
        }
        return this.baseFilter;
    }

    public BaseFilter getBaseFilter() {
        return this.baseFilter;
    }

    public BaseCriteria select(String ... st) {
        if (this.baseFilter == null) {
            this.and();
        }
        if (st != null) {
            for (int i = 0; i < st.length; ++i) {
                this.getFields().add(st[i]);
            }
        }
        return this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(Integer firstResult) {
        this.firstResult = firstResult;
    }
}

