/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.properties;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.criptografia.ToolCriptografia;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class LocalProperties {
    private final String VERSAO_CODIGO = "versao.codigo";
    private final String SUB_CODIGO_VERSAO = "versao.sub.codigo";
    private final String DATABASE_PASS = "database.pass";
    private final String DATABASE_SEED = "database.seed";
    private final String DATABASE_USER = "database.user";
    private final String DATABASE_DRIVER = "database.driver";
    private final String HOST = "host";
    private final String HOST_COMMUNICATOR = "url.host.communicador";
    private final String PORT = "porta";
    private final String URL_DATABASE = "url.database";
    private final String TIPO_SISTEMA = "tipo.sistema";
    private final String URL_DATABASE_ENDERECOS = "url.database.cep";
    private final String URL_DATABASE_NFE = "url.database.nfe";
    private final String URL_DATABASE_COMMUNICATOR = "url.database.communicator";
    private final String URL_DATABASE_LOG = "url.database.log";
    private final String URL_DATABASE_VERSAO = "url.database.versao";
    private final String URL_DATABASE_BINARY_DATA = "url.database.binarydata";
    private final String path = System.getProperty("user.dir") + "/local.xml";
    private final String GENERATION_STRATEGY = "generationStrategy";
    private final String EXIBIR_SQL = "exibirSql";
    private final String XML_PATCH_UPDATE = "xml.patch.update";
    private static final TLogger logger = TLogger.get(LocalProperties.class);
    private static Element root;

    private LocalProperties() {
    }

    public static LocalProperties getInstance() {
        return new LocalProperties();
    }

    public String getTableGenerationStrategy() {
        return this.returnProperties("generationStrategy");
    }

    private void addProps(String key, String value) {
        Element root = this.getRootElement();
        Element e = root.getChild(key);
        if (e == null) {
            e = new Element(key);
            root.addContent((Content)e);
        }
        e.setText(value);
        this.gravarArquivo(root);
    }

    private String returnProperties(String name) {
        Element root = this.getRootElement();
        Element child = root.getChild(name);
        String value = null;
        if (child != null) {
            value = child.getText();
        }
        return value;
    }

    private synchronized Element getRootElement() {
        if (root == null) {
            try {
                System.out.println("local.xml->mentorcore");
                File f = new File(this.path);
                if (!f.exists()) {
                    throw new RuntimeException("Arquivo de configuracoes, local.xml nao existe.");
                }
                SAXBuilder sb = new SAXBuilder();
                Document d = sb.build(f);
                root = d.getRootElement();
            }
            catch (JDOMException ex) {
                logger.error((Throwable)ex);
                throw new RuntimeException("Houve um problema ao ler o arquivo de configuracoes. Se voce abriu mais de um sistema de uma vez, aguarde ate o primeiro abrir para posteriormente abrir outro.");
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                throw new RuntimeException("Houve um problema ao ler o arquivo de configuracoes. Se voce abriu mais de um sistema de uma vez, aguarde ate o primeiro abrir para posteriormente abrir outro.");
            }
        }
        if (root == null) {
            root = new Element("mentorLocal");
        }
        return root;
    }

    private synchronized void gravarArquivo(Element root) {
        System.err.println("Gravando arquivo local.xml");
        try {
            XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
            root = root.detach();
            Document d = new Document(root);
            xout.output(d, (OutputStream)new FileOutputStream(new File(this.path)));
        }
        catch (IOException ex) {
            logger.error((Throwable)ex);
        }
    }

    public String getHostCommunicator() {
        String host = this.returnProperties("url.host.communicador");
        if (host != null) {
            return host;
        }
        return "localhost";
    }

    public String getCodigoVersao() {
        return this.returnProperties("versao.codigo");
    }

    public String getCodigoVersaoFormatado() {
        return "TouchERP:" + this.returnProperties("versao.codigo");
    }

    public String getSubCodigoVersao() {
        return this.returnProperties("versao.sub.codigo");
    }

    public void setVersaoBeta(String versao) {
        this.addProps("versao.sub.codigo", versao);
    }

    public void setHost(String string) {
        if (string != null && string.equalsIgnoreCase("3051")) {
            throw new RuntimeException("erro ao configurar o localhost");
        }
        this.addProps("host", string);
    }

    public void setCommunicatorIP(String string) {
        this.addProps("url.host.communicador", string);
    }

    public void setPort(String str) {
        this.addProps("porta", str);
    }

    public void setURLMentor(String str) {
        this.addProps("url.database", str);
    }

    public void setURLEndereco(String str) {
        this.addProps("url.database.cep", str);
    }

    public void setURLNfe(String str) {
        this.addProps("url.database.nfe", str);
    }

    public void setURLCommunicator(String str) {
        this.addProps("url.database.communicator", str);
    }

    public String getURLNfe() {
        return this.returnProperties("url.database.nfe");
    }

    public String getURLCommunicator() {
        return this.returnProperties("url.database.communicator");
    }

    public String getHost() {
        String host = this.returnProperties("host");
        if (!TMethods.isStrWithData((String)host)) {
            host = "localhost";
        }
        return host;
    }

    public String getPort() {
        String port = this.returnProperties("porta");
        if (!TMethods.isStrWithData((String)port)) {
            port = "3051";
        }
        return port;
    }

    public String getURLMentor() {
        String st = this.returnProperties("url.database");
        if (!TMethods.isStrWithData((String)st)) {
            st = "jdbc:firebirdsql://host:porta/mentor?lc_ctype=ISO8859_1";
        }
        return st;
    }

    public String getURLEndereco() {
        String st = this.returnProperties("url.database.cep");
        if (!TMethods.isStrWithData((String)st)) {
            st = "jdbc:firebirdsql://host:porta/endereco?lc_ctype=ISO8859_1";
        }
        return st;
    }

    public String getURLLog() {
        String st = this.returnProperties("url.database.log");
        if (!TMethods.isStrWithData((String)st)) {
            st = "jdbc:firebirdsql://host:porta/log?lc_ctype=ISO8859_1";
        }
        return st;
    }

    public void setURLLog(String str) {
        this.addProps("url.database.log", str);
    }

    public void setCodigoVersao(Integer versaoToUp) {
        this.addProps("versao.codigo", versaoToUp.toString());
    }

    public void setSubCodigoVersao(Integer versaoBancoBeta) {
        this.addProps("versao.sub.codigo", versaoBancoBeta.toString());
    }

    public String getURLVersoes() {
        String st = this.returnProperties("url.database.versao");
        if (!TMethods.isStrWithData((String)st) && !this.existsProperty("url.database.versao")) {
            st = "jdbc:firebirdsql://host:porta/versao?lc_ctype=ISO8859_1";
        }
        return st;
    }

    public void setURLVersao(String str) {
        this.addProps("url.database.versao", str);
    }

    public String getExibirSQL() {
        return this.returnProperties("exibirSql");
    }

    public void setExibirSQL(String str) {
        this.addProps("exibirSql", str);
    }

    public String getTipo() {
        return this.returnProperties("tipo.sistema");
    }

    public void setXMLPathToUpdate(String absolutePath) {
        this.addProps("xml.patch.update", absolutePath);
    }

    public String getXMLPathToUpdate() {
        return this.returnProperties("xml.patch.update");
    }

    public String getBinaryDataStore() {
        String st = this.returnProperties("url.database.binarydata");
        if (!TMethods.isStrWithData((String)st) && !this.existsProperty("url.database.binarydata")) {
            st = "jdbc:firebirdsql://host:porta/binarydata?lc_ctype=ISO8859_1";
        }
        return st;
    }

    public String getDBPass(String defaultPass) throws ExceptionInvalidData {
        String st = this.returnProperties("database.pass");
        String semente = this.getDBSeedCripto();
        if (TMethods.isStrWithData((String)st)) {
            if (TMethods.isStrWithData((String)semente)) {
                try {
                    st = ToolCriptografia.decrypte((String)semente, (String)st);
                }
                catch (Exception e) {
                    throw new ExceptionInvalidData("W.GEN.000027", new Object[0]);
                }
            }
            try {
                st = ToolCriptografia.decrypteBase64((String)st);
            }
            catch (Exception e) {
                throw new ExceptionInvalidData("W.GEN.000028", new Object[0]);
            }
            return st;
        }
        return defaultPass;
    }

    public String getDBUser(String defaultUser) {
        String st = this.returnProperties("database.user");
        if (TMethods.isStrWithData((String)st)) {
            return st;
        }
        return defaultUser;
    }

    public String getDBSeedCripto() {
        String st = this.returnProperties("database.seed");
        if (TMethods.isStrWithData((String)st)) {
            return st;
        }
        return st;
    }

    public String getDBDriver(String defaultDriver) {
        String st = this.returnProperties("database.driver");
        if (TMethods.isStrWithData((String)st)) {
            return st;
        }
        return defaultDriver;
    }

    private boolean existsProperty(String name) {
        Element root = this.getRootElement();
        Element child = root.getChild(name);
        return child != null;
    }
}

