/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.finder.BaseFilter;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.spring.CoreSpringService;

public abstract class CoreService {
    private TLogger logger = TLogger.get(CoreService.class);
    protected Class[] types = new Class[]{CoreRequestContext.class};
    protected HashMap methods = new HashMap();

    public Object execute(CoreRequestContext request, String name) throws ExceptionService {
        Method method = null;
        try {
            try {
                method = this.getMethod(name);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new ExceptionService("Invalid method name:" + name, e);
            }
            CoreSpringService test = (CoreSpringService)ConfApplicationContext.getBean(CoreSpringService.class);
            Object value = test.execute(request, this, method);
            return value;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.logger.error(e.getTargetException().getMessage(), e.getTargetException());
            throw new ExceptionService(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExceptionService(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method getMethod(String name) throws NoSuchMethodException {
        HashMap hashMap = this.methods;
        synchronized (hashMap) {
            Method method = (Method)this.methods.get(name);
            if (method == null) {
                method = this.getClass().getMethod(name, this.types);
                this.methods.put(name, method);
            }
            return method;
        }
    }

    public final Object simpleSaveInternal(CoreRequestContext request) throws ExceptionService {
        try {
            Object obj = request.getAttribute("obj");
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            Object newObj = dao.saveOrUpdate(obj);
            return newObj;
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public final Object simpleSaveCollectionInternal(CoreRequestContext request) throws ExceptionService {
        try {
            Collection aux = (Collection)request.getAttribute("obj");
            ArrayList collection = new ArrayList(aux);
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            aux.clear();
            for (Object o : collection) {
                Object newObj = dao.saveOrUpdate(o);
                aux.add(newObj);
            }
            return aux;
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public final Object simpleDeleteCollectionInternal(CoreRequestContext request) throws ExceptionService {
        try {
            Collection aux = (Collection)request.getAttribute("obj");
            ArrayList collection = new ArrayList(aux);
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            aux.clear();
            for (Object o : collection) {
                Boolean newObj = dao.delete(o);
                aux.add(newObj);
            }
            return aux;
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public final Object simpleDeleteInternal(CoreRequestContext request) throws ExceptionService {
        try {
            Object obj = request.getAttribute("obj");
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            dao.delete(obj);
            return true;
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public static Collection simpleSaveCollection(CoreBaseDAO dao, Collection object) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("obj", object);
        return (Collection)service.execute(request, "simpleSaveCollectionInternal");
    }

    public static Collection simpleDeleteCollection(CoreBaseDAO dao, Collection object) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("obj", object);
        return (Collection)service.execute(request, "simpleDeleteCollectionInternal");
    }

    public static Object simpleSave(CoreBaseDAO dao, Object object) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("obj", object);
        return service.execute(request, "simpleSaveInternal");
    }

    public static Object saveOrUpdateCollection(Collection list) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("collection", list);
        return service.execute(request, "saveOrUpdateCollectionInternal");
    }

    public final Object saveOrUpdateCollectionInternal(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        Collection list = (Collection)request.getAttribute("collection");
        return new CoreBaseDAO(this){

            @Override
            public Class getVOClass() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }.saveOrUpdateCollection(list);
    }

    public static Object simpleDelete(CoreBaseDAO dao, Object object) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("obj", object);
        return service.execute(request, "simpleDeleteInternal");
    }

    public static Object reloadObject(CoreBaseDAO dao, Object object) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("obj", object);
        return service.execute(request, "reloadObjectInternal");
    }

    public Object reloadObjectInternal(CoreRequestContext request) throws ExceptionService {
        try {
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            Object obj = request.getAttribute("obj");
            return dao.reloadObject(obj);
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public final Object simpleFindAllInternal(CoreRequestContext request) throws ExceptionService {
        try {
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            return dao.findAll();
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public Object simpleFindAllInternalOrder(CoreRequestContext request) throws ExceptionService {
        try {
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            String order = (String)request.getAttribute("order");
            return dao.findAll(order);
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public static Object simpleFindAll(CoreBaseDAO dao) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        return service.execute(request, "simpleFindAllInternal");
    }

    public static Object simpleFindAll(CoreBaseDAO dao, String order) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("order", order);
        return service.execute(request, "simpleFindAllInternalOrder");
    }

    public final Object simpleFindByCriteriaInternal(CoreRequestContext request) throws ExceptionService {
        try {
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            String fieldName = request.getAttribute("fieldName").toString();
            Object value = request.getAttribute("value");
            Integer option = (Integer)request.getAttribute("option");
            String orderBy = (String)request.getAttribute("orderBy");
            Boolean asc = (Boolean)request.getAttribute("asc");
            return dao.findByCriteria(fieldName, value, option, orderBy, asc);
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public final Object simpleFindByCriteriaUniqueResultInternal(CoreRequestContext request) throws ExceptionService {
        try {
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            String fieldName = request.getAttribute("fieldName").toString();
            Object value = request.getAttribute("value");
            Integer option = (Integer)request.getAttribute("option");
            return dao.findByCriteriaUniqueResult(fieldName, value, option);
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public static Collection simpleFindByCriteria(CoreBaseDAO dao, String fieldName, Object value, int option, String orderBy, boolean asc) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("fieldName", fieldName);
        request.setAttribute("value", value);
        request.setAttribute("option", option);
        request.setAttribute("orderBy", orderBy);
        request.setAttribute("asc", asc);
        return (Collection)service.execute(request, "simpleFindByCriteriaInternal");
    }

    public static Object simpleFindByCriteriaUniqueResult(CoreBaseDAO dao, String fieldName, Object value, int option) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("fieldName", fieldName);
        request.setAttribute("value", value);
        request.setAttribute("option", option);
        return service.execute(request, "simpleFindByCriteriaUniqueResultInternal");
    }

    public final Object simpleFindByPrimaryKeyInternal(CoreRequestContext request) throws ExceptionService {
        try {
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            Object value = request.getAttribute("value");
            return dao.findByPrimaryKey(value);
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public final Object simpleFindByPrimaryKeyInternalSearchRest(CoreRequestContext request) throws ExceptionService, ExceptionReflection {
        try {
            CoreBaseDAO dao = (CoreBaseDAO)request.getAttribute("dao");
            Object value = request.getAttribute("value");
            Map repoObjects = (Map)request.getAttribute("repoObjects");
            List myFilters = (List)request.getAttribute("myFilters");
            return dao.findByPrimaryKeySearchRest(value, repoObjects, myFilters);
        }
        catch (ExceptionDatabase e) {
            this.logger.error((Throwable)e);
            throw new ExceptionService(e);
        }
    }

    public static Object simpleFindByPrimaryKey(CoreBaseDAO dao, Object value) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("value", value);
        return service.execute(request, "simpleFindByPrimaryKeyInternal");
    }

    public static Object simpleFindByPrimaryKeyRest(CoreBaseDAO dao, Object value, Map<String, Object> repoObjectsRest) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("value", value);
        request.setAttribute("repoObjects", repoObjectsRest);
        return service.execute(request, "simpleFindByPrimaryKeyInternalSearchRest");
    }

    public static Object simpleFindByPrimaryKey(CoreBaseDAO dao, Object value, Map<String, Object> repoObjectsRest, List<BaseFilter> myFilters) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dao", dao);
        request.setAttribute("value", value);
        request.setAttribute("repoObjects", repoObjectsRest);
        request.setAttribute("myFilters", myFilters);
        return service.execute(request, "simpleFindByPrimaryKeyInternalSearchRest");
    }

    public static long getCountOfRegisters(BaseCriteria criteria) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("baseCriteria", criteria);
        Long ret = (Long)service.execute(cq, "getCountOfRegistersInternal");
        return ret;
    }

    public Long getCountOfRegistersInternal(CoreRequestContext cq) {
        BaseCriteria baseCriteria = (BaseCriteria)cq.getAttribute("baseCriteria");
        return CoreDAOFactory.getInstance().getDAONodo().getCountOfRegistersInternal(baseCriteria);
    }

    public static List executeSearch(BaseCriteria criteria) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("baseCriteria", criteria);
        List ret = (List)service.execute(cq, "executeSearchInternal");
        return ret;
    }

    public List executeSearchInternal(CoreRequestContext cq) {
        BaseCriteria baseCriteria = (BaseCriteria)cq.getAttribute("baseCriteria");
        return CoreDAOFactory.getInstance().getDAONodo().executeSearch(baseCriteria);
    }

    public static List executeSearchRest(BaseCriteria criteria, Map<String, Object> repoObjects) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("baseCriteria", criteria);
        cq.setAttribute("repoObjects", repoObjects);
        List ret = (List)service.execute(cq, "executeSearchInternalRest");
        return ret;
    }

    public List executeSearchInternalRest(CoreRequestContext cq) throws ExceptionReflection {
        BaseCriteria baseCriteria = (BaseCriteria)cq.getAttribute("baseCriteria");
        Map repoObjects = (Map)cq.getAttribute("repoObjects");
        return CoreDAOFactory.getInstance().getDAONodo().executeSearchRest(baseCriteria, repoObjects);
    }

    public static Object executeSearchUniqueResult(BaseCriteria criteria) throws ExceptionService {
        CoreService service = new CoreService(){};
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("baseCriteria", criteria);
        return service.execute(cq, "executeSearchUniqueResultInternal");
    }

    public Object executeSearchUniqueResultInternal(CoreRequestContext cq) {
        BaseCriteria baseCriteria = (BaseCriteria)cq.getAttribute("baseCriteria");
        return CoreDAOFactory.getInstance().getDAONodo().executeSearchUniqueResult(baseCriteria);
    }

    public <T> T getBean(Class<T> beanClass) {
        return (T)ConfApplicationContext.getContext().getBean(beanClass);
    }
}

