/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.aberturaperiodo;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoOcorrenciaEvtColaborador;
import com.touchcomp.basementor.model.vo.CadastroEventoConsignado;
import com.touchcomp.basementor.model.vo.CalculoComplementoSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorBancoHoras;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelEventos;
import com.touchcomp.basementor.model.vo.ControleBancoHorasFolha;
import com.touchcomp.basementor.model.vo.ControleValeTransporte;
import com.touchcomp.basementor.model.vo.DepartamentoColaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemControleValeTransporte;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.date.ToolDate;
import contatocore.util.ContatoFormatUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.aberturaperiodo.UtilGerarPlanilhaEventos;
import mentorcore.service.impl.aberturaperiodo.UtilGerarPlanilhaPonto;
import mentorcore.service.impl.aberturaperiodo.UtilLLerPlanilhaEventos;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoFolhaPagamento;
import mentorcore.tools.DateUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class ServiceAberturaPeriodo
extends CoreService {
    public static final String GERAR_PLANILHA_PONTO = "gerarPlanilhaPonto";
    public static final String GERAR_PLANILHAS_EVENTOS = "gerarPlanilhasEventos";
    public static final String LER_CREDITO_CONSIGNADO = "lerCreditoConsignado";
    public static final String LER_PLANILHAS_EVENTOS = "lerPlanilhasCotacaoModelo";
    public static final String FIND_PROX_NR_INDICE_ABERTURA = "findProxNrIndiceAbertura";
    public static final String GERAR_PLANILHAS_DECIMO_TERCEIRO = "gerarPlanilhasDecimoTerceiro";
    public static final String GERAR_PLANILHAS_CONTROLE_BANCO_HORAS = "gerarPlanilhasControleBancoHoras";
    public static final String GERAR_PLANILHA_VALE_TRANSPORTES = "gerarPlanilhaValeTransportes";

    public void gerarPlanilhaPonto(CoreRequestContext request) throws IOException, ExceptionService {
        List colaboradores = (List)request.getAttribute("colaboradores");
        String diretorio = (String)request.getAttribute("diretorio");
        byte[] planilhaPonto = (byte[])request.getAttribute("planilhaPonto");
        Date periodoInicial = (Date)request.getAttribute("periodoInicial");
        Date periodoFinal = (Date)request.getAttribute("periodoFinal");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Double horaFinalInformada = (Double)request.getAttribute("horaFinalInformada");
        new UtilGerarPlanilhaPonto().exportPlanilhaEventos(colaboradores, periodoInicial, periodoFinal, planilhaPonto, diretorio, horaFinalInformada);
    }

    public Object gerarPlanilhasEventos(CoreRequestContext cq) throws ExceptionService {
        List colaboradores = (List)cq.getAttribute("colaboradores");
        List eventos = (List)cq.getAttribute("eventos");
        String diretorio = (String)cq.getAttribute("diretorio");
        ConfPlanilhaExcelEventos modeloPlanilha = (ConfPlanilhaExcelEventos)cq.getAttribute("modeloPlanilha");
        Date dataAberturaInicial = (Date)cq.getAttribute("dataAberturaInicial");
        Date dataAberturaFinal = (Date)cq.getAttribute("dataAberturaFinal");
        String nomeCentroCusto = (String)cq.getAttribute("nomeCentroCusto");
        new UtilGerarPlanilhaEventos().exportarPlanilhaExcelEventos(colaboradores, eventos, diretorio, modeloPlanilha, dataAberturaInicial, dataAberturaFinal, nomeCentroCusto);
        return Boolean.TRUE;
    }

    public List lerCreditoConsignado(CoreRequestContext cq) throws IOException, ExceptionService {
        List files = (List)cq.getAttribute("files");
        EmpresaRh empresaRh = (EmpresaRh)cq.getAttribute("empresaRh");
        ArrayList<CadastroEventoConsignado> aux = new ArrayList<CadastroEventoConsignado>();
        List<HashMap> hashs = new UtilLLerPlanilhaEventos().importarCreditoTrabalhador(files);
        for (HashMap h : hashs) {
            CadastroEventoConsignado vo = new CadastroEventoConsignado();
            Integer codigoBanco = ((Double)h.get("CODIGO_BANCO")).intValue();
            String codigoBancoFormatado = String.format("%03d", codigoBanco);
            String numeroContrato = (String)h.get("NUMERO_CONTRATO");
            String registroColaborador = (String)h.get("REGISTRO_COLABORADOR");
            String inicioDesconto = (String)h.get("INICIO_DESCONTO");
            String finalDesconto = (String)h.get("FINAL_DESCONTO");
            Double totalParcela = (Double)h.get("TOTAL_PARCELA");
            Double valorParcela = (Double)h.get("VALOR_PARCELA");
            Date dataInicioContrato = (Date)h.get("DATA_INICIO_CONTRATO");
            vo.setValor(valorParcela);
            vo.setNrParcelas(Integer.valueOf(1));
            vo.setDataInicioDesconto(ToolDate.strToDate((String)inicioDesconto, (String)"MM/yyyy"));
            vo.setDataFinalDesconto(ToolDate.getDateLastMonthDay((Date)ToolDate.strToDate((String)finalDesconto, (String)"MM/yyyy")));
            vo.setPessoa(empresaRh.getEmpresa().getPessoa());
            vo.setEventoConsignado(empresaRh.getEventoAjudaCompensatoria());
            vo.setColaborador(this.getColaborador(registroColaborador, empresaRh.getEmpresa().getEmpresaDados().getGrupoEmpresa()));
            vo.setCodigoBanco(codigoBancoFormatado);
            vo.setDataCadastro(new Date());
            vo.setEmpresa(empresaRh.getEmpresa());
            vo.setNumeroContratoEmprestimo(numeroContrato);
            vo.setObservacao("Importacao Credito Trabalhador");
            vo.setDataInicioContrato(dataInicioContrato);
            List<EventoColaborador> evts = ServiceAberturaPeriodo.createLancamentosConsignados(vo);
            vo.setEventoColaborador(evts);
            ServiceAberturaPeriodo.simpleSave(CoreDAOFactory.getInstance().getDAOCadastroEventoConsignado(), vo);
            aux.add(vo);
        }
        return aux;
    }

    public Object lerPlanilhasCotacaoModelo(CoreRequestContext cq) throws ExceptionService, IOException {
        List files = (List)cq.getAttribute("files");
        ConfPlanilhaExcelEventos conf = (ConfPlanilhaExcelEventos)cq.getAttribute("modeloPlanilha");
        List colaboradores = (List)cq.getAttribute("colaboradores");
        return new UtilLLerPlanilhaEventos().importarPlanilhaExcelEventos(files, conf, colaboradores);
    }

    public Short findProxNrIndiceAbertura(CoreRequestContext request) {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Short indice = 0;
        indice = new UtilCalculoFolhaPagamento().findProxNrIndiceAbertura(dataInicial, dataFinal, idEmpresa);
        if (indice == null) {
            return (short)1;
        }
        return (short)(indice.intValue() + 1);
    }

    public Object gerarPlanilhasDecimoTerceiro(CoreRequestContext cq) throws ExceptionService {
        CalculoComplementoSalario complemento = (CalculoComplementoSalario)cq.getAttribute("complemento");
        List eventos = (List)cq.getAttribute("eventos");
        String diretorio = (String)cq.getAttribute("diretorio");
        ConfPlanilhaExcelEventos modeloPlanilha = (ConfPlanilhaExcelEventos)cq.getAttribute("modeloPlanilha");
        Date dataAberturaInicial = (Date)cq.getAttribute("dataAberturaInicial");
        Date dataAberturaFinal = (Date)cq.getAttribute("dataAberturaFinal");
        String nomeCentroCusto = (String)cq.getAttribute("nomeCentroCusto");
        new UtilGerarPlanilhaEventos().exportarPlanilhaExcelDecimoTerceiro(this.getDados(complemento), eventos, diretorio, modeloPlanilha, dataAberturaInicial, dataAberturaFinal, nomeCentroCusto);
        return Boolean.TRUE;
    }

    private List<HashMap> getDados(CalculoComplementoSalario complemento) throws ExceptionService {
        String hql = " select  distinct item.colaborador.identificador as ID_COLABORADOR ,   sum(item.valorComplemento) as VALOR from ItemCompSalarioEventoPeriodo item  where  item.itemEvento.complementoSalario.identificador = :complemento  group by item.colaborador.identificador,item.colaborador.pessoa.nome   order by item.colaborador.pessoa.nome ";
        List hash = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("complemento", complemento.getIdentificador().longValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        ArrayList<HashMap> newHash = new ArrayList<HashMap>();
        for (Object object : hash) {
            HashMap h = (HashMap)object;
            Long idColaborador = (Long)h.get("ID_COLABORADOR");
            Double valor = (Double)h.get("VALOR");
            Double valorPago = 0.0;
            if (!((valor = ContatoFormatUtil.arrredondarNumero((Double)(valor - valorPago), (int)2)) > 0.0)) continue;
            Colaborador c = (Colaborador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOColaborador(), "identificador", idColaborador, 0);
            h.put("COLABORADOR", c);
            h.put("VALOR", valor);
            newHash.add(h);
        }
        return newHash;
    }

    public Object gerarPlanilhasControleBancoHoras(CoreRequestContext cq) throws ExceptionService {
        ControleBancoHorasFolha banco = (ControleBancoHorasFolha)cq.getAttribute("controleBanco");
        List eventos = (List)cq.getAttribute("eventos");
        String diretorio = (String)cq.getAttribute("diretorio");
        DepartamentoColaborador departamento = (DepartamentoColaborador)cq.getAttribute("departamento");
        ConfPlanilhaExcelEventos modeloPlanilha = (ConfPlanilhaExcelEventos)cq.getAttribute("modeloPlanilha");
        Date dataAberturaInicial = (Date)cq.getAttribute("dataAberturaInicial");
        Date dataAberturaFinal = (Date)cq.getAttribute("dataAberturaFinal");
        String nomeCentroCusto = (String)cq.getAttribute("nomeCentroCusto");
        new UtilGerarPlanilhaEventos().exportarPlanilhaExcelDecimoTerceiro(this.getDadosHoras(banco, departamento), eventos, diretorio, modeloPlanilha, dataAberturaInicial, dataAberturaFinal, nomeCentroCusto);
        return Boolean.TRUE;
    }

    public Object gerarPlanilhaValeTransportes(CoreRequestContext request) throws ExceptionService {
        List itens = (List)request.getAttribute("itens");
        ControleValeTransporte vo = (ControleValeTransporte)request.getAttribute("vo");
        TipoCalculoEvento vale = (TipoCalculoEvento)request.getAttribute("evento");
        String diretorio = (String)request.getAttribute("diretorio");
        ConfPlanilhaExcelEventos modeloPlanilha = (ConfPlanilhaExcelEventos)request.getAttribute("modeloPlanilha");
        new UtilGerarPlanilhaEventos().exportarPlanilhaExcelDecimoTerceiro(this.getDados(itens), this.getEventos(vale), diretorio, modeloPlanilha, vo.getPeriodo(), vo.getPeriodo(), "VALE");
        return Boolean.TRUE;
    }

    private List<HashMap> getDados(List<ItemControleValeTransporte> itens) {
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (ItemControleValeTransporte item : itens) {
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("COLABORADOR", item.getColaborador());
            hash.put("VALOR", item.getQtdadeDescontar());
            aux.add(hash);
        }
        return aux;
    }

    private List<HashMap> getEventos(TipoCalculoEvento tp) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tipoCalculoEvento", tp);
        hash.put("valorReferencia", (short)2);
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        aux.add(hash);
        return aux;
    }

    private List<HashMap> getDadosHoras(ControleBancoHorasFolha banco, DepartamentoColaborador departamento) {
        if (departamento == null) {
            ArrayList<HashMap> aux = new ArrayList<HashMap>();
            for (ColaboradorBancoHoras col : banco.getColaboradores()) {
                HashMap<String, Object> hash = new HashMap<String, Object>();
                hash.put("COLABORADOR", col.getColaborador());
                hash.put("VALOR", 0.0);
                aux.add(hash);
            }
            return aux;
        }
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (ColaboradorBancoHoras col : banco.getColaboradores()) {
            if (!col.getColaborador().getDepartamento().equals((Object)departamento)) continue;
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("COLABORADOR", col.getColaborador());
            hash.put("VALOR", 0.0);
            aux.add(hash);
        }
        return aux;
    }

    private Colaborador getColaborador(String registroColaborador, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        String hql = " select  c from Colaborador c where c.numeroRegistroESocial = :registro and c.empresa.empresaDados.grupoEmpresa = :grupoEmpresa";
        Colaborador colaborador = (Colaborador)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("registro", (Object)registroColaborador).setParameter("grupoEmpresa", (Object)grupoEmpresa).uniqueResult();
        if (colaborador == null) {
            throw new ExceptionService("Colaborador n\u00e3o encontrado com o Registro: " + registroColaborador);
        }
        return colaborador;
    }

    public static List<EventoColaborador> createLancamentosConsignados(CadastroEventoConsignado vo) {
        ArrayList<EventoColaborador> evts = new ArrayList<EventoColaborador>();
        Colaborador c = vo.getColaborador();
        boolean continua = true;
        Date dataInicial = vo.getDataInicioDesconto();
        Date dataFinal = vo.getDataFinalDesconto();
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)(vo.getValor() / (double)vo.getNrParcelas().intValue()), (int)2);
        Integer numeroParcelas = vo.getNrParcelas();
        Double valorDebitado = 0.0;
        Integer cont = 1;
        if (vo.getNrParcelas() != 1) {
            do {
                if (cont < numeroParcelas) {
                    continua = true;
                    cont = cont + 1;
                    valorDebitado = valorDebitado + valor;
                } else {
                    valor = vo.getValor() - valorDebitado;
                    continua = false;
                }
                EventoColaborador evt = new EventoColaborador();
                evt.setColaborador(c);
                evt.setDataInicial(dataInicial);
                evt.setDataFinal(ServiceAberturaPeriodo.getDataFinalEvento(dataInicial));
                evt.setEventoConsignado(vo);
                evt.setTipoCalculoEvento(vo.getEventoConsignado());
                evt.setValor(valor);
                evt.setTipoOcorrencia(EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ESPECIFICAMENTE_PERIODO.getEnumId());
                evts.add(evt);
                dataInicial = DateUtil.nextMonth(dataInicial, 1);
            } while (continua);
        } else {
            EventoColaborador evt = new EventoColaborador();
            evt.setColaborador(c);
            evt.setDataInicial(dataInicial);
            evt.setDataFinal(dataFinal);
            evt.setEventoConsignado(vo);
            evt.setTipoCalculoEvento(vo.getEventoConsignado());
            evt.setValor(valor);
            evt.setTipoOcorrencia(EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ESPECIFICAMENTE_PERIODO.getEnumId());
            evts.add(evt);
        }
        return evts;
    }

    private static Date getDataFinalEvento(Date dataInicial) {
        return DateUtil.getDateLastMonthDay(dataInicial);
    }
}

