/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.aberturaperiodo;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelEventos;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelEventosItem;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.IndexedColors;

class UtilGerarPlanilhaEventos {
    UtilGerarPlanilhaEventos() {
    }

    public void exportarPlanilhaExcelEventos(List<Colaborador> colaboradores, List<HashMap> eventos, String caminhoAquivos, ConfPlanilhaExcelEventos modeloPlanilha, Date dataAberturaInicial, Date dataAberturaFinal, String nomeCentroCusto) throws ExceptionService {
        try {
            HSSFWorkbook book = this.buildSheets(modeloPlanilha, eventos, colaboradores);
            this.flushDataSheets(book, caminhoAquivos, dataAberturaInicial, dataAberturaFinal, nomeCentroCusto);
        }
        catch (IOException ex) {
            throw new ExceptionService("Erro ao gerar as planilhas.\n" + ex.getMessage(), ex);
        }
    }

    private HSSFWorkbook buildSheets(ConfPlanilhaExcelEventos modeloPlanilha, List<HashMap> tipos, List<Colaborador> colaboradores) throws IOException {
        HSSFWorkbook book = UtilGerarPlanilhaEventos.getSheetFile(modeloPlanilha);
        HSSFSheet sheet = book.getSheetAt(0);
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        font.setFontHeightInPoints((short)11);
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont(font);
        style.setLocked(true);
        ConfPlanilhaExcelEventosItem itemRegColab = this.getItem(modeloPlanilha.getItensConf(), "numero_registro");
        ConfPlanilhaExcelEventosItem itemNomeColab = this.getItem(modeloPlanilha.getItensConf(), "nome_colaborador");
        ConfPlanilhaExcelEventosItem itemCodEvento = this.getItem(modeloPlanilha.getItensConf(), "codigo_evento");
        ConfPlanilhaExcelEventosItem itemNomeEvento = this.getItem(modeloPlanilha.getItensConf(), "nome_evento");
        ConfPlanilhaExcelEventosItem itemValorRef = this.getItem(modeloPlanilha.getItensConf(), "valor_referencia");
        ConfPlanilhaExcelEventosItem itemTipo = this.getItem(modeloPlanilha.getItensConf(), "tipo");
        int nrLinhaRegColab = itemRegColab != null ? itemRegColab.getLinha() : -1;
        int nrLinhaNomeColab = itemNomeColab != null ? itemNomeColab.getLinha() : -1;
        int nrLinhaCodEvento = itemCodEvento != null ? itemCodEvento.getLinha() : -1;
        int nrLinhaNomeEvento = itemNomeEvento != null ? itemNomeEvento.getLinha() : -1;
        int nrLinhaValorRef = itemValorRef != null ? itemValorRef.getLinha() : -1;
        int nrLinhaTipo = itemTipo != null ? itemTipo.getLinha() : -1;
        for (Colaborador colab : colaboradores) {
            HSSFCell cell;
            HSSFRow row;
            int column;
            int maxColumn = 0;
            if (nrLinhaRegColab > -1 && itemRegColab.getUtilizar() != null && itemRegColab.getUtilizar() == 1) {
                column = itemRegColab.getColuna() - 1;
                row = this.getRow(nrLinhaRegColab, sheet);
                cell = this.getCell(column, row);
                cell.setCellValue(colab.getNumeroRegistro());
                nrLinhaRegColab += itemRegColab.getSaltoLinha().intValue();
                if ((column += itemRegColab.getSaltoColuna().intValue()) > maxColumn) {
                    maxColumn = column;
                }
            }
            if (nrLinhaNomeColab > -1 && itemNomeColab.getUtilizar() != null && itemNomeColab.getUtilizar() == 1) {
                column = itemNomeColab.getColuna() - 1;
                row = this.getRow(nrLinhaNomeColab, sheet);
                cell = this.getCell(column, row);
                cell.setCellValue(colab.getPessoa().getNome());
                nrLinhaNomeColab += itemNomeColab.getSaltoLinha().intValue();
                if ((column += itemNomeColab.getSaltoColuna().intValue()) > maxColumn) {
                    maxColumn = column;
                }
            }
            ++maxColumn;
            for (HashMap h : tipos) {
                HSSFCell cell2;
                HSSFRow row2;
                int column2;
                TipoCalculoEvento t = (TipoCalculoEvento)h.get("tipoCalculoEvento");
                Short valorReferencia = (Short)h.get("valorReferencia");
                if (nrLinhaCodEvento > -1 && itemCodEvento.getUtilizar() != null && itemCodEvento.getUtilizar() == 1) {
                    column2 = maxColumn;
                    row2 = this.getRow(nrLinhaCodEvento, sheet);
                    cell2 = this.getCell(column2, row2);
                    cell2.setCellValue((double)t.getEvento().getCodigo().longValue());
                    if (nrLinhaCodEvento == 1) {
                        row2 = this.getRow(nrLinhaCodEvento - 1, sheet);
                        cell2 = this.getCell(column2, row2);
                        cell2.setCellValue(t.getEvento().getDescricao().toUpperCase());
                        cell2.setCellStyle(style);
                    }
                    if ((column2 += itemCodEvento.getSaltoColuna().intValue()) > maxColumn) {
                        maxColumn = column2;
                    }
                }
                if (nrLinhaNomeEvento > -1 && itemNomeEvento.getUtilizar() != null && itemNomeEvento.getUtilizar() == 1) {
                    column2 = maxColumn;
                    row2 = this.getRow(nrLinhaNomeEvento, sheet);
                    cell2 = this.getCell(column2, row2);
                    cell2.setCellValue(t.getEvento().getDescricao());
                    if ((column2 += itemNomeEvento.getSaltoColuna().intValue()) > maxColumn) {
                        maxColumn = column2;
                    }
                }
                if (nrLinhaTipo > -1 && itemTipo.getUtilizar() != null && itemTipo.getUtilizar() == 1) {
                    column2 = maxColumn;
                    row2 = this.getRow(nrLinhaTipo, sheet);
                    cell2 = this.getCell(column2, row2);
                    cell2.setCellValue((double)valorReferencia.shortValue());
                    column2 += itemTipo.getSaltoColuna().intValue();
                    if (nrLinhaCodEvento == 1) {
                        row2 = this.getRow(nrLinhaCodEvento - 1, sheet);
                        cell2 = this.getCell(column2 - 1, row2);
                        cell2.setCellValue("TIPO");
                    }
                    if (column2 > maxColumn) {
                        maxColumn = column2;
                    }
                }
                if (nrLinhaValorRef <= -1 || itemValorRef.getUtilizar() == null || itemValorRef.getUtilizar() != 1) continue;
                column2 = maxColumn;
                row2 = this.getRow(nrLinhaValorRef, sheet);
                cell2 = this.getCell(column2, row2);
                cell2.setCellValue(0.0);
                column2 += itemValorRef.getSaltoColuna().intValue();
                if (nrLinhaCodEvento == 1) {
                    row2 = this.getRow(nrLinhaCodEvento - 1, sheet);
                    cell2 = this.getCell(column2 - 1, row2);
                    cell2.setCellValue("VALOR_REFERENCIA");
                }
                if (column2 <= maxColumn) continue;
                maxColumn = column2;
            }
            nrLinhaCodEvento = nrLinhaNomeColab;
            nrLinhaNomeEvento = nrLinhaNomeColab;
            nrLinhaValorRef = nrLinhaNomeColab;
            nrLinhaTipo = nrLinhaNomeColab;
        }
        return book;
    }

    private void flushDataSheets(HSSFWorkbook book, String path, Date dataAberturaInicial, Date dataAberturaFinal, String nomeCentroCusto) throws IOException {
        FileOutputStream outfile = new FileOutputStream(UtilGerarPlanilhaEventos.getFile(path, dataAberturaInicial, dataAberturaFinal, nomeCentroCusto));
        book.write((OutputStream)outfile);
        outfile.flush();
        outfile.close();
    }

    private static HSSFWorkbook getSheetFile(ConfPlanilhaExcelEventos modeloPlanilha) throws FileNotFoundException, IOException {
        POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)new ByteArrayInputStream(modeloPlanilha.getArquivoPlanilha()));
        HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
        return myWorkBook;
    }

    private ConfPlanilhaExcelEventosItem getItem(List<ConfPlanilhaExcelEventosItem> itens, String key) {
        for (ConfPlanilhaExcelEventosItem item : itens) {
            if (!item.getChave().equalsIgnoreCase(key)) continue;
            return item;
        }
        return null;
    }

    private static String getFile(String file, Date dataAberturaInicial, Date dataAberturaFinal, String nome) {
        String dataInicial = DateUtil.dateToStr(dataAberturaInicial, "dd-MM-yyyy");
        String dataFinal = DateUtil.dateToStr(dataAberturaFinal, "dd-MM-yyyy");
        return file + File.separator + nome + dataInicial + "_" + dataFinal + ".xls";
    }

    private HSSFRow getRow(int linha, HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(linha);
        if (row == null) {
            row = sheet.createRow(linha);
        }
        return row;
    }

    private HSSFCell getCell(int coluna, HSSFRow row) {
        HSSFCell cell = row.getCell(coluna);
        if (cell == null) {
            cell = row.createCell(coluna);
        }
        return cell;
    }

    public void exportarPlanilhaExcelDecimoTerceiro(List<HashMap> hash, List<HashMap> eventos, String caminhoAquivos, ConfPlanilhaExcelEventos modeloPlanilha, Date dataAberturaInicial, Date dataAberturaFinal, String nomeCentroCusto) throws ExceptionService {
        try {
            HSSFWorkbook book = this.buildSheetsDecimoTerceiro(modeloPlanilha, eventos, hash);
            this.flushDataSheets(book, caminhoAquivos, dataAberturaInicial, dataAberturaFinal, nomeCentroCusto);
        }
        catch (IOException ex) {
            throw new ExceptionService("Erro ao gerar as planilhas.\n" + ex.getMessage(), ex);
        }
    }

    private HSSFWorkbook buildSheetsDecimoTerceiro(ConfPlanilhaExcelEventos modeloPlanilha, List<HashMap> tipos, List<HashMap> hash) throws IOException {
        HSSFWorkbook book = UtilGerarPlanilhaEventos.getSheetFile(modeloPlanilha);
        HSSFSheet sheet = book.getSheetAt(0);
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        font.setFontHeightInPoints((short)11);
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont(font);
        style.setLocked(true);
        ConfPlanilhaExcelEventosItem itemRegColab = this.getItem(modeloPlanilha.getItensConf(), "numero_registro");
        ConfPlanilhaExcelEventosItem itemNomeColab = this.getItem(modeloPlanilha.getItensConf(), "nome_colaborador");
        ConfPlanilhaExcelEventosItem itemCodEvento = this.getItem(modeloPlanilha.getItensConf(), "codigo_evento");
        ConfPlanilhaExcelEventosItem itemNomeEvento = this.getItem(modeloPlanilha.getItensConf(), "nome_evento");
        ConfPlanilhaExcelEventosItem itemValorRef = this.getItem(modeloPlanilha.getItensConf(), "valor_referencia");
        ConfPlanilhaExcelEventosItem itemTipo = this.getItem(modeloPlanilha.getItensConf(), "tipo");
        int nrLinhaRegColab = itemRegColab != null ? itemRegColab.getLinha() : -1;
        int nrLinhaNomeColab = itemNomeColab != null ? itemNomeColab.getLinha() : -1;
        int nrLinhaCodEvento = itemCodEvento != null ? itemCodEvento.getLinha() : -1;
        int nrLinhaNomeEvento = itemNomeEvento != null ? itemNomeEvento.getLinha() : -1;
        int nrLinhaValorRef = itemValorRef != null ? itemValorRef.getLinha() : -1;
        int nrLinhaTipo = itemTipo != null ? itemTipo.getLinha() : -1;
        for (HashMap hashMap : hash) {
            HSSFCell cell;
            HSSFRow row;
            int column;
            Colaborador colab = (Colaborador)hashMap.get("COLABORADOR");
            Double valor = (Double)hashMap.get("VALOR");
            int maxColumn = 0;
            if (nrLinhaRegColab > -1 && itemRegColab.getUtilizar() != null && itemRegColab.getUtilizar() == 1) {
                column = itemRegColab.getColuna() - 1;
                row = this.getRow(nrLinhaRegColab, sheet);
                cell = this.getCell(column, row);
                cell.setCellValue(colab.getNumeroRegistro());
                nrLinhaRegColab += itemRegColab.getSaltoLinha().intValue();
                if ((column += itemRegColab.getSaltoColuna().intValue()) > maxColumn) {
                    maxColumn = column;
                }
            }
            if (nrLinhaNomeColab > -1 && itemNomeColab.getUtilizar() != null && itemNomeColab.getUtilizar() == 1) {
                column = itemNomeColab.getColuna() - 1;
                row = this.getRow(nrLinhaNomeColab, sheet);
                cell = this.getCell(column, row);
                cell.setCellValue(colab.getPessoa().getNome());
                nrLinhaNomeColab += itemNomeColab.getSaltoLinha().intValue();
                if ((column += itemNomeColab.getSaltoColuna().intValue()) > maxColumn) {
                    maxColumn = column;
                }
            }
            ++maxColumn;
            for (HashMap h : tipos) {
                HSSFCell cell2;
                HSSFRow row2;
                int column2;
                TipoCalculoEvento t = (TipoCalculoEvento)h.get("tipoCalculoEvento");
                Short valorReferencia = (Short)h.get("valorReferencia");
                if (nrLinhaCodEvento > -1 && itemCodEvento.getUtilizar() != null && itemCodEvento.getUtilizar() == 1) {
                    column2 = maxColumn;
                    row2 = this.getRow(nrLinhaCodEvento, sheet);
                    cell2 = this.getCell(column2, row2);
                    cell2.setCellValue((double)t.getEvento().getCodigo().longValue());
                    if (nrLinhaCodEvento == 1) {
                        row2 = this.getRow(nrLinhaCodEvento - 1, sheet);
                        cell2 = this.getCell(column2, row2);
                        cell2.setCellValue(t.getEvento().getDescricao().toUpperCase());
                        cell2.setCellStyle(style);
                    }
                    if ((column2 += itemCodEvento.getSaltoColuna().intValue()) > maxColumn) {
                        maxColumn = column2;
                    }
                }
                if (nrLinhaNomeEvento > -1 && itemNomeEvento.getUtilizar() != null && itemNomeEvento.getUtilizar() == 1) {
                    column2 = maxColumn;
                    row2 = this.getRow(nrLinhaNomeEvento, sheet);
                    cell2 = this.getCell(column2, row2);
                    cell2.setCellValue(t.getEvento().getDescricao());
                    if ((column2 += itemNomeEvento.getSaltoColuna().intValue()) > maxColumn) {
                        maxColumn = column2;
                    }
                }
                if (nrLinhaTipo > -1 && itemTipo.getUtilizar() != null && itemTipo.getUtilizar() == 1) {
                    column2 = maxColumn;
                    row2 = this.getRow(nrLinhaTipo, sheet);
                    cell2 = this.getCell(column2, row2);
                    cell2.setCellValue((double)valorReferencia.shortValue());
                    column2 += itemTipo.getSaltoColuna().intValue();
                    if (nrLinhaCodEvento == 1) {
                        row2 = this.getRow(nrLinhaCodEvento - 1, sheet);
                        cell2 = this.getCell(column2 - 1, row2);
                        cell2.setCellValue("TIPO");
                    }
                    if (column2 > maxColumn) {
                        maxColumn = column2;
                    }
                }
                if (nrLinhaValorRef <= -1 || itemValorRef.getUtilizar() == null || itemValorRef.getUtilizar() != 1) continue;
                column2 = maxColumn;
                row2 = this.getRow(nrLinhaValorRef, sheet);
                cell2 = this.getCell(column2, row2);
                cell2.setCellValue(valor.doubleValue());
                column2 += itemValorRef.getSaltoColuna().intValue();
                if (nrLinhaCodEvento == 1) {
                    row2 = this.getRow(nrLinhaCodEvento - 1, sheet);
                    cell2 = this.getCell(column2 - 1, row2);
                    cell2.setCellValue("VALOR_REFERENCIA");
                }
                if (column2 <= maxColumn) continue;
                maxColumn = column2;
            }
            nrLinhaCodEvento = nrLinhaNomeColab;
            nrLinhaNomeEvento = nrLinhaNomeColab;
            nrLinhaValorRef = nrLinhaNomeColab;
            nrLinhaTipo = nrLinhaNomeColab;
        }
        return book;
    }
}

