/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.aberturaperiodo;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.DiaHorarioTrabalho;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.PeriodoHorTrab;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.IndexedColors;

public class UtilGerarPlanilhaPonto {
    int SALTO_COLUNA = 1;
    int SALTO_LINHA = 1;
    int COLUNA_REGISTRO_COLABORADOR = 1;
    int COLUNA_NOME_COLABORADOR = 2;
    int COLUNA_DATA = 3;
    int COLUNA_STATUS = 4;
    int COLUNA_INICIO = 5;
    int COLUNA_INICIO_INTERVALO = 6;
    int COLUNA_FINAL_INTERVALO = 7;
    int COLUNA_FINAL = 8;
    int LINHA_REGISTROS = 1;
    public static final int SEGUNDA = 2;
    public static final int TERCA = 3;
    public static final int QUARTA = 4;
    public static final int QUINTA = 5;
    public static final int SEXTA = 6;
    public static final int SABADO = 7;
    public static final int DOMINGO = 1;

    public void exportPlanilhaEventos(List<Colaborador> colaboradores, Date dataInico, Date dataFinal, byte[] planilhaPonto, String diretorio, Double horaFinalInformada) throws IOException, ExceptionService {
        HSSFWorkbook book = this.buildSheets(colaboradores, dataInico, dataFinal, planilhaPonto, horaFinalInformada);
        this.flushDataSheets(book, diretorio, dataInico, dataFinal, "PLANILHA PONTO");
    }

    private HSSFWorkbook buildSheets(List<Colaborador> colaboradores, Date dataInico, Date dataFinal, byte[] planilhaPonto, Double horaFinalInformada) throws IOException, ExceptionService {
        HSSFWorkbook book = this.getSheetFile(planilhaPonto);
        HSSFSheet sheet = book.getSheetAt(0);
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        font.setFontHeightInPoints((short)11);
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont(font);
        style.setLocked(true);
        for (Colaborador colaborador : colaboradores) {
            int maxColumn = 0;
            int column = this.COLUNA_REGISTRO_COLABORADOR - 1;
            HSSFRow row = this.getRow(this.LINHA_REGISTROS, sheet);
            HSSFCell cell = this.getCell(column, row);
            cell.setCellValue(colaborador.getNumeroRegistro());
            if ((column += this.SALTO_COLUNA) > maxColumn) {
                maxColumn = column;
            }
            column = this.COLUNA_NOME_COLABORADOR - 1;
            row = this.getRow(this.LINHA_REGISTROS, sheet);
            cell = this.getCell(column, row);
            cell.setCellValue(colaborador.getPessoa().getNome());
            if ((column += this.SALTO_COLUNA) > maxColumn) {
                maxColumn = column;
            }
            ++maxColumn;
            Date dataResumo = dataInico;
            boolean continuar = true;
            do {
                Double horaInicio = 0.0;
                Double horaInicioIntervalo = 0.0;
                Double horaFinalIntervalo = 0.0;
                Double horaFinal = 0.0;
                Integer status = 1;
                DiaHorarioTrabalho diaHorario = this.getDiaHorario(colaborador, dataResumo);
                if (diaHorario != null) {
                    horaInicio = ((PeriodoHorTrab)diaHorario.getPeriodosTrabalho().get(0)).getHoraInicial();
                    horaInicioIntervalo = ((PeriodoHorTrab)diaHorario.getPeriodosTrabalho().get(0)).getHoraFinal();
                    horaFinalIntervalo = ((PeriodoHorTrab)diaHorario.getPeriodosTrabalho().get(1)).getHoraInicial();
                    horaFinal = ((PeriodoHorTrab)diaHorario.getPeriodosTrabalho().get(1)).getHoraFinal();
                } else {
                    status = 2;
                }
                int column2 = maxColumn - 1;
                this.COLUNA_DATA += this.SALTO_COLUNA;
                HSSFRow row2 = this.getRow(this.LINHA_REGISTROS, sheet);
                HSSFCell cell2 = this.getCell(column2, row2);
                cell2.setCellStyle(style);
                cell2.setCellValue(DateUtil.dayFromDate(dataResumo) + "/" + DateUtil.monthFromDate(dataResumo) + "/" + DateUtil.yearFromDate(dataResumo));
                if (this.LINHA_REGISTROS == 1) {
                    row2 = this.getRow(this.LINHA_REGISTROS - 1, sheet);
                    cell2 = this.getCell(column2, row2);
                    cell2.setCellValue("DATA");
                    cell2.setCellStyle(style);
                }
                if ((column2 += this.SALTO_COLUNA) > maxColumn) {
                    maxColumn = column2;
                }
                int column3 = maxColumn;
                HSSFRow row3 = this.getRow(this.LINHA_REGISTROS, sheet);
                HSSFCell cell3 = this.getCell(column3, row3);
                if (this.LINHA_REGISTROS == 1) {
                    row3 = this.getRow(this.LINHA_REGISTROS - 1, sheet);
                    cell3 = this.getCell(column3, row3);
                    cell3.setCellValue("STATUS");
                }
                if ((column3 += this.SALTO_COLUNA) > maxColumn) {
                    maxColumn = column3;
                }
                column3 = maxColumn;
                row3 = this.getRow(this.LINHA_REGISTROS, sheet);
                cell3 = this.getCell(column3, row3);
                if (this.LINHA_REGISTROS == 1) {
                    row3 = this.getRow(this.LINHA_REGISTROS - 1, sheet);
                    cell3 = this.getCell(column3, row3);
                    cell3.setCellValue("INICIO_TRABALHO");
                }
                if ((column3 += this.SALTO_COLUNA) > maxColumn) {
                    maxColumn = column3;
                }
                column3 = maxColumn;
                row3 = this.getRow(this.LINHA_REGISTROS, sheet);
                cell3 = this.getCell(column3, row3);
                if (this.LINHA_REGISTROS == 1) {
                    row3 = this.getRow(this.LINHA_REGISTROS - 1, sheet);
                    cell3 = this.getCell(column3, row3);
                    cell3.setCellValue("INICIO_INTERVALO");
                }
                if ((column3 += this.SALTO_COLUNA) > maxColumn) {
                    maxColumn = column3;
                }
                column3 = maxColumn;
                row3 = this.getRow(this.LINHA_REGISTROS, sheet);
                cell3 = this.getCell(column3, row3);
                if (this.LINHA_REGISTROS == 1) {
                    row3 = this.getRow(this.LINHA_REGISTROS - 1, sheet);
                    cell3 = this.getCell(column3, row3);
                    cell3.setCellValue("FINAL_INTERVALO");
                }
                if ((column3 += this.SALTO_COLUNA) > maxColumn) {
                    maxColumn = column3;
                }
                column3 = maxColumn;
                row3 = this.getRow(this.LINHA_REGISTROS, sheet);
                cell3 = this.getCell(column3, row3);
                if (horaFinalInformada == 0.0) {
                    // empty if block
                }
                if (this.LINHA_REGISTROS == 1) {
                    row3 = this.getRow(this.LINHA_REGISTROS - 1, sheet);
                    cell3 = this.getCell(column3, row3);
                    cell3.setCellValue("FINAL_TRABALHO");
                }
                if ((column3 += this.SALTO_COLUNA) > maxColumn) {
                    maxColumn = column3;
                }
                if ((dataResumo = DateUtil.nextDays(dataResumo, 1)).after(dataFinal)) {
                    continuar = false;
                    continue;
                }
                ++maxColumn;
                continuar = true;
            } while (continuar);
            this.LINHA_REGISTROS += this.SALTO_LINHA;
        }
        return book;
    }

    private HSSFWorkbook getSheetFile(byte[] planilhaPonto) throws IOException {
        POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)new ByteArrayInputStream(planilhaPonto));
        HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
        return myWorkBook;
    }

    private HSSFRow getRow(int linha, HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(linha);
        if (row == null) {
            row = sheet.createRow(linha);
        }
        return row;
    }

    private HSSFCell getCell(int coluna, HSSFRow row) {
        HSSFCell cell = row.getCell(coluna);
        if (cell == null) {
            System.out.println(coluna);
            cell = row.createCell(coluna);
        }
        return cell;
    }

    private void flushDataSheets(HSSFWorkbook book, String diretorio, Date dataInico, Date dataFinal, String nome) throws FileNotFoundException, IOException {
        FileOutputStream outfile = new FileOutputStream(UtilGerarPlanilhaPonto.getFile(diretorio, dataInico, dataFinal, nome));
        book.write((OutputStream)outfile);
        outfile.flush();
        outfile.close();
    }

    private static String getFile(String file, Date dataAberturaInicial, Date dataAberturaFinal, String nome) {
        String dataInicial = DateUtil.dateToStr(dataAberturaInicial, "dd-MM-yyyy");
        String dataFinal = DateUtil.dateToStr(dataAberturaFinal, "dd-MM-yyyy");
        return file + File.separator + nome + dataInicial + "_" + dataFinal + ".xls";
    }

    private DiaHorarioTrabalho getDiaHorario(Colaborador colaborador, Date dataResumo) throws ExceptionService {
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Integer diaFolga = this.verificarFolga(dataResumo, horario);
        if (diaFolga.equals(1)) {
            return null;
        }
        System.err.println(dataResumo);
        String hql = " select diaHorario  from DiaHorarioTrabalho diaHorario  where  diaHorario.horarioTrabalho = :horario  and  diaHorario.dataHorTrab = :dataResumo ";
        DiaHorarioTrabalho ret = (DiaHorarioTrabalho)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("horario", (Object)horario).setDate("dataResumo", dataResumo).uniqueResult();
        if (ret == null) {
            throw new ExceptionService("N\u00e3o existe horario informado para a data: " + DateUtil.dateToStr(dataResumo, "dd/MM/yyyy"));
        }
        if (ret.getPeriodosTrabalho() == null || ret.getPeriodosTrabalho().size() != 2) {
            throw new ExceptionService("Verifique as configura\u00e7\u00f5es do Horario com ID: " + horario.getIdentificador() + "---" + ret.getPeriodosTrabalho().size() + "- DATA:" + String.valueOf(ret.getDataHorTrab()));
        }
        return ret;
    }

    private Integer verificarFolga(Date dataResumo, HorarioTrabalho horario) {
        Integer dia = DateUtil.diaDaSemana(dataResumo);
        return 0;
    }
}

