/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.aberturaperiodo;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelEventos;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelEventosItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class UtilLLerPlanilhaEventos {
    UtilLLerPlanilhaEventos() {
    }

    public List<HashMap> importarCreditoTrabalhador(List<File> files) throws IOException {
        ArrayList<HashMap> creditos = new ArrayList<HashMap>();
        for (File f : files) {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(f));
            XSSFSheet sheet = workbook.getSheetAt(0);
            Integer linha = 1;
            do {
                XSSFRow row = sheet.getRow(linha.intValue());
                HashMap<String, Object> credito = new HashMap<String, Object>();
                Double codigoBanco = row.getCell(ConstantsESocial.ESOC_CODIGO_BANCO_ECONSIGNADO.intValue()).getNumericCellValue();
                String numeroContrato = row.getCell(ConstantsESocial.ESOC_NUMERO_CONTRATO_ECONSIGNADO.intValue()).getStringCellValue();
                String registroColaborador = row.getCell(ConstantsESocial.ESOC_REGISTRO_COLABORADOR_ECONSIGNADO.intValue()).getStringCellValue();
                String inicioDesconto = row.getCell(ConstantsESocial.ESOC_DATA_COMPETENCIA.intValue()).getStringCellValue();
                String finalDesconto = row.getCell(ConstantsESocial.ESOC_DATA_COMPETENCIA.intValue()).getStringCellValue();
                Double totalParcela = row.getCell(ConstantsESocial.ESOC_TOTAL_PARCELA_ECONSIGNADO.intValue()).getNumericCellValue();
                Double valorParcela = row.getCell(ConstantsESocial.ESOC_VALOR_PARCELA_ECONSIGNADO.intValue()).getNumericCellValue();
                Date dataInicioContrato = row.getCell(ConstantsESocial.ESOC_DATA_INICIO_CONTRATO.intValue()).getDateCellValue();
                credito.put("CODIGO_BANCO", codigoBanco);
                credito.put("NUMERO_CONTRATO", numeroContrato);
                credito.put("REGISTRO_COLABORADOR", registroColaborador);
                credito.put("INICIO_DESCONTO", inicioDesconto);
                credito.put("FINAL_DESCONTO", finalDesconto);
                credito.put("TOTAL_PARCELA", totalParcela);
                credito.put("VALOR_PARCELA", valorParcela);
                credito.put("DATA_INICIO_CONTRATO", dataInicioContrato);
                creditos.add(credito);
            } while (sheet.getRow((linha = Integer.valueOf(linha + 1)).intValue()) != null && sheet.getRow(linha.intValue()).getCell(0) != null);
        }
        return creditos;
    }

    public List<HashMap> importarPlanilhaExcelEventos(List<File> files, ConfPlanilhaExcelEventos modeloPlanilha, List<Colaborador> colaboradores) throws FileNotFoundException, IOException, ExceptionService {
        List<HashMap> eventos = new ArrayList<HashMap>();
        for (File f : files) {
            HSSFSheet sheet = this.getSheetFile(f.getAbsolutePath());
            eventos = this.extractDataToEventos(sheet, modeloPlanilha, colaboradores.size());
        }
        return eventos;
    }

    private HSSFSheet getSheetFile(String file) throws FileNotFoundException, IOException {
        POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(new File(file)));
        HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
        return myWorkBook.getSheetAt(0);
    }

    private List<HashMap> extractDataToEventos(HSSFSheet sheet, ConfPlanilhaExcelEventos modeloPlanilha, int nrColaboradores) throws ExceptionService {
        ConfPlanilhaExcelEventosItem itemRegColab = this.getItem(modeloPlanilha.getItensConf(), "numero_registro");
        ConfPlanilhaExcelEventosItem itemNomeColab = this.getItem(modeloPlanilha.getItensConf(), "nome_colaborador");
        ConfPlanilhaExcelEventosItem itemCodEvento = this.getItem(modeloPlanilha.getItensConf(), "codigo_evento");
        ConfPlanilhaExcelEventosItem itemNomeEvento = this.getItem(modeloPlanilha.getItensConf(), "nome_evento");
        ConfPlanilhaExcelEventosItem itemValorRef = this.getItem(modeloPlanilha.getItensConf(), "valor_referencia");
        ConfPlanilhaExcelEventosItem itemTipo = this.getItem(modeloPlanilha.getItensConf(), "tipo");
        int linhaRegColab = itemRegColab != null ? itemRegColab.getLinha() : 0;
        int linhaCodEvento = itemCodEvento != null ? itemCodEvento.getLinha() : 0;
        int linhaNomeEvento = itemNomeEvento != null ? itemNomeEvento.getLinha() : 0;
        int linhaValorRef = itemValorRef != null ? itemValorRef.getLinha() : 0;
        int linhaTipo = itemTipo != null ? itemTipo.getLinha() : 0;
        int loops = 0;
        ArrayList<HashMap> colaboradores = new ArrayList<HashMap>();
        do {
            HashMap<String, Object> h = new HashMap<String, Object>();
            if (itemRegColab != null && itemRegColab.getUtilizar() != null && itemRegColab.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(itemRegColab.getColuna() - 1) != null) {
                HSSFCell cell = sheet.getRow(linhaRegColab).getCell(itemRegColab.getColuna() - 1);
                h.put("NR_REGISTRO", this.getCellValue((Cell)cell));
            }
            boolean inicial = true;
            ArrayList dadosEventos = new ArrayList();
            int maxColun = 2;
            do {
                HSSFCell cell;
                HashMap<String, Object> hashEvento = new HashMap<String, Object>();
                if (inicial) {
                    if (itemCodEvento != null && itemCodEvento.getUtilizar() != null && itemCodEvento.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(itemCodEvento.getColuna() - 1) != null) {
                        cell = sheet.getRow(linhaRegColab).getCell(itemCodEvento.getColuna() - 1);
                        hashEvento.put("CODIGO_EVENTO", this.getLongValue((Cell)cell));
                        maxColun += itemCodEvento.getSaltoColuna().intValue();
                    }
                } else if (itemCodEvento != null && itemCodEvento.getUtilizar() != null && itemCodEvento.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(maxColun) != null) {
                    cell = sheet.getRow(linhaRegColab).getCell(maxColun);
                    hashEvento.put("CODIGO_EVENTO", this.getLongValue((Cell)cell));
                    maxColun += itemCodEvento.getSaltoColuna().intValue();
                }
                if (inicial) {
                    if (itemNomeEvento != null && itemNomeEvento.getUtilizar() != null && itemNomeEvento.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(itemNomeEvento.getColuna() - 1) != null) {
                        cell = sheet.getRow(linhaRegColab).getCell(itemNomeEvento.getColuna() - 1);
                        hashEvento.put("NOME_EVENTO", this.getCellValue((Cell)cell));
                        maxColun += itemNomeEvento.getSaltoColuna().intValue();
                    }
                } else if (itemNomeEvento != null && itemNomeEvento.getUtilizar() != null && itemNomeEvento.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(maxColun) != null) {
                    cell = sheet.getRow(linhaRegColab).getCell(maxColun);
                    hashEvento.put("NOME_EVENTO", this.getCellValue((Cell)cell));
                    maxColun += itemNomeEvento.getSaltoColuna().intValue();
                }
                if (inicial) {
                    if (itemTipo != null && itemTipo.getUtilizar() != null && itemTipo.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(itemTipo.getColuna() - 1) != null) {
                        cell = sheet.getRow(linhaRegColab).getCell(itemTipo.getColuna() - 1);
                        hashEvento.put("TIPO", this.getShortValue((Cell)cell));
                        maxColun += itemTipo.getSaltoColuna().intValue();
                    }
                } else if (itemTipo != null && itemTipo.getUtilizar() != null && itemTipo.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(maxColun) != null) {
                    cell = sheet.getRow(linhaRegColab).getCell(maxColun);
                    hashEvento.put("TIPO", this.getShortValue((Cell)cell));
                    maxColun += itemTipo.getSaltoColuna().intValue();
                }
                if (inicial) {
                    if (itemValorRef != null && itemValorRef.getUtilizar() != null && itemValorRef.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(itemValorRef.getColuna() - 1) != null) {
                        cell = sheet.getRow(linhaRegColab).getCell(itemValorRef.getColuna() - 1);
                        hashEvento.put("VALOR_REFERENCIA", this.getNumericValue((Cell)cell));
                        maxColun += itemValorRef.getSaltoColuna().intValue();
                    }
                } else if (itemValorRef != null && itemValorRef.getUtilizar() != null && itemValorRef.getUtilizar() == 1 && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(maxColun) != null) {
                    cell = sheet.getRow(linhaRegColab).getCell(maxColun);
                    hashEvento.put("VALOR_REFERENCIA", this.getNumericValue((Cell)cell));
                    maxColun += itemValorRef.getSaltoColuna().intValue();
                }
                dadosEventos.add(hashEvento);
                inicial = false;
            } while (sheet.getRow(linhaRegColab).getCell(maxColun) != null);
            linhaRegColab += itemRegColab.getSaltoLinha().intValue();
            h.put("EVENTOS", dadosEventos);
            colaboradores.add(h);
            if (++loops <= 5000) continue;
            throw new ExceptionService("Erro ao ler as planilhas. Loop sem fim. Verifique o campo salto na configura\u00e7\u00e3o da planilha.");
        } while (loops != nrColaboradores && sheet.getRow(linhaRegColab) != null && sheet.getRow(linhaRegColab).getCell(itemRegColab.getColuna() - 1) != null);
        return colaboradores;
    }

    private Double getNumericValue(Cell cell) {
        String value = this.getCellValue(cell);
        return value != null && !value.isEmpty() ? Double.parseDouble(value) : 0.0;
    }

    private Long getLongValue(Cell cell) {
        String value = this.getCellValue(cell);
        if (value != null) {
            Double doubleValue = Double.parseDouble(value);
            Integer intValue = doubleValue.intValue();
            return Long.parseLong(intValue.toString());
        }
        return null;
    }

    private Short getShortValue(Cell cell) {
        String value = this.getCellValue(cell);
        if (value != null) {
            Double doubleValue = Double.parseDouble(value);
            Integer intValue = doubleValue.intValue();
            return Short.parseShort(intValue.toString());
        }
        return null;
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 0: {
                return Double.toString(cell.getNumericCellValue());
            }
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case 2: {
                return Double.toString(cell.getNumericCellValue());
            }
        }
        return cell.getStringCellValue();
    }

    private ConfPlanilhaExcelEventosItem getItem(List<ConfPlanilhaExcelEventosItem> itens, String key) {
        for (ConfPlanilhaExcelEventosItem item : itens) {
            if (!item.getChave().equalsIgnoreCase(key)) continue;
            return item;
        }
        return null;
    }
}

