/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.analisecredito;

import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.model.impl.SaldoFinanceiroPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ClienteFinanceiro;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorlogger.TLogger;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionClienteInabilitadoAviso;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

class UtilAnaliseCreditoCliente {
    private TLogger logger = TLogger.get(UtilAnaliseCreditoCliente.class);

    UtilAnaliseCreditoCliente() {
    }

    public boolean validarUnidadeFatClienteFinanceiro(UnidadeFatCliente uni, Short verificaLimiteCredito, Double valorAdicional, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        if (uni != null) {
            this.validarClienteFinanceiro(uni.getCliente(), valorAdicional, verificaLimiteCredito, opcoesFaturamento, opcoesFinanceiras);
        }
        return true;
    }

    private boolean validarClienteFinanceiro(Cliente cliente, Double valorAdicional, Short verificarLimiteCredito, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        if (cliente.getFinanceiro().getNaoAvaliarFinanceiro() != null && cliente.getFinanceiro().getNaoAvaliarFinanceiro() == 1) {
            return true;
        }
        if (verificarLimiteCredito != null && verificarLimiteCredito == 1) {
            ClienteFinanceiro v = cliente.getFinanceiro();
            if (v.getDataLiberacaoCredito() != null && v.getDiasVigorLimiteCred() != null && v.getDiasVigorLimiteCred() > 0) {
                Date next = DateUtil.nextDays(v.getDataLiberacaoCredito(), v.getDiasVigorLimiteCred());
                Object msg = " A an\u00e1lise do limite de cr\u00e9dito deste cliente ser\u00e1 liberado \u00e0 partir da data " + DateUtil.dateToStr(v.getDataLiberacaoCredito(), "dd-MM-yyyy");
                if (v.getDataLiberacaoCredito().after(DateUtil.getCurrentDate())) {
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                        throw new ExceptionClienteInabilitadoAviso((String)msg);
                    }
                    throw new ExceptionService((String)msg);
                }
                msg = "A an\u00e1lise do limite de cr\u00e9dito deste cliente expirou. Refa\u00e7a a an\u00e1lise de Cr\u00e9dito.";
                if (next.before(DateUtil.getCurrentDate())) {
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                        throw new ExceptionClienteInabilitadoAviso((String)msg);
                    }
                    throw new ExceptionService((String)msg);
                }
            }
            String msg = "Cliente inabilitado para compras!";
            if (cliente.getFinanceiro().getHabilParaCompra() == null || cliente.getFinanceiro().getHabilParaCompra() == 0) {
                if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                    throw new ExceptionClienteInabilitadoAviso(msg);
                }
                throw new ExceptionService(msg);
            }
            this.validarTitulosEmAberto(cliente.getPessoa(), valorAdicional, opcoesFaturamento, opcoesFinanceiras, v.getLimiteCredito());
            this.validarTituloVencidoEmAberto(cliente.getPessoa(), new Date(), opcoesFinanceiras.getTipoDataAnaliseCredito(), opcoesFaturamento, opcoesFinanceiras);
        }
        return true;
    }

    private Double getSaldoDevedorCliente(Pessoa pessoa, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        try {
            Double valor = this.getSaldoDevedorTitulosCliente(pessoa);
            if (valor == null) {
                valor = 0.0;
            }
            if (opcoesFinanceiras != null && opcoesFinanceiras.getIncluirChequeAnCred() != null && opcoesFinanceiras.getIncluirChequeAnCred() == 1) {
                valor = valor + this.getSaldoDevedorChequesAbertoCliente(pessoa);
            }
            return valor;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private Double getSaldoDevedorTitulosCliente(Pessoa pessoa) throws ExceptionService {
        SaldoFinanceiroPessoa saldo = CoreDAOFactory.getInstance().getDAOSaldoTitulo().getSaldoAbertoPessoa(null, null, pessoa.getIdentificador(), null, null, null, null, null, null, null, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    private Double getSaldoDevedorChequesAbertoCliente(Pessoa pessoa) throws ExceptionService {
        try {
            Double valorChequesAberto = this.getSaldoDevedorChequesDevolvidosCliente(pessoa);
            valorChequesAberto = valorChequesAberto + this.getSaldoDevedorChequesNaoCompCliente(pessoa);
            return valorChequesAberto;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private Double getSaldoDevedorChequesDevolvidosCliente(Pessoa pessoa) throws ExceptionService {
        try {
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("idPessoa", pessoa.getIdentificador());
            Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesDevolvidos");
            valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
            return valorChequesAberto;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private Double getSaldoDevedorChequesNaoCompCliente(Pessoa pessoa) throws ExceptionService {
        try {
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("idPessoa", pessoa.getIdentificador());
            Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesNaoCompensados");
            valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
            return valorChequesAberto;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private void validarTitulosEmAberto(Pessoa pessoa, Double valorAdicional, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras, Double limiteCreditoCliente) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        if (this.getSaldoDevedorCliente(pessoa, opcoesFinanceiras) + valorAdicional > limiteCreditoCliente) {
            if (opcoesFinanceiras.getPermitirVendaComDebito() == 0) {
                throw new ExceptionService("Cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
            if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                throw new ExceptionClienteInabilitadoAviso("Cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
        }
    }

    private void validarTituloVencidoEmAberto(Pessoa pessoa, Date dataAtual, Short tipoDataAnaliseCredito, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        if (opcoesFinanceiras.getPermitirVendaComDebito() != null && opcoesFinanceiras.getPermitirVendaComDebito() != 3) {
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("pessoa", pessoa);
            request.setAttribute("dataAtual", dataAtual);
            try {
                Double saldoDevedor = this.verificarTituloVencidoEmAberto(pessoa, dataAtual, tipoDataAnaliseCredito, opcoesFinanceiras.getDiasToleranciaAnaliseCredito());
                if (saldoDevedor > 0.0) {
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 0) {
                        throw new ExceptionService("Cliente Possui Titulos em Atraso");
                    }
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                        throw new ExceptionClienteInabilitadoAviso("Cliente Possui Titulos em Atraso");
                    }
                }
            }
            catch (ExceptionService ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
                throw new ExceptionService("Erro ao validar titulos em Aberto da Pessoa ", ex);
            }
        }
    }

    private Double verificarTituloVencidoEmAberto(Pessoa pessoa, Date dataAtual, Short tipoDataAnaliseCredito, Integer diasTolerancia) {
        SaldoFinanceiroPessoa saldo = CoreDAOFactory.getInstance().getDAOSaldoTitulo().getSaldoAbertoVencidoPessoa(null, pessoa.getIdentificador(), null, null, null, null, null, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, null, null, diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }
}

