/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.analisecredito;

import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.model.impl.SaldoFinanceiroPessoa;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorlogger.TLogger;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionClienteInabilitadoAviso;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

class UtilAnaliseCreditoGrupoPessoas {
    private TLogger logger = TLogger.get(UtilAnaliseCreditoGrupoPessoas.class);

    UtilAnaliseCreditoGrupoPessoas() {
    }

    public boolean validarGrupoPessoas(GrupoPessoas grupoPessoas, Short verificaLimiteCredito, Double valorAdicional, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras, UnidadeFatCliente uni) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        if (uni != null) {
            this.validarClienteFinanceiro(grupoPessoas, valorAdicional, verificaLimiteCredito, opcoesFaturamento, opcoesFinanceiras, uni.getCliente().getPessoa());
        }
        return true;
    }

    private boolean validarClienteFinanceiro(GrupoPessoas g, Double valorAdicional, Short verificarLimiteCredito, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceiras, Pessoa pessoa) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        if (g.getNaoAvaliarFinanceiro() != null && g.getNaoAvaliarFinanceiro() == 1) {
            return true;
        }
        if (verificarLimiteCredito != null && verificarLimiteCredito == 1) {
            if (g.getDataLiberacaoCredito() != null && g.getDiasVigorLimiteCred() != null && g.getDiasVigorLimiteCred() > 0) {
                Date next = DateUtil.nextDays(g.getDataLiberacaoCredito(), g.getDiasVigorLimiteCred());
                Object msg = " A an\u00e1lise do limite de cr\u00e9dito do grupo de pessoas deste cliente ser\u00e1 liberado \u00e0 partir da data " + DateUtil.dateToStr(g.getDataLiberacaoCredito(), "dd-MM-yyyy");
                if (g.getDataLiberacaoCredito().after(DateUtil.getCurrentDate())) {
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                        throw new ExceptionClienteInabilitadoAviso((String)msg);
                    }
                    throw new ExceptionService((String)msg);
                }
                if (next.before(DateUtil.getCurrentDate())) {
                    msg = "A an\u00e1lise do limite de cr\u00e9dito do grupo de pessoas deste cliente expirou. Refa\u00e7a a an\u00e1lise de Cr\u00e9dito.";
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                        throw new ExceptionClienteInabilitadoAviso((String)msg);
                    }
                    throw new ExceptionService((String)msg);
                }
            }
            if (g.getHabilParaCompra() == null || g.getHabilParaCompra() == 0) {
                String msg = "Grupo de Pessoas deste cliente inabilitado para compras!";
                if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                    throw new ExceptionClienteInabilitadoAviso(msg);
                }
                throw new ExceptionService(msg);
            }
            this.validarTitulosEmAberto(valorAdicional, opcoesFinanceiras, g.getLimiteCredito(), pessoa);
            this.validarTituloVencidoEmAberto(new Date(), verificarLimiteCredito, opcoesFinanceiras, opcoesFinanceiras.getDiasToleranciaAnaliseCredito(), pessoa);
        }
        return true;
    }

    private Double getSaldoDevedorCliente(Pessoa pessoa, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        try {
            Double valor = this.getSaldoDevedorTitulosCliente(pessoa);
            if (valor == null) {
                valor = 0.0;
            }
            if (opcoesFinanceiras != null && opcoesFinanceiras.getIncluirChequeAnCred() != null && opcoesFinanceiras.getIncluirChequeAnCred() == 1) {
                valor = valor + this.getSaldoDevedorChequesAbertoCliente(pessoa);
            }
            return valor;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private Double getSaldoDevedorTitulosCliente(Pessoa pessoa) throws ExceptionService {
        SaldoFinanceiroPessoa saldo = CoreDAOFactory.getInstance().getDAOSaldoTitulo().getSaldoAbertoPessoa(null, null, pessoa.getGrupoPessoas().getIdentificador(), null, null, null, null, null, null, null, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }

    private Double getSaldoDevedorChequesAbertoCliente(Pessoa pessoa) throws ExceptionService {
        try {
            Double valorChequesAberto = this.getSaldoDevedorChequesDevolvidosCliente(pessoa);
            valorChequesAberto = valorChequesAberto + this.getSaldoDevedorChequesNaoCompCliente(pessoa);
            return valorChequesAberto;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private Double getSaldoDevedorChequesDevolvidosCliente(Pessoa pessoa) throws ExceptionService {
        try {
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("idPessoa", pessoa.getIdentificador());
            Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesDevolvidos");
            valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
            return valorChequesAberto;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private Double getSaldoDevedorChequesNaoCompCliente(Pessoa pessoa) throws ExceptionService {
        try {
            CoreRequestContext request = new CoreRequestContext();
            request.setAttribute("idPessoa", pessoa.getIdentificador());
            Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesNaoCompensados");
            valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
            return valorChequesAberto;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao buscar o limite do cliente.");
        }
    }

    private void validarTitulosEmAberto(Double valorAdicional, OpcoesFinanceiras opcoesFinanceiras, Double limiteCreditoCliente, Pessoa pessoa) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        Double saldoDevedor = 0.0;
        if ((saldoDevedor = Double.valueOf(saldoDevedor + this.getSaldoDevedorCliente(pessoa, opcoesFinanceiras))) + valorAdicional > limiteCreditoCliente) {
            if (opcoesFinanceiras.getPermitirVendaComDebito() == 0) {
                throw new ExceptionService("O grupo de pessoas deste cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
            if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                throw new ExceptionClienteInabilitadoAviso("O grupo de pessoas deste cliente possui t\u00edtulos em atraso ou seu limite de cr\u00e9dito foi ultrapassado.");
            }
        }
    }

    private void validarTituloVencidoEmAberto(Date dataAtual, Short tipoDataAnaliseCredito, OpcoesFinanceiras opcoesFinanceiras, Integer diasTolerancia, Pessoa pessoa) throws ExceptionService, ExceptionClienteInabilitadoAviso {
        if (opcoesFinanceiras.getPermitirVendaComDebito() != null && opcoesFinanceiras.getPermitirVendaComDebito() != 3) {
            try {
                Double saldoDevedor = this.verificarTituloVencidoEmAberto(pessoa, dataAtual, tipoDataAnaliseCredito, diasTolerancia);
                if (saldoDevedor > 0.0) {
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 0) {
                        throw new ExceptionService("Grupo de Pessoas deste cliente possui t\u00edtulos em atraso.");
                    }
                    if (opcoesFinanceiras.getPermitirVendaComDebito() == 1 || opcoesFinanceiras.getPermitirVendaComDebito() == 2) {
                        throw new ExceptionClienteInabilitadoAviso("Grupo de Pessoas deste cliente possui t\u00edtulos em atraso.");
                    }
                }
            }
            catch (ExceptionService ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
                throw new ExceptionService("Erro ao validar titulos em Aberto da Pessoa ", ex);
            }
        }
    }

    private Double verificarTituloVencidoEmAberto(Pessoa pessoa, Date dataAtual, Short tipoDataAnaliseCredito, Integer diasTolerancia) {
        SaldoFinanceiroPessoa saldo = CoreDAOFactory.getInstance().getDAOSaldoTitulo().getSaldoAbertoVencidoPessoa(null, pessoa.getGrupoPessoas().getIdentificador(), null, null, null, null, null, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, null, null, diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA);
        if (saldo != null) {
            return saldo.getValorSaldo();
        }
        return 0.0;
    }
}

