/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.analisecustoproducao;

import com.touchcomp.basementor.model.vo.AnaliseCustoCenCusto;
import com.touchcomp.basementor.model.vo.AnaliseCustoHoraColab;
import com.touchcomp.basementor.model.vo.ApuracaoCustoProvisao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilAnaliseCustoProducaoColab {
    UtilAnaliseCustoProducaoColab() {
    }

    Object getAnaliseCustoColab(Date dataIn, Date dataFim, Empresa empresa, List centroCusto) throws ExceptionService {
        List horasApontadas = this.getHorasApontadas(centroCusto, dataIn, dataFim, empresa);
        List horasDisponiveis = this.getHorasDisponiveis(centroCusto, dataIn, dataFim, empresa);
        List colaboradores = this.getColaboradores(centroCusto, dataIn, dataFim, empresa);
        List valoresHoras = this.getValoresHoraColaboradores(centroCusto, dataIn, dataFim, empresa);
        LinkedList<AnaliseCustoHoraColab> to = new LinkedList<AnaliseCustoHoraColab>();
        for (Object o : colaboradores) {
            AnaliseCustoHoraColab al = new AnaliseCustoHoraColab();
            al.setColaborador((Colaborador)o);
            this.setHorasApontado(al, horasApontadas);
            this.setHorasDisponivel(al, horasDisponiveis);
            to.add(al);
        }
        for (AnaliseCustoHoraColab a : to) {
            double custoColab = this.getCustoColaborador(valoresHoras, a.getColaborador());
            if (a.getTempoDisponivel() > 0.0) {
                a.setValorHora(Double.valueOf(custoColab / a.getTempoDisponivel()));
            } else if (a.getTempoApontado() > 0.0) {
                a.setValorHora(Double.valueOf(custoColab / a.getTempoApontado()));
            } else {
                a.setValorHora(Double.valueOf(custoColab));
            }
            a.setTempoOcioso(Double.valueOf(a.getTempoDisponivel() - a.getTempoApontado()));
            if (a.getTempoOcioso() < 0.0) {
                a.setTempoOcioso(Double.valueOf(0.0));
            }
            a.setValorOciosidade(Double.valueOf(a.getTempoOcioso() * a.getValorHora()));
        }
        return to;
    }

    private List getHorasApontadas(List centroCusto, Date dataInicial, Date dataFinal, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(EventoOsProducaoLinhaProd.class);
        c.createAlias("colaboradoresEvtProd", "cl");
        c.createAlias("cl.colaborador", "c");
        c.createAlias("c.centroCusto", "cc");
        c.createAlias("tipoEvento", "t");
        ProjectionList p = Projections.projectionList();
        Disjunction d = Restrictions.disjunction();
        for (Object o : centroCusto) {
            AnaliseCustoCenCusto a = (AnaliseCustoCenCusto)o;
            d.add((Criterion)Restrictions.eq((String)"cc.identificador", (Object)a.getCentroCusto().getIdentificador()));
        }
        c.add((Criterion)d);
        c.add(Restrictions.between((String)"dataFechamento", (Object)dataInicial, (Object)dataFinal));
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.add((Criterion)Restrictions.eq((String)"t.tiposFixos", (Object)0));
        p.add(Projections.alias((Projection)Projections.sum((String)"horaEvento"), (String)"HORA"));
        p.add(Projections.alias((Projection)Projections.property((String)"c.identificador"), (String)"ID_COLABORADOR"));
        p.add((Projection)Projections.groupProperty((String)"c.identificador"));
        c.setProjection((Projection)p);
        c.addOrder(Order.asc((String)"c.identificador"));
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    private List getHorasDisponiveis(List centroCusto, Date dataInicial, Date dataFinal, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(Colaborador.class);
        c.createAlias("horarioTrabalho", "h");
        c.createAlias("h.diaHorarioTrabalho", "d");
        c.createAlias("centroCusto", "cc");
        ProjectionList p = Projections.projectionList();
        Disjunction d = Restrictions.disjunction();
        for (Object o : centroCusto) {
            AnaliseCustoCenCusto a = (AnaliseCustoCenCusto)o;
            d.add((Criterion)Restrictions.eq((String)"cc.identificador", (Object)a.getCentroCusto().getIdentificador()));
        }
        c.add((Criterion)d);
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.add(Restrictions.between((String)"d.dataHorTrab", (Object)dataInicial, (Object)dataFinal));
        p.add(Projections.alias((Projection)Projections.sum((String)"d.totalHorasDia"), (String)"HORA"));
        p.add(Projections.alias((Projection)Projections.property((String)"identificador"), (String)"ID_COLABORADOR"));
        p.add((Projection)Projections.groupProperty((String)"identificador"));
        c.setProjection((Projection)p);
        c.addOrder(Order.asc((String)"identificador"));
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    private List getColaboradores(List centroCusto, Date dataInicial, Date dataFinal, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(Colaborador.class);
        c.createAlias("centroCusto", "cc");
        Disjunction d = Restrictions.disjunction();
        for (Object o : centroCusto) {
            AnaliseCustoCenCusto a = (AnaliseCustoCenCusto)o;
            d.add((Criterion)Restrictions.eq((String)"cc.identificador", (Object)a.getCentroCusto().getIdentificador()));
        }
        c.add((Criterion)d);
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.add(Restrictions.isEmpty((String)"recisoes"));
        c.addOrder(Order.asc((String)"identificador"));
        return c.list();
    }

    private void setHorasApontado(AnaliseCustoHoraColab al, List horas) {
        for (int i = 0; i < horas.size(); ++i) {
            HashMap h = (HashMap)horas.get(i);
            Long id = (Long)h.get("ID_COLABORADOR");
            Double hrs = (Double)h.get("HORA");
            if (id.longValue() != al.getColaborador().getIdentificador().longValue()) continue;
            al.setTempoApontado(hrs);
            horas.remove(i);
            break;
        }
    }

    private void setHorasDisponivel(AnaliseCustoHoraColab al, List horas) {
        for (int i = 0; i < horas.size(); ++i) {
            HashMap h = (HashMap)horas.get(i);
            Long id = (Long)h.get("ID_COLABORADOR");
            Double hrs = (Double)h.get("HORA");
            if (id.longValue() != al.getColaborador().getIdentificador().longValue()) continue;
            al.setTempoDisponivel(hrs);
            horas.remove(i);
            break;
        }
    }

    private List getValoresHoraColaboradores(List centroCusto, Date dataIn, Date dataFim, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(ApuracaoCustoProvisao.class);
        c.createAlias("itensCusto", "itensCusto");
        c.createAlias("itensCusto.colaborador", "colaborador");
        c.createAlias("colaborador.centroCusto", "centroCusto");
        Disjunction d = Restrictions.disjunction();
        for (Object o : centroCusto) {
            AnaliseCustoCenCusto a = (AnaliseCustoCenCusto)o;
            d.add((Criterion)Restrictions.eq((String)"centroCusto.identificador", (Object)a.getCentroCusto().getIdentificador()));
        }
        c.add((Criterion)d);
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.add(Restrictions.between((String)"periodo", (Object)dataIn, (Object)dataFim));
        c.addOrder(Order.asc((String)"identificador"));
        ProjectionList proj = Projections.projectionList();
        proj.add(Projections.alias((Projection)Projections.property((String)"colaborador.identificador"), (String)"idColaborador"));
        proj.add(Projections.alias((Projection)Projections.property((String)"itensCusto.totalCustoColaborador"), (String)"totalCustoColaborador"));
        c.setProjection((Projection)proj);
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    private Double getCustoColaborador(List valoresHoras, Colaborador colaborador) throws ExceptionService {
        for (Object o : valoresHoras) {
            HashMap h = (HashMap)o;
            Long idColab = (Long)h.get("idColaborador");
            if (idColab.longValue() != colaborador.getIdentificador().longValue()) continue;
            Double totalCustoColaborador = (Double)h.get("totalCustoColaborador");
            return totalCustoColaborador;
        }
        return 0.0;
    }
}

