/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.analisecustoproducao;

import com.touchcomp.basementor.model.vo.AnaliseCustoCelProd;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdAtDepr;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdAtMan;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdAtivo;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdRateio;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelRatOpCel;
import com.touchcomp.basementor.model.vo.AnaliseCustoCenCusto;
import com.touchcomp.basementor.model.vo.AnaliseCustoHoraColab;
import com.touchcomp.basementor.model.vo.AnaliseCustoMedConsAtivo;
import com.touchcomp.basementor.model.vo.AnaliseCustoProd;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CelulaProdutivaEquipamento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementortools.tools.map.ToolMap;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilAnaliseCustoProducaoOcupCel {
    UtilAnaliseCustoProducaoOcupCel() {
    }

    public List getAnaliseCustoCelulas(Date dataInicial, Date dataFinal, List valoresMedidaAtivo, Empresa empresa, AnaliseCustoProd analiseCusto, Boolean simulacao, List<AnaliseCustoCelProd> analiseCelProd, Short tipoPesquisaHoras) throws ExceptionDatabase, ExceptionService {
        if (simulacao.booleanValue() && analiseCusto != null) {
            try {
                return this.mesclarDados(this.getSimulacao(analiseCusto), analiseCelProd);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionService(ex);
            }
            catch (InvocationTargetException ex) {
                throw new ExceptionService(ex);
            }
        }
        return this.mesclarDados(this.realizado(dataInicial, dataFinal, valoresMedidaAtivo, empresa, tipoPesquisaHoras), analiseCelProd);
    }

    public List pesquisarHorasOcupacaoCelulas(Date dataIn, Date dataFim, Empresa empresa, Short tipoPesquisaHoras) {
        List dadosLinha = ToolMethods.isEquals((Object)2, (Object)tipoPesquisaHoras) ? this.pesquisarHorasOcupacaoCelulasLPRoteiro(dataIn, dataFim, empresa) : this.pesquisarHorasOcupacaoCelulasLP(dataIn, dataFim, empresa);
        List dadosEnc = ToolMethods.isEquals((Object)2, (Object)tipoPesquisaHoras) ? this.pesquisarHorasOcupacaoCelulasSERoteiro(dataIn, dataFim, empresa) : this.pesquisarHorasOcupacaoCelulasSE(dataIn, dataFim, empresa);
        return ToolMap.concatAndSumMaps((List)dadosLinha, (List)dadosEnc, (String[])new String[]{"ID_CELULA_PRODUTIVA"}, (String[])new String[]{"TOTAL_HORAS"});
    }

    public List pesquisarHorasOcupacaoCelulasLP(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(e.horaEvento) as TOTAL_HORAS,c.identificador as ID_CELULA_PRODUTIVA from EventoOsProducaoLinhaProd e inner join e.tipoEvento t inner join e.faseProdutiva f inner join f.celulaProdutiva c where cast(e.dataFechamento as date) between :dataIn and :dataFim and e.empresa=:empresa and t.tiposFixos=:tipoEvento and (e.tipoApontEvento=:celula or e.tipoApontEvento=:celula1) group by c.identificador");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        q.setInteger("tipoEvento", 0);
        q.setInteger("celula", 0);
        q.setInteger("celula1", 5);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List pesquisarHorasOcupacaoCelulasLPRoteiro(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(e.horaEventoRoteiro) as TOTAL_HORAS,c.identificador as ID_CELULA_PRODUTIVA from EventoOsProducaoLinhaProd e inner join e.tipoEvento t inner join e.faseProdutiva f inner join f.celulaProdutiva c where cast(e.dataFechamento as date) between :dataIn and :dataFim and e.empresa=:empresa and t.tiposFixos=:tipoEvento and (e.tipoApontEvento=:celula or e.tipoApontEvento=:celula1) group by c.identificador");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        q.setInteger("tipoEvento", 0);
        q.setInteger("celula", 0);
        q.setInteger("celula1", 5);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List pesquisarHorasOcupacaoCelulasSE(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(e.horaEvento) as TOTAL_HORAS,c.identificador as ID_CELULA_PRODUTIVA from EventoOsProdSobEnc e inner join e.tipoEvento t inner join e.faseProdutiva f inner join f.celulaProdutiva c inner join e.subdivisaoOSProdSobEnc s inner join s.ordemServicoProdSobEnc o where cast(e.dataFechamento as date) between :dataIn and :dataFim and e.empresa=:empresa and o.comunicadoProducao is not null and t.tiposFixos=:tipoEvento and (e.tipoApontEvento=:celula or e.tipoApontEvento=:celula1) group by c.identificador");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        q.setInteger("tipoEvento", 0);
        q.setInteger("celula", 0);
        q.setInteger("celula1", 5);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List pesquisarHorasOcupacaoCelulasSERoteiro(Date dataIn, Date dataFim, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(sub.horasPrevistas) as TOTAL_HORAS, c.identificador as ID_CELULA_PRODUTIVA from SubdivisaoOSProdSobEnc sub inner join sub.faseProdutiva f inner join f.celulaProdutiva c inner join sub.ordemServicoProdSobEnc os where cast(sub.dataFechamento as date) between :dataIn and :dataFim and os.empresa=:empresa and os.comunicadoProducao is not null group by c.identificador");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("empresa", (Object)empresa);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List data = q.list();
        return data;
    }

    private List<AnaliseCustoCelProdAtivo> getAnaliseCustoEquipamentos(Date dataInicial, Date dataFinal, AnaliseCustoCelProdRateio analise, List valores) throws ExceptionDatabase {
        ArrayList<AnaliseCustoCelProdAtivo> ret = new ArrayList<AnaliseCustoCelProdAtivo>();
        for (CelulaProdutivaEquipamento cl : analise.getCelulaProdutiva().getEquipamentos()) {
            if (cl.getAtivo() == null || cl.getAtivo() != 1) continue;
            AnaliseCustoCelProdAtivo al = new AnaliseCustoCelProdAtivo();
            al.setEquipamento(cl.getEquipamento());
            this.setValoresDepreciacao(dataInicial, dataFinal, al, cl.getEquipamento(), analise);
            this.setValoresManutencao0(dataInicial, dataFinal, al, cl.getEquipamento(), analise);
            this.setValoresConsumo(cl.getEquipamento(), al, analise, valores);
            ret.add(al);
        }
        return ret;
    }

    private List getDepr(Equipamento equipamento, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select e from DepreciacaoBem e inner join e.itemCiapDepreciacaoBaixaBem i  inner join i.depreciacaoCiap d  inner join e.bemTipoDepreciacao bd  inner join bd.bem b  inner join b.equipamento eq  where d.periodo between :dataIn and :dataFim  and eq = :equip");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("equip", (Object)equipamento);
        return q.list();
    }

    private void setValoresConsumo(Equipamento equipamento, AnaliseCustoCelProdAtivo al, AnaliseCustoCelProdRateio analise, List valores) {
        for (Object ob : valores) {
            AnaliseCustoMedConsAtivo medConsAtivo = (AnaliseCustoMedConsAtivo)ob;
            if (equipamento.getMedidaConsumoAtivo() == null || !medConsAtivo.getMedidaConsumoAtivo().equals((Object)equipamento.getMedidaConsumoAtivo())) continue;
            al.setVrConsumoTotal(Double.valueOf(medConsAtivo.getValor() * equipamento.getQuantidadeConsumo() * analise.getHorasApontadas()));
            break;
        }
    }

    private void setValoresDepreciacao(Date dataInicial, Date dataFinal, AnaliseCustoCelProdAtivo analiseCustoCelProdAtivo, Equipamento eq, AnaliseCustoCelProdRateio analiseCustoCelProd) {
        List depr = this.getDepr(eq, dataInicial, dataFinal);
        double d = 0.0;
        ArrayList<AnaliseCustoCelProdAtDepr> temp = new ArrayList<AnaliseCustoCelProdAtDepr>();
        for (Object db : depr) {
            DepreciacaoBem dp = (DepreciacaoBem)db;
            AnaliseCustoCelProdAtDepr ac = new AnaliseCustoCelProdAtDepr();
            ac.setDepreciacaoBem(dp);
            ac.setAnaliseCustoCelProdAtivo(analiseCustoCelProdAtivo);
            d += dp.getValorDepreciacao() + dp.getValorDeprecAcelerada();
            temp.add(ac);
        }
        analiseCustoCelProdAtivo.setValorDepreciacao(Double.valueOf(d));
        analiseCustoCelProdAtivo.setAnaliseCustoCelProdAtDepr(temp);
    }

    Object getAnaliseCustoColab(Date dataIn, Date dataFim, Empresa empresa, List centroCusto) {
        List horasApontadas = this.getHorasApontadas(centroCusto, dataIn, dataFim, empresa);
        List horasDisponiveis = this.getHorasDisponiveis(centroCusto, dataIn, dataFim, empresa);
        List colaboradores = this.getColaboradores(centroCusto, dataIn, dataFim, empresa);
        LinkedList<AnaliseCustoHoraColab> to = new LinkedList<AnaliseCustoHoraColab>();
        for (Object o : colaboradores) {
            AnaliseCustoHoraColab al = new AnaliseCustoHoraColab();
            al.setColaborador((Colaborador)o);
            this.setHorasApontado(al, horasApontadas);
            this.setHorasDisponivel(al, horasDisponiveis);
            to.add(al);
        }
        for (AnaliseCustoHoraColab a : to) {
            a.setTempoOcioso(Double.valueOf(a.getTempoDisponivel() - a.getTempoApontado()));
            if (a.getTempoOcioso() < 0.0) {
                a.setTempoOcioso(Double.valueOf(0.0));
            }
            a.setValorHora(Double.valueOf(a.getColaborador().getValorPorHora() + a.getColaborador().getValorTributosPorHora()));
            a.setValorOciosidade(Double.valueOf(a.getTempoOcioso() * a.getValorHora()));
        }
        return to;
    }

    private List getHorasApontadas(List centroCusto, Date dataInicial, Date dataFinal, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(EventoOsProducaoLinhaProd.class);
        c.createAlias("colaboradoresEvtProd", "cl");
        c.createAlias("cl.colaborador", "c");
        c.createAlias("c.centroCusto", "cc");
        ProjectionList p = Projections.projectionList();
        Disjunction d = Restrictions.disjunction();
        for (Object o : centroCusto) {
            AnaliseCustoCenCusto a = (AnaliseCustoCenCusto)o;
            d.add((Criterion)Restrictions.eq((String)"cc.identificador", (Object)a.getCentroCusto().getIdentificador()));
        }
        c.add((Criterion)d);
        c.add(Restrictions.between((String)"dataFechamento", (Object)dataInicial, (Object)dataFinal));
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        p.add(Projections.alias((Projection)Projections.sum((String)"horaEvento"), (String)"HORA"));
        p.add(Projections.alias((Projection)Projections.sum((String)"c.identificador"), (String)"ID_COLABORADOR"));
        p.add((Projection)Projections.groupProperty((String)"c.identificador"));
        c.setProjection((Projection)p);
        c.addOrder(Order.asc((String)"c.identificador"));
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    private List getHorasDisponiveis(List centroCusto, Date dataInicial, Date dataFinal, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(Colaborador.class);
        c.createAlias("horarioTrabalho", "h");
        c.createAlias("h.diaHorarioTrabalho", "d");
        c.createAlias("centroCusto", "cc");
        ProjectionList p = Projections.projectionList();
        Disjunction d = Restrictions.disjunction();
        for (Object o : centroCusto) {
            AnaliseCustoCenCusto a = (AnaliseCustoCenCusto)o;
            d.add((Criterion)Restrictions.eq((String)"cc.identificador", (Object)a.getCentroCusto().getIdentificador()));
        }
        c.add((Criterion)d);
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.add(Restrictions.between((String)"d.dataHorTrab", (Object)dataInicial, (Object)dataFinal));
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        p.add(Projections.alias((Projection)Projections.sum((String)"d.totalHorasDia"), (String)"HORA"));
        p.add(Projections.alias((Projection)Projections.property((String)"identificador"), (String)"ID_COLABORADOR"));
        p.add((Projection)Projections.groupProperty((String)"identificador"));
        c.setProjection((Projection)p);
        c.addOrder(Order.asc((String)"identificador"));
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return c.list();
    }

    private List getColaboradores(List centroCusto, Date dataInicial, Date dataFinal, Empresa emp) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(Colaborador.class);
        c.createAlias("centroCusto", "cc");
        Disjunction d = Restrictions.disjunction();
        for (Object o : centroCusto) {
            AnaliseCustoCenCusto a = (AnaliseCustoCenCusto)o;
            d.add((Criterion)Restrictions.eq((String)"cc.identificador", (Object)a.getCentroCusto().getIdentificador()));
        }
        c.add((Criterion)d);
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)emp));
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.addOrder(Order.asc((String)"identificador"));
        return c.list();
    }

    private void setHorasApontado(AnaliseCustoHoraColab al, List horas) {
        for (int i = 0; i < horas.size(); ++i) {
            HashMap h = (HashMap)horas.get(i);
            Long id = (Long)h.get("ID_COLABORADOR");
            Double hrs = (Double)h.get("HORA");
            if (id.longValue() != al.getColaborador().getIdentificador().longValue()) continue;
            al.setTempoApontado(hrs);
            horas.remove(i);
            break;
        }
    }

    private void setHorasDisponivel(AnaliseCustoHoraColab al, List horas) {
        for (int i = 0; i < horas.size(); ++i) {
            HashMap h = (HashMap)horas.get(i);
            Long id = (Long)h.get("ID_COLABORADOR");
            Double hrs = (Double)h.get("HORA");
            if (id.longValue() != al.getColaborador().getIdentificador().longValue()) continue;
            al.setTempoDisponivel(hrs);
            horas.remove(i);
            break;
        }
    }

    private void setValoresManutencao0(Date dataInicial, Date dataFinal, AnaliseCustoCelProdAtivo al, Equipamento equipamento, AnaliseCustoCelProdRateio analise) throws ExceptionDatabase {
        List depr = this.getManutencoes(equipamento, dataInicial, dataFinal);
        double d = 0.0;
        ArrayList<AnaliseCustoCelProdAtMan> temp = new ArrayList<AnaliseCustoCelProdAtMan>();
        for (Object db : depr) {
            FechamentoOrdemServico dp = (FechamentoOrdemServico)db;
            AnaliseCustoCelProdAtMan ac = new AnaliseCustoCelProdAtMan();
            ac.setFechamentoOrdemServico(dp);
            ac.setAnaliseCustoCelProdAtivo(al);
            d += dp.getVlrCustoTotal().doubleValue();
            temp.add(ac);
        }
        al.setValorManutencao(Double.valueOf(d));
        al.setAnaliseCustoCelProdAtMan(temp);
    }

    private List getManutencoes(Equipamento equipamento, Date dataInicial, Date dataFinal) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct f.identificador from FechamentoOrdemServico f inner join f.ordemServico o  inner join o.equipamento e  left join f.analiseCustoCelProdAtMan a where f.dataFechamento between :dataIn and :dataFim  and e = :equip and a is null");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("equip", (Object)equipamento);
        List l = q.list();
        LinkedList<FechamentoOrdemServico> ret = new LinkedList<FechamentoOrdemServico>();
        for (Long l1 : l) {
            FechamentoOrdemServico f = (FechamentoOrdemServico)CoreDAOFactory.getInstance().getDAOFechamentoOrdemServicoCore().findByPrimaryKey(l1);
            ret.add(f);
        }
        return ret;
    }

    private List getSimulacao(AnaliseCustoProd analiseCusto) throws IllegalAccessException, InvocationTargetException {
        ArrayList<AnaliseCustoCelProdRateio> to = new ArrayList<AnaliseCustoCelProdRateio>();
        for (AnaliseCustoCelProd o : analiseCusto.getAnaliseCustoCelProd()) {
            AnaliseCustoCelProdRateio a = new AnaliseCustoCelProdRateio();
            BeanUtils.copyProperties((Object)a, (Object)o);
            a.setAnaliseCustoProd(null);
            to.add(a);
        }
        return to;
    }

    private List realizado(Date dataInicial, Date dataFinal, List valoresMedidaAtivo, Empresa empresa, Short tipoHora) throws ExceptionDatabase {
        List celulas = this.pesquisarHorasOcupacaoCelulas(dataInicial, dataFinal, empresa, tipoHora);
        ArrayList<AnaliseCustoCelProdRateio> to = new ArrayList<AnaliseCustoCelProdRateio>();
        for (Object o : celulas) {
            HashMap h = (HashMap)o;
            Long id = (Long)h.get("ID_CELULA_PRODUTIVA");
            Double horas = (Double)h.get("TOTAL_HORAS");
            AnaliseCustoCelProdRateio a = new AnaliseCustoCelProdRateio();
            a.setCelulaProdutiva((CelulaProdutiva)CoreDAOFactory.getInstance().getDAOCelulaProdutiva().findByPrimaryKey(id));
            a.setHorasApontadas(horas);
            a.setAnaliseCustoCelProdAtivo(this.getAnaliseCustoEquipamentos(dataInicial, dataFinal, a, valoresMedidaAtivo));
            to.add(a);
        }
        return to;
    }

    private List mesclarDados(List celulas, List<AnaliseCustoCelProd> analiseCelProd) {
        block0: for (AnaliseCustoCelProd o : analiseCelProd) {
            AnaliseCustoCelProdRateio al = (AnaliseCustoCelProdRateio)o;
            for (Object ob : celulas) {
                AnaliseCustoCelProdRateio al1 = (AnaliseCustoCelProdRateio)ob;
                if (!al.getCelulaProdutiva().equals((Object)al1.getCelulaProdutiva())) continue;
                al1.setPesoRateioInicial(al.getPesoRateioInicial());
                al1.setPesoRateio(al.getPesoRateio());
                al1.setPesoRateioInf(al.getPesoRateioInf());
                al1.setRatearCelula(al.getRatearCelula());
                al1.setInfHorasApontManual(al.getInfHorasApontManual());
                al1.setRateioOpcionalCelula(al.getRateioOpcionalCelula());
                al1.setPlanosConta(al.getPlanosConta());
                al1.setPlanosContaGerencial(al.getPlanosContaGerencial());
                if (al1.getInfHorasApontManual() != null && al1.getInfHorasApontManual() == 1) {
                    al1.setHorasApontadas(al.getHorasApontadas());
                }
                for (AnaliseCustoCelRatOpCel aux : al1.getRateioOpcionalCelula()) {
                    aux.setIdentificador(null);
                    aux.setAnaliseCustoCelProdRateio(al1);
                }
                for (AnaliseCustoCelRatOpCel aux : al1.getPlanosConta()) {
                    aux.setIdentificador(null);
                    aux.setAnaliseCustoCelProdRateio(al1);
                }
                for (AnaliseCustoCelRatOpCel aux : al1.getPlanosContaGerencial()) {
                    aux.setIdentificador(null);
                    aux.setAnaliseCustoCelProdRateio(al1);
                }
                continue block0;
            }
        }
        return celulas;
    }
}

