/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.analisecustoproducao;

import com.touchcomp.basementor.model.vo.AnaliseCustoCelProd;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdAtivo;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdItem;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdRateio;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelRatOp;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelRatOpCel;
import com.touchcomp.basementor.model.vo.AnaliseCustoHoraColab;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoConta;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoContaCel;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoContaGer;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoContaGerCel;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import mentorcore.tools.ContatoFormatUtil;

class UtilAnaliseCustoProducaoRateioSimulacao {
    UtilAnaliseCustoProducaoRateioSimulacao() {
    }

    Object calcularRateioHoras(List valoresContas, List valoresGer, List celulasProdutivas, List colaboradores, List rateioOpcional, Short tipoRatManutencao, List analiseCelulas) {
        List celulasPeso = this.getCalculoRateioCel(celulasProdutivas, analiseCelulas);
        this.limparValoresCelulasNovoCalc(celulasPeso);
        this.setHorasCelula(celulasPeso, celulasProdutivas);
        this.calcularRateioContas(valoresContas, celulasPeso);
        this.calcularRateioContasCel(celulasProdutivas, celulasPeso);
        this.calcularRateioContasGerenciais(valoresGer, celulasPeso);
        this.calcularRateioContasGerenciaisCel(celulasProdutivas, celulasPeso);
        this.calcularRateioHorasColab(colaboradores, celulasPeso);
        this.calcularValorDeprAtivos(celulasProdutivas, celulasPeso);
        this.calcularValorManutencao(celulasProdutivas, celulasPeso, tipoRatManutencao);
        this.calcularRateioOpcional(rateioOpcional, celulasPeso);
        this.calcularRateioOpcionalCelula(celulasProdutivas, analiseCelulas);
        this.calcularValorHora(celulasPeso);
        return celulasPeso;
    }

    private void calcularRateioOpcionalCelula(List celulasProdutivas, List celulasPeso) {
        for (Object ob : celulasProdutivas) {
            AnaliseCustoCelProdRateio ac = (AnaliseCustoCelProdRateio)ob;
            AnaliseCustoCelProd al = this.getAnaliseCustoCelProd(ac.getCelulaProdutiva(), celulasPeso);
            for (AnaliseCustoCelRatOpCel at : ac.getRateioOpcionalCelula()) {
                AnaliseCustoCelProdItem it = this.getAnaliseCustoCelProdItem(al.getAnaliseCustoCelProdItem(), (short)8, al);
                it.setCustoRateioInicial(at.getCustoRateioInicial());
                if (at.getTipoRateio() != null) {
                    it.setDescricao("Valor referente ao rateio opcional " + at.getTipoRateio().getDescricao());
                } else {
                    it.setDescricao("Valor referente ao rateio opcional  n\u00e3o informado");
                }
                it.setTipo(Short.valueOf((short)8));
            }
        }
    }

    private List getCalculoRateioCel(List celulasProdutivas, List analises) {
        ArrayList<AnaliseCustoCelProd> to = new ArrayList<AnaliseCustoCelProd>();
        for (Object ob : celulasProdutivas) {
            AnaliseCustoCelProdRateio r = (AnaliseCustoCelProdRateio)ob;
            AnaliseCustoCelProd c = this.getAnaliseCelulas(r.getCelulaProdutiva(), analises);
            c.setPesoRateioInicial(r.getPesoRateioInicial());
            to.add(c);
        }
        return to;
    }

    private AnaliseCustoCelProd getAnaliseCelulas(CelulaProdutiva celula, List analises) {
        AnaliseCustoCelProd found = null;
        for (Object o : analises) {
            AnaliseCustoCelProd aux = (AnaliseCustoCelProd)o;
            if (!aux.getCelulaProdutiva().equals((Object)celula)) continue;
            found = aux;
            break;
        }
        if (found == null) {
            found = new AnaliseCustoCelProd();
            found.setCelulaProdutiva(celula);
        }
        return found;
    }

    private void calcularRateioContas(List valoresContas, List celulasPeso) {
        for (Object o : valoresContas) {
            AnaliseCustoPlanoConta al = (AnaliseCustoPlanoConta)o;
            AnaliseCustoCelProdItem it = null;
            AnaliseCustoCelProdItem itArred = null;
            double total = 0.0;
            for (Object ob : celulasPeso) {
                AnaliseCustoCelProd c = (AnaliseCustoCelProd)ob;
                if (!(c.getPesoRateioInicial() > 0.0)) continue;
                double aux = al.getValorConsiderarInicial() * c.getPesoRateioInicial() / 100.0;
                aux = ContatoFormatUtil.arrredondarNumero(aux, 2);
                total += aux;
                it = this.getAnaliseCustoCelProdItem(al.getPlanoConta(), c, (short)1);
                it.setCustoRateioInicial(Double.valueOf(aux));
                if (!(it.getCustoRateioInicial() > 0.0)) continue;
                itArred = it;
            }
            if (itArred == null) continue;
            itArred.setCustoRateioInicial(Double.valueOf(itArred.getCustoRateioInicial() + (total - al.getValorConsiderarInicial())));
        }
    }

    private AnaliseCustoCelProdItem getAnaliseCustoCelProdItem(PlanoContaGerencial pc, AnaliseCustoCelProd analise, short tipoRat) {
        AnaliseCustoCelProdItem found = null;
        for (Object o : analise.getAnaliseCustoCelProdItem()) {
            AnaliseCustoCelProdItem a = (AnaliseCustoCelProdItem)o;
            if (!Objects.equals(a.getPlanoContaGer(), pc) || !Objects.equals(a.getTipo(), tipoRat)) continue;
            found = a;
            break;
        }
        if (found == null) {
            found = new AnaliseCustoCelProdItem();
            found.setPlanoContaGer(pc);
            found.setDescricao("Rateio referente ao plano de conta gerencial " + found.getPlanoContaGer().getCodigo() + " - " + found.getPlanoContaGer().getDescricao());
            found.setTipo(Short.valueOf(tipoRat));
            analise.getAnaliseCustoCelProdItem().add(found);
        }
        return found;
    }

    private void calcularRateioContasGerenciais(List valoresContas, List celulasPeso) {
        for (Object o : valoresContas) {
            AnaliseCustoPlanoContaGer al = (AnaliseCustoPlanoContaGer)o;
            AnaliseCustoCelProdItem it = null;
            AnaliseCustoCelProdItem itArred = null;
            double total = 0.0;
            for (Object ob : celulasPeso) {
                AnaliseCustoCelProd c = (AnaliseCustoCelProd)ob;
                if (!(c.getPesoRateioInicial() > 0.0)) continue;
                double aux = al.getValorConsiderarInicial() * c.getPesoRateioInicial() / 100.0;
                aux = ContatoFormatUtil.arrredondarNumero(aux, 2);
                total += aux;
                it = this.getAnaliseCustoCelProdItem(al.getPlanoContaGer(), c, (short)5);
                it.setCustoRateioInicial(Double.valueOf(aux));
                if (!(it.getCustoRateioInicial() > 0.0)) continue;
                itArred = it;
            }
            if (itArred == null) continue;
            itArred.setCustoRateioInicial(Double.valueOf(itArred.getCustoRateioInicial() + (total - al.getValorConsiderarInicial())));
        }
    }

    private AnaliseCustoCelProdItem getAnaliseCustoCelProdItem(PlanoConta pc, AnaliseCustoCelProd analise, short tipoRat) {
        AnaliseCustoCelProdItem found = null;
        for (Object o : analise.getAnaliseCustoCelProdItem()) {
            AnaliseCustoCelProdItem a = (AnaliseCustoCelProdItem)o;
            if (!Objects.equals(a.getPlanoConta(), pc) || !Objects.equals(tipoRat, a.getTipo())) continue;
            found = a;
            break;
        }
        if (found == null) {
            found = new AnaliseCustoCelProdItem();
            found.setPlanoConta(pc);
            found.setDescricao("Rateio referente ao plano de conta " + found.getPlanoConta().getCodigo() + " - " + found.getPlanoConta().getDescricao());
            found.setTipo(Short.valueOf(tipoRat));
            analise.getAnaliseCustoCelProdItem().add(found);
        }
        return found;
    }

    private void calcularRateioOpcional(List rateioOpcional, List celulasPeso) {
        for (Object o : rateioOpcional) {
            AnaliseCustoCelRatOp al = (AnaliseCustoCelRatOp)o;
            AnaliseCustoCelProdItem it = null;
            AnaliseCustoCelProdItem itArred = null;
            double total = 0.0;
            for (Object ob : celulasPeso) {
                AnaliseCustoCelProd c = (AnaliseCustoCelProd)ob;
                if (!(c.getPesoRateioInicial() > 0.0)) continue;
                double aux = al.getCustoRateioInicial() * c.getPesoRateioInicial() / 100.0;
                aux = ContatoFormatUtil.arrredondarNumero(aux, 2);
                total += aux;
                it = this.getAnaliseCustoCelProdItem(al, c);
                it.setCustoRateioInicial(Double.valueOf(aux));
                if (!(it.getCustoRateioInicial() > 0.0)) continue;
                itArred = it;
            }
            if (itArred == null) continue;
            itArred.setCustoRateioInicial(Double.valueOf(itArred.getCustoRateioInicial() + (total - al.getCustoRateioInicial())));
        }
    }

    private AnaliseCustoCelProdItem getAnaliseCustoCelProdItem(AnaliseCustoCelRatOp analiseOP, AnaliseCustoCelProd analise) {
        AnaliseCustoCelProdItem found = null;
        for (Object o : analise.getAnaliseCustoCelProdItem()) {
            AnaliseCustoCelProdItem a = (AnaliseCustoCelProdItem)o;
            if (a.getAnaliseCustoOPTipo() == null || !a.getAnaliseCustoOPTipo().equals((Object)analiseOP.getTipoRateio())) continue;
            found = a;
            break;
        }
        if (found == null) {
            found = new AnaliseCustoCelProdItem();
            found.setAnaliseCustoOPTipo(analiseOP.getTipoRateio());
            found.setDescricao("Rateio referente ao rateio opcional " + analiseOP.getTipoRateio().getDescricao());
            found.setTipo(Short.valueOf((short)6));
            analise.getAnaliseCustoCelProdItem().add(found);
        }
        return found;
    }

    private void calcularRateioHorasColab(List colaboradores, List celulasPeso) {
        double vlrTotal = 0.0;
        for (Object o : colaboradores) {
            AnaliseCustoHoraColab al = (AnaliseCustoHoraColab)o;
            vlrTotal += al.getValorOciosidadeInicial().doubleValue();
        }
        double soma = 0.0;
        AnaliseCustoCelProdItem it = null;
        AnaliseCustoCelProdItem itArred = null;
        for (Object o : celulasPeso) {
            AnaliseCustoCelProd al = (AnaliseCustoCelProd)o;
            if (!(al.getPesoRateioInicial() > 0.0)) continue;
            double aux = vlrTotal * al.getPesoRateioInicial() / 100.0;
            aux = ContatoFormatUtil.arrredondarNumero(aux, 2);
            it = this.getAnaliseCustoCelProdItem(al.getAnaliseCustoCelProdItem(), (short)2, al);
            it.setDescricao("Rateio referente a ociosidade dos colaboradores.");
            it.setCustoRateioInicial(Double.valueOf(aux));
            soma += aux;
            if (!(it.getCustoRateioInicial() > 0.0)) continue;
            itArred = it;
        }
        if (itArred != null) {
            itArred.setCustoRateioInicial(Double.valueOf(itArred.getCustoRateioInicial() + (vlrTotal - soma)));
        }
    }

    private AnaliseCustoCelProdItem getAnaliseCustoCelProdItem(List analiseCelProdItem, short tipo, AnaliseCustoCelProd analise) {
        AnaliseCustoCelProdItem found = null;
        found = new AnaliseCustoCelProdItem();
        found.setTipo(Short.valueOf(tipo));
        analise.getAnaliseCustoCelProdItem().add(found);
        return found;
    }

    private void limparValoresCelulasNovoCalc(List<AnaliseCustoCelProd> celulasProdutivas) {
        for (AnaliseCustoCelProd aux : celulasProdutivas) {
            aux.setAnaliseCustoCelProdItem(new ArrayList());
        }
    }

    private void calcularValorHora(List celulasPeso) {
        for (Object o : celulasPeso) {
            AnaliseCustoCelProd al = (AnaliseCustoCelProd)o;
            double valorTotal = 0.0;
            for (AnaliseCustoCelProdItem it : al.getAnaliseCustoCelProdItem()) {
                valorTotal += it.getCustoRateioInicial().doubleValue();
            }
            al.setCustoRateioInicial(Double.valueOf(valorTotal));
            if (!(al.getHorasInicial() > 0.0) || !(al.getPesoRateioInicial() > 0.0)) continue;
            al.setCustoHoraInicial(Double.valueOf(valorTotal / al.getHorasInicial()));
        }
    }

    private void setHorasCelula(List celulasPeso, List celulasProdutivas) {
        block0: for (Object o : celulasPeso) {
            AnaliseCustoCelProd al = (AnaliseCustoCelProd)o;
            for (Object ob : celulasProdutivas) {
                AnaliseCustoCelProdRateio ah = (AnaliseCustoCelProdRateio)ob;
                if (!al.getCelulaProdutiva().equals((Object)ah.getCelulaProdutiva())) continue;
                al.setHorasInicial(ah.getHorasInicial());
                continue block0;
            }
        }
    }

    private void calcularValorDeprAtivos(List celulasProdutivas, List celulasPeso) {
        for (Object ob : celulasProdutivas) {
            AnaliseCustoCelProdRateio ac = (AnaliseCustoCelProdRateio)ob;
            AnaliseCustoCelProd al = this.getAnaliseCustoCelProd(ac.getCelulaProdutiva(), celulasPeso);
            double vrConsumo = 0.0;
            double vrDepreciacao = 0.0;
            for (AnaliseCustoCelProdAtivo at : ac.getAnaliseCustoCelProdAtivo()) {
                vrDepreciacao += at.getValorDepreciacaoInicial().doubleValue();
                vrConsumo += at.getVrConsumoTotalInicial().doubleValue();
            }
            if (al == null) continue;
            AnaliseCustoCelProdItem it = this.getAnaliseCustoCelProdItem(al.getAnaliseCustoCelProdItem(), (short)3, al);
            it.setCustoRateioInicial(Double.valueOf(vrConsumo));
            it.setDescricao("Valor referente ao consumo dos equipamentos.");
            it.setTipo(Short.valueOf((short)3));
            it = this.getAnaliseCustoCelProdItem(al.getAnaliseCustoCelProdItem(), (short)4, al);
            it.setCustoRateioInicial(Double.valueOf(vrDepreciacao));
            it.setDescricao("Valor referente as deprecia\u00e7\u00f5es.");
            it.setTipo(Short.valueOf((short)4));
        }
    }

    private void calcularValorManutencao(List celulasProdutivas, List celulasPeso, Short tipoManutencao) {
        if (tipoManutencao == 2) {
            this.calcularPorCelula(celulasProdutivas, celulasPeso);
        } else if (tipoManutencao == 3) {
            this.calcularRateioTodasCelulas(celulasProdutivas, celulasPeso);
        }
    }

    private AnaliseCustoCelProd getAnaliseCustoCelProd(CelulaProdutiva celulaProdutiva, List celulasPeso) {
        for (Object o : celulasPeso) {
            AnaliseCustoCelProd a = (AnaliseCustoCelProd)o;
            if (!a.getCelulaProdutiva().equals((Object)celulaProdutiva)) continue;
            return a;
        }
        return null;
    }

    private void calcularPorCelula(List celulasProdutivas, List celulasPeso) {
        for (Object ob : celulasProdutivas) {
            AnaliseCustoCelProdRateio ac = (AnaliseCustoCelProdRateio)ob;
            AnaliseCustoCelProd al = this.getAnaliseCustoCelProd(ac.getCelulaProdutiva(), celulasPeso);
            double vrManutencao = 0.0;
            for (AnaliseCustoCelProdAtivo at : ac.getAnaliseCustoCelProdAtivo()) {
                vrManutencao += at.getValorManutencaoInicial().doubleValue();
            }
            if (al == null) continue;
            AnaliseCustoCelProdItem it = this.getAnaliseCustoCelProdItem(al.getAnaliseCustoCelProdItem(), (short)7, al);
            it.setCustoRateioInicial(Double.valueOf(vrManutencao));
            it.setDescricao("Valor referente a manuten\u00e7\u00e3o dos equipamentos.");
            it.setTipo(Short.valueOf((short)7));
        }
    }

    private void calcularRateioTodasCelulas(List celulasProdutivas, List celulasPeso) {
        double vrManutencao = 0.0;
        double soma = 0.0;
        for (Object ob : celulasProdutivas) {
            AnaliseCustoCelProdRateio ac = (AnaliseCustoCelProdRateio)ob;
            for (AnaliseCustoCelProdAtivo at : ac.getAnaliseCustoCelProdAtivo()) {
                vrManutencao += at.getValorManutencaoInicial().doubleValue();
            }
        }
        AnaliseCustoCelProdItem it = null;
        AnaliseCustoCelProdItem itArred = null;
        for (Object o : celulasPeso) {
            AnaliseCustoCelProd al = (AnaliseCustoCelProd)o;
            if (!(al.getHorasInicial() > 0.0) || !(al.getPesoRateioInicial() > 0.0)) continue;
            double aux = vrManutencao * al.getPesoRateioInicial() / 100.0;
            aux = ContatoFormatUtil.arrredondarNumero(aux, 2);
            it = this.getAnaliseCustoCelProdItem(al.getAnaliseCustoCelProdItem(), (short)7, al);
            it.setCustoRateioInicial(Double.valueOf(vrManutencao));
            it.setDescricao("Rateio referente a manuten\u00e7\u00e3o de equipamentos(rateio).");
            it.setTipo(Short.valueOf((short)7));
            soma += aux;
            if (!(it.getCustoRateio() > 0.0)) continue;
            itArred = it;
        }
        if (itArred != null) {
            itArred.setCustoRateio(Double.valueOf(itArred.getCustoRateioInicial() + (vrManutencao - soma)));
            itArred.setCustoRateioInicial(Double.valueOf(itArred.getCustoRateioInicial() + (vrManutencao - soma)));
        }
    }

    private void calcularRateioContasCel(List<AnaliseCustoCelProdRateio> celulasProdutivas, List<AnaliseCustoCelProd> celulasPeso) {
        Iterator<AnaliseCustoCelProdRateio> iterator = celulasProdutivas.iterator();
        while (iterator.hasNext()) {
            AnaliseCustoCelProdRateio ob;
            AnaliseCustoCelProdRateio ac = ob = iterator.next();
            AnaliseCustoCelProd al = this.getAnaliseCustoCelProd(ac.getCelulaProdutiva(), celulasPeso);
            for (AnaliseCustoPlanoContaCel at : ac.getPlanosConta()) {
                AnaliseCustoCelProdItem it = this.getAnaliseCustoCelProdItem(at.getPlanoConta(), al, (short)9);
                it.setCustoRateio(at.getValorConsiderarInicial());
                it.setDescricao("Valor referente ao plano de conta informado na c\u00e9lula.");
                it.setPlanoConta(at.getPlanoConta());
                it.setTipo(Short.valueOf((short)9));
            }
        }
    }

    private void calcularRateioContasGerenciaisCel(List<AnaliseCustoCelProdRateio> celulasProdutivas, List<AnaliseCustoCelProd> celulasPeso) {
        Iterator<AnaliseCustoCelProdRateio> iterator = celulasProdutivas.iterator();
        while (iterator.hasNext()) {
            AnaliseCustoCelProdRateio ob;
            AnaliseCustoCelProdRateio ac = ob = iterator.next();
            AnaliseCustoCelProd al = this.getAnaliseCustoCelProd(ac.getCelulaProdutiva(), celulasPeso);
            for (AnaliseCustoPlanoContaGerCel at : ac.getPlanosContaGerencial()) {
                AnaliseCustoCelProdItem it = this.getAnaliseCustoCelProdItem(at.getPlanoContaGer(), al, (short)10);
                it.setCustoRateio(at.getValorConsiderarInicial());
                it.setDescricao("Valor referente ao plano de conta gerencial informado na c\u00e9lula.");
                it.setPlanoContaGer(at.getPlanoContaGer());
                it.setTipo(Short.valueOf((short)10));
            }
        }
    }
}

