/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaocomissaorep;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloProvReal;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LancamentoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.apuracaocomissaorep.UtilApuracaoComissaoRep;
import mentorcore.utilities.CoreUtilityFactory;

public class ServiceApuracaoComissaoRep
extends CoreService {
    public static final String CALCULAR_COMISSAO_REPRESENTANTE = "calcularComissaoRepresentante";
    public static final String CALCULAR_COMISSAO_REPRESENTANTE_LOTE = "calcularComissaoRepresentanteLote";
    public static final String VALIDAR_DATA_APU_COMISSAO = "validarDataApuracaoComissao";
    public static final String DELETAR_APURACAO_COMISSAO_REPRESENTANTE = "deletarApuracaoComissaoRepresentante";
    public static final String REGERAR_TITULO_COMISSAO_REPRESENTANTE = "regerarTituloComissaoRepresentante";
    public static final String SALVAR_APURACAO_E_GERAR_LANC_DEBITO = "salvarApuracaoEGerarLancDebito";
    public static final String VALIDA_APURACAO_COMISSAO_REPRESENTANTE_POR_OS = "validaApuracaoComissaoRepresentantePorOS";
    public static final String SALVAR_RECALC_PEDIDOS_COMISSAO = "salvarRecalcPedidosComissao";
    public static final String EXISTS_APURACAO_COMISSAO_BY_TITULO_REPRESENTANTE = "existsApuracaoComissaoByTituloRepresentante";

    public ApuracaoComissaoRepresentante calcularComissaoRepresentante(CoreRequestContext request) throws Exception {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Date dataVenc = (Date)request.getAttribute("dataVenc");
        Representante representante = (Representante)request.getAttribute("representante");
        OpcoesFinanceiras opcoes = (OpcoesFinanceiras)request.getAttribute("opcoes");
        Short filtrarEmpresa = (Short)request.getAttribute("filtrarEmpresa");
        Empresa emp = (Empresa)request.getAttribute("empresa");
        Short gerarTitulo = (Short)request.getAttribute("gerarTitulo");
        Short titulosPercComissaoZero = (Short)request.getAttribute("titulosPercComissaoZero");
        OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)request.getAttribute("opcoesGerenciais");
        Short gerarTituloIrrf = (Short)request.getAttribute("gerarTituloIrrf");
        Short gerarTituloIndenizatorio = (Short)request.getAttribute("gerarTituloIndenizatorio");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        Short considerarMovManualEstornoPeriodo = (Short)request.getAttribute("considerarMovManualEstornoPeriodo");
        Short gerarTituloAntecipado = (Short)request.getAttribute("gerarTituloAntecipado");
        PlanoConta planoContaTituloAntecipado = (PlanoConta)request.getAttribute("planoContaTituloAntecipado");
        Short ignorarFiltrosNFCe = (Short)request.getAttribute("ignorarFiltrosNFCe");
        Date dataEmissao = (Date)request.getAttribute("dataEmissao");
        Date dataCompetencia = (Date)request.getAttribute("dataCompetencia");
        if (ToolMethods.isNull((Object)dataEmissao).booleanValue()) {
            dataEmissao = new Date();
        }
        if (ToolMethods.isNull((Object)dataCompetencia).booleanValue()) {
            dataCompetencia = new Date();
        }
        return new UtilApuracaoComissaoRep().calcularValores(representante, dataInicial, dataFinal, dataVenc, emp, gerarTitulo, opcoes, titulosPercComissaoZero, opcoesGerenciais, filtrarEmpresa, gerarTituloIrrf, opcoesFinanceiras, opcoesContabeis, considerarMovManualEstornoPeriodo, gerarTituloAntecipado, dataEmissao, dataCompetencia, gerarTituloIndenizatorio, ignorarFiltrosNFCe);
    }

    public List<ApuracaoComissaoRepresentante> calcularComissaoRepresentanteLote(CoreRequestContext request) throws Exception {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Date dataVenc = (Date)request.getAttribute("dataVenc");
        OpcoesFinanceiras opcoes = (OpcoesFinanceiras)request.getAttribute("opcoes");
        Short filtrarEmpresa = (Short)request.getAttribute("filtrarEmpresa");
        Empresa emp = (Empresa)request.getAttribute("empresa");
        Short gerarTitulo = (Short)request.getAttribute("gerarTitulo");
        Short titulosPercComissaoZero = (Short)request.getAttribute("titulosPercComissaoZero");
        OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)request.getAttribute("opcoesGerenciais");
        Short gerarTituloIrrf = (Short)request.getAttribute("gerarTituloIrrf");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        Short considerarMovManualEstorno = (Short)request.getAttribute("considerarMovManualEstorno");
        Date dataEmissao = (Date)request.getAttribute("dataEmissao");
        Date dataCompetencia = (Date)request.getAttribute("dataCompetencia");
        Short ignorarFiltrosNFCe = (Short)request.getAttribute("ignorarFiltrosNFCe");
        if (ToolMethods.isNull((Object)dataEmissao).booleanValue()) {
            dataEmissao = new Date();
        }
        if (ToolMethods.isNull((Object)dataCompetencia).booleanValue()) {
            dataCompetencia = new Date();
        }
        return new UtilApuracaoComissaoRep().calcularComissaoRepresentanteLote(dataInicial, dataFinal, dataVenc, emp, gerarTitulo, opcoes, titulosPercComissaoZero, opcoesGerenciais, filtrarEmpresa, gerarTituloIrrf, opcoesFinanceiras, opcoesContabeis, considerarMovManualEstorno, dataEmissao, dataCompetencia, (short)0, ignorarFiltrosNFCe);
    }

    public Boolean validarDataApuracaoComissao(CoreRequestContext request) {
        Date dataInicial = (Date)request.getAttribute("dataIn");
        Date dataFinal = (Date)request.getAttribute("dataFim");
        Representante representante = (Representante)request.getAttribute("rep");
        return CoreDAOFactory.getInstance().getDAOApuracaoComissaoRep().validarDataApuracaoComissao(dataInicial, dataFinal, representante);
    }

    public void deletarApuracaoComissaoRepresentante(CoreRequestContext request) throws ExceptionService {
        ApuracaoComissaoRepresentante vo = (ApuracaoComissaoRepresentante)request.getAttribute("apuracaoComissaoRepresentante");
        ArrayList<LancamentoComissaoRepresentante> lista = new ArrayList<LancamentoComissaoRepresentante>();
        if (vo.getLancamentosComissaoRepresentante() != null) {
            for (LancamentoComissaoRepresentante l : vo.getLancamentosComissaoRepresentante()) {
                l.setApuracaoComissaoRepresentante(null);
                lista.add(l);
            }
        }
        CoreService.saveOrUpdateCollection(lista);
        vo.setLancamentosComissaoRepresentante(new ArrayList());
        CoreService.simpleDelete(CoreDAOFactory.getInstance().getDAOApuracaoComissaoRep(), vo);
    }

    public ApuracaoComissaoRepresentante regerarTituloComissaoRepresentante(CoreRequestContext request) throws Exception {
        ApuracaoComissaoRepresentante vo = (ApuracaoComissaoRepresentante)request.getAttribute("apuracaoComissaoRepresentante");
        Date dataVenc = (Date)request.getAttribute("dataVenc");
        OpcoesFinanceiras opcoes = (OpcoesFinanceiras)request.getAttribute("opcoes");
        Short gerarTitulo = (Short)request.getAttribute("gerarTitulo");
        OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)request.getAttribute("opcoesGerenciais");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        Date dataEmissao = (Date)request.getAttribute("dataEmissao");
        Date dataCompetencia = (Date)request.getAttribute("dataCompetencia");
        if (ToolMethods.isNull((Object)dataEmissao).booleanValue()) {
            dataEmissao = new Date();
        }
        if (ToolMethods.isNull((Object)dataCompetencia).booleanValue()) {
            dataCompetencia = new Date();
        }
        return new UtilApuracaoComissaoRep().regerarTitulo(vo, gerarTitulo, opcoes, dataVenc, opcoesGerenciais, empresa, dataEmissao, dataCompetencia, opcoesContabeis);
    }

    public ApuracaoComissaoRepresentante salvarApuracaoEGerarLancDebito(CoreRequestContext request) throws ExceptionService {
        ApuracaoComissaoRepresentante vo = (ApuracaoComissaoRepresentante)request.getAttribute("apuracaoComissaoRepresentante");
        vo = (ApuracaoComissaoRepresentante)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOApuracaoComissaoRep(), vo);
        return vo;
    }

    public Boolean validaApuracaoComissaoRepresentantePorOS(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        Titulo titulo = (Titulo)request.getAttribute("titulo");
        return new UtilApuracaoComissaoRep().validaApuracaoPorOS(titulo);
    }

    public Boolean salvarRecalcPedidosComissao(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        List pedidos = (List)request.getAttribute("pedidos");
        OpcoesFaturamento opcoesFaturamento = (OpcoesFaturamento)request.getAttribute("opcoesFaturamento");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        for (Pedido pedido : pedidos) {
            CoreUtilityFactory.getUtilityPedido().calcularValoresPedido(pedido, opcoesFaturamento, opcoesFinanceiras);
            this.verificarTitulosRealizadosAtualizarComissao(pedido, opcoesFinanceiras);
            pedido = (Pedido)CoreDAOFactory.getInstance().getDAOPedido().saveOrUpdate(pedido);
            Double perc = pedido.getPercComissao();
            for (Expedicao exp : pedido.getExpedicao()) {
                if (exp.getNotaFiscalPropria() == null) continue;
                for (ItemNotaFiscalPropria item : exp.getNotaFiscalPropria().getItensNotaPropria()) {
                    item.setPercComissao(perc);
                    item.setRepresentante(pedido.getRepresentante());
                    exp.getNotaFiscalPropria().setRepresentante(pedido.getRepresentante());
                }
                List<Titulo> titulos = this.getTitulosAll(exp.getNotaFiscalPropria());
                CoreUtilityFactory.getUtilityTitulos().atualizarRecalcComissaoTitulosNFBasePedido(exp.getNotaFiscalPropria(), titulos, opcoesFinanceiras);
                CoreDAOFactory.getInstance().getDAONotaFiscalPropria().saveOrUpdate(exp.getNotaFiscalPropria());
            }
        }
        return true;
    }

    private List<Titulo> getTitulosAll(NotaFiscalPropria vo) {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
            for (Titulo t : i.getTitulos()) {
                titulos.add(t);
            }
        }
        return titulos;
    }

    private void verificarTitulosRealizadosAtualizarComissao(Pedido pedido, OpcoesFinanceiras opFinanceiras) throws ExceptionService {
        Boolean b = true;
        for (InfPagamentoPedido i : pedido.getInfPagamentoPedido()) {
            for (Titulo t : i.getTitulos()) {
                if (!ToolMethods.isEquals((Object)t.getProvisao(), (Object)EnumConstTituloProvReal.PROVISIONADO.getValue())) continue;
                b = false;
            }
        }
        if (b.booleanValue()) {
            CoreUtilityFactory.getUtilityTitulos().atualizaBCComissaoRepresentante(pedido, opFinanceiras);
        }
    }

    public Boolean existsApuracaoComissaoByTituloRepresentante(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        TituloRepresentante titulo = (TituloRepresentante)request.getAttribute("tituloRepresentante");
        return new UtilApuracaoComissaoRep().existsApuracaoComissaoByTituloRepresentante(titulo);
    }
}

