/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaocomissaorep;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstImpostosRetidos;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteBaixasPag;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteTitulosFat;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteTitulosVenc;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesContabeisImpostosRetidos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.opcoes.CompOpcoesContabeis;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.apuracaocomissao.ServiceApuracaoComissaoImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.query.Query;

class UtilApuracaoComissaoRep {
    private static final TLogger logger = TLogger.get(UtilApuracaoComissaoRep.class);
    private final ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl = (ServiceOpcoesContabeisBaixaTitulosImpl)Context.get(ServiceOpcoesContabeisBaixaTitulosImpl.class);
    private final SCompPlanoConta builderPC = (SCompPlanoConta)Context.get(SCompPlanoConta.class);

    UtilApuracaoComissaoRep() {
    }

    List<ApuracaoComissaoRepresentante> calcularComissaoRepresentanteLote(Date dataInicial, Date dataFinal, Date dataVenc, Empresa emp, Short gerarTitulo, OpcoesFinanceiras opcoes, Short titulosPercComissaoZero, OpcoesGerenciais opcoesGerenciais, Short filtrarEmpresa, Short gerarTituloIrrf, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, Short considerarMovManualEstornoPeriodo, Date dataEmissao, Date dataCompetencia, Short gerarTituloIndenizatorio, Short ignorarFiltrosNFCe) throws Exception {
        HashSet hs = new HashSet();
        List rep = this.getRepresentantesPag(dataInicial, dataFinal, titulosPercComissaoZero);
        hs.addAll(rep);
        rep = this.getRepresentantesVenc(dataInicial, dataFinal, titulosPercComissaoZero);
        hs.addAll(rep);
        rep = this.getRepresentantesFat(dataInicial, dataFinal, titulosPercComissaoZero);
        hs.addAll(rep);
        rep = this.getRepresentantesNFCe(dataInicial, dataFinal, ignorarFiltrosNFCe);
        hs.addAll(rep);
        ArrayList<ApuracaoComissaoRepresentante> apuracoes = new ArrayList<ApuracaoComissaoRepresentante>();
        for (Representante representante : hs) {
            ApuracaoComissaoRepresentante ap = this.calcularValores(representante, dataInicial, dataFinal, dataVenc, emp, gerarTitulo, opcoes, titulosPercComissaoZero, opcoesGerenciais, filtrarEmpresa, gerarTituloIrrf, opcoesFinanceiras, opcoesContabeis, considerarMovManualEstornoPeriodo, EnumConstantsMentorSimNao.NAO.getValue(), dataEmissao, dataCompetencia, gerarTituloIndenizatorio, ignorarFiltrosNFCe);
            ap.getTitulosFaturamento().forEach(titulo -> titulo.setApuracaoComissaoRepresentante(ap));
            ap.getTitulosVencimento().forEach(titulo -> titulo.setApuracaoComissaoRepresentante(ap));
            ap.getBaixasPagamento().forEach(baixa -> baixa.setApuracaoComissaoRepresentante(ap));
            apuracoes.add(ap);
        }
        return apuracoes;
    }

    public ApuracaoComissaoRepresentante calcularValores(Representante rep, Date dataInicial, Date dataFinal, Date dataVenc, Empresa emp, short gerarTitulo, OpcoesFinanceiras op, Short titulosPercComissaoZero, OpcoesGerenciais opcoesGerenciais, Short filtrarEmpresa, Short gerarTituloIrrf, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, Short considerarMovManualEstornoPeriodo, Short gerarTituloAntecipado, Date dataEmissao, Date dataCompetencia, Short gerarTituloIndenizatorio, Short ignorarFiltrosNFCe) throws Exception {
        ApuracaoComissaoRepresentante vo = new ApuracaoComissaoRepresentante();
        if (rep.getComissaoFaturamento() != null && rep.getComissaoFaturamento() > 0.0) {
            List<TituloRepresentante> titulosFat = this.getTitulosFaturamento(dataInicial, dataFinal, rep, titulosPercComissaoZero, filtrarEmpresa, emp);
            List<ApuracaoComissaoRepresentanteTitulosFat> titulosFaturamento = this.calcularComissaoFaturamento(titulosFat, rep.getComissaoFaturamento(), rep);
            vo.setTitulosFaturamento(titulosFaturamento);
        }
        if (rep.getComissaoVencimento() != null && rep.getComissaoVencimento() > 0.0) {
            List<TituloRepresentante> titulosVenc = this.getTitulosVencimento(dataInicial, dataFinal, rep, titulosPercComissaoZero, filtrarEmpresa, emp);
            List<ApuracaoComissaoRepresentanteTitulosVenc> titulosVencimento = this.calcularComissaoVencimento(titulosVenc, rep.getComissaoVencimento(), rep);
            vo.setTitulosVencimento(titulosVencimento);
        }
        if (rep.getComissaoPagamento() != null && rep.getComissaoPagamento() > 0.0) {
            List<BaixaTitulo> titulosPag = this.getTitulosPagamento(dataInicial, dataFinal, rep, titulosPercComissaoZero, filtrarEmpresa, emp);
            List<ApuracaoComissaoRepresentanteBaixasPag> baixasPagamentos = this.calcularComissaoPag(titulosPag, rep.getComissaoPagamento(), rep, op);
            vo.setBaixasPagamento(baixasPagamentos);
        }
        ServiceApuracaoComissaoImpl service = (ServiceApuracaoComissaoImpl)Context.get(ServiceApuracaoComissaoImpl.class);
        Double vlrNFCe = service.getValoresRecVistaNFCe(rep, dataInicial, dataFinal, ignorarFiltrosNFCe);
        Double vlrNFCeNFe = service.getValoresRecVistaNFCeNFe(rep, dataInicial, dataFinal, ignorarFiltrosNFCe);
        vo.setVrComissaoVendaNFCe(vlrNFCe);
        vo.setVrComissaoVendaNFCeNFe(vlrNFCeNFe);
        vo.setComissaoFaturamento(rep.getComissaoFaturamento());
        vo.setComissaoPagamento(rep.getComissaoPagamento());
        vo.setComissaoVencimento(rep.getComissaoVencimento());
        vo.setDataCadastro(new Date());
        vo.setDataInicial(dataInicial);
        vo.setDataFinal(dataFinal);
        vo.setEmpresa(emp);
        vo.setRepresentante(rep);
        vo.setGerarTituloIrrf(gerarTituloIrrf.shortValue());
        vo.setGerarTituloIndenizatorio(gerarTituloIndenizatorio);
        vo.setVrComissaoFaturamento(this.getValorComissaoFaturamento(vo.getTitulosFaturamento()));
        vo.setVrComissaoPagamento(this.getValorComissaoPagamento(vo.getBaixasPagamento()));
        vo.setVrComissaoVencimento(this.getValorComissaoVencimento(vo.getTitulosVencimento()));
        vo.setConsMovManualEstornoPeriodo(considerarMovManualEstornoPeriodo);
        vo.setGerarTituloAntecipado(gerarTituloAntecipado);
        this.getLancamentosComissaoRepresentante(vo);
        if (gerarTitulo == EnumConstantsMentorSimNao.SIM.getValue()) {
            vo.setTituloGerado(this.criarTitulo(vo, op, dataVenc, opcoesGerenciais, emp, dataEmissao, dataCompetencia, vo.getValorLiquido(), opcoesContabeis));
        }
        if (gerarTituloAntecipado.shortValue() == EnumConstantsMentorSimNao.SIM.getValue() && vo.getValorLiquido() > 0.0) {
            vo.setTituloGerado(this.criarTitulo(vo, op, dataVenc, opcoesGerenciais, emp, dataEmissao, dataCompetencia, vo.getValorLiquido(), opcoesContabeis));
            PlanoConta pcAntecipado = vo.getRepresentante().getPessoa().getContasPessoa().getPlanoContaAntecPassivo();
            if (pcAntecipado != null) {
                vo.getTituloGerado().setPlanoConta(pcAntecipado);
            }
            Double valorIndenizado = ToolFormatter.arrredondarNumero((Double)(vo.getValorLiquido() - vo.getValorLiquido() / 12.0), (int)2);
            valorIndenizado = ToolFormatter.arrredondarNumero((Double)(valorIndenizado - valorIndenizado * vo.getRepresentante().getPercIrrf() / 100.0), (int)2);
            vo.getTituloGerado().setValor(valorIndenizado);
            vo.getTituloGerado().setAntecipado(gerarTituloAntecipado);
        }
        if (gerarTituloIndenizatorio.equals(EnumConstantsMentorSimNao.SIM.getValue()) && vo.getValorLiquido() > 0.0) {
            OpcoesContabeisImpostosRetidos indenizado = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.INDENIZATORIO_COMISSAO);
            OpcoesContabeisImpostosRetidos irrf = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.IRRF_COMISSAO);
            if (indenizado == null) {
                throw new Exception("Informe o Plano de contas de indeniza\u00e7\u00e3o em Op\u00e7\u00f5es Contabeis");
            }
            if (irrf == null) {
                throw new Exception("Informe o Plano de contas de IRRF de Comiss\u00e3o em Op\u00e7\u00f5es Contabeis");
            }
            PlanoConta pcIndenizado = indenizado.getPlanoContaImpostoRetido();
            PlanoConta pcIrrf = irrf.getPlanoContaImpostoRetido();
            if (pcIndenizado == null) {
                throw new Exception("Informe o Plano de contas de indeniza\u00e7\u00e3o em Op\u00e7\u00f5es Contabeis");
            }
            if (pcIrrf == null) {
                throw new Exception("Informe o Plano de contas de IRRF de Comiss\u00e3o em Op\u00e7\u00f5es Contabeis");
            }
            Double valorIndenizatorio = ToolFormatter.arrredondarNumero((Double)(vo.getValorLiquido() / 12.0 - vo.getValorLiquido() / 12.0 * vo.getRepresentante().getPercIrrf() / 100.0), (int)2);
            vo.setTituloIndenizatorio(this.criarTitulo(vo, op, dataVenc, opcoesGerenciais, emp, dataEmissao, dataCompetencia, valorIndenizatorio, opcoesContabeis));
            vo.getTituloIndenizatorio().setPlanoConta(pcIndenizado);
            vo.setGerarTituloIrrf((short)1);
            Double valorIrrf = ToolFormatter.arrredondarNumero((Double)(vo.getValorLiquido() / 12.0 * vo.getRepresentante().getPercIrrf() / 100.0), (int)2);
            Titulo tituloIrrf = this.gerarTituloIRRF(vo, valorIrrf, opcoesContabeis, opcoesFinanceiras, dataEmissao);
            if (tituloIrrf != null) {
                tituloIrrf.setDataEmissao(dataEmissao);
                tituloIrrf.setDataCompetencia(dataCompetencia);
                tituloIrrf.setDataVencimento(dataVenc);
                tituloIrrf.setDataVencimentoBase(dataVenc);
                tituloIrrf.setPlanoConta(pcIrrf != null ? pcIrrf : tituloIrrf.getPlanoConta());
                vo.setTituloIrrf(tituloIrrf);
            }
        }
        vo.setTitulosPercComissaoZerados(titulosPercComissaoZero);
        return vo;
    }

    public Titulo gerarTituloIRRF(ApuracaoComissaoRepresentante vo, Double valorIrrf, OpcoesContabeis oc, OpcoesFinanceiras op, Date dataEmissao) throws ExceptionService {
        if (valorIrrf == 0.0) {
            return null;
        }
        OpcoesContabeisImpostosRetidos irrf = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)oc, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.IRRF);
        if (irrf.getDiaVencimentoImpostoRetido() == null || irrf.getDiaVencimentoImpostoRetido() == 0) {
            throw new ExceptionService("Informe o dia de vencimento do IRRF na empresa Contabilidade");
        }
        if (irrf.getPessoaImpostoRetido() == null) {
            throw new ExceptionService("Informe a Pessoa do IRRF na empresa Contabilidade");
        }
        if (irrf.getPlanoContaImpostoRetido() == null) {
            throw new ExceptionService("Informe o Plano de conta Contabil IRRF na empresa Contabilidade");
        }
        if (irrf.getPlanoContaGerencialImpostoRetido() == null) {
            throw new ExceptionService("Informe o Plano Gerencial IRRF na empresa Contabilidade");
        }
        Date dataVencimento = this.getVencimento(vo.getDataFinal(), irrf.getDiaVencimentoImpostoRetido().intValue());
        String observacao = this.getObservacao(vo);
        return this.getTituloIrrf(irrf.getPessoaImpostoRetido(), irrf.getPlanoContaImpostoRetido(), irrf.getPlanoContaGerencialImpostoRetido(), vo, observacao, valorIrrf, dataVencimento, EnumConstantsMentorSimNao.SIM.getValue(), op, (short)0, dataEmissao);
    }

    public Titulo getTituloIrrf(Pessoa p, PlanoConta pc, PlanoContaGerencial pcGer, ApuracaoComissaoRepresentante vo, String obs, Double valor, Date dataTitulo, Short num, OpcoesFinanceiras op, Short tipoTitulo, Date dataEmissao) {
        Titulo t = new Titulo();
        t.setCarteiraCobranca(op.getCarteiraCobrancaTitPag());
        t.setDataCadastro(new Date());
        t.setDataEmissao(dataEmissao);
        t.setDataCompetencia(dataEmissao);
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataVencimento(dataTitulo);
        t.setDataVencimentoBase(dataTitulo);
        t.setNaoCompoeFluxo(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setObservacao(obs);
        t.setPagRec(tipoTitulo);
        t.setPercJurosMes(Double.valueOf(0.0));
        t.setPessoa(p);
        t.setNumParcTituloEstnota(num);
        t.setPlanoConta(pc);
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(valor);
        t.setVrAbatimento(Double.valueOf(0.0));
        t.setVrDescontoCondicional(Double.valueOf(0.0));
        t.setVrIofPago(Double.valueOf(0.0));
        t.setVrJurosDia(Double.valueOf(0.0));
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataTitulo, dataTitulo, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), obs, pcGer, null, Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valor, null);
        ArrayList<LancamentoCtbGerencial> aux = new ArrayList<LancamentoCtbGerencial>();
        aux.add(l);
        t.setLancCtbGerencial(aux);
        return t;
    }

    private Date getVencimento(Date dataVencimento, Integer diaVencimento) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataVencimento);
        g.add(2, 1);
        g.set(5, diaVencimento);
        return g.getTime();
    }

    private String getObservacao(ApuracaoComissaoRepresentante vo) {
        StringBuilder obs = new StringBuilder("Apura\u00e7\u00e3o de comiss\u00e3o  de representantes ");
        String mes = String.valueOf(ToolDate.getMonthFromDate((Date)vo.getDataFinal()));
        mes = ToolFormatter.completaZerosEsquerda((String)mes, (int)2);
        obs.append(mes);
        obs.append("/");
        obs.append(ToolDate.getYearFromDate((Date)vo.getDataFinal()));
        return obs.toString();
    }

    private List<ApuracaoComissaoRepresentanteTitulosFat> calcularComissaoFaturamento(List<TituloRepresentante> titulos, Double percBaseRec, Representante representante) {
        Double vlrComissao = 0.0;
        ArrayList<ApuracaoComissaoRepresentanteTitulosFat> lista = new ArrayList<ApuracaoComissaoRepresentanteTitulosFat>();
        for (TituloRepresentante titRep : titulos) {
            if (!ToolMethods.isEquals((Object)titRep.getRepresentante(), (Object)representante)) continue;
            Double percComissao = titRep.getPercComissao();
            Double vlrBC = titRep.getVrBCComissao();
            if (titRep.getVrBCComissao() == null) {
                vlrBC = 0.0;
            }
            if (titRep.getPercComissao() == null) {
                percComissao = 0.0;
            }
            vlrComissao = ContatoFormatUtil.arrredondarNumero(vlrBC * (percComissao / 100.0) * (percBaseRec / 100.0), 2);
            ApuracaoComissaoRepresentanteTitulosFat ap = new ApuracaoComissaoRepresentanteTitulosFat();
            ap.setTituloRepresentante(titRep);
            ap.setValor(vlrComissao);
            lista.add(ap);
        }
        return lista;
    }

    private List<ApuracaoComissaoRepresentanteTitulosVenc> calcularComissaoVencimento(List<TituloRepresentante> titulos, Double percBaseRec, Representante representante) {
        Double vlrComissao = 0.0;
        ArrayList<ApuracaoComissaoRepresentanteTitulosVenc> lista = new ArrayList<ApuracaoComissaoRepresentanteTitulosVenc>();
        for (TituloRepresentante titRep : titulos) {
            if (!ToolMethods.isEquals((Object)titRep.getRepresentante(), (Object)representante)) continue;
            Double percComissao = titRep.getPercComissao();
            Double vlrBC = titRep.getVrBCComissao();
            if (titRep.getVrBCComissao() == null) {
                vlrBC = 0.0;
            }
            if (titRep.getPercComissao() == null) {
                percComissao = 0.0;
            }
            vlrComissao = ContatoFormatUtil.arrredondarNumero(vlrBC * (percComissao / 100.0) * (percBaseRec / 100.0), 2);
            ApuracaoComissaoRepresentanteTitulosVenc ap = new ApuracaoComissaoRepresentanteTitulosVenc();
            ap.setTituloRepresentante(titRep);
            ap.setValor(vlrComissao);
            lista.add(ap);
        }
        return lista;
    }

    private List<ApuracaoComissaoRepresentanteBaixasPag> calcularComissaoPag(List<BaixaTitulo> baixas, Double percBaseRec, Representante representante, OpcoesFinanceiras opcoesFinanceiras) {
        Double vlrComissao = 0.0;
        ArrayList<ApuracaoComissaoRepresentanteBaixasPag> baixasPagamento = new ArrayList<ApuracaoComissaoRepresentanteBaixasPag>();
        for (BaixaTitulo baixa : baixas) {
            for (TituloRepresentante titRep : baixa.getTitulo().getRepresentantes()) {
                Double percBaixado;
                if (!ToolMethods.isEquals((Object)titRep.getRepresentante(), (Object)representante)) continue;
                Double percUtilizadoComissao = ContatoFormatUtil.arrredondarNumero(titRep.getVrBCComissao() * 100.0 / titRep.getTitulo().getValor(), 6);
                if (!ToolMethods.isEquals((Object)titRep.getVrBCComissao(), (Object)0.0)) {
                    percBaixado = (baixa.getValor() - baixa.getVrDesconto()) / titRep.getVrBCComissao() * (percUtilizadoComissao / 100.0);
                    if (ToolMethods.isEquals((Object)opcoesFinanceiras.getNaoDescBaixaComRepres(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                        percBaixado = baixa.getValor() / titRep.getVrBCComissao() * (percUtilizadoComissao / 100.0);
                    }
                } else {
                    percBaixado = 0.0;
                }
                Double percComissao = titRep.getPercComissao();
                Double vlrBC = titRep.getVrBCComissao();
                if (titRep.getVrBCComissao() == null) {
                    vlrBC = 0.0;
                }
                if (titRep.getPercComissao() == null) {
                    percComissao = 0.0;
                }
                vlrBC = vlrBC * percBaixado;
                vlrComissao = ContatoFormatUtil.arrredondarNumero(vlrBC * (percComissao / 100.0) * (percBaseRec / 100.0), 2);
                if (baixa.getTitulo().getIdentificador() == 301024L) {
                    System.out.println("");
                }
                ApuracaoComissaoRepresentanteBaixasPag b = new ApuracaoComissaoRepresentanteBaixasPag();
                b.setBaixaTitulo(baixa);
                b.setValor(vlrComissao);
                baixasPagamento.add(b);
            }
        }
        return baixasPagamento;
    }

    private List<TituloRepresentante> getTitulosVencimento(Date dataInicial, Date dataFinal, Representante representante, Short titulosPercComissaoZero, Short filtrarEmpresa, Empresa empresa) {
        Object hql = "select distinct      tr from TituloRepresentante tr inner join tr.titulo t where t.dataVencimento between :dataInicial and :dataFinal      and tr.representante =       :representante      and t.provisao       =       :provisao      and (:filtrarEmpresa <> 1 or t.empresa= :empresa)     and t.pagRec         =       :pagRec ";
        if (titulosPercComissaoZero == null || titulosPercComissaoZero.shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            hql = (String)hql + " and tr.percComissao  <>       0";
        }
        hql = (String)hql + " and not exists (select b.identificador from BaixaTitulo b  where (  b.grupoDeBaixaFormas.formaPagamento = :renegociacao or b.grupoDeBaixaFormas.formaPagamento = :faltaPagamento )  and b.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select apv.identificador  from ApuracaoComissaoRepresentanteTitulosVenc apv where apv.tituloRepresentante.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select apb.identificador  from ApuracaoComissaoRepresentanteBaixasPag apb  where apb.apuracaoComissaoRepresentante.representante =  :representante and apb.baixaTitulo.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select apf.identificador  from ApuracaoComissaoRepresentanteTitulosFat apf where apf.tituloRepresentante.titulo.identificador = t.identificador)";
        Query query = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        query.setDate("dataInicial", dataInicial);
        query.setDate("dataFinal", dataFinal);
        query.setEntity("representante", (Object)representante);
        query.setShort("provisao", (short)1);
        query.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        query.setShort("pagRec", (short)1);
        query.setShort("renegociacao", (short)8);
        query.setShort("faltaPagamento", (short)3);
        query.setEntity("empresa", (Object)empresa);
        return query.list();
    }

    private List<TituloRepresentante> getTitulosFaturamento(Date dataInicial, Date dataFinal, Representante representante, Short titulosPercComissaoZero, Short filtrarEmpresa, Empresa empresa) {
        Object hql = "select distinct      tr from TituloRepresentante tr inner join tr.titulo t where t.dataEmissao between :dataInicial and :dataFinal      and tr.representante =       :representante      and t.provisao       =       :provisao      and (:filtrarEmpresa <> 1 or t.empresa= :empresa)     and t.pagRec         =       :pagRec ";
        if (titulosPercComissaoZero == null || titulosPercComissaoZero.shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            hql = (String)hql + " and tr.percComissao  <>       0";
        }
        hql = (String)hql + " and not exists (select b.identificador from BaixaTitulo b  where (   b.grupoDeBaixaFormas.formaPagamento = :renegociacao  or b.grupoDeBaixaFormas.formaPagamento = :faltaPagamento  )  and b.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select apf.identificador  from ApuracaoComissaoRepresentanteTitulosFat apf where apf.tituloRepresentante.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select apb.identificador  from ApuracaoComissaoRepresentanteBaixasPag apb  where apb.apuracaoComissaoRepresentante.representante =  :representante and apb.baixaTitulo.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select apv.identificador  from ApuracaoComissaoRepresentanteTitulosVenc apv where apv.tituloRepresentante.titulo.identificador = t.identificador)";
        Query query = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        query.setDate("dataInicial", dataInicial);
        query.setDate("dataFinal", dataFinal);
        query.setEntity("representante", (Object)representante);
        query.setShort("provisao", (short)1);
        query.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        query.setShort("pagRec", (short)1);
        query.setShort("renegociacao", (short)8);
        query.setShort("faltaPagamento", (short)3);
        query.setEntity("empresa", (Object)empresa);
        return query.list();
    }

    private List<BaixaTitulo> getTitulosPagamento(Date dataInicial, Date dataFinal, Representante representante, Short titulosPercComissaoZero, Short filtrarEmpresa, Empresa empresa) {
        Object hql = "select distinct      b  from BaixaTitulo b  inner join b.titulo t inner join t.representantes tr where  b.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao between :dataInicial and :dataFinal  and tr.representante   = :representante  and\tt.pagRec   = :pagRec   and\tt.provisao = :provisao  and (:filtrarEmpresa <> 1 or t.empresa= :empresa) and (      b.grupoDeBaixaFormas.formaPagamento <> :renegociacao and      b.grupoDeBaixaFormas.formaPagamento <> :faltaPagamento)";
        if (titulosPercComissaoZero == null || titulosPercComissaoZero.shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            hql = (String)hql + " and tr.percComissao  <>       0";
        }
        hql = (String)hql + " and not exists (select apb.identificador  from ApuracaoComissaoRepresentanteBaixasPag apb  where apb.apuracaoComissaoRepresentante.representante =  :representante and apb.baixaTitulo.identificador = b.identificador)";
        hql = (String)hql + " and not exists (select apf.identificador  from ApuracaoComissaoRepresentanteTitulosFat apf where apf.tituloRepresentante.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select apv.identificador  from ApuracaoComissaoRepresentanteTitulosVenc apv where apv.tituloRepresentante.titulo.identificador = t.identificador)";
        Query query = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        query.setDate("dataInicial", dataInicial);
        query.setDate("dataFinal", dataFinal);
        query.setEntity("representante", (Object)representante);
        query.setShort("pagRec", (short)1);
        query.setShort("provisao", (short)1);
        query.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        query.setShort("renegociacao", (short)8);
        query.setShort("faltaPagamento", (short)3);
        query.setEntity("empresa", (Object)empresa);
        query.setEntity("representante", (Object)representante);
        return query.list();
    }

    private Titulo criarTitulo(ApuracaoComissaoRepresentante vo, OpcoesFinanceiras op, Date dataVenc, OpcoesGerenciais opcoesGerenciais, Empresa empresa, Date dataEmissao, Date dataCompetencia, Double valor, OpcoesContabeis opcoesContabeis) throws Exception {
        if (valor > 0.0) {
            Titulo titulo = new Titulo();
            titulo.setDataCadastro(new Date());
            titulo.setDataEmissao(dataEmissao);
            titulo.setDataCompetencia(dataCompetencia);
            titulo.setDataEntradaSaida(titulo.getDataCompetencia());
            titulo.setDataVencimento(dataVenc);
            titulo.setDataVencimentoBase(dataVenc);
            titulo.setEmpresa(vo.getEmpresa());
            titulo.setObservacao("Comiss\u00e3o rep." + DateUtil.dateToStr(vo.getDataInicial()) + " a " + DateUtil.dateToStr(vo.getDataFinal()) + ".");
            titulo.setPagRec(Short.valueOf((short)0));
            titulo.setTipoDoc(op.getTipoDocFinanceiro());
            titulo.setPessoa(vo.getRepresentante().getPessoa());
            titulo.setClassificacaoPessoa(op.getClassificacaoClientes());
            titulo.setPlanoConta(this.builderPC.getPlanoConta(vo.getRepresentante(), opcoesContabeis));
            titulo.setTipoPessoa(EnumConstPessoa.REPRESENTANTE.getEnumId());
            titulo.setValor(valor);
            titulo.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(titulo.getPagRec().shortValue()));
            titulo.setProvisao(Short.valueOf((short)1));
            titulo.setMeioPagamento(op.getMeioPagamento());
            OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.findOpcaoContabilBaixaTituloComFormaPagCache(titulo.getPagRec(), titulo.getTipoDoc(), titulo.getClassificacaoPessoa(), Short.valueOf((short)1), empresa);
            CentroCusto centroCusto = null;
            if (opcoesGerenciais != null && opcoesGerenciais.getCentroCustoApurComisRepr() != null) {
                centroCusto = opcoesGerenciais.getCentroCustoApurComisRepr();
            } else if (opcoesContabeisBaixaTitulos != null && opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao() != null) {
                centroCusto = opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao();
            } else if (opcoesGerenciais != null && opcoesGerenciais.getLancarCentroCusto().equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                throw new Exception("N\u00e3o informado o Centro de Custo para Gera\u00e7\u00e3o de T\u00edtulos de Representante no Recurso Op\u00e7\u00f5es Gerenciais!");
            }
            LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), titulo.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), titulo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), "Lanc. por titulo(pagamento comissao rep.), para " + titulo.getPessoa().getNome(), vo.getRepresentante().getPlanoContaGer(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), centroCusto, valor, null);
            ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
            lanc.add(l);
            titulo.setLancCtbGerencial(lanc);
            return titulo;
        }
        return null;
    }

    private List getRepresentantesPag(Date dataInicial, Date dataFinal, Short titulosPercComissaoZero) {
        Object hql = "select distinct      r  from BaixaTitulo b  inner join b.titulo t inner join t.representantes tr inner join tr.representante r where  b.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao between :dataInicial and :dataFinal  and (      b.grupoDeBaixaFormas.formaPagamento <> :renegociacao and      b.grupoDeBaixaFormas.formaPagamento <> :faltaPagamento) and\tt.pagRec   = :pagRec   and\tt.provisao = :provisao and r.comissaoPagamento > 0 ";
        if (titulosPercComissaoZero == null || titulosPercComissaoZero.shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            hql = (String)hql + " and tr.percComissao  <>       0";
        }
        hql = (String)hql + " and not exists (select ap.identificador  from ApuracaoComissaoRepresentanteBaixasPag ap where ap.baixaTitulo.identificador = b.identificador)";
        Query query = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        query.setDate("dataInicial", dataInicial);
        query.setDate("dataFinal", dataFinal);
        query.setShort("pagRec", (short)1);
        query.setShort("provisao", (short)1);
        query.setShort("renegociacao", (short)8);
        query.setShort("faltaPagamento", (short)3);
        return query.list();
    }

    private List getRepresentantesVenc(Date dataInicial, Date dataFinal, Short titulosPercComissaoZero) {
        Object hql = "select distinct      r  from TituloRepresentante tr  inner join tr.titulo t  inner join tr.representante r where t.dataVencimento between :dataInicial and :dataFinal      and t.provisao       =       :provisao      and t.pagRec         =       :pagRec      and r.comissaoVencimento >0";
        if (titulosPercComissaoZero == null || titulosPercComissaoZero.shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            hql = (String)hql + " and tr.percComissao  <>       0";
        }
        hql = (String)hql + " and not exists (select b.identificador from BaixaTitulo b  where (  b.grupoDeBaixaFormas.formaPagamento = :renegociacao or b.grupoDeBaixaFormas.formaPagamento = :faltaPagamento )  and b.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select ap.identificador  from ApuracaoComissaoRepresentanteTitulosVenc ap where ap.tituloRepresentante.titulo.identificador = t.identificador)";
        Query query = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        query.setDate("dataInicial", dataInicial);
        query.setDate("dataFinal", dataFinal);
        query.setShort("provisao", (short)1);
        query.setShort("pagRec", (short)1);
        query.setShort("renegociacao", (short)8);
        query.setShort("faltaPagamento", (short)3);
        return query.list();
    }

    private List getRepresentantesFat(Date dataInicial, Date dataFinal, Short titulosPercComissaoZero) {
        Object hql = "select distinct      r  from TituloRepresentante tr  inner join tr.titulo t  inner join tr.representante r where t.dataEmissao between :dataInicial and :dataFinal      and t.provisao       =       :provisao      and t.pagRec         =       :pagRec      and tr.vrBCComissao > 0     and r.comissaoFaturamento >0";
        if (titulosPercComissaoZero == null || titulosPercComissaoZero.shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            hql = (String)hql + " and tr.percComissao  <>       0";
        }
        hql = (String)hql + " and not exists (select b.identificador from BaixaTitulo b  where (   b.grupoDeBaixaFormas.formaPagamento = :renegociacao  or b.grupoDeBaixaFormas.formaPagamento = :faltaPagamento  or b.grupoDeBaixaFormas.formaPagamento = :devolucao)  and b.titulo.identificador = t.identificador)";
        hql = (String)hql + " and not exists (select ap.identificador  from ApuracaoComissaoRepresentanteTitulosFat ap where ap.tituloRepresentante.titulo.identificador = t.identificador)";
        Query query = CoreBdUtil.getInstance().getSession().createQuery((String)hql);
        query.setDate("dataInicial", dataInicial);
        query.setDate("dataFinal", dataFinal);
        query.setShort("provisao", (short)1);
        query.setShort("pagRec", (short)1);
        query.setShort("devolucao", (short)2);
        query.setShort("renegociacao", (short)8);
        query.setShort("faltaPagamento", (short)3);
        return query.list();
    }

    private void getLancamentosComissaoRepresentante(ApuracaoComissaoRepresentante vo) {
        List<LancamentoComissaoRepresentante> lancamentos = this.findLancamentosComissaoRepresentantePorData(vo.getDataInicial(), vo.getDataFinal(), vo);
        if (lancamentos != null) {
            vo.setLancamentosComissaoRepresentante(lancamentos);
            this.calcularDebitoCredito(vo);
        }
    }

    private List<LancamentoComissaoRepresentante> findLancamentosComissaoRepresentantePorData(Date dataInicial, Date dataFinal, ApuracaoComissaoRepresentante vo) {
        String filtroDataLancamento = vo.getConsMovManualEstornoPeriodo().shortValue() == EnumConstantsMentorSimNao.SIM.getValue() ? " l.dataLancamento Between :dataIn And :dataFim " : " l.dataLancamento <=  :dataFim ";
        String hql = "from LancamentoComissaoRepresentante l where " + filtroDataLancamento + " and l.representante = :rep and l.apuracaoComissaoRepresentante is null";
        Query query = CoreBdUtil.getInstance().getSession().createQuery(hql);
        if (vo.getConsMovManualEstornoPeriodo().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            query.setDate("dataIn", dataInicial);
        }
        query.setDate("dataFim", dataFinal);
        query.setEntity("rep", (Object)vo.getRepresentante());
        return query.list();
    }

    private void calcularDebitoCredito(ApuracaoComissaoRepresentante h) {
        Double valorDebito = 0.0;
        Double valorCredito = 0.0;
        for (LancamentoComissaoRepresentante l : h.getLancamentosComissaoRepresentante()) {
            if (l.getDebCred().equals((short)1)) {
                valorCredito = valorCredito + l.getValor();
                continue;
            }
            valorDebito = valorDebito + l.getValor();
        }
        h.setValorDebito(valorDebito);
        h.setValorCredito(valorCredito);
        h.setValorLiquido(Double.valueOf(h.getVrComissaoFaturamento() + h.getVrComissaoPagamento() + h.getVrComissaoVencimento() + h.getValorCredito() + h.getVrComissaoVendaNFCe() + h.getVrComissaoVendaNFCeNFe() - h.getValorDebito()));
    }

    public ApuracaoComissaoRepresentante regerarTitulo(ApuracaoComissaoRepresentante vo, Short gerarTitulo, OpcoesFinanceiras op, Date dataVenc, OpcoesGerenciais opcoesGerenciais, Empresa empresa, Date dataEmissao, Date dataCompetencia, OpcoesContabeis opcoesContabeis) throws Exception {
        if (gerarTitulo.shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            vo.setTituloGerado(this.criarTitulo(vo, op, dataVenc, opcoesGerenciais, empresa, dataEmissao, dataCompetencia, vo.getValorLiquido(), opcoesContabeis));
        }
        return vo;
    }

    private Double getValorComissaoPagamento(List<ApuracaoComissaoRepresentanteBaixasPag> baixasPagamento) {
        Double valor = 0.0;
        for (ApuracaoComissaoRepresentanteBaixasPag b : baixasPagamento) {
            valor = valor + b.getValor();
        }
        return valor;
    }

    private Double getValorComissaoFaturamento(List<ApuracaoComissaoRepresentanteTitulosFat> titulosFat) {
        Double valor = 0.0;
        for (ApuracaoComissaoRepresentanteTitulosFat b : titulosFat) {
            valor = valor + b.getValor();
        }
        return valor;
    }

    private Double getValorComissaoVencimento(List<ApuracaoComissaoRepresentanteTitulosVenc> titulosVenc) {
        Double valor = 0.0;
        for (ApuracaoComissaoRepresentanteTitulosVenc b : titulosVenc) {
            valor = valor + b.getValor();
        }
        return valor;
    }

    public Boolean validaApuracaoPorOS(Titulo titulo) {
        String hql = "select distinct      a  from ApuracaoComissaoRepresentante a  inner join a.titulosFaturamento tf inner join tf.tituloRepresentante tr  inner join tr.titulo t where t = :titulo";
        Query query = CoreBdUtil.getInstance().getSession().createQuery(hql);
        query.setEntity("titulo", (Object)titulo);
        List aux = query.list();
        if (aux != null && !aux.isEmpty()) {
            return false;
        }
        return true;
    }

    public Boolean existsApuracaoComissaoByTituloRepresentante(TituloRepresentante tituloRepresentante) {
        String hql = "select distinct tr.identificador  from ApuracaoComissaoRepresentante tr  where exists (select apBaixa.identificador                from ApuracaoComissaoRepresentanteBaixasPag apBaixa                 where apBaixa.baixaTitulo.titulo = :titulo                and apBaixa.apuracaoComissaoRepresentante = tr) or exists (select apFat.identificador               from ApuracaoComissaoRepresentanteTitulosFat apFat               where apFat.tituloRepresentante  = :tituloRepresentante             and apFat.apuracaoComissaoRepresentante = tr) or exists (select apVenc.identificador             from ApuracaoComissaoRepresentanteTitulosVenc apVenc             where apVenc.tituloRepresentante = :tituloRepresentante             and apVenc.apuracaoComissaoRepresentante = tr)";
        Query query = CoreBdUtil.getInstance().getSession().createQuery(hql);
        query.setEntity("titulo", (Object)tituloRepresentante.getTitulo());
        query.setEntity("tituloRepresentante", (Object)tituloRepresentante);
        List aux = query.list();
        return aux != null && !aux.isEmpty();
    }

    private List getRepresentantesNFCe(Date dataInicial, Date dataFinal, Short ignorarFiltrosNFCe) {
        String hql = "";
        hql = ToolMethods.isNull((Object)ignorarFiltrosNFCe) != false || ToolMethods.isEquals((Object)ignorarFiltrosNFCe, (Object)0) ? "select distinct i.representante  from NFCe n inner join n.naturezaOperacao nat inner join n.itens i inner join i.icms ic inner join n.pagamentos p inner join p.tipoPagamentoNFe tp inner join p.meioPagamento m inner join n.totalizadores t where  m.pagamentoAVista=:sim and i.status=:sim and p.status=:sim and (n.status=:autorizada or n.status=:autorizadaForaPrazo) and nat.gerarComissaoRep=:sim and n.dataEmissao between :dataIn and :dataFim" : " select  distinct i.representante from NFCe n inner join n.itens i where  i.status=:sim and (n.status=:autorizada or n.status=:autorizadaForaPrazo) and n.dataEmissao between :dataIn and :dataFim";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setShort("sim", (short)1);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        return q.list();
    }
}

