/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaocsllirpj;

import com.touchcomp.basementor.constants.enums.dctf.EnumConstPeriodicidadeDCTF;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.ApuracaoCSLLReal;
import com.touchcomp.basementor.model.vo.ApuracaoIRPJReal;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.LancamentosRegistrosEcf;
import com.touchcomp.basementor.model.vo.LancamentosRegistrosEcfPlanoConta;
import com.touchcomp.basementor.model.vo.ParametrizacaoEcf;
import com.touchcomp.basementorservice.service.impl.saldoconta.ServiceSaldoContaImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.ContatoFormatUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilApuracaoCSLLIRPJReal {
    ServiceSaldoContaImpl serviceSaldoConta = (ServiceSaldoContaImpl)Context.get(ServiceSaldoContaImpl.class);

    public HashMap calcularApuracaoCSLLIRPJReal(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Short tipoApuracao, Short abaterIpi, Short abaterIcmsST, Short calcularValorRetidoFonte, Short tipoApuracaoReal) throws ExceptionService {
        HashMap h;
        List vendas = this.getVendasNotaPropria(grupoEmpresa, dataInicial, dataFinal);
        ArrayList devolucoes = new ArrayList();
        for (HashMap h2 : vendas) {
            Long idCnae = (Long)h2.get("ID_CNAE");
            Boolean achouDevolucao = false;
            for (HashMap hh : devolucoes) {
                Long idCnae2 = (Long)hh.get("ID_CNAE");
                Double valorDevolucao = (Double)hh.get("VALOR_TOTAL");
                if (!idCnae.equals(idCnae2)) continue;
                h2.put("VALOR_DEVOLUCAO", valorDevolucao);
                achouDevolucao = true;
                break;
            }
            if (!achouDevolucao.booleanValue()) {
                h2.put("VALOR_DEVOLUCAO", 0.0);
            }
            Double valorSaldoCredorAnteriorCSLL = this.getValorSaldoCredorAnteriorCSLL(idCnae, dataInicial);
            h2.put("VALOR_SALDO_ANTERIOR_CSLL", valorSaldoCredorAnteriorCSLL);
            Double valorSaldoCredorAnteriorIRPJ = this.getValorSaldoCredorAnteriorIRPJ(idCnae, dataInicial);
            h2.put("VALOR_SALDO_ANTERIOR_IRPJ", valorSaldoCredorAnteriorIRPJ);
        }
        Double valorRetidoFonteCSLL = 0.0;
        Double valorRetidoFonteIRPJ = 0.0;
        if (calcularValorRetidoFonte.equals((short)1)) {
            h = this.getValorRetidoFonteCSLLIRFF(dataInicial, dataFinal, grupoEmpresa);
            valorRetidoFonteCSLL = (Double)h.get("VR_CONTRIBUICAO_SOCIAL");
            valorRetidoFonteIRPJ = (Double)h.get("VR_IRRF");
        }
        h = this.processarValores(vendas, valorRetidoFonteCSLL, valorRetidoFonteIRPJ, tipoApuracao, abaterIpi, abaterIcmsST);
        return h;
    }

    private List getVendasNotaPropria(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("cfopDevolucaoVenda", (short)0);
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> getDevolucoesNotaPropriaTerceiros(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal) {
        List<HashMap> devolucoesNP = this.getDevolucoesNotaPropria(grupoEmpresa, dataInicial, dataFinal);
        this.getDevolucoesNotaTerceiros(grupoEmpresa, dataInicial, dataFinal, devolucoesNP);
        return devolucoesNP;
    }

    private List<HashMap> getDevolucoesNotaPropria(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(ilf.valorTotal)  - sum(ilf.vrIpiIndustria + ilf.vrIpiComercio) - sum(ilf.vrIcmsSt) as VALOR_TOTAL, i.modeloFiscal.cnae.identificador as ID_CNAE from ItemNotaFiscalPropria i inner join i.notaFiscalPropria n  inner join i.itemNotaLivroFiscal ilf  where n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and n.naturezaOperacao.entradaSaida = :entSaida and ilf.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and i.modeloFiscal.cnae is not null group by i.modeloFiscal.cnae.identificador");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)2);
        q.setShort("cfopDevolucaoVenda", (short)1);
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void getDevolucoesNotaTerceiros(GrupoEmpresa grupoEmpresa, Date dataInicial, Date dataFinal, List<HashMap> devolucoesNP) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(ilf.valorTotal)  - sum(ilf.vrIpiIndustria + ilf.vrIpiComercio) - sum(ilf.vrIcmsSt) as VALOR_TOTAL, i.modeloFiscal.cnae.identificador as ID_CNAE  from ItemNotaTerceiros i inner join i.notaFiscalTerceiros n  inner join i.itemNotaLivroFiscal ilf  where n.dataEntrada between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and i.naturezaOperacao.entradaSaida = :entSaida and ilf.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and i.modeloFiscal.cnae is not null group by i.modeloFiscal.cnae.identificador");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)0);
        q.setShort("cfopDevolucaoVenda", (short)1);
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List devolucoesNT = q.list();
        if (devolucoesNT != null) {
            for (HashMap h : devolucoesNP) {
                Long idCnae = (Long)h.get("ID_CNAE");
                Double valorTotal = (Double)h.get("VALOR_TOTAL");
                Boolean achou = false;
                for (HashMap hh : devolucoesNT) {
                    Long idCnae2 = (Long)hh.get("ID_CNAE");
                    Double valorTotal2 = (Double)hh.get("VALOR_TOTAL");
                    if (!idCnae.equals(idCnae2)) continue;
                    valorTotal2 = valorTotal2 + valorTotal;
                    h.put("VALOR_TOTAL", valorTotal2);
                    achou = true;
                    break;
                }
                if (achou.booleanValue()) continue;
                HashMap<String, Number> hashNew = new HashMap<String, Number>();
                hashNew.put("ID_CNAE", idCnae);
                hashNew.put("VALOR_TOTAL", valorTotal);
                hashNew.put("VALOR_IPI", 0.0);
                hashNew.put("VALOR_ICMS_ST", 0.0);
                devolucoesNP.add(hashNew);
            }
        }
    }

    private HashMap processarValores(List<HashMap> vendas, Double valorRetidoCSLL, Double valorRetidoIR, Short tipoApuracao, Short abaterIpi, Short abaterIcmsST) {
        ArrayList<ApuracaoCSLLReal> apuracoesCSLL = new ArrayList<ApuracaoCSLLReal>();
        ArrayList<ApuracaoIRPJReal> apuracoesIRPJ = new ArrayList<ApuracaoIRPJReal>();
        Boolean valorRetidoContabilizado = false;
        for (HashMap h : vendas) {
            if (valorRetidoContabilizado.booleanValue()) {
                valorRetidoCSLL = 0.0;
                valorRetidoIR = 0.0;
            }
            Long idCnae = (Long)h.get("ID_CNAE");
            Double valorTotal = (Double)h.get("VALOR_TOTAL");
            Double valorIpi = (Double)h.get("VALOR_IPI");
            Double valorIcmsST = (Double)h.get("VALOR_ICMS_ST");
            Double valorDevolucao = (Double)h.get("VALOR_DEVOLUCAO");
            Double valorSaldoCredorAnteriorCSLL = (Double)h.get("VALOR_SALDO_ANTERIOR_CSLL");
            Double valorSaldoCredorAnteriorIRPJ = (Double)h.get("VALOR_SALDO_ANTERIOR_IRPJ");
            CNAE cnae = this.findCnae(idCnae);
            if (abaterIpi.equals((short)1)) {
                valorTotal = valorTotal - valorIpi;
            }
            if (abaterIcmsST.equals((short)1)) {
                valorTotal = valorTotal - valorIcmsST;
            }
            valorRetidoContabilizado = true;
            ApuracaoCSLLReal apCSLL = this.createApuracaoCSLLReal(cnae, valorTotal, valorDevolucao, valorRetidoCSLL, valorSaldoCredorAnteriorCSLL);
            apuracoesCSLL.add(apCSLL);
            ApuracaoIRPJReal apIRPJ = this.createApuracaoIRPJReal(cnae, valorTotal, valorDevolucao, valorRetidoIR, tipoApuracao, valorSaldoCredorAnteriorIRPJ);
            apuracoesIRPJ.add(apIRPJ);
        }
        HashMap<String, ArrayList<Object>> hh = new HashMap<String, ArrayList<Object>>();
        hh.put("apuracoesCSLLReal", apuracoesCSLL);
        hh.put("apuracoesIRPJReal", apuracoesIRPJ);
        return hh;
    }

    private CNAE findCnae(Long idCnae) {
        try {
            return (CNAE)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOCNAE(), idCnae);
        }
        catch (ExceptionService ex) {
            Logger.getLogger(UtilApuracaoCSLLIRPJReal.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private ApuracaoCSLLReal createApuracaoCSLLReal(CNAE cnae, Double valorTotal, Double valorDevolucao, Double valorRetidoCSLL, Double valorSaldoAnterior) {
        ApuracaoCSLLReal vo = new ApuracaoCSLLReal();
        vo.setValorBruto(valorTotal);
        vo.setValorDevolucao(valorDevolucao);
        vo.setValorRetencoes(valorRetidoCSLL);
        vo.setValorTotal(Double.valueOf(vo.getValorBruto() - vo.getValorDevolucao()));
        vo.setPercPresuncaoCSLL(cnae.getPercPresuncaoCSLL());
        vo.setBaseCalculoCSLL(ContatoFormatUtil.arrredondarNumero(vo.getValorTotal() * (vo.getPercPresuncaoCSLL() / 100.0), 2));
        vo.setAliquotaCSLL(cnae.getAliquotaCSLL());
        vo.setValorSaldoCredorAnterior(valorSaldoAnterior);
        vo.setValorCSLL(ContatoFormatUtil.arrredondarNumero(vo.getBaseCalculoCSLL() * (vo.getAliquotaCSLL() / 100.0), 2));
        vo.setValorCSLL(ContatoFormatUtil.arrredondarNumero(vo.getValorCSLL() - vo.getValorRetencoes() + valorSaldoAnterior, 2));
        if (vo.getValorCSLL() < 0.0) {
            vo.setValorSaldoCredor(Double.valueOf(vo.getValorCSLL() * -1.0));
            vo.setValorCSLL(Double.valueOf(0.0));
        }
        vo.setCnae(cnae);
        return vo;
    }

    private ApuracaoIRPJReal createApuracaoIRPJReal(CNAE cnae, Double valorTotal, Double valorDevolucao, Double valorRetidoIR, Short tipoApuracao, Double valorSaldoAnterior) {
        ApuracaoIRPJReal vo = new ApuracaoIRPJReal();
        vo.setValorBruto(valorTotal);
        vo.setValorDevolucao(valorDevolucao);
        vo.setValorRetencoes(valorRetidoIR);
        vo.setValorTotal(Double.valueOf(vo.getValorBruto() - vo.getValorDevolucao()));
        vo.setPercPresuncaoIRPJ(cnae.getPercPresuncaoIRPJ());
        vo.setBaseCalculoIRPJ(ContatoFormatUtil.arrredondarNumero(vo.getValorTotal() * (vo.getPercPresuncaoIRPJ() / 100.0), 2));
        vo.setAliquotaIRPJ(cnae.getAliquotaIRPJ());
        vo.setValorSaldoCredorAnterior(valorSaldoAnterior);
        if (tipoApuracao.equals(EnumConstPeriodicidadeDCTF.TRIMESTRAL.getValue()) && vo.getBaseCalculoIRPJ() > 60000.0) {
            Double diferenca = vo.getBaseCalculoIRPJ() - 60000.0;
            vo.setValorAdicional(ContatoFormatUtil.arrredondarNumero(diferenca * 0.1, 2));
        } else if (tipoApuracao.equals(EnumConstPeriodicidadeDCTF.MENSAL.getValue()) && vo.getBaseCalculoIRPJ() > 20000.0) {
            Double diferenca = vo.getBaseCalculoIRPJ() - 20000.0;
            vo.setValorAdicional(ContatoFormatUtil.arrredondarNumero(diferenca * 0.1, 2));
        }
        vo.setValorIRPJ(ContatoFormatUtil.arrredondarNumero(vo.getBaseCalculoIRPJ() * (vo.getAliquotaIRPJ() / 100.0), 2));
        vo.setValorIRPJRecolher(ContatoFormatUtil.arrredondarNumero(vo.getValorIRPJ() + vo.getValorAdicional() - vo.getValorRetencoes() + valorSaldoAnterior, 2));
        if (vo.getValorIRPJRecolher() <= 0.0) {
            vo.setValorIRPJRecolher(Double.valueOf(0.0));
            vo.setValorSaldoCredor(Double.valueOf(vo.getValorIRPJRecolher() * -1.0));
        }
        vo.setCnae(cnae);
        return vo;
    }

    private HashMap getValorRetidoFonteCSLLIRFF(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum(b.baixaTitulo.vrContribSocial),0) as VR_CONTRIBUICAO_SOCIAL, coalesce(sum(b.baixaTitulo.vrIR),0) as VR_IRRF  from BaixaTituloSpedPis b  where b.baixaTitulo.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao between :dataInicial and :dataFinal and b.baixaTitulo.grupoDeBaixaFormas.grupoDeBaixa.empresa.empresaDados.grupoEmpresa = :grupoEmpresa");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)q.uniqueResult();
    }

    private Double getValorSaldoCredorAnteriorCSLL(Long idCnae, Date dataInicial) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(a.valorSaldoCredor,0) from ApuracaoCSLLReal a  where a.apuracaoCSLLIRPJ.dataInicial =   (select max(aa.apuracaoCSLLIRPJ.dataInicial)    from ApuracaoCSLLReal aa    where aa.apuracaoCSLLIRPJ.dataInicial < :dataInicial    and aa.cnae.identificador = :idCnae)");
        q.setDate("dataInicial", dataInicial);
        q.setLong("idCnae", idCnae.longValue());
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    private Double getValorSaldoCredorAnteriorIRPJ(Long idCnae, Date dataInicial) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(a.valorSaldoCredor,0) from ApuracaoIRPJReal a  where a.apuracaoCSLLIRPJ.dataInicial =   (select max(aa.apuracaoCSLLIRPJ.dataInicial)    from ApuracaoIRPJReal aa    where aa.apuracaoCSLLIRPJ.dataInicial < :dataInicial    and aa.cnae.identificador = :idCnae)");
        q.setDate("dataInicial", dataInicial);
        q.setLong("idCnae", idCnae.longValue());
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    public HashMap calcularApuracaoCSLLIRPJReal(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Short tipoApuracao, Short abaterIpi, Short abaterIcmsST, Short calcularValorRetidoFonte, Short tipoApuracaoReal, EncerramentoContabil encerramentoContabil, List<ParametrizacaoEcf> listParametrizacaoEcf) throws ExceptionService {
        HashMap h;
        List<HashMap> vendas = this.pesquisarValoresSaldoParametrizacaoEcf(encerramentoContabil, listParametrizacaoEcf, dataFinal, grupoEmpresa);
        ArrayList devolucoes = new ArrayList();
        for (HashMap h2 : vendas) {
            Long idCnae = (Long)h2.get("ID_CNAE");
            Boolean achouDevolucao = false;
            for (HashMap hh : devolucoes) {
                Long idCnae2 = (Long)hh.get("ID_CNAE");
                Double valorDevolucao = (Double)hh.get("VALOR_TOTAL");
                if (!idCnae.equals(idCnae2)) continue;
                h2.put("VALOR_DEVOLUCAO", valorDevolucao);
                achouDevolucao = true;
                break;
            }
            if (!achouDevolucao.booleanValue()) {
                h2.put("VALOR_DEVOLUCAO", 0.0);
            }
            Double valorSaldoCredorAnteriorCSLL = this.getValorSaldoCredorAnteriorCSLL(idCnae, dataInicial);
            h2.put("VALOR_SALDO_ANTERIOR_CSLL", valorSaldoCredorAnteriorCSLL);
            Double valorSaldoCredorAnteriorIRPJ = this.getValorSaldoCredorAnteriorIRPJ(idCnae, dataInicial);
            h2.put("VALOR_SALDO_ANTERIOR_IRPJ", valorSaldoCredorAnteriorIRPJ);
        }
        Double valorRetidoFonteCSLL = 0.0;
        Double valorRetidoFonteIRPJ = 0.0;
        if (calcularValorRetidoFonte.equals((short)1)) {
            h = this.getValorRetidoFonteCSLLIRFF(dataInicial, dataFinal, grupoEmpresa);
            valorRetidoFonteCSLL = (Double)h.get("VR_CONTRIBUICAO_SOCIAL");
            valorRetidoFonteIRPJ = (Double)h.get("VR_IRRF");
        }
        h = this.processarValores(vendas, valorRetidoFonteCSLL, valorRetidoFonteIRPJ, tipoApuracao, abaterIpi, abaterIcmsST);
        return h;
    }

    private List<HashMap> pesquisarValoresSaldoParametrizacaoEcf(EncerramentoContabil encerramentoContabil, List<ParametrizacaoEcf> listParametrizacaoEcf, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        ArrayList<HashMap> valores = new ArrayList<HashMap>();
        ParametrizacaoEcf parametrizacaoEcf = null;
        for (ParametrizacaoEcf p : listParametrizacaoEcf) {
            if (!ToolMethods.isEquals((Object)p.getAnoCalendario().intValue(), (Object)ToolDate.getYearFromDate((Date)dataFinal))) continue;
            parametrizacaoEcf = p;
        }
        for (LancamentosRegistrosEcf l : parametrizacaoEcf.getLancamentosRegistroEcfM300()) {
            for (LancamentosRegistrosEcfPlanoConta plano : l.getPlanoConta()) {
                List saldos = this.serviceSaldoConta.findSaldosConta(null, null, plano.getPlanoConta().getCodigo(), plano.getPlanoConta().getCodigo(), dataFinal, dataFinal, grupoEmpresa.getIdentificador(), EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, EnumConstantsOrdenacao.ORDEM_NUMERICA, encerramentoContabil);
                HashMap<String, Double> h = new HashMap<String, Double>();
                h.put("VALOR_TOTAL", ((SaldoContaContabil)saldos.get(0)).getSaldoAtual());
                h.put("VALOR_DEVOLUCAO", ((SaldoContaContabil)saldos.get(0)).getSaldoAnterior());
                valores.add(h);
            }
        }
        return valores;
    }
}

