/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaoicmsdifal;

import com.touchcomp.basementor.model.vo.ApuracaoIcmsDifalOrigemDestino;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class ServiceApuracaoIcmsDifalOrigemDestino
extends CoreService {
    public static final String CALCULAR_VALORES_APURACAO_ICMS_DIFAL = "calcularValoresApuracaoIcmsDifal";
    public static final String FIND_APURACAO_MES_ANTERIOR = "findApuracaoMesAnterior";
    public static final String FIND_OBRIG_IMCS_DIFAL_MES_ANTERIOR_POR_UF = "findObrigIcmsDifalMesAnteriorPorUF";

    public List calcularValoresApuracaoIcmsDifal(CoreRequestContext r) throws ExceptionService {
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Short calcularDifalFatEntrada = (Short)r.getAttribute("calcularDifalFatEntrada");
        List lista = this.getValoresIcmsDifalSaida(dataInicial, dataFinal, empresa);
        if (calcularDifalFatEntrada != null && calcularDifalFatEntrada.equals((short)1)) {
            lista = this.getValoresIcmsDifalFatEntrada(dataInicial, dataFinal, empresa, lista);
        }
        return lista;
    }

    public List getValoresIcmsDifalSaida(Date dataInicial, Date dataFinal, Empresa empresa) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT sum(l.valorIcmsPartilhaRem) as VALOR_REM, sum(l.valorIcmsPartilhaDest) as VALOR_DEST, sum(l.valorFundoPobreza) as VALOR_FUNDO_POBREZA, l.uf.identificador as ID_UF, l.entradaSaidaNaturezaOp as ENTRADA_SAIDA FROM NotaFiscalPropria n  inner join n.livrosFiscais l WHERE l.dataLivro between :dataInicial and :dataFinal   and l.empresa = :empresa   and l.cancelado = :naoCancelado   and l.entradaSaidaNaturezaOp = :saida GROUP BY l.uf.identificador, l.entradaSaidaNaturezaOp HAVING (sum(l.valorIcmsPartilhaRem) + sum(l.valorIcmsPartilhaDest) +sum(l.valorFundoPobreza) ) > 0");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("naoCancelado", (short)0);
        q.setShort("saida", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        Double valorRemetente = 0.0;
        if (lista != null) {
            for (Object o : lista) {
                HashMap h = (HashMap)o;
                valorRemetente = valorRemetente + (Double)h.get("VALOR_REM");
                UnidadeFederativa uf = (UnidadeFederativa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOUnidadeFederativa(), (Long)h.get("ID_UF"));
                h.put("UF", uf);
            }
        }
        return lista;
    }

    public List getValoresIcmsDifalFatEntrada(Date dataInicial, Date dataFinal, Empresa empresa, List<HashMap> listaSaida) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT sum(l.valorIcmsPartilhaRem) as VALOR_REM, sum(l.valorIcmsPartilhaDest) as VALOR_DEST, sum(l.valorFundoPobreza) as VALOR_FUNDO_POBREZA, l.uf.identificador as ID_UF, l.entradaSaidaNaturezaOp as ENTRADA_SAIDA FROM NotaFiscalPropria n  inner join n.livrosFiscais l WHERE l.dataLivro between :dataInicial and :dataFinal   and l.empresa = :empresa   and l.cancelado = :naoCancelado   and l.entradaSaidaNaturezaOp = :faturamentoEntrada GROUP BY l.uf.identificador, l.entradaSaidaNaturezaOp HAVING (sum(l.valorIcmsPartilhaRem) + sum(l.valorIcmsPartilhaDest) +sum(l.valorFundoPobreza) )  > 0");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("naoCancelado", (short)0);
        q.setShort("faturamentoEntrada", (short)2);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        if (lista != null) {
            for (Object o : lista) {
                HashMap h = (HashMap)o;
                UnidadeFederativa uf = (UnidadeFederativa)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOUnidadeFederativa(), (Long)h.get("ID_UF"));
                h.put("UF", uf);
                Double valorDevolucao = (Double)h.get("VALOR_REM") + (Double)h.get("VALOR_DEST");
                h.put("VALOR_DEST", valorDevolucao);
                h.put("VALOR_REM", 0.0);
                listaSaida.add(h);
            }
        }
        return listaSaida;
    }

    public ApuracaoIcmsDifalOrigemDestino findApuracaoMesAnterior(CoreRequestContext r) throws ExceptionService {
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOApuracaoIcmsDifalOrigemDestino().findApuracaoMesAnterior(dataInicial, empresa);
    }

    public Object findObrigIcmsDifalMesAnteriorPorUF(CoreRequestContext r) {
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        UnidadeFederativa uf = (UnidadeFederativa)r.getAttribute("uf");
        return CoreDAOFactory.getInstance().getDAOApuracaoIcmsDifalOrigemDestino().findObrigIcmsDifalMesAnteriorPorUF(uf, empresa);
    }
}

