/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaoipi;

import com.touchcomp.basementor.model.vo.ApuracaoIPI;
import com.touchcomp.basementor.model.vo.Empresa;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceApuracaoIpi
extends CoreService {
    public static final String CALCULAR_VALORES_IPI = "calcularValoresIpi";
    public static final String VALIDAR_APURACAO_DATA = "validarApuracaoData";
    public static final String VALIDAR_APURACAO_MES_ANTERIOR = "validarApuracaoMesAnterior";
    public static final String VALIDAR_APURACAO_MENSAL_MES_ATUAL = "validarApuracaoMensalMesAtual";
    public static final String VALIDAR_APURACAO_DECENDIO_MES_ATUAL = "validarApuracaoDecendioMesAtual";
    public static final String DELETAR_APURACAO_IPI = "deletarApuracaoIpi";
    public static final String VALIDAR_ULTIMO_REGISTRO = "validarUltimoRegistro";
    public static final String FIND_APURACOES_POR_DATA_AND_EMPRESA = "findApuracoesPorDataAndEmpresa";

    public Object calcularValoresIpi(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().calcularValoresIpi(request);
    }

    public Object validarApuracaoData(CoreRequestContext request) throws ExceptionService {
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().validarApuracaoData(request);
    }

    public Object validarApuracaoMesAnterior(CoreRequestContext request) throws ExceptionService {
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().validarApuracaoMesAnterior(request);
    }

    public Object validarApuracaoMensalMesAtual(CoreRequestContext request) throws ExceptionService {
        Date data = (Date)request.getAttribute("data");
        Short tipoApuracao = (Short)request.getAttribute("tipoApuracao");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().validarApuracaoMensalMesAtual(data, tipoApuracao, empresa);
    }

    public Object validarApuracaoDecendioMesAtual(CoreRequestContext request) throws ExceptionService {
        Date data = (Date)request.getAttribute("data");
        Short tipoApuracao = (Short)request.getAttribute("tipoApuracao");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().validarApuracaoDecendioMesAtual(data, tipoApuracao, empresa);
    }

    public Object deletarApuracaoIpi(CoreRequestContext request) throws ExceptionService, ExceptionDatabase, Exception {
        ApuracaoIPI vo = (ApuracaoIPI)request.getAttribute("apuracaoIpi");
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().deletarApuracaoIpi(vo);
    }

    public Object validarUltimoRegistro(CoreRequestContext request) throws ExceptionService, ExceptionDatabase, Exception {
        ApuracaoIPI vo = (ApuracaoIPI)request.getAttribute("apuracao");
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().validarUltimoRegistro(vo);
    }

    public Object findApuracoesPorDataAndEmpresa(CoreRequestContext request) {
        Date data = (Date)request.getAttribute("data");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOApuracaoIPI().findApuracoesPorDataAndEmpresa(data, empresa);
    }
}

