/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaopiscofins;

import com.touchcomp.basementor.model.vo.ApuracaoCofins;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM500;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM505;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM600;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM605;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM610;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM620;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM800;
import com.touchcomp.basementor.model.vo.ApuracaoCofinsM810;
import com.touchcomp.basementor.model.vo.ApuracaoPis;
import com.touchcomp.basementor.model.vo.ApuracaoPisCofins;
import com.touchcomp.basementor.model.vo.ApuracaoPisM100;
import com.touchcomp.basementor.model.vo.ApuracaoPisM105;
import com.touchcomp.basementor.model.vo.ApuracaoPisM200;
import com.touchcomp.basementor.model.vo.ApuracaoPisM205;
import com.touchcomp.basementor.model.vo.ApuracaoPisM210;
import com.touchcomp.basementor.model.vo.ApuracaoPisM220;
import com.touchcomp.basementor.model.vo.ApuracaoPisM350;
import com.touchcomp.basementor.model.vo.ApuracaoPisM400;
import com.touchcomp.basementor.model.vo.ApuracaoPisM410;
import com.touchcomp.basementor.model.vo.BaixaTituloSpedCofins;
import com.touchcomp.basementor.model.vo.BaixaTituloSpedPis;
import com.touchcomp.basementor.model.vo.CodigoAjustePisCofins;
import com.touchcomp.basementor.model.vo.CodigoContribuicaoSocialPisCofins;
import com.touchcomp.basementor.model.vo.CodigoDCTF;
import com.touchcomp.basementor.model.vo.CodigoTipoCreditoPisCofins;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.IndicadorIncidenciaTributaria;
import com.touchcomp.basementor.model.vo.IndicadorNaturezaPessoaJuridica;
import com.touchcomp.basementor.model.vo.NaturezaBCCredito;
import com.touchcomp.basementor.model.vo.NaturezaReceitaPisCofins;
import com.touchcomp.basementor.model.vo.ParamReceitaPisCofins;
import com.touchcomp.basementor.model.vo.ParamReceitaPisCofinsCST;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorservice.service.impl.codigotipocreditopiscofins.ServiceCodigoTipoCreditoPisCofinsImpl;
import com.touchcomp.basementorservice.service.impl.incidenciapiscofins.ServiceIncidenciaPisCofinsImpl;
import com.touchcomp.basementorservice.service.impl.naturezabccredito.ServiceNaturezaBCCreditoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilCalculoApuracaoPisCofins {
    private Date dataInicial;
    private Date dataFinal;
    private GrupoEmpresa grupoEmpresa;
    private IndicadorIncidenciaTributaria indicadorIncTrib;
    private IndicadorNaturezaPessoaJuridica indicadorNaturezaPessoaJuridica;
    private ParamReceitaPisCofins paramReceitaIsenta = null;
    private Short apurarCreditoRegimeNaoCumulativo = null;
    private Short apurarRps = null;
    private PlanoConta planoContaPis;
    private PlanoConta planoContaCofins;
    private HashMap hashNaturezas = new HashMap();
    private HashMap hashIncidencias = new HashMap();
    private HashMap hashCodigoTipoCreditoPisCofins = new HashMap();

    UtilCalculoApuracaoPisCofins() {
    }

    public ApuracaoPisCofins calcularApuracaoPisCofins(CoreRequestContext r) throws ExceptionService {
        this.dataInicial = (Date)r.getAttribute("dataInicial");
        this.dataFinal = (Date)r.getAttribute("dataFinal");
        this.grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        this.indicadorIncTrib = (IndicadorIncidenciaTributaria)r.getAttribute("indicadorIncidenciaTributaria");
        this.indicadorNaturezaPessoaJuridica = (IndicadorNaturezaPessoaJuridica)r.getAttribute("indicadorNaturezaPessoaJuridica");
        this.paramReceitaIsenta = this.findParamReceitaPisCofinsIsentaAliquotaZero();
        this.apurarCreditoRegimeNaoCumulativo = (Short)r.getAttribute("apurarCreditoRegimeNaoCumulativo");
        this.apurarRps = (Short)r.getAttribute("apurarRps");
        this.planoContaPis = (PlanoConta)r.getAttribute("planoContaPis");
        this.planoContaCofins = (PlanoConta)r.getAttribute("planoContaCofins");
        if (this.indicadorIncTrib.getCodigo().equals("2")) {
            return this.getDadosRegimeCumulativo(this.dataInicial, this.dataFinal, this.grupoEmpresa);
        }
        return this.getDadosRegimeNaoCumulativo(this.dataInicial, this.dataFinal, this.grupoEmpresa);
    }

    private ApuracaoPisCofins getDadosRegimeCumulativo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        List dados = this.getVendasRegimeCumulativo(grupoEmpresa, dataInicial, dataFinal);
        HashMap h = this.gerarBlocoMPisCumulativo(dados);
        ApuracaoPis pis = new ApuracaoPis();
        if (h.get("BLOCO_M200") != null && !((List)h.get("BLOCO_M200")).isEmpty()) {
            pis.setApuracaoPisM200((List)h.get("BLOCO_M200"));
        } else {
            pis.getApuracaoPisM200().add(this.getApuracaoPisM200Zerada());
        }
        if (h.get("BLOCO_M400") != null) {
            pis.setApuracaoPisM400((List)h.get("BLOCO_M400"));
        }
        if (h.get("BLOCO_M350") != null) {
            pis.setApuracaoPisM350((List)h.get("BLOCO_M350"));
        }
        h = this.gerarBlocoMCofinsCumulativo(dados);
        ApuracaoCofins cofins = new ApuracaoCofins();
        if (h.get("BLOCO_M600") != null && !((List)h.get("BLOCO_M600")).isEmpty()) {
            cofins.setApuracaoCofinsM600((List)h.get("BLOCO_M600"));
        } else {
            cofins.getApuracaoCofinsM600().add(this.getApuracaoCofinsM600Zerada());
        }
        if (h.get("BLOCO_M800") != null) {
            cofins.setApuracaoCofinsM800((List)h.get("BLOCO_M800"));
        }
        ApuracaoPisCofins pisCofins = new ApuracaoPisCofins();
        pisCofins.setApuracaoPis(pis);
        pisCofins.setApuracaoCofins(cofins);
        return pisCofins;
    }

    private List getVendasRegimeCumulativo(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        List dados = this.getVendasRegimeCumulativoLivrosFiscais(grupoEmpresa, dataIn, dataFim);
        this.getVendasRegimeCumulativoF100(grupoEmpresa, dataIn, dataFim, dados);
        if (ToolMethods.isEquals((Object)this.apurarRps, (Object)1)) {
            this.getVendasRPSRegimeCumulativo(grupoEmpresa, dataIn, dataFim, dados);
        }
        return dados;
    }

    private HashMap gerarBlocoMPisCumulativo(List<HashMap> dados) throws ExceptionService {
        ArrayList<ApuracaoPisM400> blocoM400 = new ArrayList<ApuracaoPisM400>();
        ArrayList<ApuracaoPisM210> blocoM210 = new ArrayList<ApuracaoPisM210>();
        ArrayList<ApuracaoPisM200> blocoM200 = new ArrayList<ApuracaoPisM200>();
        HashMap<String, Object> hh = new HashMap<String, Object>();
        for (HashMap h : dados) {
            String codIncPis = (String)h.get("COD_INC_PIS");
            Double valorReceita = (Double)h.get("VALOR_REC_AUFERIDA");
            Double valorPis = (Double)h.get("VALOR_PIS");
            Double valorBCPis = (Double)h.get("VALOR_BC_PIS");
            Double aliqPis = (Double)h.get("ALIQ_PIS");
            if (this.getIncidenciaIsentaAliquotaZeroSuspensao(codIncPis)) {
                ApuracaoPisM400 ap = this.gerarBlocoM400(codIncPis, valorReceita);
                blocoM400.add(ap);
                if (this.paramReceitaIsenta == null || !this.existsParamReceitaIsentaAliquotaZeroSuspensaoFromCodigo(codIncPis)) continue;
                List<HashMap> dadosM410 = this.findDetalhamentoReceitasIsentasAliquotaZeroSuspensao(codIncPis);
                this.gerarApuracaoPisM410(ap, dadosM410, codIncPis);
                continue;
            }
            if (!(aliqPis > 0.0)) continue;
            this.gerarBlocoM210Cumulativo(codIncPis, valorReceita, valorPis, valorBCPis, aliqPis, this.dataInicial, this.dataFinal, this.grupoEmpresa, blocoM210);
        }
        Double valorContribCumulativa = this.getValorContribuicaoCumulativaM210(blocoM210);
        if (valorContribCumulativa > 0.0) {
            ApuracaoPisM200 a = new ApuracaoPisM200();
            a.setValorContribCumulativaPeriodo(valorContribCumulativa);
            a.setValorRetidoFonteCumulativo(this.getValorRetidoFontePis(this.dataInicial, this.dataFinal, this.grupoEmpresa));
            a.setValorContribCumulativaRecolher(Double.valueOf(a.getValorContribCumulativaPeriodo() - a.getValorRetidoFonteCumulativo()));
            a.setValorTotalRecolher(Double.valueOf(a.getValorContribCumulativaPeriodo() - a.getValorRetidoFonteCumulativo()));
            a.setApuracaoPisM210(blocoM210);
            blocoM200.add(a);
            for (ApuracaoPisM210 m : blocoM210) {
                m.setApuracaoPisM200(a);
            }
            ApuracaoPisM205 aa = new ApuracaoPisM205();
            aa.setTipo(Short.valueOf((short)1));
            aa.setValorDebito(a.getValorTotalRecolher());
            aa.setCodigoDCTF(this.getCodigoDCTFPeriodoAnteriorPis());
            aa.setApuracaoPisM200(a);
            a.getApuracaoPisM205().add(aa);
            hh.put("BLOCO_M200", blocoM200);
        }
        hh.put("BLOCO_M400", blocoM400);
        hh.put("BLOCO_M350", this.gerarBlocoM350());
        return hh;
    }

    private boolean getIncidenciaIsentaAliquotaZeroSuspensao(String codIncPis) {
        return codIncPis.equals("04") || codIncPis.equals("05") || codIncPis.equals("06") || codIncPis.equals("07") || codIncPis.equals("08") || codIncPis.equals("09");
    }

    private ApuracaoPisM400 gerarBlocoM400(String codIncPis, Double valorReceita) throws ExceptionService {
        ApuracaoPisM400 a = new ApuracaoPisM400();
        a.setIncidenciaPis(this.getIncidenciaPisCofinsPorCodigo(codIncPis));
        a.setValorTotalReceitaBruta(valorReceita);
        a.setPlanoConta(this.planoContaPis);
        ApuracaoPisM410 aa = new ApuracaoPisM410();
        aa.setApuracaoPisM400(a);
        aa.setValorReceitaBruta(valorReceita);
        aa.setPlanoConta(this.planoContaPis);
        a.getApuracaoPisM410().add(aa);
        return a;
    }

    private IncidenciaPisCofins getIncidenciaPisCofinsPorCodigo(String codIncPis) throws ExceptionService {
        BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOIncidenciaPisCofins().getVOClass());
        b.and().equal("codigo", codIncPis);
        IncidenciaPisCofins inc = (IncidenciaPisCofins)CoreService.executeSearchUniqueResult(b);
        return inc;
    }

    private void gerarBlocoM210Cumulativo(String codIncPis, Double valorReceita, Double valorPis, Double valorBCPis, Double aliquotaPis, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, List<ApuracaoPisM210> blocoM210) throws ExceptionService {
        Boolean achou = false;
        for (ApuracaoPisM210 a : blocoM210) {
            if (!a.getAliquotaPis().equals(aliquotaPis)) continue;
            achou = true;
            a.setValorReceitaBruta(Double.valueOf(a.getValorReceitaBruta() + valorReceita));
            a.setValorBCContribuicao(Double.valueOf(a.getValorBCContribuicao() + valorBCPis));
            a.setValorContribuicaoApurado(Double.valueOf(a.getValorContribuicaoApurado() + valorPis));
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
        }
        if (!achou.booleanValue()) {
            ApuracaoPisM210 a = new ApuracaoPisM210();
            a.setAliquotaPis(aliquotaPis);
            a.setValorReceitaBruta(valorReceita);
            a.setValorBCContribuicao(valorBCPis);
            a.setValorContribuicaoApurado(valorPis);
            a.setValorContribuicaoDiferir(Double.valueOf(0.0));
            a.setValorContribuicaoDiferirAnterior(Double.valueOf(0.0));
            a.setValorAjustesAcrescimo(Double.valueOf(0.0));
            a.setCodigoContribuicaoSocialPisCofins(this.getCodigoContribuicaoSocialCumulativoBasico());
            ApuracaoPisM220 ajusteDebito = this.gerarBlocoM220Cumulativo(aliquotaPis, dataInicial, dataFinal, grupoEmpresa);
            if (ajusteDebito != null) {
                a.setValorAjustesReducao(ajusteDebito.getValorAjuste());
                ajusteDebito.setApuracaoPisM210(a);
                a.getApuracaoPisM220().add(ajusteDebito);
            }
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
            blocoM210.add(a);
        }
    }

    private ApuracaoPisM220 gerarBlocoM220Cumulativo(Double aliquotaPis, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorPis) as VALOR_PIS  from LivroFiscal lv where lv.dataLivro between :dataIn and :dataFim and lv.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and (lv.entradaSaidaNaturezaOp = :entSaida1 or lv.entradaSaidaNaturezaOp = :entSaida2) and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda and lv.aliquotaPis = :aliquotaPis");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida1", (short)2);
        q.setShort("entSaida2", (short)0);
        q.setShort("cancelado", (short)0);
        q.setShort("cfopDevolucaoVenda", (short)1);
        q.setDouble("aliquotaPis", aliquotaPis.doubleValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        if (h != null && h.get("VALOR_PIS") != null && (Double)h.get("VALOR_PIS") > 0.0) {
            ApuracaoPisM220 a = new ApuracaoPisM220();
            a.setTipoAjuste(new Short("0"));
            a.setValorAjuste((Double)h.get("VALOR_PIS"));
            a.setCodigoAjustePisCofins(this.getCodigoAjustePisCofinsEstorno());
            return a;
        }
        return null;
    }

    private Double getValorContribuicaoCumulativaM210(List<ApuracaoPisM210> blocoM210) {
        Double valor = 0.0;
        for (ApuracaoPisM210 a : blocoM210) {
            valor = valor + a.getValorTotalContribuicao();
        }
        return valor;
    }

    private HashMap gerarBlocoMCofinsCumulativo(List<HashMap> dados) throws ExceptionService {
        ArrayList<ApuracaoCofinsM800> blocoM800 = new ArrayList<ApuracaoCofinsM800>();
        ArrayList<ApuracaoCofinsM610> blocoM610 = new ArrayList<ApuracaoCofinsM610>();
        ArrayList<ApuracaoCofinsM600> blocoM600 = new ArrayList<ApuracaoCofinsM600>();
        HashMap<String, ArrayList<Object>> hh = new HashMap<String, ArrayList<Object>>();
        for (HashMap h : dados) {
            String codIncCofins = (String)h.get("COD_INC_COFINS");
            Double valorReceita = (Double)h.get("VALOR_REC_AUFERIDA");
            Double valorCofins = (Double)h.get("VALOR_COFINS");
            Double valorBCCofins = (Double)h.get("VALOR_BC_COFINS");
            Double aliqCofins = (Double)h.get("ALIQ_COFINS");
            if (this.getIncidenciaIsentaAliquotaZeroSuspensao(codIncCofins)) {
                ApuracaoCofinsM800 ap = this.gerarBlocoM800(codIncCofins, valorReceita);
                blocoM800.add(ap);
                if (this.paramReceitaIsenta == null || !this.existsParamReceitaIsentaAliquotaZeroSuspensaoFromCodigo(codIncCofins)) continue;
                List<HashMap> dadosM810 = this.findDetalhamentoReceitasIsentasAliquotaZeroSuspensao(codIncCofins);
                this.gerarApuracaoCofinsM810(ap, dadosM810, codIncCofins);
                continue;
            }
            if (!(aliqCofins > 0.0)) continue;
            this.gerarBlocoM610Cumulativo(codIncCofins, valorReceita, valorCofins, valorBCCofins, aliqCofins, this.dataInicial, this.dataFinal, this.grupoEmpresa, blocoM610);
        }
        Double valorContribCumulativa = this.getValorContribuicaoCumulativaM610(blocoM610);
        if (valorContribCumulativa > 0.0) {
            ApuracaoCofinsM600 a = new ApuracaoCofinsM600();
            a.setValorContribCumulativaPeriodo(valorContribCumulativa);
            a.setValorRetidoFonteCumulativo(this.getValorRetidoFonteCofins(this.dataInicial, this.dataFinal, this.grupoEmpresa));
            a.setValorContribCumulativaRecolher(Double.valueOf(a.getValorContribCumulativaPeriodo() - a.getValorRetidoFonteCumulativo()));
            a.setValorTotalRecolher(Double.valueOf(a.getValorContribCumulativaPeriodo() - a.getValorRetidoFonteCumulativo()));
            a.setApuracaoCofinsM610(blocoM610);
            for (ApuracaoCofinsM610 m : blocoM610) {
                m.setApuracaoCofinsM600(a);
            }
            ApuracaoCofinsM605 aa = new ApuracaoCofinsM605();
            aa.setTipo(Short.valueOf((short)1));
            aa.setValorDebito(a.getValorTotalRecolher());
            aa.setApuracaoCofinsM600(a);
            aa.setCodigoDCTF(this.getCodigoDCTFPeriodoAnteriorCofins());
            a.getApuracaoCofinsM605().add(aa);
            blocoM600.add(a);
            hh.put("BLOCO_M600", blocoM600);
        }
        hh.put("BLOCO_M800", blocoM800);
        return hh;
    }

    private ApuracaoCofinsM800 gerarBlocoM800(String codIncPis, Double valorReceita) throws ExceptionService {
        ApuracaoCofinsM800 a = new ApuracaoCofinsM800();
        a.setIncidenciaCofins(this.getIncidenciaPisCofinsPorCodigo(codIncPis));
        a.setValorTotalReceitaBruta(valorReceita);
        a.setPlanoConta(this.planoContaCofins);
        ApuracaoCofinsM810 aa = new ApuracaoCofinsM810();
        aa.setApuracaoCofinsM800(a);
        aa.setValorReceitaBruta(valorReceita);
        aa.setPlanoConta(this.planoContaCofins);
        a.getApuracaoCofinsM810().add(aa);
        return a;
    }

    private void gerarBlocoM610Cumulativo(String codIncPis, Double valorReceita, Double valorCofins, Double valorBCCofins, Double aliquotaCofins, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, List<ApuracaoCofinsM610> blocoM610) throws ExceptionService {
        Boolean achou = false;
        for (ApuracaoCofinsM610 a : blocoM610) {
            if (!a.getAliquotaCofins().equals(aliquotaCofins)) continue;
            achou = true;
            a.setValorReceitaBruta(Double.valueOf(a.getValorReceitaBruta() + valorReceita));
            a.setValorBCContribuicao(Double.valueOf(a.getValorBCContribuicao() + valorBCCofins));
            a.setValorContribuicaoApurado(Double.valueOf(a.getValorContribuicaoApurado() + valorCofins));
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
            break;
        }
        if (!achou.booleanValue()) {
            ApuracaoCofinsM610 a = new ApuracaoCofinsM610();
            a.setAliquotaCofins(aliquotaCofins);
            a.setValorReceitaBruta(valorReceita);
            a.setValorBCContribuicao(valorBCCofins);
            a.setValorContribuicaoApurado(valorCofins);
            a.setValorContribuicaoDiferir(Double.valueOf(0.0));
            a.setValorContribuicaoDiferirAnterior(Double.valueOf(0.0));
            a.setValorAjustesAcrescimo(Double.valueOf(0.0));
            a.setCodigoContribuicaoSocialPisCofins(this.getCodigoContribuicaoSocialCumulativoBasico());
            ApuracaoCofinsM620 ajusteDebito = this.gerarBlocoM620Cumulativo(aliquotaCofins, dataInicial, dataFinal, grupoEmpresa);
            if (ajusteDebito != null) {
                a.setValorAjustesReducao(ajusteDebito.getValorAjuste());
                ajusteDebito.setApuracaoCofinsM610(a);
                a.getApuracaoCofinsM620().add(ajusteDebito);
            }
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
            blocoM610.add(a);
        }
    }

    private ApuracaoCofinsM620 gerarBlocoM620Cumulativo(Double aliquotaCofins, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorCofins) as VALOR_COFINS  from LivroFiscal lv where lv.dataLivro between :dataIn and :dataFim and lv.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and (lv.entradaSaidaNaturezaOp = :entSaida1 or lv.entradaSaidaNaturezaOp = :entSaida2) and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda and lv.aliquotaCofins = :aliquotaCofins");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida1", (short)2);
        q.setShort("entSaida2", (short)0);
        q.setShort("cancelado", (short)0);
        q.setShort("cfopDevolucaoVenda", (short)1);
        q.setDouble("aliquotaCofins", aliquotaCofins.doubleValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        if (h != null && h.get("VALOR_COFINS") != null && (Double)h.get("VALOR_COFINS") > 0.0) {
            ApuracaoCofinsM620 a = new ApuracaoCofinsM620();
            a.setTipoAjuste(new Short("0"));
            a.setValorAjuste((Double)h.get("VALOR_COFINS"));
            a.setCodigoAjustePisCofins(this.getCodigoAjustePisCofinsEstorno());
            return a;
        }
        return null;
    }

    private Double getValorContribuicaoCumulativaM610(List<ApuracaoCofinsM610> blocoM610) {
        Double valor = 0.0;
        for (ApuracaoCofinsM610 a : blocoM610) {
            valor = valor + a.getValorTotalContribuicao();
        }
        return valor;
    }

    private List getVendasRegimeCumulativoLivrosFiscais(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorTotal) as VALOR_REC_AUFERIDA, lv.incidenciaPis.codigo as COD_INC_PIS, sum(lv.valorPis) as VALOR_PIS,  sum(lv.vrBCPis) as VALOR_BC_PIS,  lv.aliquotaPis as ALIQ_PIS, lv.incidenciaCofins.codigo as COD_INC_COFINS, sum(lv.valorCofins) as VALOR_COFINS,  sum(lv.vrBCCofins) as VALOR_BC_COFINS,  lv.aliquotaCofins as ALIQ_COFINS from LivroFiscal lv where lv.dataLivro between :dataIn and :dataFim and lv.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :nao and lv.cfop.cfopReceitaVendaSped = :sim and lv.incidenciaCofins.codigo <> :incidenciaNaoGeradorCredito group by lv.incidenciaPis.codigo, lv.aliquotaPis, lv.incidenciaCofins.codigo, lv.aliquotaCofins");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("cancelado", (short)0);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setString("incidenciaNaoGeradorCredito", "49");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void getVendasRegimeCumulativoF100(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.vrOper) as VALOR_REC_AUFERIDA, lv.cstPis.codigo as COD_INC_PIS, sum(lv.vrPis) as VALOR_PIS,  sum(lv.vrBcPis) as VALOR_BC_PIS,  lv.aliqPis as ALIQ_PIS, lv.cstCofins.codigo as COD_INC_COFINS, sum(lv.vrCofins) as VALOR_COFINS,  sum(lv.vrBcCofins) as VALOR_BC_COFINS,  lv.aliqCofins as ALIQ_COFINS from LancamentoSpedPisCofins lv where lv.dataOper between :dataIn and :dataFim and  lv.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and (lv.indOper = :cod1 or lv.indOper = :cod2) group by lv.cstPis.codigo, lv.aliqPis, lv.cstCofins.codigo, lv.aliqCofins");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("cod1", new Short("1").shortValue());
        q.setShort("cod2", new Short("2").shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lancamentos = q.list();
        for (HashMap lanc : lancamentos) {
            String codPis = (String)lanc.get("COD_INC_PIS");
            String codCofins = (String)lanc.get("COD_INC_COFINS");
            Double aliqPis = (Double)lanc.get("ALIQ_PIS");
            Double aliqCofins = (Double)lanc.get("ALIQ_COFINS");
            Boolean achou = false;
            for (HashMap h : dados) {
                String codPis2 = (String)h.get("COD_INC_PIS");
                String codCofins2 = (String)h.get("COD_INC_COFINS");
                Double aliqPis2 = (Double)h.get("ALIQ_PIS");
                Double aliqCofins2 = (Double)h.get("ALIQ_COFINS");
                if (!codPis.equals(codPis2) || !codCofins.equals(codCofins2) || !aliqPis.equals(aliqPis2) || !aliqCofins.equals(aliqCofins2)) continue;
                h.put("VALOR_REC_AUFERIDA", (Double)h.get("VALOR_REC_AUFERIDA") + (Double)lanc.get("VALOR_REC_AUFERIDA"));
                h.put("VALOR_PIS", (Double)h.get("VALOR_PIS") + (Double)lanc.get("VALOR_PIS"));
                h.put("VALOR_BC_PIS", (Double)h.get("VALOR_BC_PIS") + (Double)lanc.get("VALOR_BC_PIS"));
                h.put("VALOR_COFINS", (Double)h.get("VALOR_COFINS") + (Double)lanc.get("VALOR_COFINS"));
                h.put("VALOR_BC_COFINS", (Double)h.get("VALOR_BC_COFINS") + (Double)lanc.get("VALOR_BC_COFINS"));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            dados.add(lanc);
        }
    }

    private CodigoAjustePisCofins getCodigoAjustePisCofinsEstorno() throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCodigoAjustePisCofins().getVOClass());
        bc.and().equal("codigo", "06");
        return (CodigoAjustePisCofins)CoreService.executeSearchUniqueResult(bc);
    }

    private CodigoContribuicaoSocialPisCofins getCodigoContribuicaoSocialCumulativoBasico() throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCodigoContribuicaoSocialPisCofins().getVOClass());
        bc.and().equal("codigo", "51");
        return (CodigoContribuicaoSocialPisCofins)CoreService.executeSearchUniqueResult(bc);
    }

    private CodigoContribuicaoSocialPisCofins getCodigoContribuicaoSocialNaoCumulativoBasico() throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCodigoContribuicaoSocialPisCofins().getVOClass());
        bc.and().equal("codigo", "01");
        return (CodigoContribuicaoSocialPisCofins)CoreService.executeSearchUniqueResult(bc);
    }

    private CodigoDCTF getCodigoDCTFPeriodoAnteriorPis() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select a.codigoDCTF from ApuracaoPisM205 a where a.apuracaoPisM200.apuracaoPis.apuracaoPisCofins.periodo = (    select max(ap.periodo) from ApuracaoPisCofins ap where ap.periodo < :periodoAtual)");
        q.setDate("periodoAtual", this.dataInicial);
        CodigoDCTF c = (CodigoDCTF)q.uniqueResult();
        return c;
    }

    private CodigoDCTF getCodigoDCTFPeriodoAnteriorCofins() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select a.codigoDCTF from ApuracaoCofinsM605 a where a.apuracaoCofinsM600.apuracaoCofins.apuracaoPisCofins.periodo = (    select max(ap.periodo) from ApuracaoPisCofins ap where ap.periodo < :periodoAtual)");
        q.setDate("periodoAtual", this.dataInicial);
        CodigoDCTF c = (CodigoDCTF)q.uniqueResult();
        return c;
    }

    private Double getValorRetidoFontePis(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        List lista = null;
        Double valor = 0.0;
        try {
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOBaixaTituloSpedPis().getVOClass());
            b.and().between("baixaTitulo.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao", dataInicial, dataFinal);
            b.and().equal("baixaTitulo.grupoDeBaixaFormas.grupoDeBaixa.empresa.empresaDados.grupoEmpresa", grupoEmpresa);
            lista = CoreService.executeSearch(b);
        }
        catch (ExceptionService ex) {
            throw new ExceptionService("Erro ao pesquisar as baixas de sped pis/cofins");
        }
        if (lista != null && !lista.isEmpty()) {
            for (Object o : lista) {
                BaixaTituloSpedPis b = (BaixaTituloSpedPis)o;
                valor = valor + b.getBaixaTitulo().getVrPis();
            }
        }
        return valor;
    }

    private Double getValorRetidoFonteCofins(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        List lista = null;
        Double valor = 0.0;
        try {
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOBaixaTituloSpedCofins().getVOClass());
            b.and().between("baixaTitulo.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao", dataInicial, dataFinal);
            b.and().equal("baixaTitulo.grupoDeBaixaFormas.grupoDeBaixa.empresa.empresaDados.grupoEmpresa", grupoEmpresa);
            lista = CoreService.executeSearch(b);
        }
        catch (ExceptionService ex) {
            throw new ExceptionService("Erro ao pesquisar os valores retidos na fonte de cofins");
        }
        if (lista != null && !lista.isEmpty()) {
            for (Object o : lista) {
                BaixaTituloSpedCofins b = (BaixaTituloSpedCofins)o;
                valor = valor + b.getBaixaTitulo().getVrConfins();
            }
        }
        return valor;
    }

    private Object gerarBlocoM350() {
        ArrayList<ApuracaoPisM350> apuracoes = new ArrayList<ApuracaoPisM350>();
        if (this.indicadorNaturezaPessoaJuridica != null && (this.indicadorNaturezaPessoaJuridica.getCodigo().equals("01") || this.indicadorNaturezaPessoaJuridica.getCodigo().equals("02") || this.indicadorNaturezaPessoaJuridica.getCodigo().equals("04"))) {
            Session s = CoreBdUtil.getInstance().getSession();
            Query q = s.createQuery(" select  coalesce(sum(mov.basePis),0) as BASE_CALCULO, coalesce(sum(mov.baseNaoPis),0) as EXCLUSAO_BASE_CALCULO, coalesce(sum(mov.valorPis),0) AS VALOR_PIS, coalesce(mov.aliquotaPis,0) as ALIQUOTA_PIS from MovimentoFolha mov  where  mov.aberturaPeriodo.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  mov.aberturaPeriodo.periodoApuracao between :dataInicial and :dataFinal  group by mov.aliquotaPis");
            q.setDate("dataInicial", this.dataInicial);
            q.setDate("dataFinal", this.dataFinal);
            q.setEntity("grupoEmpresa", (Object)this.grupoEmpresa);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List lista = q.list();
            if (lista != null) {
                for (HashMap h : lista) {
                    Double baseCalculo = (Double)h.get("BASE_CALCULO");
                    Double exclusaoBaseCalculo = (Double)h.get("EXCLUSAO_BASE_CALCULO");
                    Double valorPis = (Double)h.get("VALOR_PIS");
                    Double aliquotaPis = (Double)h.get("ALIQUOTA_PIS");
                    if (aliquotaPis == null || !(aliquotaPis > 0.0)) continue;
                    ApuracaoPisM350 a = new ApuracaoPisM350();
                    a.setValorTotalFolha(Double.valueOf(baseCalculo + exclusaoBaseCalculo));
                    a.setValorBaseCalculo(baseCalculo);
                    a.setValorExclusaoBaseCalculo(exclusaoBaseCalculo);
                    a.setAliquotaPis(aliquotaPis);
                    a.setValorContribuicaoSocialFolha(valorPis);
                    apuracoes.add(a);
                }
            }
        }
        return apuracoes;
    }

    private ApuracaoPisM200 getApuracaoPisM200Zerada() {
        ApuracaoPisM200 a = new ApuracaoPisM200();
        return a;
    }

    private ApuracaoCofinsM600 getApuracaoCofinsM600Zerada() {
        ApuracaoCofinsM600 a = new ApuracaoCofinsM600();
        return a;
    }

    private ParamReceitaPisCofins findParamReceitaPisCofinsIsentaAliquotaZero() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct p from ParamReceitaPisCofins p");
        q.setMaxResults(1);
        return (ParamReceitaPisCofins)q.uniqueResult();
    }

    private boolean existsParamReceitaIsentaAliquotaZeroSuspensaoFromCodigo(String codIncPis) {
        for (ParamReceitaPisCofinsCST p : this.paramReceitaIsenta.getCst()) {
            if (!p.getIncidenciaPisCofins().getCodigo().equals(codIncPis)) continue;
            return true;
        }
        return false;
    }

    private List<HashMap> findDetalhamentoReceitasIsentasAliquotaZeroSuspensao(String codIncPisCofins) {
        List<HashMap> lista = new ArrayList<HashMap>();
        lista.addAll(this.findDetalhamentoReceitasIsentasAliquotaZeroSuspensaoNotaPropria(codIncPisCofins));
        lista.addAll(this.findDetalhamentoReceitasIsentasAliquotaZeroSuspensaoNFCe(codIncPisCofins));
        lista = this.agruparDetalhamentoReceitasIsentasAliquotaZeroSuspensao(lista);
        return lista;
    }

    private List<HashMap> findDetalhamentoReceitasIsentasAliquotaZeroSuspensaoNotaPropria(String codIncPisCofins) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(lv.valorTotal) as VALOR_REC_AUFERIDA, i.natReceitaPisCofins.identificador as ID_NAT_RECEITA_PIS_COFINS from NotaFiscalPropria np inner join np.itensNotaPropria i inner join i.itemNotaLivroFiscal lv  where np.dataEmissaoNota between :dataIn and :dataFim and np.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and np.naturezaOperacao.entradaSaida = :entSaida and (np.situacaoDocumento.codigo <> :cod1 and np.situacaoDocumento.codigo <> :cod2 and np.situacaoDocumento.codigo <> :cod3) and lv.cfop.cfopDevolucaoVenda = :nao and lv.cfop.cfopReceitaVendaSped = :sim and i.natReceitaPisCofins is not null and i.incidenciaPisCofins.codigo = :incidenciaPisCofins group by  i.natReceitaPisCofins.identificador");
        q.setDate("dataIn", this.dataInicial);
        q.setDate("dataFim", this.dataFinal);
        q.setEntity("grupoEmpresa", (Object)this.grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setString("cod1", "02");
        q.setString("cod2", "03");
        q.setString("cod3", "04");
        q.setString("incidenciaPisCofins", codIncPisCofins);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> findDetalhamentoReceitasIsentasAliquotaZeroSuspensaoNFCe(String codIncPisCofins) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select sum(i.valorTotal) as VALOR_REC_AUFERIDA, p.natReceitaPisCofins.identificador as ID_NAT_RECEITA_PIS_COFINS from NFCe np inner join np.itens i inner join i.pis p  where np.dataEmissao between :dataIn and :dataFim and np.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and np.naturezaOperacao.entradaSaida = :entSaida and (np.situacaoDocumento.codigo <> :cod1 and np.situacaoDocumento.codigo <> :cod2 and np.situacaoDocumento.codigo <> :cod3) and i.cfop.cfopDevolucaoVenda = :nao and i.cfop.cfopReceitaVendaSped = :sim and p.incidenciaPisCofins.codigo = :incidenciaPisCofins and i.status = :naoCancelado and p.natReceitaPisCofins is not null group by  p.natReceitaPisCofins.identificador");
        q.setDate("dataIn", this.dataInicial);
        q.setDate("dataFim", this.dataFinal);
        q.setEntity("grupoEmpresa", (Object)this.grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("nao", (short)0);
        q.setShort("naoCancelado", (short)1);
        q.setShort("sim", (short)1);
        q.setString("cod1", "02");
        q.setString("cod2", "03");
        q.setString("cod3", "04");
        q.setString("incidenciaPisCofins", codIncPisCofins);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void gerarApuracaoPisM410(ApuracaoPisM400 ap, List<HashMap> lista, String codIncidencia) {
        ArrayList<ApuracaoPisM410> registrosM410 = new ArrayList<ApuracaoPisM410>();
        PlanoConta pc = null;
        for (ParamReceitaPisCofinsCST paramCst : this.paramReceitaIsenta.getCst()) {
            if (!ToolMethods.isEquals((Object)paramCst.getIncidenciaPisCofins().getCodigo(), (Object)codIncidencia)) continue;
            pc = paramCst.getPlanoConta();
        }
        for (HashMap h : lista) {
            Long idNatReceita = (Long)h.get("ID_NAT_RECEITA_PIS_COFINS");
            Double valor = (Double)h.get("VALOR_REC_AUFERIDA");
            ApuracaoPisM410 m = new ApuracaoPisM410();
            m.setNaturezaReceitaPisCofins(this.getNatReceitaPisCofins(idNatReceita));
            m.setValorReceitaBruta(valor);
            if (pc != null) {
                m.setPlanoConta(pc);
            } else {
                m.setPlanoConta(this.planoContaPis);
            }
            registrosM410.add(m);
        }
        ap.setApuracaoPisM410(registrosM410);
    }

    private void gerarApuracaoCofinsM810(ApuracaoCofinsM800 ap, List<HashMap> lista, String codIncidencia) {
        ArrayList<ApuracaoCofinsM810> registrosM810 = new ArrayList<ApuracaoCofinsM810>();
        PlanoConta pc = null;
        for (ParamReceitaPisCofinsCST paramCst : this.paramReceitaIsenta.getCst()) {
            if (!ToolMethods.isEquals((Object)paramCst.getIncidenciaPisCofins().getCodigo(), (Object)codIncidencia)) continue;
            pc = paramCst.getPlanoConta();
        }
        for (HashMap h : lista) {
            Long idNatReceita = (Long)h.get("ID_NAT_RECEITA_PIS_COFINS");
            Double valor = (Double)h.get("VALOR_REC_AUFERIDA");
            ApuracaoCofinsM810 m = new ApuracaoCofinsM810();
            m.setNaturezaReceitaPisCofins(this.getNatReceitaPisCofins(idNatReceita));
            m.setValorReceitaBruta(valor);
            if (pc != null) {
                m.setPlanoConta(pc);
            } else {
                m.setPlanoConta(this.planoContaCofins);
            }
            registrosM810.add(m);
        }
        ap.setApuracaoCofinsM810(registrosM810);
    }

    private NaturezaReceitaPisCofins getNatReceitaPisCofins(Long idNatReceita) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct np from NaturezaReceitaPisCofins np where np.identificador = :idNatureza");
        q.setLong("idNatureza", idNatReceita.longValue());
        q.setMaxResults(1);
        return (NaturezaReceitaPisCofins)q.uniqueResult();
    }

    private ApuracaoPisCofins getDadosRegimeNaoCumulativo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        List dadosVendas = this.getVendasRegimeNaoCumulativo(grupoEmpresa, dataInicial, dataFinal);
        HashMap h = this.gerarBlocoMPisNaoCumulativo(dadosVendas);
        ApuracaoPis pis = new ApuracaoPis();
        if (h.get("BLOCO_M200") != null && !((List)h.get("BLOCO_M200")).isEmpty()) {
            pis.setApuracaoPisM200((List)h.get("BLOCO_M200"));
        } else {
            pis.getApuracaoPisM200().add(this.getApuracaoPisM200Zerada());
        }
        if (h.get("BLOCO_M400") != null) {
            pis.setApuracaoPisM400((List)h.get("BLOCO_M400"));
        }
        if (h.get("BLOCO_M350") != null) {
            pis.setApuracaoPisM350((List)h.get("BLOCO_M350"));
        }
        if (ToolMethods.isEquals((Object)this.apurarCreditoRegimeNaoCumulativo, (Object)1)) {
            List dadosEntradas = this.getCreditosEntradasRegimeNaoCumulativoPis(grupoEmpresa, dataInicial, dataFinal);
            this.gerarBlocoMPisNaoCumulativoCreditos(pis, dadosEntradas);
        }
        h = this.gerarBlocoMCofinsNaoCumulativo(dadosVendas);
        ApuracaoCofins cofins = new ApuracaoCofins();
        if (h.get("BLOCO_M600") != null && !((List)h.get("BLOCO_M600")).isEmpty()) {
            cofins.setApuracaoCofinsM600((List)h.get("BLOCO_M600"));
        } else {
            cofins.getApuracaoCofinsM600().add(this.getApuracaoCofinsM600Zerada());
        }
        if (h.get("BLOCO_M800") != null) {
            cofins.setApuracaoCofinsM800((List)h.get("BLOCO_M800"));
        }
        if (ToolMethods.isEquals((Object)this.apurarCreditoRegimeNaoCumulativo, (Object)1)) {
            List dadosEntradasCofins = this.getCreditosEntradasRegimeNaoCumulativoCofins(grupoEmpresa, dataInicial, dataFinal);
            this.gerarBlocoMCofinsNaoCumulativoCreditos(cofins, dadosEntradasCofins);
        }
        ApuracaoPisCofins pisCofins = new ApuracaoPisCofins();
        pisCofins.setApuracaoPis(pis);
        pisCofins.setApuracaoCofins(cofins);
        return pisCofins;
    }

    private List getVendasRegimeNaoCumulativo(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        List dados = this.getVendasRegimeNaoCumulativoLivrosFiscais(grupoEmpresa, dataIn, dataFim);
        this.getVendasRegimeNaoCumulativoF100(grupoEmpresa, dataIn, dataFim, dados);
        if (ToolMethods.isEquals((Object)this.apurarRps, (Object)1)) {
            this.getVendasRPSRegimeNaoCumulativo(grupoEmpresa, dataIn, dataFim, dados);
        }
        return dados;
    }

    private List getVendasRegimeNaoCumulativoLivrosFiscais(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorTotal) as VALOR_REC_AUFERIDA, lv.incidenciaPis.codigo as COD_INC_PIS, sum(lv.valorPis) as VALOR_PIS,  sum(lv.vrBCPis) as VALOR_BC_PIS,  lv.aliquotaPis as ALIQ_PIS, lv.incidenciaCofins.codigo as COD_INC_COFINS, sum(lv.valorCofins) as VALOR_COFINS,  sum(lv.vrBCCofins) as VALOR_BC_COFINS,  lv.aliquotaCofins as ALIQ_COFINS from LivroFiscal lv where lv.dataLivro between :dataIn and :dataFim and lv.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :nao and lv.cfop.cfopReceitaVendaSped = :sim and lv.incidenciaCofins.codigo <> :incidenciaNaoGeradorCredito group by lv.incidenciaPis.codigo, lv.aliquotaPis, lv.incidenciaCofins.codigo, lv.aliquotaCofins");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida", (short)1);
        q.setShort("cancelado", (short)0);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setString("incidenciaNaoGeradorCredito", "49");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void getVendasRegimeNaoCumulativoF100(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.vrOper) as VALOR_REC_AUFERIDA, lv.cstPis.codigo as COD_INC_PIS, sum(lv.vrPis) as VALOR_PIS,  sum(lv.vrBcPis) as VALOR_BC_PIS,  lv.aliqPis as ALIQ_PIS, lv.cstCofins.codigo as COD_INC_COFINS, sum(lv.vrCofins) as VALOR_COFINS,  sum(lv.vrBcCofins) as VALOR_BC_COFINS,  lv.aliqCofins as ALIQ_COFINS from LancamentoSpedPisCofins lv where lv.dataOper between :dataIn and :dataFim and  lv.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and (lv.indOper = :cod1 or lv.indOper = :cod2) group by lv.cstPis.codigo, lv.aliqPis, lv.cstCofins.codigo, lv.aliqCofins");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("cod1", new Short("1").shortValue());
        q.setShort("cod2", new Short("2").shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lancamentos = q.list();
        for (HashMap lanc : lancamentos) {
            String codPis = (String)lanc.get("COD_INC_PIS");
            String codCofins = (String)lanc.get("COD_INC_COFINS");
            Double aliqPis = (Double)lanc.get("ALIQ_PIS");
            Double aliqCofins = (Double)lanc.get("ALIQ_COFINS");
            Boolean achou = false;
            for (HashMap h : dados) {
                String codPis2 = (String)h.get("COD_INC_PIS");
                String codCofins2 = (String)h.get("COD_INC_COFINS");
                Double aliqPis2 = (Double)h.get("ALIQ_PIS");
                Double aliqCofins2 = (Double)h.get("ALIQ_COFINS");
                if (!codPis.equals(codPis2) || !codCofins.equals(codCofins2) || !aliqPis.equals(aliqPis2) || !aliqCofins.equals(aliqCofins2)) continue;
                h.put("VALOR_REC_AUFERIDA", (Double)h.get("VALOR_REC_AUFERIDA") + (Double)lanc.get("VALOR_REC_AUFERIDA"));
                h.put("VALOR_PIS", (Double)h.get("VALOR_PIS") + (Double)lanc.get("VALOR_PIS"));
                h.put("VALOR_BC_PIS", (Double)h.get("VALOR_BC_PIS") + (Double)lanc.get("VALOR_BC_PIS"));
                h.put("VALOR_COFINS", (Double)h.get("VALOR_COFINS") + (Double)lanc.get("VALOR_COFINS"));
                h.put("VALOR_BC_COFINS", (Double)h.get("VALOR_BC_COFINS") + (Double)lanc.get("VALOR_BC_COFINS"));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            dados.add(lanc);
        }
    }

    private HashMap gerarBlocoMPisNaoCumulativo(List<HashMap> dados) throws ExceptionService {
        ArrayList<ApuracaoPisM400> blocoM400 = new ArrayList<ApuracaoPisM400>();
        ArrayList<ApuracaoPisM210> blocoM210 = new ArrayList<ApuracaoPisM210>();
        ArrayList<ApuracaoPisM200> blocoM200 = new ArrayList<ApuracaoPisM200>();
        HashMap<String, Object> hh = new HashMap<String, Object>();
        for (HashMap h : dados) {
            String codIncPis = (String)h.get("COD_INC_PIS");
            Double valorReceita = (Double)h.get("VALOR_REC_AUFERIDA");
            Double valorPis = (Double)h.get("VALOR_PIS");
            Double valorBCPis = (Double)h.get("VALOR_BC_PIS");
            Double aliqPis = (Double)h.get("ALIQ_PIS");
            if (this.getIncidenciaIsentaAliquotaZeroSuspensao(codIncPis)) {
                ApuracaoPisM400 ap = this.gerarBlocoM400(codIncPis, valorReceita);
                blocoM400.add(ap);
                if (this.paramReceitaIsenta == null || !this.existsParamReceitaIsentaAliquotaZeroSuspensaoFromCodigo(codIncPis)) continue;
                List<HashMap> dadosM410 = this.findDetalhamentoReceitasIsentasAliquotaZeroSuspensao(codIncPis);
                this.gerarApuracaoPisM410(ap, dadosM410, codIncPis);
                continue;
            }
            if (!(aliqPis > 0.0)) continue;
            this.gerarBlocoM210NaoCumulativo(codIncPis, valorReceita, valorPis, valorBCPis, aliqPis, this.dataInicial, this.dataFinal, this.grupoEmpresa, blocoM210);
        }
        Double valorContribNaoCumulativa = this.getValorContribuicaoNaoCumulativaM210(blocoM210);
        if (valorContribNaoCumulativa > 0.0) {
            ApuracaoPisM200 a = new ApuracaoPisM200();
            a.setValorContribNaoCumulativaPeriodo(valorContribNaoCumulativa);
            a.setValorContribNaoCumulativaDevida(valorContribNaoCumulativa);
            a.setValorRetidoFonteNaoCumulativo(this.getValorRetidoFontePis(this.dataInicial, this.dataFinal, this.grupoEmpresa));
            a.setValorContribNaoCumulativaRecolher(Double.valueOf(a.getValorContribNaoCumulativaDevida() - a.getValorRetidoFonteNaoCumulativo()));
            a.setValorTotalRecolher(Double.valueOf(a.getValorContribNaoCumulativaDevida() - a.getValorRetidoFonteNaoCumulativo()));
            a.setApuracaoPisM210(blocoM210);
            blocoM200.add(a);
            for (ApuracaoPisM210 m : blocoM210) {
                m.setApuracaoPisM200(a);
            }
            ApuracaoPisM205 aa = new ApuracaoPisM205();
            aa.setTipo(Short.valueOf((short)0));
            aa.setValorDebito(a.getValorTotalRecolher());
            aa.setCodigoDCTF(this.getCodigoDCTFPeriodoAnteriorPis());
            aa.setApuracaoPisM200(a);
            a.getApuracaoPisM205().add(aa);
            hh.put("BLOCO_M200", blocoM200);
        }
        hh.put("BLOCO_M400", blocoM400);
        hh.put("BLOCO_M350", this.gerarBlocoM350());
        return hh;
    }

    private void gerarBlocoM210NaoCumulativo(String codIncPis, Double valorReceita, Double valorPis, Double valorBCPis, Double aliquotaPis, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, List<ApuracaoPisM210> blocoM210) throws ExceptionService {
        Boolean achou = false;
        for (ApuracaoPisM210 a : blocoM210) {
            if (!a.getAliquotaPis().equals(aliquotaPis)) continue;
            achou = true;
            a.setValorReceitaBruta(Double.valueOf(a.getValorReceitaBruta() + valorReceita));
            a.setValorBCContribuicao(Double.valueOf(a.getValorBCContribuicao() + valorBCPis));
            a.setValorContribuicaoApurado(Double.valueOf(a.getValorContribuicaoApurado() + valorPis));
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
        }
        if (!achou.booleanValue()) {
            ApuracaoPisM220 ajusteDebito;
            ApuracaoPisM210 a = new ApuracaoPisM210();
            a.setAliquotaPis(aliquotaPis);
            a.setValorReceitaBruta(valorReceita);
            a.setValorBCContribuicao(valorBCPis);
            a.setValorContribuicaoApurado(valorPis);
            a.setValorContribuicaoDiferir(Double.valueOf(0.0));
            a.setValorContribuicaoDiferirAnterior(Double.valueOf(0.0));
            a.setValorAjustesAcrescimo(Double.valueOf(0.0));
            a.setCodigoContribuicaoSocialPisCofins(this.getCodigoContribuicaoSocialNaoCumulativoBasico());
            if (ToolMethods.isEquals((Object)this.apurarCreditoRegimeNaoCumulativo, (Object)0) && (ajusteDebito = this.gerarBlocoM220NaoCumulativo(aliquotaPis, dataInicial, dataFinal, grupoEmpresa)) != null) {
                a.setValorAjustesReducao(ajusteDebito.getValorAjuste());
                ajusteDebito.setApuracaoPisM210(a);
                a.getApuracaoPisM220().add(ajusteDebito);
            }
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
            blocoM210.add(a);
        }
    }

    private ApuracaoPisM220 gerarBlocoM220NaoCumulativo(Double aliquotaPis, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorPis) as VALOR_PIS  from LivroFiscal lv where lv.dataLivro between :dataIn and :dataFim and lv.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and (lv.entradaSaidaNaturezaOp = :entSaida1 or lv.entradaSaidaNaturezaOp = :entSaida2) and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda and lv.aliquotaPis = :aliquotaPis");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida1", (short)2);
        q.setShort("entSaida2", (short)0);
        q.setShort("cancelado", (short)0);
        q.setShort("cfopDevolucaoVenda", (short)1);
        q.setDouble("aliquotaPis", aliquotaPis.doubleValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        if (h != null && h.get("VALOR_PIS") != null && (Double)h.get("VALOR_PIS") > 0.0) {
            ApuracaoPisM220 a = new ApuracaoPisM220();
            a.setTipoAjuste(new Short("0"));
            a.setValorAjuste((Double)h.get("VALOR_PIS"));
            a.setCodigoAjustePisCofins(this.getCodigoAjustePisCofinsEstorno());
            return a;
        }
        return null;
    }

    private Double getValorContribuicaoNaoCumulativaM210(List<ApuracaoPisM210> blocoM210) {
        Double valor = 0.0;
        for (ApuracaoPisM210 a : blocoM210) {
            valor = valor + a.getValorTotalContribuicao();
        }
        return valor;
    }

    private HashMap gerarBlocoMCofinsNaoCumulativo(List<HashMap> dados) throws ExceptionService {
        ArrayList<ApuracaoCofinsM800> blocoM800 = new ArrayList<ApuracaoCofinsM800>();
        ArrayList<ApuracaoCofinsM610> blocoM610 = new ArrayList<ApuracaoCofinsM610>();
        ArrayList<ApuracaoCofinsM600> blocoM600 = new ArrayList<ApuracaoCofinsM600>();
        HashMap<String, ArrayList<Object>> hh = new HashMap<String, ArrayList<Object>>();
        for (HashMap h : dados) {
            String codIncCofins = (String)h.get("COD_INC_COFINS");
            Double valorReceita = (Double)h.get("VALOR_REC_AUFERIDA");
            Double valorCofins = (Double)h.get("VALOR_COFINS");
            Double valorBCCofins = (Double)h.get("VALOR_BC_COFINS");
            Double aliqCofins = (Double)h.get("ALIQ_COFINS");
            if (this.getIncidenciaIsentaAliquotaZeroSuspensao(codIncCofins)) {
                ApuracaoCofinsM800 ap = this.gerarBlocoM800(codIncCofins, valorReceita);
                blocoM800.add(ap);
                if (this.paramReceitaIsenta == null || !this.existsParamReceitaIsentaAliquotaZeroSuspensaoFromCodigo(codIncCofins)) continue;
                List<HashMap> dadosM810 = this.findDetalhamentoReceitasIsentasAliquotaZeroSuspensao(codIncCofins);
                this.gerarApuracaoCofinsM810(ap, dadosM810, codIncCofins);
                continue;
            }
            if (!(aliqCofins > 0.0)) continue;
            this.gerarBlocoM610NaoCumulativo(codIncCofins, valorReceita, valorCofins, valorBCCofins, aliqCofins, this.dataInicial, this.dataFinal, this.grupoEmpresa, blocoM610);
        }
        Double valorContribNaoCumulativa = this.getValorContribuicaoNaoCumulativaM610(blocoM610);
        if (valorContribNaoCumulativa > 0.0) {
            ApuracaoCofinsM600 a = new ApuracaoCofinsM600();
            a.setValorContribNaoCumulativaPeriodo(valorContribNaoCumulativa);
            a.setValorContribNaoCumulativaDevida(valorContribNaoCumulativa);
            a.setValorRetidoFonteNaoCumulativo(this.getValorRetidoFonteCofins(this.dataInicial, this.dataFinal, this.grupoEmpresa));
            a.setValorContribNaoCumulativaRecolher(Double.valueOf(a.getValorContribNaoCumulativaDevida() - a.getValorRetidoFonteNaoCumulativo()));
            a.setValorTotalRecolher(Double.valueOf(a.getValorContribNaoCumulativaDevida() - a.getValorRetidoFonteNaoCumulativo()));
            a.setApuracaoCofinsM610(blocoM610);
            for (ApuracaoCofinsM610 m : blocoM610) {
                m.setApuracaoCofinsM600(a);
            }
            ApuracaoCofinsM605 aa = new ApuracaoCofinsM605();
            aa.setTipo(Short.valueOf((short)0));
            aa.setValorDebito(a.getValorTotalRecolher());
            aa.setApuracaoCofinsM600(a);
            aa.setCodigoDCTF(this.getCodigoDCTFPeriodoAnteriorCofins());
            a.getApuracaoCofinsM605().add(aa);
            blocoM600.add(a);
            hh.put("BLOCO_M600", blocoM600);
        }
        hh.put("BLOCO_M800", blocoM800);
        return hh;
    }

    private void gerarBlocoM610NaoCumulativo(String codIncPis, Double valorReceita, Double valorCofins, Double valorBCCofins, Double aliquotaCofins, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, List<ApuracaoCofinsM610> blocoM610) throws ExceptionService {
        Boolean achou = false;
        for (ApuracaoCofinsM610 a : blocoM610) {
            if (!a.getAliquotaCofins().equals(aliquotaCofins)) continue;
            achou = true;
            a.setValorReceitaBruta(Double.valueOf(a.getValorReceitaBruta() + valorReceita));
            a.setValorBCContribuicao(Double.valueOf(a.getValorBCContribuicao() + valorBCCofins));
            a.setValorContribuicaoApurado(Double.valueOf(a.getValorContribuicaoApurado() + valorCofins));
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
            break;
        }
        if (!achou.booleanValue()) {
            ApuracaoCofinsM620 ajusteDebito;
            ApuracaoCofinsM610 a = new ApuracaoCofinsM610();
            a.setAliquotaCofins(aliquotaCofins);
            a.setValorReceitaBruta(valorReceita);
            a.setValorBCContribuicao(valorBCCofins);
            a.setValorContribuicaoApurado(valorCofins);
            a.setValorContribuicaoDiferir(Double.valueOf(0.0));
            a.setValorContribuicaoDiferirAnterior(Double.valueOf(0.0));
            a.setValorAjustesAcrescimo(Double.valueOf(0.0));
            a.setCodigoContribuicaoSocialPisCofins(this.getCodigoContribuicaoSocialNaoCumulativoBasico());
            if (ToolMethods.isEquals((Object)this.apurarCreditoRegimeNaoCumulativo, (Object)0) && (ajusteDebito = this.gerarBlocoM620NaoCumulativo(aliquotaCofins, dataInicial, dataFinal, grupoEmpresa)) != null) {
                a.setValorAjustesReducao(ajusteDebito.getValorAjuste());
                ajusteDebito.setApuracaoCofinsM610(a);
                a.getApuracaoCofinsM620().add(ajusteDebito);
            }
            a.setValorTotalContribuicao(Double.valueOf(a.getValorContribuicaoApurado() - a.getValorAjustesReducao()));
            blocoM610.add(a);
        }
    }

    private ApuracaoCofinsM620 gerarBlocoM620NaoCumulativo(Double aliquotaCofins, Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorCofins) as VALOR_COFINS  from LivroFiscal lv where lv.dataLivro between :dataIn and :dataFim and lv.empresa.empresaDados.grupoEmpresa=:grupoEmpresa and (lv.entradaSaidaNaturezaOp = :entSaida1 or lv.entradaSaidaNaturezaOp = :entSaida2) and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda and lv.aliquotaCofins = :aliquotaCofins");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("entSaida1", (short)2);
        q.setShort("entSaida2", (short)0);
        q.setShort("cancelado", (short)0);
        q.setShort("cfopDevolucaoVenda", (short)1);
        q.setDouble("aliquotaCofins", aliquotaCofins.doubleValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap h = (HashMap)q.uniqueResult();
        if (h != null && h.get("VALOR_COFINS") != null && (Double)h.get("VALOR_COFINS") > 0.0) {
            ApuracaoCofinsM620 a = new ApuracaoCofinsM620();
            a.setTipoAjuste(new Short("0"));
            a.setValorAjuste((Double)h.get("VALOR_COFINS"));
            a.setCodigoAjustePisCofins(this.getCodigoAjustePisCofinsEstorno());
            return a;
        }
        return null;
    }

    private Double getValorContribuicaoNaoCumulativaM610(List<ApuracaoCofinsM610> blocoM610) {
        Double valor = 0.0;
        for (ApuracaoCofinsM610 a : blocoM610) {
            valor = valor + a.getValorTotalContribuicao();
        }
        return valor;
    }

    private List getCreditosEntradasRegimeNaoCumulativoPis(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        List dados = this.getNotasTerceirosEntradasRegimeNaoCumulativoLivrosFiscaisPis(grupoEmpresa, dataIn, dataFim);
        dados = this.getNotasPropriasEntradasRegimeNaoCumulativoLivrosFiscaisPis(grupoEmpresa, dataIn, dataFim, dados);
        return dados;
    }

    private List getNotasTerceirosEntradasRegimeNaoCumulativoLivrosFiscaisPis(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.incidenciaPisCofins.codigo as COD_INC_PIS, sum(lv.vrPis) as VALOR_PIS,  sum(lv.vrBCPis) as VALOR_BC_PIS,  lv.aliquotaPis as ALIQ_PIS, nb.codigo as COD_NAT_BC_CREDITO from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i inner join i.itemNotaLivroFiscal lv left  join i.naturezaBCCredito nb where  n.dataEntrada between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and (i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito1 or       i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito2 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito3 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito4 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito5 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito6 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito7 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito8 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito9 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito10 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito11 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito12 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito13 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito14) and (lv.cfop.codigo <> :cfopBonificacao1 and lv.cfop.codigo <> :cfopBonificacao2) and lv.cfop.cfopGeradorCredito = :sim  group by  i.incidenciaPisCofins.codigo, nb.codigo, lv.aliquotaPis having sum(lv.vrPis) > 0  order by lv.aliquotaPis ");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("incidenciaGeradorCredito1", "50");
        q.setString("incidenciaGeradorCredito2", "51");
        q.setString("incidenciaGeradorCredito3", "52");
        q.setString("incidenciaGeradorCredito4", "53");
        q.setString("incidenciaGeradorCredito5", "54");
        q.setString("incidenciaGeradorCredito6", "55");
        q.setString("incidenciaGeradorCredito7", "56");
        q.setString("incidenciaGeradorCredito8", "60");
        q.setString("incidenciaGeradorCredito9", "61");
        q.setString("incidenciaGeradorCredito10", "62");
        q.setString("incidenciaGeradorCredito11", "63");
        q.setString("incidenciaGeradorCredito12", "64");
        q.setString("incidenciaGeradorCredito13", "65");
        q.setString("incidenciaGeradorCredito14", "66");
        q.setString("cfopBonificacao1", "1.910");
        q.setString("cfopBonificacao2", "2.910");
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getNotasPropriasEntradasRegimeNaoCumulativoLivrosFiscaisPis(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.incidenciaPisCofins.codigo as COD_INC_PIS, sum(lv.vrPis) as VALOR_PIS,  sum(lv.vrBCPis) as VALOR_BC_PIS,  lv.aliquotaPis as ALIQ_PIS from NotaFiscalPropria n  inner join n.itensNotaPropria i inner join i.itemNotaLivroFiscal lv where  n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and (i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito1 or       i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito2 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito3 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito4 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito5 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito6 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito7 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito8 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito9 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito10 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito11 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito12 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito13 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito14) and (lv.cfop.codigo <> :cfopBonificacao1 and lv.cfop.codigo <> :cfopBonificacao2) and lv.cfop.cfopGeradorCredito = :sim  and lv.cfop.cfopDevolucaoVenda = :sim and (n.naturezaOperacao.entradaSaida = 0 OR n.naturezaOperacao.entradaSaida = 2) and (n.status = 100) group by  i.incidenciaPisCofins.codigo, lv.aliquotaPis having sum(lv.vrPis) > 0  order by lv.aliquotaPis ");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("incidenciaGeradorCredito1", "50");
        q.setString("incidenciaGeradorCredito2", "51");
        q.setString("incidenciaGeradorCredito1", "50");
        q.setString("incidenciaGeradorCredito3", "52");
        q.setString("incidenciaGeradorCredito4", "53");
        q.setString("incidenciaGeradorCredito5", "54");
        q.setString("incidenciaGeradorCredito6", "55");
        q.setString("incidenciaGeradorCredito7", "56");
        q.setString("incidenciaGeradorCredito8", "60");
        q.setString("incidenciaGeradorCredito9", "61");
        q.setString("incidenciaGeradorCredito10", "62");
        q.setString("incidenciaGeradorCredito11", "63");
        q.setString("incidenciaGeradorCredito12", "64");
        q.setString("incidenciaGeradorCredito13", "65");
        q.setString("incidenciaGeradorCredito14", "66");
        q.setString("cfopBonificacao1", "1.910");
        q.setString("cfopBonificacao2", "2.910");
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List temp = q.list();
        for (HashMap h : temp) {
            h.put("COD_NAT_BC_CREDITO", "12");
        }
        for (HashMap h : temp) {
            String codigo = (String)h.get("COD_INC_PIS");
            String codNatBCCredito = (String)h.get("COD_NAT_BC_CREDITO");
            Double aliqPis = (Double)h.get("ALIQ_PIS");
            Double valorPis = (Double)h.get("VALOR_PIS");
            Double valorBCPis = (Double)h.get("VALOR_BC_PIS");
            Boolean achou = false;
            for (HashMap h2 : dados) {
                String codigo2 = (String)h2.get("COD_INC_PIS");
                String codNatBCCredito2 = (String)h2.get("COD_NAT_BC_CREDITO");
                Double aliqPis2 = (Double)h2.get("ALIQ_PIS");
                Double valorPis2 = (Double)h2.get("VALOR_PIS");
                Double valorBCPis2 = (Double)h2.get("VALOR_BC_PIS");
                if (!ToolMethods.isEquals((Object)codigo, (Object)codigo2) || !ToolMethods.isEquals((Object)codNatBCCredito, (Object)codNatBCCredito2) || !ToolMethods.isEquals((Object)aliqPis, (Object)aliqPis2)) continue;
                h2.put("VALOR_PIS", valorPis + valorPis2);
                h2.put("VALOR_BC_PIS", valorBCPis + valorBCPis2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            dados.add(h);
        }
        return dados;
    }

    private void gerarBlocoMPisNaoCumulativoCreditos(ApuracaoPis pis, List<HashMap> dadosEntradas) {
        this.gerarBlocoPisM100(pis, dadosEntradas);
        this.abaterCreditosPeriodoApurado(pis);
    }

    private void gerarBlocoPisM100(ApuracaoPis pis, List<HashMap> dadosEntradas) {
        List<ApuracaoPisM105> apuracoesM105 = this.gerarBlocoPisM105(dadosEntradas);
        ArrayList<ApuracaoPisM100> apuracoesM100 = new ArrayList<ApuracaoPisM100>();
        for (ApuracaoPisM105 apM105 : apuracoesM105) {
            Boolean achou = false;
            for (ApuracaoPisM100 apM100 : apuracoesM100) {
                if (!ToolMethods.isEquals((Object)apM105.getAliquotaPis(), (Object)apM100.getAliquotaPis()) || !ToolMethods.isEquals((Object)apM105.getCodigoTipoCreditoPisCofins(), (Object)apM100.getCodigoTipoCreditoPisCofins())) continue;
                apM100.setValorBCCredito(Double.valueOf(apM100.getValorBCCredito() + apM105.getValorBCCredito()));
                apM100.setValorTotalCreditoApurado(Double.valueOf(apM100.getValorTotalCreditoApurado() + apM105.getValorPis()));
                apM100.setValorTotalCreditoDisponivel(Double.valueOf(apM100.getValorTotalCreditoDisponivel() + apM105.getValorPis()));
                apM100.setValorCreditoDesconto(Double.valueOf(apM100.getValorCreditoDesconto() + apM105.getValorPis()));
                apM100.getApuracaoPisM105().add(apM105);
                apM105.setApuracaoPisM100(apM100);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ApuracaoPisM100 apM100 = new ApuracaoPisM100();
            String codTipoCredito = "";
            if (apM105.getIncidenciaPisCofins().getCodigo().equals("50") || apM105.getIncidenciaPisCofins().getCodigo().equals("53")) {
                codTipoCredito = "101";
            } else if (apM105.getIncidenciaPisCofins().getCodigo().equals("51")) {
                codTipoCredito = "201";
            } else if (apM105.getIncidenciaPisCofins().getCodigo().equals("52")) {
                codTipoCredito = "301";
            }
            apM100.setCodigoTipoCreditoPisCofins(this.getCodigoTipoCreditoPisCofinsFromCodigo(codTipoCredito));
            apM100.setAliquotaPis(apM105.getAliquotaPis());
            apM100.setValorBCCredito(apM105.getValorBCCredito());
            apM100.setValorTotalCreditoApurado(apM105.getValorPis());
            apM100.setValorTotalCreditoDisponivel(apM105.getValorPis());
            apM100.setValorCreditoDesconto(apM105.getValorPis());
            apM100.getApuracaoPisM105().add(apM105);
            apM105.setApuracaoPisM100(apM100);
            apuracoesM100.add(apM100);
        }
        pis.getApuracaoPisM100().addAll(apuracoesM100);
    }

    private NaturezaBCCredito getNaturezaBCCredFromCodigo(String codNatBCCred) {
        if (codNatBCCred != null) {
            if (this.hashNaturezas.get(codNatBCCred) != null) {
                return (NaturezaBCCredito)this.hashNaturezas.get(codNatBCCred);
            }
            ServiceNaturezaBCCreditoImpl service = (ServiceNaturezaBCCreditoImpl)ConfApplicationContext.getBean(ServiceNaturezaBCCreditoImpl.class);
            NaturezaBCCredito nat = service.getByCodigo(codNatBCCred);
            if (nat != null) {
                this.hashNaturezas.put(codNatBCCred, nat);
                return nat;
            }
        }
        return null;
    }

    private IncidenciaPisCofins getIncidenciaPisCofinsFromCodigo(String codCST) {
        if (codCST != null) {
            if (this.hashIncidencias.get(codCST) != null) {
                return (IncidenciaPisCofins)this.hashIncidencias.get(codCST);
            }
            ServiceIncidenciaPisCofinsImpl service = (ServiceIncidenciaPisCofinsImpl)ConfApplicationContext.getBean(ServiceIncidenciaPisCofinsImpl.class);
            IncidenciaPisCofins inc = service.getByCodigo(codCST);
            if (inc != null) {
                this.hashIncidencias.put(codCST, inc);
                return inc;
            }
        }
        return null;
    }

    private CodigoTipoCreditoPisCofins getCodigoTipoCreditoPisCofinsFromCodigo(String codigo) {
        if (codigo != null) {
            if (this.hashCodigoTipoCreditoPisCofins.get(codigo) != null) {
                return (CodigoTipoCreditoPisCofins)this.hashCodigoTipoCreditoPisCofins.get(codigo);
            }
            ServiceCodigoTipoCreditoPisCofinsImpl service = (ServiceCodigoTipoCreditoPisCofinsImpl)ConfApplicationContext.getBean(ServiceCodigoTipoCreditoPisCofinsImpl.class);
            CodigoTipoCreditoPisCofins inc = service.getByCodigo(codigo);
            if (inc != null) {
                this.hashCodigoTipoCreditoPisCofins.put(codigo, inc);
                return inc;
            }
        }
        return null;
    }

    private void abaterCreditosPeriodoApurado(ApuracaoPis pis) {
        Double valorContribNaoCumulativa = 0.0;
        for (ApuracaoPisM200 m200 : pis.getApuracaoPisM200()) {
            valorContribNaoCumulativa = valorContribNaoCumulativa + m200.getValorContribNaoCumulativaPeriodo();
        }
        Double valorDeduzir = 0.0;
        for (ApuracaoPisM100 m100 : pis.getApuracaoPisM100()) {
            Double valor = m100.getValorTotalCreditoDisponivel();
            if (valor > valorContribNaoCumulativa) {
                Double dif = valor - valorContribNaoCumulativa;
                m100.setValorCreditoDesconto(valorContribNaoCumulativa);
                m100.setValorSaldoCreditoFuturo(dif);
                m100.setIndicadorDescontoCredito(new Short("1"));
                valorDeduzir = valorDeduzir + valorContribNaoCumulativa;
                continue;
            }
            valorContribNaoCumulativa = valorContribNaoCumulativa - valor;
            valorDeduzir = valorDeduzir + valor;
        }
        for (ApuracaoPisM200 m200 : pis.getApuracaoPisM200()) {
            m200.setValorCreditoDescontado(valorDeduzir);
            m200.setValorContribNaoCumulativaDevida(Double.valueOf(m200.getValorContribNaoCumulativaPeriodo() - m200.getValorCreditoDescontado() - m200.getValorCreditoDescontadoAnterior()));
            m200.setValorContribNaoCumulativaRecolher(Double.valueOf(m200.getValorContribNaoCumulativaDevida() - m200.getValorRetidoFonteNaoCumulativo() - m200.getValorOutrasDeducoesNaoCumulativo()));
            m200.setValorTotalRecolher(Double.valueOf(m200.getValorContribCumulativaRecolher() + m200.getValorContribNaoCumulativaRecolher()));
            if (m200.getValorTotalRecolher() == 0.0) {
                m200.getApuracaoPisM205().clear();
                continue;
            }
            for (ApuracaoPisM205 m205 : m200.getApuracaoPisM205()) {
                m205.setValorDebito(m200.getValorTotalRecolher());
            }
        }
    }

    private List<ApuracaoPisM105> gerarBlocoPisM105(List<HashMap> dadosEntradas) {
        ArrayList<ApuracaoPisM105> apuracoesM105 = new ArrayList<ApuracaoPisM105>();
        for (HashMap h : dadosEntradas) {
            String codCST = (String)h.get("COD_INC_PIS");
            String codNatBCCred = (String)h.get("COD_NAT_BC_CREDITO");
            Double valorPis = ToolFormatter.arrredondarNumero((Double)((Double)h.get("VALOR_PIS")), (int)2);
            Double valorBCPis = ToolFormatter.arrredondarNumero((Double)((Double)h.get("VALOR_BC_PIS")), (int)2);
            Double aliqPis = ToolFormatter.arrredondarNumero((Double)((Double)h.get("ALIQ_PIS")), (int)2);
            valorPis = ToolFormatter.arrredondarNumero((Double)(valorBCPis * (aliqPis / 100.0)), (int)2);
            ApuracaoPisM105 ap = new ApuracaoPisM105();
            ap.setNaturezaBCCredito(this.getNaturezaBCCredFromCodigo(codNatBCCred));
            ap.setIncidenciaPisCofins(this.getIncidenciaPisCofinsFromCodigo(codCST));
            ap.setAliquotaPis(aliqPis);
            ap.setValorPis(valorPis);
            ap.setValorBCPis(valorBCPis);
            ap.setValorBCCumulativa(Double.valueOf(0.0));
            ap.setValorBCNaoCumulativa(Double.valueOf(ap.getValorBCPis() - ap.getValorBCCumulativa()));
            ap.setValorBCCredito(ap.getValorBCNaoCumulativa());
            String codTipoCredito = "";
            if (ap.getIncidenciaPisCofins().getCodigo().equals("50") || ap.getIncidenciaPisCofins().getCodigo().equals("53")) {
                codTipoCredito = "101";
            } else if (ap.getIncidenciaPisCofins().getCodigo().equals("51")) {
                codTipoCredito = "201";
            } else if (ap.getIncidenciaPisCofins().getCodigo().equals("52")) {
                codTipoCredito = "301";
            }
            ap.setCodigoTipoCreditoPisCofins(this.getCodigoTipoCreditoPisCofinsFromCodigo(codTipoCredito));
            apuracoesM105.add(ap);
        }
        return this.aglutinarBlocoPisM105(apuracoesM105);
    }

    private List<ApuracaoPisM105> aglutinarBlocoPisM105(List<ApuracaoPisM105> apuracoesM105) {
        ArrayList<ApuracaoPisM105> apuracoesNew = new ArrayList<ApuracaoPisM105>();
        for (ApuracaoPisM105 apOld : apuracoesM105) {
            Boolean achou = false;
            for (ApuracaoPisM105 apNew : apuracoesNew) {
                if (!ToolMethods.isEquals((Object)apOld.getNaturezaBCCredito(), (Object)apNew.getNaturezaBCCredito()) || !ToolMethods.isEquals((Object)apOld.getIncidenciaPisCofins(), (Object)apNew.getIncidenciaPisCofins()) || !ToolMethods.isEquals((Object)apOld.getAliquotaPis(), (Object)apNew.getAliquotaPis()) || !ToolMethods.isEquals((Object)apOld.getCodigoTipoCreditoPisCofins(), (Object)apNew.getCodigoTipoCreditoPisCofins())) continue;
                apNew.setValorBCCredito(Double.valueOf(apNew.getValorBCCredito() + apOld.getValorBCCredito()));
                apNew.setValorBCCumulativa(Double.valueOf(apNew.getValorBCCumulativa() + apOld.getValorBCCumulativa()));
                apNew.setValorBCNaoCumulativa(Double.valueOf(apNew.getValorBCNaoCumulativa() + apOld.getValorBCNaoCumulativa()));
                apNew.setValorBCPis(Double.valueOf(apNew.getValorBCPis() + apOld.getValorBCPis()));
                apNew.setValorPis(Double.valueOf(apNew.getValorPis() + apOld.getValorPis()));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ApuracaoPisM105 ap = new ApuracaoPisM105();
            ap.setAliquotaPis(apOld.getAliquotaPis());
            ap.setValorPis(apOld.getValorPis());
            ap.setNaturezaBCCredito(apOld.getNaturezaBCCredito());
            ap.setIncidenciaPisCofins(apOld.getIncidenciaPisCofins());
            ap.setValorBCCredito(apOld.getValorBCCredito());
            ap.setValorBCCumulativa(apOld.getValorBCCumulativa());
            ap.setValorBCNaoCumulativa(apOld.getValorBCNaoCumulativa());
            ap.setValorBCPis(apOld.getValorBCPis());
            ap.setCodigoTipoCreditoPisCofins(apOld.getCodigoTipoCreditoPisCofins());
            apuracoesNew.add(ap);
        }
        return apuracoesNew;
    }

    private List getCreditosEntradasRegimeNaoCumulativoCofins(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        List dados = this.getNotasTerceirosEntradasRegimeNaoCumulativoLivrosFiscaisCofins(grupoEmpresa, dataIn, dataFim);
        dados = this.getNotasPropriasEntradasRegimeNaoCumulativoLivrosFiscaisCofins(grupoEmpresa, dataIn, dataFim, dados);
        return dados;
    }

    private List getNotasTerceirosEntradasRegimeNaoCumulativoLivrosFiscaisCofins(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.incidenciaPisCofins.codigo as COD_INC_COFINS, sum(lv.vrCofins) as VALOR_COFINS,  sum(lv.vrBCCofins) as VALOR_BC_COFINS,  lv.aliquotaCofins as ALIQ_COFINS, nb.codigo as COD_NAT_BC_CREDITO from NotaFiscalTerceiros n  inner join n.itemNotaTerceiros i inner join i.itemNotaLivroFiscal lv left  join i.naturezaBCCredito nb where  n.dataEntrada between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and (i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito1 or       i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito2 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito3 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito4 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito5 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito6 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito7 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito8 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito9 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito10 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito11 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito12 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito13 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito14) and (lv.cfop.codigo <> :cfopBonificacao1 and lv.cfop.codigo <> :cfopBonificacao2) and lv.cfop.cfopGeradorCredito = :sim  group by  i.incidenciaPisCofins.codigo, nb.codigo, lv.aliquotaCofins having sum(lv.vrCofins) > 0  order by lv.aliquotaCofins ");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("incidenciaGeradorCredito1", "50");
        q.setString("incidenciaGeradorCredito2", "51");
        q.setString("incidenciaGeradorCredito1", "50");
        q.setString("incidenciaGeradorCredito3", "52");
        q.setString("incidenciaGeradorCredito4", "53");
        q.setString("incidenciaGeradorCredito5", "54");
        q.setString("incidenciaGeradorCredito6", "55");
        q.setString("incidenciaGeradorCredito7", "56");
        q.setString("incidenciaGeradorCredito8", "60");
        q.setString("incidenciaGeradorCredito9", "61");
        q.setString("incidenciaGeradorCredito10", "62");
        q.setString("incidenciaGeradorCredito11", "63");
        q.setString("incidenciaGeradorCredito12", "64");
        q.setString("incidenciaGeradorCredito13", "65");
        q.setString("incidenciaGeradorCredito14", "66");
        q.setString("cfopBonificacao1", "1.910");
        q.setString("cfopBonificacao2", "2.910");
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List getNotasPropriasEntradasRegimeNaoCumulativoLivrosFiscaisCofins(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct i.incidenciaPisCofins.codigo as COD_INC_COFINS, sum(lv.vrCofins) as VALOR_COFINS,  sum(lv.vrBCCofins) as VALOR_BC_COFINS,  lv.aliquotaCofins as ALIQ_COFINS from NotaFiscalPropria n  inner join n.itensNotaPropria i inner join i.itemNotaLivroFiscal lv where  n.dataEmissaoNota between :dataIn and :dataFim and n.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and (i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito1 or       i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito2 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito3 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito4 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito5 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito6 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito7 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito8 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito9 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito10 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito11 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito12 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito13 or      i.incidenciaPisCofins.codigo = :incidenciaGeradorCredito14) and (lv.cfop.codigo <> :cfopBonificacao1 and lv.cfop.codigo <> :cfopBonificacao2) and lv.cfop.cfopGeradorCredito = :sim  and lv.cfop.cfopDevolucaoVenda = :sim  and (n.naturezaOperacao.entradaSaida = 0 OR n.naturezaOperacao.entradaSaida = 2) and (n.status = 100) group by  i.incidenciaPisCofins.codigo, lv.aliquotaCofins having sum(lv.vrCofins) > 0  order by lv.aliquotaCofins ");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setString("incidenciaGeradorCredito1", "50");
        q.setString("incidenciaGeradorCredito2", "51");
        q.setString("incidenciaGeradorCredito1", "50");
        q.setString("incidenciaGeradorCredito3", "52");
        q.setString("incidenciaGeradorCredito4", "53");
        q.setString("incidenciaGeradorCredito5", "54");
        q.setString("incidenciaGeradorCredito6", "55");
        q.setString("incidenciaGeradorCredito7", "56");
        q.setString("incidenciaGeradorCredito8", "60");
        q.setString("incidenciaGeradorCredito9", "61");
        q.setString("incidenciaGeradorCredito10", "62");
        q.setString("incidenciaGeradorCredito11", "63");
        q.setString("incidenciaGeradorCredito12", "64");
        q.setString("incidenciaGeradorCredito13", "65");
        q.setString("incidenciaGeradorCredito14", "66");
        q.setString("cfopBonificacao1", "1.910");
        q.setString("cfopBonificacao2", "2.910");
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List temp = q.list();
        for (HashMap h : temp) {
            h.put("COD_NAT_BC_CREDITO", "12");
        }
        for (HashMap h : temp) {
            String codigo = (String)h.get("COD_INC_COFINS");
            String codNatBCCredito = (String)h.get("COD_NAT_BC_CREDITO");
            Double aliqCofins = (Double)h.get("ALIQ_COFINS");
            Double valorCofins = (Double)h.get("VALOR_COFINS");
            Double valorBCCofins = (Double)h.get("VALOR_BC_COFINS");
            Boolean achou = false;
            for (HashMap h2 : dados) {
                String codigo2 = (String)h2.get("COD_INC_COFINS");
                String codNatBCCredito2 = (String)h2.get("COD_NAT_BC_CREDITO");
                Double aliqCofins2 = (Double)h2.get("ALIQ_COFINS");
                Double valorCofins2 = (Double)h2.get("VALOR_COFINS");
                Double valorBCCofins2 = (Double)h2.get("VALOR_BC_COFINS");
                if (!ToolMethods.isEquals((Object)codigo, (Object)codigo2) || !ToolMethods.isEquals((Object)codNatBCCredito, (Object)codNatBCCredito2) || !ToolMethods.isEquals((Object)aliqCofins, (Object)aliqCofins2)) continue;
                h2.put("VALOR_COFINS", valorCofins + valorCofins2);
                h2.put("VALOR_BC_COFINS", valorBCCofins + valorBCCofins2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            dados.add(h);
        }
        return dados;
    }

    private void gerarBlocoMCofinsNaoCumulativoCreditos(ApuracaoCofins cofins, List<HashMap> dadosEntradas) {
        this.gerarBlocoCofinsM500(cofins, dadosEntradas);
        this.abaterCreditosPeriodoApuradoCofins(cofins);
    }

    private void gerarBlocoCofinsM500(ApuracaoCofins cofins, List<HashMap> dadosEntradas) {
        List<ApuracaoCofinsM505> apuracoesM505 = this.gerarBlocoCofinsM505(dadosEntradas);
        ArrayList<ApuracaoCofinsM500> apuracoesM500 = new ArrayList<ApuracaoCofinsM500>();
        for (ApuracaoCofinsM505 apM505 : apuracoesM505) {
            Boolean achou = false;
            for (ApuracaoCofinsM500 apM500 : apuracoesM500) {
                if (!ToolMethods.isEquals((Object)apM505.getAliquotaCofins(), (Object)apM500.getAliquotaCofins()) || !ToolMethods.isEquals((Object)apM505.getCodigoTipoCreditoPisCofins(), (Object)apM500.getCodigoTipoCreditoPisCofins())) continue;
                apM500.setValorBCCredito(Double.valueOf(apM500.getValorBCCredito() + apM505.getValorBCCredito()));
                apM500.setValorTotalCreditoApurado(Double.valueOf(apM500.getValorTotalCreditoApurado() + apM505.getValorCofins()));
                apM500.setValorTotalCreditoDisponivel(Double.valueOf(apM500.getValorTotalCreditoDisponivel() + apM505.getValorCofins()));
                apM500.setValorCreditoDesconto(Double.valueOf(apM500.getValorCreditoDesconto() + apM505.getValorCofins()));
                apM500.getApuracaoCofinsM505().add(apM505);
                apM505.setApuracaoCofinsM500(apM500);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ApuracaoCofinsM500 apM500 = new ApuracaoCofinsM500();
            String codTipoCredito = "";
            if (apM505.getIncidenciaPisCofins().getCodigo().equals("50") || apM505.getIncidenciaPisCofins().getCodigo().equals("53")) {
                codTipoCredito = "101";
            } else if (apM505.getIncidenciaPisCofins().getCodigo().equals("51")) {
                codTipoCredito = "201";
            } else if (apM505.getIncidenciaPisCofins().getCodigo().equals("52")) {
                codTipoCredito = "301";
            }
            apM500.setCodigoTipoCreditoPisCofins(this.getCodigoTipoCreditoPisCofinsFromCodigo(codTipoCredito));
            apM500.setAliquotaCofins(apM505.getAliquotaCofins());
            apM500.setValorBCCredito(apM505.getValorBCCredito());
            apM500.setValorTotalCreditoApurado(apM505.getValorCofins());
            apM500.setValorTotalCreditoDisponivel(apM505.getValorCofins());
            apM500.setValorCreditoDesconto(apM505.getValorCofins());
            apM500.getApuracaoCofinsM505().add(apM505);
            apM505.setApuracaoCofinsM500(apM500);
            apuracoesM500.add(apM500);
        }
        cofins.getApuracaoCofinsM500().addAll(apuracoesM500);
    }

    private List<ApuracaoCofinsM505> gerarBlocoCofinsM505(List<HashMap> dadosEntradas) {
        ArrayList<ApuracaoCofinsM505> apuracoesM505 = new ArrayList<ApuracaoCofinsM505>();
        for (HashMap h : dadosEntradas) {
            String codCST = (String)h.get("COD_INC_COFINS");
            String codNatBCCred = (String)h.get("COD_NAT_BC_CREDITO");
            Double valorCofins = ToolFormatter.arrredondarNumero((Double)((Double)h.get("VALOR_COFINS")), (int)2);
            Double valorBCCofins = ToolFormatter.arrredondarNumero((Double)((Double)h.get("VALOR_BC_COFINS")), (int)2);
            Double aliqCofins = ToolFormatter.arrredondarNumero((Double)((Double)h.get("ALIQ_COFINS")), (int)2);
            valorCofins = ToolFormatter.arrredondarNumero((Double)(valorBCCofins * (aliqCofins / 100.0)), (int)2);
            ApuracaoCofinsM505 ap = new ApuracaoCofinsM505();
            ap.setNaturezaBCCredito(this.getNaturezaBCCredFromCodigo(codNatBCCred));
            ap.setIncidenciaPisCofins(this.getIncidenciaPisCofinsFromCodigo(codCST));
            ap.setAliquotaCofins(aliqCofins);
            ap.setValorCofins(valorCofins);
            ap.setValorBCCofins(valorBCCofins);
            ap.setValorBCCumulativa(Double.valueOf(0.0));
            ap.setValorBCNaoCumulativa(Double.valueOf(ap.getValorBCCofins() - ap.getValorBCCumulativa()));
            ap.setValorBCCredito(ap.getValorBCNaoCumulativa());
            String codTipoCredito = "";
            if (ap.getIncidenciaPisCofins().getCodigo().equals("50") || ap.getIncidenciaPisCofins().getCodigo().equals("53")) {
                codTipoCredito = "101";
            } else if (ap.getIncidenciaPisCofins().getCodigo().equals("51")) {
                codTipoCredito = "201";
            } else if (ap.getIncidenciaPisCofins().getCodigo().equals("52")) {
                codTipoCredito = "301";
            }
            ap.setCodigoTipoCreditoPisCofins(this.getCodigoTipoCreditoPisCofinsFromCodigo(codTipoCredito));
            apuracoesM505.add(ap);
        }
        return this.aglutinarBlocoCofinsM505(apuracoesM505);
    }

    private List<ApuracaoCofinsM505> aglutinarBlocoCofinsM505(List<ApuracaoCofinsM505> apuracoesM505) {
        ArrayList<ApuracaoCofinsM505> apuracoesNew = new ArrayList<ApuracaoCofinsM505>();
        for (ApuracaoCofinsM505 apOld : apuracoesM505) {
            Boolean achou = false;
            for (ApuracaoCofinsM505 apNew : apuracoesNew) {
                if (!ToolMethods.isEquals((Object)apOld.getNaturezaBCCredito(), (Object)apNew.getNaturezaBCCredito()) || !ToolMethods.isEquals((Object)apOld.getIncidenciaPisCofins(), (Object)apNew.getIncidenciaPisCofins()) || !ToolMethods.isEquals((Object)apOld.getAliquotaCofins(), (Object)apNew.getAliquotaCofins()) || !ToolMethods.isEquals((Object)apOld.getCodigoTipoCreditoPisCofins(), (Object)apNew.getCodigoTipoCreditoPisCofins())) continue;
                apNew.setValorBCCredito(Double.valueOf(apNew.getValorBCCredito() + apOld.getValorBCCredito()));
                apNew.setValorBCCumulativa(Double.valueOf(apNew.getValorBCCumulativa() + apOld.getValorBCCumulativa()));
                apNew.setValorBCNaoCumulativa(Double.valueOf(apNew.getValorBCNaoCumulativa() + apOld.getValorBCNaoCumulativa()));
                apNew.setValorBCCofins(Double.valueOf(apNew.getValorBCCofins() + apOld.getValorBCCofins()));
                apNew.setValorCofins(Double.valueOf(apNew.getValorCofins() + apOld.getValorCofins()));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            ApuracaoCofinsM505 ap = new ApuracaoCofinsM505();
            ap.setAliquotaCofins(apOld.getAliquotaCofins());
            ap.setValorCofins(apOld.getValorCofins());
            ap.setNaturezaBCCredito(apOld.getNaturezaBCCredito());
            ap.setIncidenciaPisCofins(apOld.getIncidenciaPisCofins());
            ap.setValorBCCredito(apOld.getValorBCCredito());
            ap.setValorBCCumulativa(apOld.getValorBCCumulativa());
            ap.setValorBCNaoCumulativa(apOld.getValorBCNaoCumulativa());
            ap.setValorBCCofins(apOld.getValorBCCofins());
            ap.setCodigoTipoCreditoPisCofins(apOld.getCodigoTipoCreditoPisCofins());
            apuracoesNew.add(ap);
        }
        return apuracoesNew;
    }

    private void abaterCreditosPeriodoApuradoCofins(ApuracaoCofins cofins) {
        Double valorContribNaoCumulativa = 0.0;
        for (ApuracaoCofinsM600 m600 : cofins.getApuracaoCofinsM600()) {
            valorContribNaoCumulativa = valorContribNaoCumulativa + m600.getValorContribNaoCumulativaPeriodo();
        }
        Double valorDeduzir = 0.0;
        for (ApuracaoCofinsM500 m500 : cofins.getApuracaoCofinsM500()) {
            Double valor = m500.getValorTotalCreditoDisponivel();
            if (valor > valorContribNaoCumulativa) {
                Double dif = valor - valorContribNaoCumulativa;
                m500.setValorCreditoDesconto(valorContribNaoCumulativa);
                m500.setValorSaldoCreditoFuturo(dif);
                m500.setIndicadorDescontoCredito(new Short("1"));
                valorDeduzir = valorDeduzir + valorContribNaoCumulativa;
                continue;
            }
            valorContribNaoCumulativa = valorContribNaoCumulativa - valor;
            valorDeduzir = valorDeduzir + valor;
        }
        for (ApuracaoCofinsM600 m600 : cofins.getApuracaoCofinsM600()) {
            m600.setValorCreditoDescontado(valorDeduzir);
            m600.setValorContribNaoCumulativaDevida(Double.valueOf(m600.getValorContribNaoCumulativaPeriodo() - m600.getValorCreditoDescontado() - m600.getValorCreditoDescontadoAnterior()));
            m600.setValorContribNaoCumulativaRecolher(Double.valueOf(m600.getValorContribNaoCumulativaDevida() - m600.getValorRetidoFonteNaoCumulativo() - m600.getValorOutrasDeducoesNaoCumulativo()));
            m600.setValorTotalRecolher(Double.valueOf(m600.getValorContribCumulativaRecolher() + m600.getValorContribNaoCumulativaRecolher()));
            if (m600.getValorTotalRecolher() == 0.0) {
                m600.getApuracaoCofinsM605().clear();
                continue;
            }
            for (ApuracaoCofinsM605 m605 : m600.getApuracaoCofinsM605()) {
                m605.setValorDebito(m600.getValorTotalRecolher());
            }
        }
    }

    private List<HashMap> agruparDetalhamentoReceitasIsentasAliquotaZeroSuspensao(List<HashMap> lista) {
        ArrayList<HashMap> novaLista = new ArrayList<HashMap>();
        for (HashMap h : lista) {
            Long idNatReceita = (Long)h.get("ID_NAT_RECEITA_PIS_COFINS");
            Double valor = (Double)h.get("VALOR_REC_AUFERIDA");
            Boolean achou = false;
            for (HashMap h2 : novaLista) {
                Long idNatReceita2 = (Long)h2.get("ID_NAT_RECEITA_PIS_COFINS");
                Double valor2 = (Double)h2.get("VALOR_REC_AUFERIDA");
                if (!ToolMethods.isEquals((Object)idNatReceita, (Object)idNatReceita2)) continue;
                h2.put("VALOR_REC_AUFERIDA", valor + valor2);
                achou = true;
            }
            if (achou.booleanValue()) continue;
            HashMap<String, Number> hh = new HashMap<String, Number>();
            hh.put("ID_NAT_RECEITA_PIS_COFINS", idNatReceita);
            hh.put("VALOR_REC_AUFERIDA", valor);
            novaLista.add(hh);
        }
        return novaLista;
    }

    private void getVendasRPSRegimeCumulativo(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorLiquidoNfse) as VALOR_REC_AUFERIDA, lv.incidenciaPisCofins.codigo as COD_INC_PIS, sum(lv.valorPis) as VALOR_PIS,  sum(lv.bcPis) as VALOR_BC_PIS,  lv.aliquotaPis as ALIQ_PIS, lv.incidenciaPisCofins.codigo as COD_INC_COFINS, sum(lv.valorCofins) as VALOR_COFINS,  sum(lv.bcCofins) as VALOR_BC_COFINS,  lv.aliquotaCofins as ALIQ_COFINS from Rps lv where lv.dataEmissao between :dataIn and :dataFim and  lv.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and lv.status <> :cancelado group by lv.incidenciaPisCofins.codigo, lv.aliquotaPis, lv.incidenciaPisCofins.codigo, lv.aliquotaCofins");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("cancelado", (short)2);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lancamentos = q.list();
        for (HashMap lanc : lancamentos) {
            String codPis = (String)lanc.get("COD_INC_PIS");
            String codCofins = (String)lanc.get("COD_INC_COFINS");
            Double aliqPis = (Double)lanc.get("ALIQ_PIS");
            Double aliqCofins = (Double)lanc.get("ALIQ_COFINS");
            Boolean achou = false;
            for (HashMap h : dados) {
                String codPis2 = (String)h.get("COD_INC_PIS");
                String codCofins2 = (String)h.get("COD_INC_COFINS");
                Double aliqPis2 = (Double)h.get("ALIQ_PIS");
                Double aliqCofins2 = (Double)h.get("ALIQ_COFINS");
                if (!codPis.equals(codPis2) || !codCofins.equals(codCofins2) || !aliqPis.equals(aliqPis2) || !aliqCofins.equals(aliqCofins2)) continue;
                h.put("VALOR_REC_AUFERIDA", (Double)h.get("VALOR_REC_AUFERIDA") + (Double)lanc.get("VALOR_REC_AUFERIDA"));
                h.put("VALOR_PIS", (Double)h.get("VALOR_PIS") + (Double)lanc.get("VALOR_PIS"));
                h.put("VALOR_BC_PIS", (Double)h.get("VALOR_BC_PIS") + (Double)lanc.get("VALOR_BC_PIS"));
                h.put("VALOR_COFINS", (Double)h.get("VALOR_COFINS") + (Double)lanc.get("VALOR_COFINS"));
                h.put("VALOR_BC_COFINS", (Double)h.get("VALOR_BC_COFINS") + (Double)lanc.get("VALOR_BC_COFINS"));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            dados.add(lanc);
        }
    }

    private void getVendasRPSRegimeNaoCumulativo(GrupoEmpresa grupoEmpresa, Date dataIn, Date dataFim, List<HashMap> dados) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct sum(lv.valorLiquidoNfse) as VALOR_REC_AUFERIDA, lv.incidenciaPisCofins.codigo as COD_INC_PIS, sum(lv.valorPis) as VALOR_PIS,  sum(lv.bcPis) as VALOR_BC_PIS,  lv.aliquotaPis as ALIQ_PIS, lv.incidenciaPisCofins.codigo as COD_INC_COFINS, sum(lv.valorCofins) as VALOR_COFINS,  sum(lv.bcCofins) as VALOR_BC_COFINS,  lv.aliquotaCofins as ALIQ_COFINS from Rps lv where lv.dataEmissao between :dataIn and :dataFim and  lv.empresa.empresaDados.grupoEmpresa = :grupoEmpresa and lv.status <> :cancelado group by lv.incidenciaPisCofins.codigo, lv.aliquotaPis, lv.incidenciaPisCofins.codigo, lv.aliquotaCofins");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setShort("cancelado", (short)2);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lancamentos = q.list();
        for (HashMap lanc : lancamentos) {
            String codPis = (String)lanc.get("COD_INC_PIS");
            String codCofins = (String)lanc.get("COD_INC_COFINS");
            Double aliqPis = (Double)lanc.get("ALIQ_PIS");
            Double aliqCofins = (Double)lanc.get("ALIQ_COFINS");
            Boolean achou = false;
            for (HashMap h : dados) {
                String codPis2 = (String)h.get("COD_INC_PIS");
                String codCofins2 = (String)h.get("COD_INC_COFINS");
                Double aliqPis2 = (Double)h.get("ALIQ_PIS");
                Double aliqCofins2 = (Double)h.get("ALIQ_COFINS");
                if (!codPis.equals(codPis2) || !codCofins.equals(codCofins2) || !aliqPis.equals(aliqPis2) || !aliqCofins.equals(aliqCofins2)) continue;
                h.put("VALOR_REC_AUFERIDA", (Double)h.get("VALOR_REC_AUFERIDA") + (Double)lanc.get("VALOR_REC_AUFERIDA"));
                h.put("VALOR_PIS", (Double)h.get("VALOR_PIS") + (Double)lanc.get("VALOR_PIS"));
                h.put("VALOR_BC_PIS", (Double)h.get("VALOR_BC_PIS") + (Double)lanc.get("VALOR_BC_PIS"));
                h.put("VALOR_COFINS", (Double)h.get("VALOR_COFINS") + (Double)lanc.get("VALOR_COFINS"));
                h.put("VALOR_BC_COFINS", (Double)h.get("VALOR_BC_COFINS") + (Double)lanc.get("VALOR_BC_COFINS"));
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            dados.add(lanc);
        }
    }
}

