/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaovlrcontato;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemGrupoApuracaoVlrContSistemas;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoRps;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.RegimeEspecialTributacaoRPS;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.apuracaovlrcontato.UtilCalculoApuracaoVlrContSistemas;
import mentorcore.service.impl.apuracaovlrcontato.UtilCalculoOutrosServicos;
import mentorcore.service.impl.apuracaovlrcontato.UtilGerarRPS;

public class ServiceApuracaoVlrContSistemas
extends CoreService {
    public static final String FIND_DADOS_APURACAO = "findDadosApuracao";
    public static final String FIND_DADOS_AP_VALORES_CLIENTES_ESPECIFICOS = "findDadosApValoresClienteEspecificos";
    public static final String FIND_DADOS_APURACAO_POR_CLIENTE_FINANCEIRO = "findDadosApuracaoPorClienteFinanceiro";
    public static final String CALCULAR_VALOR_RELACIONAMENTO = "calcularValorRelacionamento";
    public static final String GERAR_RPS_MENSAL = "gerarRPSMensal";

    public List findDadosApuracao(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Date dataLimite = (Date)request.getAttribute("dataLimite");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        new UtilCalculoApuracaoVlrContSistemas().validarAtendimentosADefinir(dataInicial, dataFinal);
        return new UtilCalculoApuracaoVlrContSistemas().findDadosApuracao(dataInicial, dataFinal, dataLimite, empresa);
    }

    public List findDadosApValoresClienteEspecificos(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Date dataLimite = (Date)request.getAttribute("dataLimite");
        List clientes = (List)request.getAttribute("clientes");
        new UtilCalculoApuracaoVlrContSistemas().validarAtendimentosADefinir(dataInicial, dataFinal);
        return new UtilCalculoApuracaoVlrContSistemas().findDadosApuracao(dataInicial, dataFinal, dataLimite, clientes);
    }

    public Object findDadosApuracaoPorClienteFinanceiro(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Date dataLimite = (Date)request.getAttribute("dataLimite");
        ItemGrupoApuracaoVlrContSistemas item = (ItemGrupoApuracaoVlrContSistemas)request.getAttribute("itemApuracao");
        return new UtilCalculoApuracaoVlrContSistemas().findDadosApuracaoPorCliente(dataInicial, dataFinal, dataLimite, item);
    }

    public Object calcularValorRelacionamento(CoreRequestContext request) {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        RelPessoaContato relPessoaContato = (RelPessoaContato)request.getAttribute("relPessoaContato");
        return new UtilCalculoOutrosServicos().calcularValorRelacionamento(relPessoaContato, dataInicial, dataFinal);
    }

    public Object gerarRPSMensal(CoreRequestContext cq) throws Exception {
        ItemGrupoApuracaoVlrContSistemas itemGrupo = (ItemGrupoApuracaoVlrContSistemas)cq.getAttribute("itemGrupo");
        CondicoesPagamento condicoesPagamento = (CondicoesPagamento)cq.getAttribute("condicoesPagamento");
        NaturezaOperacaoRps naturezaOperacaoRps = (NaturezaOperacaoRps)cq.getAttribute("naturezaOperacaoRps");
        Short modoArredondamento = (Short)cq.getAttribute("modoArredondamento");
        RegimeEspecialTributacaoRPS regimeEspecialTributacaoRPS = (RegimeEspecialTributacaoRPS)cq.getAttribute("regimeEspecialTributacao");
        Empresa emp = (Empresa)cq.getAttribute("empresa");
        OpcoesFaturamentoNFSe opcoesFaturamentoNFSe = (OpcoesFaturamentoNFSe)cq.getAttribute("opcoesFaturamentoNFSe");
        OpcoesContabeis opCont = (OpcoesContabeis)cq.getAttribute("opcoesContabeis");
        if ((itemGrupo.getValorMensal() > 0.0 || itemGrupo.getValorOutrosServicos() > 0.0) && (itemGrupo.getRpsMensal() == null || itemGrupo.getRpsMensal().getNumeroNFse() == null || itemGrupo.getRpsMensal().getNumeroNFse() <= 0L)) {
            itemGrupo.setRpsMensal(new UtilGerarRPS().getRpsMensal(itemGrupo, condicoesPagamento, naturezaOperacaoRps, emp, modoArredondamento, regimeEspecialTributacaoRPS, opcoesFaturamentoNFSe, opCont));
        }
        if (itemGrupo.getValorVenda() > 0.0 && (itemGrupo.getRpsVenda() == null || itemGrupo.getRpsVenda().getNumeroNFse() == null || itemGrupo.getRpsVenda().getNumeroNFse() <= 0L)) {
            itemGrupo.setRpsVenda(new UtilGerarRPS().getRpsVendas(itemGrupo, condicoesPagamento, naturezaOperacaoRps, emp, modoArredondamento, regimeEspecialTributacaoRPS, opcoesFaturamentoNFSe, opCont));
        }
        return itemGrupo;
    }
}

