/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaovlrcontato;

import com.touchcomp.basementor.constants.enums.procedenciasolicitacao.EnumProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.CustoMensal;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemGrupoApuracaoVlrContSistemas;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.apuracaovlrcontato.UtilCalculoOutrosServicos;
import mentorcore.service.impl.apuracaovlrcontato.UtilCalculoReembolsos;
import mentorcore.service.impl.apuracaovlrcontato.UtilCalculoValoresVenda;
import mentorcore.service.impl.apuracaovlrcontato.UtilValoresCredDeb;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilCalculoApuracaoVlrContSistemas {
    List findDadosApuracao(Date dataInicial, Date dataFinal, Date dataLimite, List clientes) throws ExceptionDatabase, ExceptionService {
        ArrayList<ItemGrupoApuracaoVlrContSistemas> apuracoes = new ArrayList<ItemGrupoApuracaoVlrContSistemas>();
        for (Object o : clientes) {
            ClienteFinancContSistemas c = (ClienteFinancContSistemas)o;
            ItemGrupoApuracaoVlrContSistemas vo = new ItemGrupoApuracaoVlrContSistemas();
            vo.setClienteFinancContSistemas(c);
            vo.setCustoMensal(this.findValorMensal(c, dataInicial, dataFinal));
            if (vo.getCustoMensal() != null) {
                vo.setValorMensal(vo.getCustoMensal().getValor());
            }
            new UtilCalculoReembolsos().findAndProcessValoresReembolsos(c, dataInicial, dataFinal, vo);
            new UtilCalculoOutrosServicos().findAndProcessValoresOutrosServicos(c, dataInicial, dataFinal, vo);
            new UtilValoresCredDeb().findAndProcessValoresCredDeb(c, dataLimite, vo);
            new UtilCalculoValoresVenda().findAndProcessValoresVenda(c, dataLimite, vo);
            vo.setValorTotal(Double.valueOf(vo.getValorMensal() + vo.getValorOutrosServicos() + vo.getValorReembolso() + vo.getValorRenegociacao() + vo.getValorVenda() - vo.getValorCredito()));
            apuracoes.add(vo);
        }
        return apuracoes;
    }

    List findDadosApuracao(Date dataInicial, Date dataFinal, Date dataLimite, Empresa empresa) throws ExceptionDatabase, ExceptionService {
        List clientes = this.findClientesFinanceirosContSistemas(empresa);
        return this.findDadosApuracao(dataInicial, dataFinal, dataLimite, clientes);
    }

    Object findDadosApuracaoPorCliente(Date dataInicial, Date dataFinal, Date dataLimite, ItemGrupoApuracaoVlrContSistemas vo) throws ExceptionDatabase, ExceptionService {
        ClienteFinancContSistemas c = vo.getClienteFinancContSistemas();
        vo.setClienteFinancContSistemas(c);
        vo.setCustoMensal(this.findValorMensal(c, dataInicial, dataFinal));
        if (vo.getCustoMensal() != null) {
            vo.setValorMensal(vo.getCustoMensal().getValor());
        } else {
            vo.setValorMensal(Double.valueOf(0.0));
        }
        new UtilCalculoReembolsos().findAndProcessValoresReembolsos(c, dataInicial, dataFinal, vo);
        new UtilCalculoOutrosServicos().findAndProcessValoresOutrosServicos(c, dataInicial, dataFinal, vo);
        new UtilValoresCredDeb().findAndProcessValoresCredDeb(c, dataLimite, vo);
        new UtilCalculoValoresVenda().findAndProcessValoresVenda(c, dataLimite, vo);
        vo.setValorTotal(Double.valueOf(vo.getValorMensal() + vo.getValorOutrosServicos() + vo.getValorReembolso() + vo.getValorRenegociacao() + vo.getValorVenda() + vo.getValorDebito() - vo.getValorCredito()));
        return vo;
    }

    private List findClientesFinanceirosContSistemas(Empresa empresa) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct c from ClienteFinancContSistemas c inner join fetch c.clienteContSistemas cs inner join cs.tomadorPrestadorRps t inner join t.pessoa p where c.ativo = :sim and cs.empresa = :empresa";
        Query q = s.createQuery(hql);
        q.setShort("sim", (short)1);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    private CustoMensal findValorMensal(ClienteFinancContSistemas c, Date dataInicial, Date dataFinal) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select c from CustoMensal c where c.clienteFinancContSistemas = :clienteFinanc  and :dataFinal between c.dataInicial and c.dataFinal  and c.clienteFinancContSistemas.clienteContSistemas.tomadorPrestadorRps.pessoa.ativo = :sim order by c.dataFinal";
        Query q = s.createQuery(hql);
        q.setEntity("clienteFinanc", (Object)c);
        q.setShort("sim", (short)1);
        q.setDate("dataFinal", dataFinal);
        System.out.println(c.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
        List resultado = q.list();
        if (resultado.size() > 1) {
            // empty if block
        }
        if (resultado.size() > 0) {
            return (CustoMensal)resultado.get(0);
        }
        return null;
    }

    public void validarAtendimentosADefinir(Date dataInicial, Date dataFinal) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = " select count(r) from RelPessoaContato r where  r.dataFinalizacao between :dataInicial and :dataFinal and r.finalizado = :finalizado and r.procedenciaSolicitacaoContato.tipoProcedencia = :temporaria";
        Query q = s.createQuery(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("finalizado", (short)1);
        q.setShort("temporaria", EnumProcedenciaSolicitacao.TEMPORARIA.getValue());
        Long nr = (Long)q.uniqueResult();
        if (nr > 0L) {
            throw new ExceptionService("Existem atendimentos finalizados com proced\u00eancia tempor\u00e1ria informada.");
        }
    }
}

