/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaovlrcontato;

import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.CustoOutrosServicos;
import com.touchcomp.basementor.model.vo.ItemGrupoApuracaoVlrContSistemas;
import com.touchcomp.basementor.model.vo.ItemOutrosServicosApuracao;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacaoContato;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.RelPessoaContatoLog;
import com.touchcomp.basementor.model.vo.RelPessoaContatoVenda;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementorvalidator.entities.impl.relpessoacontato.ValidRelPessoaContato;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Session;
import org.hibernate.query.Query;

class UtilCalculoOutrosServicos {
    ValidRelPessoaContato valid = (ValidRelPessoaContato)Context.get(ValidRelPessoaContato.class);

    UtilCalculoOutrosServicos() {
    }

    public void findAndProcessValoresOutrosServicos(ClienteFinancContSistemas c, Date dataInicial, Date dataFinal, ItemGrupoApuracaoVlrContSistemas vo) throws ExceptionDatabase, ExceptionService {
        this.valid.clearContainer();
        List<CustoOutrosServicos> itens = this.findItemValoresOutrosServicos(c, dataInicial, dataFinal, vo);
        this.processarValoresOutrosServicos(itens, c, dataInicial, dataFinal, vo);
        if (this.valid.hasErrors()) {
            throw new ExceptionService(this.valid.getContainer().asString());
        }
    }

    private List<CustoOutrosServicos> findItemValoresOutrosServicos(ClienteFinancContSistemas c, Date dataInicial, Date dataFinal, ItemGrupoApuracaoVlrContSistemas vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "from CustoOutrosServicos c where c.clienteFinancContSistemas = :clienteFinanc and :dataFinal between c.dataInicial and c.dataFinal  order by c.dataFinal";
        Query q = s.createQuery(hql);
        q.setEntity("clienteFinanc", (Object)c);
        q.setDate("dataFinal", dataFinal);
        List lista = q.list();
        return lista;
    }

    private void processarValoresOutrosServicos(List<CustoOutrosServicos> lista, ClienteFinancContSistemas c, Date dataInicial, Date dataFinal, ItemGrupoApuracaoVlrContSistemas vo) throws ExceptionService {
        ArrayList<ItemOutrosServicosApuracao> itens = new ArrayList<ItemOutrosServicosApuracao>();
        Double valorTotalOutrosServicos = 0.0;
        Iterator<CustoOutrosServicos> iterator = lista.iterator();
        while (iterator.hasNext()) {
            CustoOutrosServicos o;
            CustoOutrosServicos custo = o = iterator.next();
            ItemOutrosServicosApuracao i = new ItemOutrosServicosApuracao();
            i.setProcSolicitacaoContato(custo.getProcedenciaSolicitacao());
            i.setItemGrupoApuracaoVlrContSistemas(vo);
            List<RelPessoaContato> relacionamentos = this.findRelacionamentoPorProcSolicitacao(dataInicial, dataFinal, c, i.getProcSolicitacaoContato(), vo.getIdentificador());
            i.setItemOutrosServicosApurVinc(this.buildRelVenda(relacionamentos, i));
            Double tempoRel = this.processarRelacioanamentosBancoHorasServicos(i.getItemOutrosServicosApurVinc());
            i.setValor(Double.valueOf(custo.getValor() * tempoRel));
            valorTotalOutrosServicos = valorTotalOutrosServicos + i.getValor();
            itens.add(i);
        }
        vo.setItensOutrosServicosApuracao(itens);
        vo.setValorOutrosServicos(valorTotalOutrosServicos);
    }

    private Double processarRelacioanamentosBancoHorasServicos(List<RelPessoaContatoVenda> itens) throws ExceptionService {
        Double tempo = 0.0;
        for (RelPessoaContatoVenda o : itens) {
            tempo = tempo + this.processarTempoFaturar(o);
        }
        return tempo;
    }

    public Double processarTempoFaturar(RelPessoaContatoVenda vo) throws ExceptionService {
        if (vo.getVendaServicosTouch().getTipoVenda() == 3) {
            return 0.0;
        }
        if (vo.getVendaServicosTouch().getTipoVenda() == 2) {
            return 0.0;
        }
        if (vo.getVendaServicosTouch().getTipoVenda() == 4) {
            return vo.getRelPessoaContato().getTempoTotalCobranca();
        }
        throw new ExceptionService("Tipo de Venda associado " + String.valueOf(vo.getRelPessoaContato()) + " \u00e9 invalido para ser vinculado a um faturamento.");
    }

    Double calcularValorRelacionamento(RelPessoaContato relPessoaContato, Date dataInicial, Date dataFinal) {
        Double valorCustoOutrosServicos = this.findValorCustoOutrosServicos(relPessoaContato, dataInicial, dataFinal);
        Double tempoRelacionamento = this.findTempoDuracaoRelacionamento(relPessoaContato);
        return valorCustoOutrosServicos * tempoRelacionamento;
    }

    private Double findValorCustoOutrosServicos(RelPessoaContato relPessoaContato, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select c.valor from CustoOutrosServicos c where c.clienteFinancContSistemas.clienteContSistemas = :clienteContato and c.procedenciaSolicitacao = :procSolicitacao and :dataFinal between c.dataInicial and c.dataFinal ";
        Query q = s.createQuery(hql);
        q.setEntity("clienteContato", (Object)relPessoaContato.getClienteContSistemas());
        q.setEntity("procSolicitacao", (Object)relPessoaContato.getProcedenciaSolicitacaoContato());
        q.setDate("dataFinal", dataFinal);
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            return 0.0;
        }
        return valor;
    }

    private Double findTempoDuracaoRelacionamento(RelPessoaContato relPessoaContato) {
        Double tempo = 0.0;
        for (Object o : relPessoaContato.getAgendamentos()) {
            RelPessoaContatoLog r = (RelPessoaContatoLog)o;
            tempo = tempo + r.getTempoDispendiado();
        }
        return tempo;
    }

    private List<RelPessoaContato> findRelacionamentoPorProcSolicitacao(Date dataInicial, Date dataFinal, ClienteFinancContSistemas c, ProcedenciaSolicitacaoContato procSolicitacaoContato, Long idGrupoApuracao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select r from RelPessoaContato r where r.clienteContSistemas = :cliente and cast(r.dataFinalizacao as date) between :dataInicial and :dataFinal and r.finalizado = :finalizado and r.procedenciaSolicitacaoContato = :procSolicitacaoContato";
        if (idGrupoApuracao != null) {
            hql = (String)hql + " or itemGrupo.identificador = :idGrupoApuracao)";
        }
        Query q = s.createQuery((String)hql);
        q.setEntity("cliente", (Object)c.getClienteContSistemas());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("finalizado", (short)1);
        q.setEntity("procSolicitacaoContato", (Object)procSolicitacaoContato);
        if (idGrupoApuracao != null) {
            q.setLong("idGrupoApuracao", idGrupoApuracao.longValue());
        }
        List lista = q.list();
        return lista;
    }

    private List<RelPessoaContatoVenda> buildRelVenda(List<RelPessoaContato> relacionamentos, ItemOutrosServicosApuracao i) {
        LinkedList<RelPessoaContatoVenda> all = new LinkedList<RelPessoaContatoVenda>();
        for (RelPessoaContato rel : relacionamentos) {
            this.valid.validarVendasVinculadas(rel);
            for (RelPessoaContatoVenda vv : rel.getVendasVinculadas()) {
                if (vv.getItemOutrosServicosApuracao() != null) continue;
                all.add(vv);
            }
        }
        return all;
    }
}

