/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaovlrcontato;

import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.ItemGrupoApuracaoVlrContSistemas;
import com.touchcomp.basementor.model.vo.ItemReembolsoApuracao;
import com.touchcomp.basementor.model.vo.ItemReembolsoApuracaoVinc;
import com.touchcomp.basementor.model.vo.ReembolsoContSistemas;
import com.touchcomp.basementor.model.vo.TipoReembolsoContSistemas;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilCalculoReembolsos {
    public void findAndProcessValoresReembolsos(ClienteFinancContSistemas c, Date dataInicial, Date dataFinal, ItemGrupoApuracaoVlrContSistemas vo) throws ExceptionDatabase {
        List itens = this.findItemValoresReembolsos(c, dataInicial, dataFinal, vo);
        this.processarValoresReembolsos(itens, c, dataInicial, dataFinal, vo);
    }

    private List findItemValoresReembolsos(ClienteFinancContSistemas c, Date dataInicial, Date dataFinal, ItemGrupoApuracaoVlrContSistemas vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select sum(r.valor) as VALOR, r.tipoReembolso.identificador as TIPO_REEMBOLSO from ReembolsoContSistemas r left join r.itemReembolsoApuracaoVinc                    as itemVinc left join itemVinc.itemReembolsoApuracao                 as itemReembolso left join itemReembolso.itemGrupoApuracaoVlrContSistemas as itemGrupo where r.relPessoaContato.clienteContSistemas = :cliente and (r.naoGerarFinanceiroCliente is null or r.naoGerarFinanceiroCliente = :nao) and cast(r.relPessoaContato.dataFinalizacao as date) between :dataInicial and :dataFinal and (itemVinc is null";
        hql = vo.getIdentificador() != null ? (String)hql + " or itemGrupo.identificador = :idGrupoApuracao)" : (String)hql + ")";
        hql = (String)hql + " group by r.tipoReembolso.identificador";
        Query q = s.createQuery((String)hql);
        q.setEntity("cliente", (Object)c.getClienteContSistemas());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("nao", (short)0);
        if (vo.getIdentificador() != null) {
            q.setLong("idGrupoApuracao", vo.getIdentificador().longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        return lista;
    }

    private void processarValoresReembolsos(List lista, ClienteFinancContSistemas c, Date dataInicial, Date dataFinal, ItemGrupoApuracaoVlrContSistemas vo) throws ExceptionDatabase {
        Double valorTotalReembolso = 0.0;
        ArrayList<ItemReembolsoApuracao> itens = new ArrayList<ItemReembolsoApuracao>();
        if (lista != null && !lista.isEmpty()) {
            for (Object o : lista) {
                HashMap h = (HashMap)o;
                ItemReembolsoApuracao i = new ItemReembolsoApuracao();
                i.setValor((Double)h.get("VALOR"));
                valorTotalReembolso = valorTotalReembolso + i.getValor();
                i.setTipoReembolso((TipoReembolsoContSistemas)CoreDAOFactory.getInstance().getDAOTipoReembolsoContSistemas().findByPrimaryKey((Long)h.get("TIPO_REEMBOLSO")));
                i.setItemGrupoApuracaoVlrContSistemas(vo);
                List<ReembolsoContSistemas> reembolsos = this.findReembolsosPorTipoReembolso(dataInicial, dataFinal, c, i.getTipoReembolso(), vo.getIdentificador());
                ArrayList<ItemReembolsoApuracaoVinc> reembolsosVinc = new ArrayList<ItemReembolsoApuracaoVinc>();
                Iterator<ReembolsoContSistemas> iterator = reembolsos.iterator();
                while (iterator.hasNext()) {
                    ReembolsoContSistemas ob;
                    ReembolsoContSistemas r = ob = iterator.next();
                    ItemReembolsoApuracaoVinc vinc = new ItemReembolsoApuracaoVinc();
                    vinc.setItemReembolsoApuracao(i);
                    vinc.setReembolsoContSistemas(r);
                    reembolsosVinc.add(vinc);
                }
                i.setItemReembolsoApuracaoVinc(reembolsosVinc);
                itens.add(i);
            }
        }
        vo.setValorReembolso(valorTotalReembolso);
        vo.setItensReembolsoApuracao(itens);
    }

    private List<ReembolsoContSistemas> findReembolsosPorTipoReembolso(Date dataInicial, Date dataFinal, ClienteFinancContSistemas c, TipoReembolsoContSistemas tipoReembolso, Long idGrupoApuracao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct r from ReembolsoContSistemas r left join r.itemReembolsoApuracaoVinc                    as itemVinc left join itemVinc.itemReembolsoApuracao                 as itemReembolso left join itemReembolso.itemGrupoApuracaoVlrContSistemas as itemGrupo where r.relPessoaContato.clienteContSistemas = :cliente and cast(r.relPessoaContato.dataFinalizacao as date) between :dataInicial and :dataFinal and r.tipoReembolso = :tipoReembolso and (itemVinc is null";
        hql = idGrupoApuracao != null ? (String)hql + " or itemGrupo.identificador = :idGrupoApuracao )" : (String)hql + " )";
        Query q = s.createQuery((String)hql);
        q.setEntity("cliente", (Object)c.getClienteContSistemas());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("tipoReembolso", (Object)tipoReembolso);
        if (idGrupoApuracao != null) {
            q.setLong("idGrupoApuracao", idGrupoApuracao.longValue());
        }
        List lista = q.list();
        return lista;
    }
}

