/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaovlrcontato;

import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.GrApuracaoItemVendaTouch;
import com.touchcomp.basementor.model.vo.ItemGrupoApuracaoVlrContSistemas;
import com.touchcomp.basementor.model.vo.ItemVendaServicosTouch;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

class UtilCalculoValoresVenda {
    UtilCalculoValoresVenda() {
    }

    public void findAndProcessValoresVenda(ClienteFinancContSistemas c, Date dataLimite, ItemGrupoApuracaoVlrContSistemas vo) {
        List itens = this.findItemValoresVenda(c, dataLimite, vo);
        this.processarValoresVenda(itens, vo);
    }

    private List findItemValoresVenda(ClienteFinancContSistemas c, Date dataLimite, ItemGrupoApuracaoVlrContSistemas vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct it from VendaServicosTouch r inner join r.itemVendaServicos it left join it.grApuracaoItemVenda gr left join gr.itemGrupoApuracao i left join i.grupoApuracaoVlrContSistemas g where r.clienteContSistemas = :cliente and (r.cancelado is null or r.cancelado = :nao) and (r.naoTarifar is null or r.naoTarifar = :nao) and it.dataVencimento <=:dataLimite and (i is null";
        hql = vo.getGrupoApuracaoVlrContSistemas() != null && vo.getGrupoApuracaoVlrContSistemas().getIdentificador() != null ? (String)hql + " or g.identificador = :idGrupoApuracao )" : (String)hql + " )";
        Query q = s.createQuery((String)hql);
        q.setEntity("cliente", (Object)c);
        q.setDate("dataLimite", dataLimite);
        q.setShort("nao", (short)0);
        if (vo.getGrupoApuracaoVlrContSistemas() != null && vo.getGrupoApuracaoVlrContSistemas().getIdentificador() != null) {
            q.setLong("idGrupoApuracao", vo.getGrupoApuracaoVlrContSistemas().getIdentificador().longValue());
        }
        List lista = q.list();
        return lista;
    }

    private void processarValoresVenda(List lista, ItemGrupoApuracaoVlrContSistemas vo) {
        double vlrVenda = 0.0;
        double vlrRenegociacao = 0.0;
        double vlrOutrosServicos = 0.0;
        ArrayList<GrApuracaoItemVendaTouch> to = new ArrayList<GrApuracaoItemVendaTouch>();
        for (Object o : lista) {
            ItemVendaServicosTouch cv = (ItemVendaServicosTouch)o;
            GrApuracaoItemVendaTouch gr = new GrApuracaoItemVendaTouch();
            gr.setItemVendaServicos(cv);
            to.add(gr);
            if (cv.getVendaServicosTouch().getTipoVenda() == 0) {
                vlrVenda += cv.getValor().doubleValue();
                continue;
            }
            if (cv.getVendaServicosTouch().getTipoVenda() == 2 || cv.getVendaServicosTouch().getTipoVenda() == 3) {
                vlrOutrosServicos += cv.getValor().doubleValue();
                continue;
            }
            if (cv.getVendaServicosTouch().getTipoVenda() != 1) continue;
            vlrRenegociacao += cv.getValor().doubleValue();
        }
        vo.setValorVenda(Double.valueOf(vlrVenda));
        vo.setValorRenegociacao(Double.valueOf(vlrRenegociacao));
        vo.setValorOutrosServicos(Double.valueOf(vo.getValorOutrosServicos() + vlrOutrosServicos));
        vo.setItemVendaServicosTouch(to);
    }
}

