/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaovlrcontato;

import com.touchcomp.basementor.constants.enums.modelorps.EnumConstStatusRPS;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EnderecoWebServNFSe;
import com.touchcomp.basementor.model.vo.ItemGrupoApuracaoVlrContSistemas;
import com.touchcomp.basementor.model.vo.ItemServicoRPSRPS;
import com.touchcomp.basementor.model.vo.ModeloRPS;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoRps;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RegimeEspecialTributacaoRPS;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilRps;
import com.touchcomp.basementorservice.service.impl.modelorps.ServiceModeloRPSImpl;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibs.ServiceParamTribCbsIbsImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisRPS;

class UtilGerarRPS {
    UtilGerarRPS() {
    }

    public Rps getRpsMensal(ItemGrupoApuracaoVlrContSistemas ig, CondicoesPagamento cd, NaturezaOperacaoRps nat, Empresa emp, Short modoArredondamento, RegimeEspecialTributacaoRPS regimeEspecialTributacao, OpcoesFaturamentoNFSe opcoesFaturamentoNFSe, OpcoesContabeis opCont) throws Exception {
        double valor = ig.getValorMensal() + ig.getValorOutrosServicos();
        if (ig.getClienteFinancContSistemas().getFaturarReembolsos() != null && ig.getClienteFinancContSistemas().getFaturarReembolsos() == 1) {
            double percAjuste = ig.getClienteFinancContSistemas().getPercAjusteImpostos();
            valor += ig.getValorReembolso() + ig.getValorReembolso() * percAjuste / 100.0;
        }
        if (ig.getInfValorFatMensal() != null && ig.getInfValorFatMensal() == 1) {
            valor = ig.getValorFatMensInf();
        }
        return this.getRps(ig.getRpsMensal(), ig, cd, nat, emp, ig.getClienteFinancContSistemas().getServicoRpsFatManut(), valor, modoArredondamento, regimeEspecialTributacao, opcoesFaturamentoNFSe, opCont);
    }

    public Rps getRpsVendas(ItemGrupoApuracaoVlrContSistemas ig, CondicoesPagamento cd, NaturezaOperacaoRps nat, Empresa emp, Short modoArredondamento, RegimeEspecialTributacaoRPS regimeEspecialTributacao, OpcoesFaturamentoNFSe opcoesFaturamentoNFSe, OpcoesContabeis opCont) throws Exception {
        return this.getRps(ig.getRpsVenda(), ig, cd, nat, emp, ig.getClienteFinancContSistemas().getServicoRpsFatVenda(), ig.getValorVenda(), modoArredondamento, regimeEspecialTributacao, opcoesFaturamentoNFSe, opCont);
    }

    public Rps getRps(Rps r, ItemGrupoApuracaoVlrContSistemas ig, CondicoesPagamento cd, NaturezaOperacaoRps nat, Empresa emp, ServicoRPS serv, Double valor, Short modoArredondamento, RegimeEspecialTributacaoRPS regimeEspecialTributacaoRPS, OpcoesFaturamentoNFSe opcoesFaturamentoNFse, OpcoesContabeis opCont) throws Exception {
        if (r == null) {
            r = new Rps();
            r.setRegimeEspTributacao(regimeEspecialTributacaoRPS);
            r.setModoArredondamento(modoArredondamento);
        }
        r.setStatus(Short.valueOf(EnumConstStatusRPS.RPS_NORMAL.getValue()));
        ClienteFinancContSistemas cl = ig.getClienteFinancContSistemas();
        r.setRegimeEspecialRecol(Short.valueOf((short)0));
        r.setUnidadeTomPrestRPS(this.getUnidadeFatPrestadorServ(ig));
        List listaModeloRps = ((ServiceModeloRPSImpl)ConfApplicationContext.getBean(ServiceModeloRPSImpl.class)).pesquisarModeloRpsCategoriaPessoaServicoRps(r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getCategoriaPessoa(), serv, emp);
        ModeloRPS modeloRps = null;
        if (BaseMethods.isWithData((Collection)listaModeloRps)) {
            modeloRps = (ModeloRPS)listaModeloRps.get(0);
        }
        if (modeloRps == null) {
            throw new ExceptionService("N\u00e3o foi encontrado Modelo RPS/NFSe para a Categoria Pessoa " + String.valueOf(r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getCategoriaPessoa()) + " e Servi\u00e7o RPS " + serv.getDiscriminacao());
        }
        r.setAliquotaCofins(modeloRps.getAliquotaCofins());
        r.setAliquotaContSoc(modeloRps.getAliquotaCSLL());
        r.setAliquotaInss(modeloRps.getAliquotaINSS());
        r.setAliquotaIr(modeloRps.getAliquotaIRRF());
        r.setAliquotaIss(modeloRps.getAliquotaISS());
        r.setAliquotaOutros(modeloRps.getAliquotaOutros());
        r.setAliquotaPis(modeloRps.getAliquotaPis());
        r.setDataCadastro(new Date());
        r.setDataEmissao(new Date());
        r.setHoraEmissao(new Date());
        r.setDataExecucaoServico(r.getDataEmissao());
        r.setDestinatario(cl.getClienteContSistemas().getTomadorPrestadorRps().getPessoa());
        r.setDiscriminacao(serv.getDiscriminacao());
        r.setCondicoesPagamento(cd);
        if (r.getCondicoesPagamento() != null) {
            r.setMeioPagamento(r.getCondicoesPagamento().getMeioPagamento());
        }
        r.setEmpresa(emp);
        r.setEnderecoWebServ(this.getEnderecoWebService(emp.getPessoa().getEndereco().getCidade(), opcoesFaturamentoNFse));
        r.setEntradaSaida(modeloRps.getEntradaSaida());
        if (modeloRps == null) {
            throw new ExceptionService("N\u00e3o foi informado modelo de faturamento de servi\u00e7os para o cliente " + cl.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
        }
        r.setEntradaSaida(modeloRps.getEntradaSaida());
        r.setModeloRps(modeloRps);
        r.setServicoRPS(serv);
        if (r.getServicoRPS() != null) {
            r.setNbs(r.getServicoRPS().getNbs());
        }
        r.setCnae(modeloRps.getCnae());
        r.setCodigoTributacaoServ(modeloRps.getCodigoTributacaoServ());
        r.setTaxaTributacaoFederal(serv.getGrupoServicoRPS().getTaxaFederal());
        r.setTaxaTributacaoMunicipal(serv.getGrupoServicoRPS().getTaxaMunicipal());
        r.setNaturezaOperacaoRps(nat);
        r.setSerie(modeloRps.getSerie());
        r.setSituacaoDocumento(this.getSituacaoDocumento());
        r.setValorUnitario(valor);
        r.setTipoRps(modeloRps.getTipoRps());
        if (r.getUnidadeTomPrestRPS() != null) {
            r.setCategoriaPessoa(r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getCategoriaPessoa());
            r.setClassificacaoPessoas(r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getClassificacaoPessoa());
        }
        r.setTipoIss(this.getTipoISS(r));
        r.setTipoPis(modeloRps.getTipoPis());
        r.setTipoCofins(modeloRps.getTipoCofins());
        r.setGerarFinanceiro(r.getModeloRps().getGerarFinanceiro());
        ItemServicoRPSRPS item = CoreUtilityFactory.getUtilityRpsNFSe().buildItem(opcoesFaturamentoNFse.getItemServicoRPSPadrao());
        item.setValor(r.getValorUnitario());
        item.setRps(r);
        r.setItensRps(Arrays.asList(item));
        r.setParamTribCbsIbsClass(((ServiceParamTribCbsIbsImpl)Context.get(ServiceParamTribCbsIbsImpl.class)).getParametrizacaoRpsNFSe(r.getDataEmissao(), r.getEmpresa(), r.getUnidadeTomPrestRPS(), r.getNbs()));
        CalculosImpFiscaisRPS.calcularImpFiscaisRPS(r);
        if (ig.getClienteFinancContSistemas().getClienteContSistemas().getResponsaveisFinanceiros().isEmpty()) {
            throw new ExceptionService("Informe ao menos um respons\u00e1vel financeiro para " + r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getNome());
        }
        r.setEmail(this.getEmailAtivo((Pessoa)ig.getClienteFinancContSistemas().getClienteContSistemas().getResponsaveisFinanceiros().get(0)));
        if (r.getEmail() == null || r.getEmail().trim().length() == 0) {
            throw new ExceptionService("Informe o email ativo para " + r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getNome());
        }
        r.setCidade(r.getEmpresa().getPessoa().getEndereco().getCidade());
        try {
            CompParametrizacaoContabilRps.DadosContas dados = new CompParametrizacaoContabilRps().getPlanoContasNfPropria(r.getModeloRps(), r.getUnidadeTomPrestRPS(), r.getEmpresa(), r.getCategoriaPessoa(), opCont, r.getClassificacaoPessoas());
            r.setPlanoContaCred(dados.getPlanoContaCred());
            r.setPlanoContaDeb(dados.getPlanoContaDeb());
        }
        catch (ExceptionParametrizacao ex) {
            throw new ExceptionService(ex);
        }
        return r;
    }

    private SituacaoDocumento getSituacaoDocumento() throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("codigo", "00");
        return (SituacaoDocumento)CoreServiceFactory.getServiceSituacaoDocumento().execute(cq, "getSituacaoDocumento");
    }

    private UnidadeFatTomPrestRPS getUnidadeFatPrestadorServ(ItemGrupoApuracaoVlrContSistemas r) {
        return (UnidadeFatTomPrestRPS)r.getClienteFinancContSistemas().getClienteContSistemas().getTomadorPrestadorRps().getUnidadesFat().get(0);
    }

    private EnderecoWebServNFSe getEnderecoWebService(Cidade cidade, OpcoesFaturamentoNFSe opcoesFaturamentoNFSe) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("cidade", cidade);
        cq.setAttribute("opcoesFaturamentoNFSe", opcoesFaturamentoNFSe);
        return (EnderecoWebServNFSe)CoreServiceFactory.getServiceRPS().findEnderecoWebserviceCidade(cq);
    }

    private String getEmailAtivo(Pessoa pes) {
        for (EmailPessoa em : pes.getComplemento().getEmails()) {
            if (em.getAtivo() == null || em.getAtivo() != 1) continue;
            return em.getEmail();
        }
        return null;
    }

    private Short getTipoISS(Rps r) {
        if (r.getUnidadeTomPrestRPS() != null && r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getTipoIss() == 0) {
            return (short)0;
        }
        if (r.getUnidadeTomPrestRPS() != null && r.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getTipoIss() == 1) {
            return (short)1;
        }
        return r.getModeloRps().getTipoIss();
    }
}

