/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.apuracaovlrcontato;

import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.CreditoDebitoValorTouch;
import com.touchcomp.basementor.model.vo.GrApuracaoCredDebValorTouch;
import com.touchcomp.basementor.model.vo.ItemGrupoApuracaoVlrContSistemas;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

class UtilValoresCredDeb {
    UtilValoresCredDeb() {
    }

    public void findAndProcessValoresCredDeb(ClienteFinancContSistemas c, Date dataLimite, ItemGrupoApuracaoVlrContSistemas vo) {
        List itens = this.findItemValoresCreditoDebito(c, dataLimite, vo);
        this.processarValoresCredDebito(itens, vo);
    }

    private List findItemValoresCreditoDebito(ClienteFinancContSistemas c, Date dataLimite, ItemGrupoApuracaoVlrContSistemas vo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "select distinct r from CreditoDebitoValorTouch r left join r.grApuracaoCredDeb g left join g.itemGrupoApuracao i left join i.grupoApuracaoVlrContSistemas gg where r.clienteContSistemas = :cliente and cast(r.dataReembolso as date) <=:dataLimite and (g is null";
        hql = vo.getGrupoApuracaoVlrContSistemas() != null && vo.getGrupoApuracaoVlrContSistemas().getIdentificador() != null ? (String)hql + " or gg.identificador = :idGrupoApuracao )" : (String)hql + " )";
        Query q = s.createQuery((String)hql);
        q.setEntity("cliente", (Object)c);
        q.setDate("dataLimite", dataLimite);
        if (vo.getGrupoApuracaoVlrContSistemas() != null && vo.getGrupoApuracaoVlrContSistemas().getIdentificador() != null) {
            q.setLong("idGrupoApuracao", vo.getGrupoApuracaoVlrContSistemas().getIdentificador().longValue());
        }
        List lista = q.list();
        return lista;
    }

    private void processarValoresCredDebito(List lista, ItemGrupoApuracaoVlrContSistemas vo) {
        double vlr = 0.0;
        double vlrDeb = 0.0;
        ArrayList<GrApuracaoCredDebValorTouch> toAdd = new ArrayList<GrApuracaoCredDebValorTouch>();
        for (Object o : lista) {
            CreditoDebitoValorTouch cv = (CreditoDebitoValorTouch)o;
            GrApuracaoCredDebValorTouch gr = new GrApuracaoCredDebValorTouch();
            gr.setCreditoDebitoValor(cv);
            toAdd.add(gr);
            if (cv.getDebCred() == 1) {
                vlr += cv.getValor().doubleValue();
                continue;
            }
            vlrDeb += cv.getValor().doubleValue();
        }
        vo.setValorCredito(Double.valueOf(vlr));
        vo.setValorDebito(Double.valueOf(vlrDeb));
        vo.setCreditoValorTouch(toAdd);
    }
}

