/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.arquivonis;

import com.touchcomp.basementor.model.vo.ArquivoNIS;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.EstadoCivil;
import com.touchcomp.basementor.model.vo.RacaCor;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

public class ArquivoNISWritter {
    private TLogger logger = TLogger.get(this.getClass());
    private long nrOrdemRegistro = 1L;
    private long nrSequencial = 0L;
    private final String COD_ORIGEM_DESTINO = "000000000000000001";
    private final String NIS = "00000000000";
    private final String HEADER_GERAL = "00";
    private final String REGISTRO_DETALHE = "02";
    private final String TRAILER_GERAL = "99";
    private final String FLAG = "00";
    private final String COD_RETORNO = "0000";

    public void gerarArquivoNIS(ArquivoNIS vo, File file) throws ExceptionService {
        try {
            this.nrOrdemRegistro = 1L;
            File file00 = this.createWritterBlock00(vo);
            File file02 = this.createWritterBlock02(vo);
            File file99 = this.createWritterBlock99(vo);
            this.apendToSomeFile(file.getParent(), file00, file02, file99, vo);
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar o arquivo. \n" + ex.getMessage());
        }
    }

    private File createWritterBlock00(ArquivoNIS vo) throws IOException {
        File f = File.createTempFile("nis_bloco_00", ".txt");
        PrintWriter p = new PrintWriter(f);
        this.writterBlocoHeaderGeral00(p, vo);
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlock02(ArquivoNIS vo) throws IOException, ExceptionService {
        File f = File.createTempFile("nis_bloco_02", ".txt");
        PrintWriter p = new PrintWriter(f);
        this.writterBlocoRegistroDetalhe02(p, vo, vo.getColaborador());
        p.flush();
        p.close();
        return f;
    }

    private File createWritterBlock99(ArquivoNIS vo) throws IOException, ExceptionService {
        File f = File.createTempFile("nis_bloco_99", ".txt");
        PrintWriter p = new PrintWriter(f);
        this.writterBlocoTrailerGeral99(p, vo);
        p.flush();
        p.close();
        return f;
    }

    private void writterBlocoHeaderGeral00(PrintWriter p, ArquivoNIS vo) {
        this.getTipoArquivo00(p, vo);
        this.getCnpjEmpresa00(p, vo);
        this.getNomeEmpresa00(p, vo);
        this.getTipoRemessa00(p, vo);
        this.getDataEmissao00(p, vo);
        this.getCodigoProcesso00(p, vo);
    }

    private void getTipoArquivo00(PrintWriter p, ArquivoNIS vo) {
        this.zerarNrSequencial();
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("00");
        p.append(this.getNrSequencial());
        p.append("0900");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString("C", 1));
        p.append(this.getFormatedString("", 179));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getCnpjEmpresa00(PrintWriter p, ArquivoNIS vo) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("00");
        p.append(this.getNrSequencial());
        p.append("0829");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString(this.getClearString(vo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(this.getFormatedString("", 166));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getNomeEmpresa00(PrintWriter p, ArquivoNIS vo) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("00");
        p.append(this.getNrSequencial());
        p.append("0313");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString(vo.getEmpresa().getPessoa().getNome(), 40));
        p.append(this.getFormatedString("", 140));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getTipoRemessa00(PrintWriter p, ArquivoNIS vo) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("00");
        p.append(this.getNrSequencial());
        p.append("0413");
        p.append("00");
        p.append("00");
        p.append(this.getTipoRemessa(vo));
        p.append(this.getFormatedString("", 179));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getDataEmissao00(PrintWriter p, ArquivoNIS vo) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("00");
        p.append(this.getNrSequencial());
        p.append("0903");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedDate(vo.getDataEmissao()));
        p.append(this.getFormatedString("", 172));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getCodigoProcesso00(PrintWriter p, ArquivoNIS vo) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("00");
        p.append(this.getNrSequencial());
        p.append("0913");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString("0013", 4));
        p.append(this.getFormatedString("", 176));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private String getTipoRemessa(ArquivoNIS vo) {
        if (vo.getTipoRemessa().equals((short)0)) {
            return "O";
        }
        return "R";
    }

    private void writterBlocoRegistroDetalhe02(PrintWriter p, ArquivoNIS vo, List<Colaborador> colaboradores) throws ExceptionService {
        for (Colaborador colaborador : colaboradores) {
            this.zerarNrSequencial();
            this.getTipoOperacao02(p);
            this.getNomePessoa02(p, colaborador);
            this.getDataNascimento02(p, colaborador);
            this.getNomeMae02(p, colaborador);
            this.getNomePai02(p, colaborador);
            this.getCodigoMunicipio02(p, colaborador);
            this.getSexo02(p, colaborador);
            this.getRacaCor02(p, colaborador);
            this.getNivelInstrucao02(p, colaborador);
            this.getEstadoCivil02(p, colaborador);
            this.getNacionalidade02(p, colaborador);
            this.getPaisOrigem02(p, colaborador);
            this.getCpf02(p, colaborador);
            this.getTituloEleitor02(p, colaborador, vo.getEnviarDadosTituloEleitor());
            this.getCarteiraIdentidade02(p, colaborador, vo.getEnviarDadosRG());
            this.getCTPS02(p, colaborador);
            this.getDataChegada02(p, colaborador);
            this.getPortariaNaturalizacao02(p, colaborador);
            this.getDataNaturalizacao02(p, colaborador);
            this.getEmail02(p, colaborador);
            this.getEndereco02(p, colaborador);
            this.getDadosVinculo(p, colaborador);
        }
    }

    private void getTipoOperacao02(PrintWriter p) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0902");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString("I", 1));
        p.append(this.getFormatedString("", 179));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getNomePessoa02(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0195");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString(colaborador.getPessoa().getNome(), 70));
        p.append(this.getFormatedString("", 110));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getDataNascimento02(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0197");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedDate(colaborador.getPessoa().getComplemento().getDataNascimento()));
        p.append(this.getFormatedString("", 172));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getNomeMae02(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0200");
        p.append("00");
        p.append("00");
        if (colaborador.getNomeMae() != null && !colaborador.getNomeMae().isEmpty()) {
            p.append(this.getFormatedString(colaborador.getNomeMae(), 70));
        } else {
            p.append(this.getFormatedString("IGNORADA", 70));
        }
        p.append(this.getFormatedString("", 110));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getNomePai02(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0199");
        p.append("00");
        p.append("00");
        if (colaborador.getNomePai() != null && !colaborador.getNomePai().isEmpty()) {
            p.append(this.getFormatedString(colaborador.getNomePai(), 70));
        } else {
            p.append(this.getFormatedString("IGNORADO", 70));
        }
        p.append(this.getFormatedString("", 110));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getCodigoMunicipio02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getNacionalidade() != null && colaborador.getNacionalidade().getCodigo().equals("10")) {
            if (colaborador.getCidadeNascimento() != null) {
                p.append(this.getNrOrdemRegistro());
                p.append("000000000000000001");
                p.append("00000000000");
                p.append("02");
                p.append(this.getNrSequencial());
                p.append("0390");
                p.append("00");
                p.append("00");
                p.append(this.getFormatedString(colaborador.getCidadeNascimento().getCodIbgeCompleto(), 7));
                p.append(this.getFormatedString("", 173));
                p.append(this.getFilter());
                p.append("00000000000");
                p.append("0000");
                p.append(this.getFinalLine());
            } else {
                throw new ExceptionService("Primeiro preencha a UF e Cidade de nascimento do colaborador: " + colaborador.getPessoa().getNome());
            }
        }
    }

    private void getSexo02(PrintWriter p, Colaborador colaborador) {
        if (colaborador.getSexo() != null) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0201");
            p.append("00");
            p.append("00");
            if (colaborador.getSexo().equals((short)0)) {
                p.append(this.getFormatedString("M", 1));
            } else {
                p.append(this.getFormatedString("F", 1));
            }
            p.append(this.getFormatedString("", 179));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private void getRacaCor02(PrintWriter p, Colaborador colaborador) {
        if (colaborador.getRacaCor() != null) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0206");
            p.append("00");
            p.append("00");
            p.append(this.getFormatedString(this.getCodigoRacaCor(colaborador.getRacaCor()), 2));
            p.append(this.getFormatedString("", 178));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private String getCodigoRacaCor(RacaCor racaCor) {
        switch (racaCor.getCodigo()) {
            case "1": {
                return "05";
            }
            case "2": {
                return "01";
            }
            case "4": {
                return "02";
            }
            case "6": {
                return "04";
            }
        }
        return "03";
    }

    private void getNivelInstrucao02(PrintWriter p, Colaborador colaborador) {
        if (colaborador.getGrauInstrucao() != null) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0008");
            p.append("00");
            p.append("00");
            p.append(this.getFormatedNumero(new Short(colaborador.getGrauInstrucao().getCodigo()), 0, 2));
            p.append(this.getFormatedString("", 178));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private void getEstadoCivil02(PrintWriter p, Colaborador colaborador) {
        if (colaborador.getEstadoCivil() != null) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0389");
            p.append("00");
            p.append("00");
            p.append(this.getFormatedString(this.getCodigoEstadoCivil(colaborador.getEstadoCivil()), 2));
            p.append(this.getFormatedString("", 178));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private String getCodigoEstadoCivil(EstadoCivil estadoCivil) {
        switch (estadoCivil.getIdentificador().intValue()) {
            case 1: {
                return "01";
            }
            case 2: {
                return "02";
            }
            case 3: {
                return "06";
            }
            case 4: {
                return "04";
            }
            case 7: {
                return "05";
            }
        }
        return "03";
    }

    private void getNacionalidade02(PrintWriter p, Colaborador colaborador) {
        if (colaborador.getNacionalidade() != null) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0386");
            p.append("00");
            p.append("00");
            p.append(this.getFormatedNumero(new Long(this.getCodigoNacionalidade(colaborador.getNacionalidade().getCodigo())), 0, 4));
            p.append(this.getFormatedString("", 176));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0386");
            p.append("01");
            p.append("00");
            if (colaborador.getNacionalidade().getCodigo().equals("10")) {
                p.append(this.getFormatedString("1", 1));
            } else if (colaborador.getNacionalidade().getCodigo().equals("20")) {
                p.append(this.getFormatedString("2", 1));
            } else {
                p.append(this.getFormatedString("3", 1));
            }
            p.append(this.getFormatedString("", 179));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private String getCodigoNacionalidade(String codigo) {
        if (codigo.equals("10") || codigo.equals("20")) {
            return "10";
        }
        return codigo;
    }

    private void getPaisOrigem02(PrintWriter p, Colaborador colaborador) {
        if (colaborador.getNacionalidade() != null && !colaborador.getNacionalidade().getCodigo().equals("10") && !colaborador.getNacionalidade().getCodigo().equals("20")) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0387");
            p.append("00");
            p.append("00");
            p.append(this.getFormatedNumero(new Long(this.getCodigoNacionalidade(colaborador.getNacionalidade().getCodigo())), 0, 4));
            p.append(this.getFormatedString("", 176));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private void getCpf02(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0370");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString(this.getClearString(colaborador.getPessoa().getComplemento().getCnpj()), 11));
        p.append(this.getFormatedString("", 169));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getTituloEleitor02(PrintWriter p, Colaborador colaborador, Short enviarDadosTituloEleitor) throws ExceptionService {
        if (enviarDadosTituloEleitor.equals((short)1)) {
            this.getNumeroTituloEleitor02(p, colaborador);
            this.getZonaTituloEleitor02(p, colaborador);
            this.getSecaoTituloEleitor02(p, colaborador);
        }
    }

    private void getNumeroTituloEleitor02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getTituloEleitor() == null || colaborador.getTituloEleitor().isEmpty()) {
            throw new ExceptionService("Primeiro preencha os dados do T\u00edtulo de Eleitor para o colaborador: " + colaborador.getNomeMae());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0371");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedNumero(new Long(this.getClearString(colaborador.getTituloEleitor())), 0, 13));
        p.append(this.getFormatedString("", 167));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getZonaTituloEleitor02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getZonaTituloEleitor() == null || colaborador.getZonaTituloEleitor().isEmpty()) {
            throw new ExceptionService("Primeiro preencha os dados do T\u00edtulo de Eleitor para o colaborador: " + colaborador.getNomeMae());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0371");
        p.append("01");
        p.append("00");
        p.append(this.getFormatedNumero(new Long(this.getClearString(colaborador.getZonaTituloEleitor())), 0, 4));
        p.append(this.getFormatedString("", 176));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getSecaoTituloEleitor02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getSecaoTituloEleitor() == null || colaborador.getSecaoTituloEleitor().isEmpty()) {
            throw new ExceptionService("Primeiro preencha os dados do T\u00edtulo de Eleitor para o colaborador: " + colaborador.getNomeMae());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0371");
        p.append("02");
        p.append("00");
        p.append(this.getFormatedNumero(new Long(this.getClearString(colaborador.getSecaoTituloEleitor())), 0, 4));
        p.append(this.getFormatedString("", 176));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getCarteiraIdentidade02(PrintWriter p, Colaborador colaborador, Short enviarDadosRG) throws ExceptionService {
        if (enviarDadosRG.equals((short)1) && colaborador.getPessoa().getComplemento().getRg() != null && !colaborador.getPessoa().getComplemento().getRg().isEmpty()) {
            this.getNumeroCarteiraIdentidade(p, colaborador);
            this.getComplementoCarteiraIdentidade(p, colaborador);
            this.getUFEmissaoCarteiraIdentidade(p, colaborador);
            this.getDataEmissaoCarteiraIdentidade(p, colaborador);
            this.getOrgaoEmissorCarteiraIdentidade(p, colaborador);
        }
    }

    private void getNumeroCarteiraIdentidade(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0372");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString(this.getClearString(colaborador.getPessoa().getComplemento().getRg()), 20));
        p.append(this.getFormatedString("", 160));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getComplementoCarteiraIdentidade(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0372");
        p.append("01");
        p.append("00");
        p.append(this.getFormatedString("", 180));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getUFEmissaoCarteiraIdentidade(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getPessoa().getComplemento().getUfEmissaoRG() == null) {
            throw new ExceptionService("Primeiro preencha os dados relativos ao RG do colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0372");
        p.append("02");
        p.append("00");
        p.append(this.getFormatedString(colaborador.getPessoa().getComplemento().getUfEmissaoRG().getSigla(), 2));
        p.append(this.getFormatedString("", 178));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getDataEmissaoCarteiraIdentidade(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getPessoa().getComplemento().getDataEmissaoRG() == null) {
            throw new ExceptionService("Primeiro preencha os dados relativos ao RG do colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0372");
        p.append("03");
        p.append("00");
        p.append(this.getFormatedDate(colaborador.getPessoa().getComplemento().getDataEmissaoRG()));
        p.append(this.getFormatedString("", 172));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getOrgaoEmissorCarteiraIdentidade(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0372");
        p.append("04");
        p.append("00");
        p.append("10");
        p.append(this.getFormatedString("", 178));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getCTPS02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getCarteiraProfissional() == null || colaborador.getCarteiraProfissional().isEmpty()) {
            throw new ExceptionService("Primeiro, informe os dados da Carteira de Trabalho para o colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0373");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedNumero(new Long(this.getClearString(colaborador.getCarteiraProfissional())), 0, 7));
        p.append(this.getFormatedString("", 173));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
        if (colaborador.getSerieCarteiraProfissional() == null || colaborador.getSerieCarteiraProfissional().isEmpty()) {
            throw new ExceptionService("Primeiro, informe os dados da Carteira de Trabalho para o colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0373");
        p.append("01");
        p.append("00");
        p.append(this.getFormatedNumero(new Long(this.getClearString(colaborador.getSerieCarteiraProfissional())), 0, 5));
        p.append(this.getFormatedString("", 175));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
        if (colaborador.getUfCarteiraProfissional() == null) {
            throw new ExceptionService("Primeiro, informe os dados da Carteira de Trabalho para o colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0373");
        p.append("02");
        p.append("00");
        p.append(this.getFormatedString(colaborador.getUfCarteiraProfissional().getSigla(), 2));
        p.append(this.getFormatedString("", 178));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
        if (colaborador.getDataEmissaoCTPS() == null) {
            throw new ExceptionService("Primeiro, informe os dados da Carteira de Trabalho para o colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0373");
        p.append("03");
        p.append("00");
        p.append(this.getFormatedDate(colaborador.getDataEmissaoCTPS()));
        p.append(this.getFormatedString("", 172));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getDataChegada02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getNacionalidade() != null && !colaborador.getNacionalidade().getCodigo().equals("10") && !colaborador.getNacionalidade().getCodigo().equals("20")) {
            if (colaborador.getDataChegada() != null) {
                p.append(this.getNrOrdemRegistro());
                p.append("000000000000000001");
                p.append("00000000000");
                p.append("02");
                p.append(this.getNrSequencial());
                p.append("0391");
                p.append("00");
                p.append("00");
                p.append(this.getFormatedDate(colaborador.getDataChegada()));
                p.append(this.getFormatedString("", 172));
                p.append(this.getFilter());
                p.append("00000000000");
                p.append("0000");
                p.append(this.getFinalLine());
            } else {
                throw new ExceptionService("Preencha a data de chegada ao pa\u00eds para o colaborador :" + colaborador.getPessoa().getNome());
            }
        }
    }

    private void getPortariaNaturalizacao02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getNacionalidade() != null && colaborador.getNacionalidade().getCodigo().equals("20")) {
            if (colaborador.getPortariaNaturalizacao() != null) {
                p.append(this.getNrOrdemRegistro());
                p.append("000000000000000001");
                p.append("00000000000");
                p.append("02");
                p.append(this.getNrSequencial());
                p.append("0401");
                p.append("00");
                p.append("00");
                p.append(this.getFormatedNumero(new Long(colaborador.getPortariaNaturalizacao()), 0, 16));
                p.append(this.getFormatedString("", 164));
                p.append(this.getFilter());
                p.append("00000000000");
                p.append("0000");
                p.append(this.getFinalLine());
            } else {
                throw new ExceptionService("Preencha a portaria de naturaliza\u00e7\u00e3o para o colaborador :" + colaborador.getPessoa().getNome());
            }
        }
    }

    private void getDataNaturalizacao02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getNacionalidade() != null && colaborador.getNacionalidade().getCodigo().equals("20")) {
            if (colaborador.getDataNaturalizacao() != null) {
                p.append(this.getNrOrdemRegistro());
                p.append("000000000000000001");
                p.append("00000000000");
                p.append("02");
                p.append(this.getNrSequencial());
                p.append("0815");
                p.append("00");
                p.append("00");
                p.append(this.getFormatedDate(colaborador.getDataNaturalizacao()));
                p.append(this.getFormatedString("", 172));
                p.append(this.getFilter());
                p.append("00000000000");
                p.append("0000");
                p.append(this.getFinalLine());
            } else {
                throw new ExceptionService("Preencha a data de naturaliza\u00e7\u00e3o para o colaborador :" + colaborador.getPessoa().getNome());
            }
        }
    }

    private void getEmail02(PrintWriter p, Colaborador colaborador) {
        if (colaborador.getPessoa().getComplemento().getEmails() != null && !colaborador.getPessoa().getComplemento().getEmails().isEmpty()) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0810");
            p.append("00");
            p.append("00");
            p.append(this.getFormatedString(((EmailPessoa)colaborador.getPessoa().getComplemento().getEmails().get(0)).getEmail(), 50));
            p.append(this.getFormatedString("", 130));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private void getEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        this.getCepEndereco02(p, colaborador);
        this.getTipoEndereco02(p, colaborador);
        this.getTipoLogradouroEndereco02(p, colaborador);
        this.getLogradouroEndereco02(p, colaborador);
        this.getTipoNumeroEndereco02(p, colaborador);
        this.getNumeroEndereco02(p, colaborador);
        this.getComplementoEndereco02(p, colaborador);
        this.getBairroEndereco02(p, colaborador);
        this.getCodigoMunicipioEndereco02(p, colaborador);
    }

    private void getCepEndereco02(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString(this.getClearString(colaborador.getPessoa().getEndereco().getCep()), 8));
        p.append(this.getFormatedString("", 172));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getTipoEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getTipoEndereco() == null) {
            throw new ExceptionService("Primeiro, cadastre os dados adicionais do endere\u00e7o no cadastro do colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("01");
        p.append("00");
        p.append(this.getFormatedString(this.getTipoEndereco(colaborador.getTipoEndereco()), 1));
        p.append(this.getFormatedString("", 179));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getTipoLogradouroEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getTipoLogradouroEndereco() == null) {
            throw new ExceptionService("Primeiro, cadastre os dados adicionais do endere\u00e7o no cadastro do colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("02");
        p.append("00");
        p.append(this.getFormatedString(colaborador.getTipoLogradouroEndereco().getSigla(), 3));
        p.append(this.getFormatedString("", 177));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getLogradouroEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("03");
        p.append("00");
        p.append(this.getFormatedString(colaborador.getPessoa().getEndereco().getLogradouro(), 40));
        p.append(this.getFormatedString("", 140));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getTipoNumeroEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("04");
        p.append("00");
        p.append(this.getFormatedString("Num.", 5));
        p.append(this.getFormatedString("", 175));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getNumeroEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getPessoa().getEndereco().getNumero() == null) {
            throw new ExceptionService("Primeiro, cadastre o n\u00famero do endere\u00e7o do colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("05");
        p.append("00");
        p.append(this.getFormatedString(colaborador.getPessoa().getEndereco().getNumero(), 7));
        p.append(this.getFormatedString("", 173));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getComplementoEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getPessoa().getEndereco().getComplemento() != null && !colaborador.getPessoa().getEndereco().getComplemento().isEmpty()) {
            p.append(this.getNrOrdemRegistro());
            p.append("000000000000000001");
            p.append("00000000000");
            p.append("02");
            p.append(this.getNrSequencial());
            p.append("0911");
            p.append("06");
            p.append("00");
            p.append(this.getFormatedString(colaborador.getPessoa().getEndereco().getComplemento(), 15));
            p.append(this.getFormatedString("", 165));
            p.append(this.getFilter());
            p.append("00000000000");
            p.append("0000");
            p.append(this.getFinalLine());
        }
    }

    private void getBairroEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getPessoa().getEndereco().getBairro() == null) {
            throw new ExceptionService("Primeiro, cadastre o bairro do endere\u00e7o do colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("07");
        p.append("00");
        p.append(this.getFormatedString(colaborador.getPessoa().getEndereco().getBairro(), 40));
        p.append(this.getFormatedString("", 140));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getCodigoMunicipioEndereco02(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        if (colaborador.getPessoa().getEndereco().getCidade() == null || colaborador.getPessoa().getEndereco().getCidade().getUf() == null) {
            throw new ExceptionService("Primeiro, cadastre o bairro do endere\u00e7o do colaborador: " + colaborador.getPessoa().getNome());
        }
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0911");
        p.append("08");
        p.append("00");
        p.append(this.getFormatedString(this.getClearString(colaborador.getPessoa().getEndereco().getCidade().getUf().getCodIbge()) + this.getClearString(colaborador.getPessoa().getEndereco().getCidade().getCodIbge()), 7));
        p.append(this.getFormatedString("", 173));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private String getTipoEndereco(Short tipoEndereco) {
        if (tipoEndereco.equals((short)1)) {
            return "1";
        }
        return "3";
    }

    private void getDadosVinculo(PrintWriter p, Colaborador colaborador) {
        this.getTipoVinculo(p, colaborador);
        this.getCnpjVinculo(p, colaborador);
        this.getDataAdmissaoVinculo(p, colaborador);
    }

    private void getTipoVinculo(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0292");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString("59", 2));
        p.append(this.getFormatedString("", 178));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getCnpjVinculo(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0292");
        p.append("01");
        p.append("00");
        p.append(this.getFormatedNumero(new Long(this.getClearString(colaborador.getEmpresa().getPessoa().getComplemento().getCnpj())), 0, 16));
        p.append(this.getFormatedString("", 164));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void getDataAdmissaoVinculo(PrintWriter p, Colaborador colaborador) {
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("00000000000");
        p.append("02");
        p.append(this.getNrSequencial());
        p.append("0292");
        p.append("02");
        p.append("00");
        p.append(this.getFormatedDate(colaborador.getDataAdmissao()));
        p.append(this.getFormatedString("", 172));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void writterBlocoTrailerGeral99(PrintWriter p, ArquivoNIS vo) {
        this.zerarNrSequencial();
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("99999999999");
        p.append("99");
        p.append(this.getNrSequencial());
        p.append("0908");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedString(this.getNomeArquivo(vo), 35));
        p.append(this.getFormatedString("", 145));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
        p.append(this.getNrOrdemRegistro());
        p.append("000000000000000001");
        p.append("99999999999");
        p.append("99");
        p.append(this.getNrSequencial());
        p.append("0912");
        p.append("00");
        p.append("00");
        p.append(this.getFormatedNumero(this.nrOrdemRegistro - 1L, 0, 9));
        p.append(this.getFormatedString("", 171));
        p.append(this.getFilter());
        p.append("00000000000");
        p.append("0000");
        p.append(this.getFinalLine());
    }

    private void apendToSomeFile(String path, File bloco00, File bloco02, File bloco99, ArquivoNIS vo) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(this.getFilePath(path, vo));
        this.copy(bloco00, out);
        this.copy(bloco02, out);
        this.copy(bloco99, out);
        bloco00.delete();
        bloco02.delete();
        bloco99.delete();
        ((OutputStream)out).close();
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }

    private File getFilePath(String directory, ArquivoNIS vo) {
        File f = new File(directory + File.separatorChar + this.getNomeArquivo(vo) + ".txt");
        return f;
    }

    private String getNomeArquivo(ArquivoNIS vo) {
        return "CADASTRONIS.D" + this.getFormatedDate(vo.getDataEmissao(), "yyMMdd") + "S" + this.getFormatedNumero(vo.getNrSequencial(), 0, 2);
    }

    public String getFormatedNumero(Number numero, int numCasasDecimais, int numCasasInteiras) {
        return ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)numero, (int)numCasasDecimais, (int)numCasasInteiras));
    }

    public String getFormatedDate(Date data) {
        return DateUtil.dateToStr(data, "ddMMyyyy");
    }

    public String getFormatedDate(Date data, String mask) {
        return DateUtil.dateToStr(data, mask);
    }

    private String getFinalLine() {
        return "\r\n";
    }

    public String getFormatedString(String st, int numeroCasas) {
        if (st == null) {
            st = "";
        }
        if ((st = ContatoFormatUtil.clearStringXml((String)st)).length() > numeroCasas) {
            return st.substring(0, numeroCasas);
        }
        return ToolString.completaEspacos((String)st, (int)numeroCasas);
    }

    private String getClearString(String st) {
        return ToolString.refina((String)st);
    }

    private void zerarNrSequencial() {
        this.nrSequencial = 0L;
    }

    private String getNrSequencial() {
        String nrSeq = this.getFormatedNumero(this.nrSequencial, 0, 3);
        ++this.nrSequencial;
        return nrSeq;
    }

    private String getNrOrdemRegistro() {
        String nrOrdem = this.getFormatedNumero(this.nrOrdemRegistro, 0, 11);
        ++this.nrOrdemRegistro;
        return nrOrdem;
    }

    private String getFilter() {
        return this.getFormatedString("", 32);
    }
}

