/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.arquivoserasa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ArquivoSerasa;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.PessoaArquivoSerasa;
import com.touchcomp.basementorclientwebservices.arquivoserasa.model.Cli;
import com.touchcomp.basementorclientwebservices.arquivoserasa.model.EndCli;
import com.touchcomp.basementorclientwebservices.arquivoserasa.model.EndEtnCli;
import com.touchcomp.basementorclientwebservices.arquivoserasa.model.EnvoCad;
import com.touchcomp.basementorclientwebservices.arquivoserasa.model.TelCli;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mentorcore.service.impl.arquivoserasa.UtilityArquisoSerasa;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import utilities.MarshallerUtil;

public class UtilCriarArquivoDadosCadastrais {
    public static void criarArquivoDadosCadastrais(ArquivoSerasa arquivoSerasa, File caminho) throws Exception {
        PrintWriter p1 = new PrintWriter(new File(caminho.getAbsolutePath() + File.separator + "ACPO107_" + ToolString.refina((String)arquivoSerasa.getEmpresa().getPessoa().getComplemento().getCnpj()).substring(0, 8) + "_62173620_" + ToolDate.dateToStr((Date)new Date(), (String)"yyyyMMdd") + "_00001.xml"));
        p1.write(UtilCriarArquivoDadosCadastrais.converterXml(MarshallerUtil.mashall((Object)UtilCriarArquivoDadosCadastrais.criarEnvoCad1(arquivoSerasa))));
        p1.flush();
        p1.close();
        PrintWriter p2 = new PrintWriter(new File(caminho.getAbsolutePath() + File.separator + "ACPO107_" + ToolString.refina((String)arquivoSerasa.getEmpresa().getPessoa().getComplemento().getCnpj()).substring(0, 8) + "_62173620_" + ToolDate.dateToStr((Date)new Date(), (String)"yyyyMMdd") + "_00002.xml"));
        p2.write(UtilCriarArquivoDadosCadastrais.converterXml(MarshallerUtil.mashall((Object)UtilCriarArquivoDadosCadastrais.criarEnvoCad2(arquivoSerasa))).replace("/>", ">\n</EnvoCad>"));
        p2.flush();
        p2.close();
    }

    private static String converterXml(String xml) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(xml)));
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        System.out.println(result.getWriter().toString());
        return result.getWriter().toString();
    }

    private static EnvoCad criarEnvoCad1(ArquivoSerasa arquivoSerasa) {
        EnvoCad envoCad = new EnvoCad();
        envoCad.setDtRms(ToolDate.dateToStr((Date)new Date(), (String)"ddMMyyyy"));
        envoCad.setSeqlRms("1");
        envoCad.setNrRms(arquivoSerasa.getIdentificador().toString());
        envoCad.setNmOgm(ToolString.clearSpecialCharacXML((String)arquivoSerasa.getEmpresa().getPessoa().getNome()));
        envoCad.setCnpjOgm(ToolString.refina((String)arquivoSerasa.getEmpresa().getPessoa().getComplemento().getCnpj()));
        envoCad.setCli(UtilCriarArquivoDadosCadastrais.criarCli(arquivoSerasa));
        return envoCad;
    }

    private static List<Cli> criarCli(ArquivoSerasa arquivoSerasa) {
        ArrayList<Cli> listCli = new ArrayList<Cli>();
        for (PessoaArquivoSerasa pessoaArquivoSerasa : arquivoSerasa.getPessoaArquivoSerasa()) {
            Cli cli = new Cli();
            cli.setNmCli(ToolString.clearSpecialCharacXML((String)pessoaArquivoSerasa.getPessoa().getNome()));
            cli.setIdfcCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCnpj()));
            cli.setTipCli(UtilityArquisoSerasa.verificarTipoCliente(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCnpj())));
            cli.setEndCli(UtilCriarArquivoDadosCadastrais.criarEndCli(pessoaArquivoSerasa));
            cli.setTelCli(UtilCriarArquivoDadosCadastrais.criarTelCli(pessoaArquivoSerasa));
            cli.setEndEtnCli(UtilCriarArquivoDadosCadastrais.criarEndEtnCli(pessoaArquivoSerasa));
            listCli.add(cli);
        }
        return listCli;
    }

    private static List<EndCli> criarEndCli(PessoaArquivoSerasa pessoaArquivoSerasa) {
        ArrayList<EndCli> listEndCli = new ArrayList<EndCli>();
        EndCli endCli = new EndCli();
        endCli.setUfEndCli(pessoaArquivoSerasa.getPessoa().getEndereco().getCidade().getUf().getSigla());
        endCli.setMunEndCli(ToolString.clearSpecialCharacXML((String)pessoaArquivoSerasa.getPessoa().getEndereco().getCidade().getDescricao()));
        endCli.setCepEndCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getEndereco().getCep()));
        endCli.setBaiEndCli(ToolString.clearSpecialCharacXML((String)pessoaArquivoSerasa.getPessoa().getEndereco().getBairro()));
        endCli.setCmptEndCli(ToolString.clearSpecialCharacXML((String)pessoaArquivoSerasa.getPessoa().getEndereco().getComplemento()));
        endCli.setNrEndCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getEndereco().getNumero()));
        endCli.setLgrEndCli(ToolString.clearSpecialCharacXML((String)pessoaArquivoSerasa.getPessoa().getEndereco().getLogradouro()));
        listEndCli.add(endCli);
        return listEndCli;
    }

    private static List<TelCli> criarTelCli(PessoaArquivoSerasa pessoaArquivoSerasa) {
        TelCli telCli;
        ArrayList<TelCli> listTelCli = new ArrayList<TelCli>();
        if (pessoaArquivoSerasa.getPessoa().getComplemento().getFone1() != null && ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getFone1().trim()).length() > 0) {
            telCli = new TelCli();
            telCli.setNrTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getFone1().trim()).substring(2));
            telCli.setDddTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getFone1().trim()).substring(0, 2));
            listTelCli.add(telCli);
        }
        if (pessoaArquivoSerasa.getPessoa().getComplemento().getFone2() != null && ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getFone2().trim()).length() > 0) {
            telCli = new TelCli();
            telCli.setNrTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getFone2().trim()).substring(2));
            telCli.setDddTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getFone2().trim()).substring(0, 2));
            listTelCli.add(telCli);
        }
        if (pessoaArquivoSerasa.getPessoa().getComplemento().getCel1() != null && ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCel1().trim()).length() > 0) {
            telCli = new TelCli();
            telCli.setNrTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCel1().trim()).substring(2));
            telCli.setDddTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCel1().trim()).substring(0, 2));
            listTelCli.add(telCli);
        }
        if (pessoaArquivoSerasa.getPessoa().getComplemento().getCel2() != null && ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCel2().trim()).length() > 0) {
            telCli = new TelCli();
            telCli.setNrTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCel2().trim()).substring(2));
            telCli.setDddTelCli(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCel2().trim()).substring(0, 2));
            listTelCli.add(telCli);
        }
        return listTelCli;
    }

    private static List<EndEtnCli> criarEndEtnCli(PessoaArquivoSerasa pessoaArquivoSerasa) {
        ArrayList<EndEtnCli> listEndEtnCli = new ArrayList<EndEtnCli>();
        for (EmailPessoa emailPessoa : pessoaArquivoSerasa.getPessoa().getComplemento().getEmails()) {
            if (listEndEtnCli.size() >= 5 || emailPessoa.getEmail() == null || emailPessoa.getEmail().trim().length() <= 0 || !ToolMethods.isEquals((Object)emailPessoa.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || !UtilCriarArquivoDadosCadastrais.verificarEmailRepetidos(listEndEtnCli, emailPessoa)) continue;
            EndEtnCli endEtnCli = new EndEtnCli();
            endEtnCli.setEmaiCli(emailPessoa.getEmail().trim());
            listEndEtnCli.add(endEtnCli);
        }
        return listEndEtnCli;
    }

    private static boolean verificarEmailRepetidos(List<EndEtnCli> listEndEtnCli, EmailPessoa emailPessoa) {
        for (EndEtnCli endEtnCli : listEndEtnCli) {
            if (!ToolMethods.isEquals((Object)endEtnCli.getEmaiCli(), (Object)emailPessoa.getEmail().trim())) continue;
            return false;
        }
        return true;
    }

    private static EnvoCad criarEnvoCad2(ArquivoSerasa arquivoSerasa) {
        EnvoCad envoCad = new EnvoCad();
        envoCad.setDtRms(ToolDate.dateToStr((Date)new Date(), (String)"ddMMyyyy"));
        envoCad.setSeqlRms("2");
        envoCad.setNrRms(arquivoSerasa.getIdentificador().toString());
        envoCad.setNmOgm(ToolString.clearSpecialCharacXML((String)arquivoSerasa.getEmpresa().getPessoa().getNome()));
        envoCad.setCnpjOgm(ToolString.refina((String)arquivoSerasa.getEmpresa().getPessoa().getComplemento().getCnpj()));
        return envoCad;
    }
}

