/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.arquivoserasa;

import com.touchcomp.basementor.model.vo.ArquivoSerasa;
import com.touchcomp.basementor.model.vo.PessoaArquivoSerasa;
import com.touchcomp.basementor.model.vo.TituloArquivoSerasa;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import mentorcore.service.impl.arquivoserasa.UtilityArquisoSerasa;

public class UtilCriarArquivoSerasa {
    private static int quantidadeRegistroPessoa = 0;
    private static int quantidadeRegistroTitulo = 0;

    public static void criarArquivoSerasa(ArquivoSerasa arquivoSerasa, File caminho) throws FileNotFoundException {
        PrintWriter p = new PrintWriter(new File(caminho.getAbsolutePath()));
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)UtilCriarArquivoSerasa.buildHeaderFile(arquivoSerasa));
        sb.append((CharSequence)UtilCriarArquivoSerasa.buildDetailPessoa(arquivoSerasa));
        sb.append((CharSequence)UtilCriarArquivoSerasa.buildDetailTitulo(arquivoSerasa));
        sb.append((CharSequence)UtilCriarArquivoSerasa.buildTrailerFile());
        p.write(sb.toString());
        p.flush();
        p.close();
    }

    private static StringBuilder buildHeaderFile(ArquivoSerasa arquivoSerasa) {
        StringBuilder sb = new StringBuilder();
        sb.append("00");
        sb.append("RELATO COMP NEGOCIOS");
        sb.append(ToolString.refina((String)arquivoSerasa.getEmpresa().getPessoa().getComplemento().getCnpj()));
        sb.append(UtilityArquisoSerasa.formatarDatas8Digitos(arquivoSerasa.getDataInicial()));
        sb.append(UtilityArquisoSerasa.formatarDatas8Digitos(arquivoSerasa.getDataFinal()));
        sb.append(UtilityArquisoSerasa.verificarPeriodicidade(arquivoSerasa.getPeriodicidade()));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 15));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 3));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 29));
        sb.append("V.");
        sb.append("01");
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 26));
        sb.append("\n");
        return sb;
    }

    private static StringBuilder buildDetailPessoa(ArquivoSerasa arquivoSerasa) {
        StringBuilder sb = new StringBuilder();
        for (PessoaArquivoSerasa pessoaArquivoSerasa : arquivoSerasa.getPessoaArquivoSerasa()) {
            sb.append("01");
            sb.append(UtilityArquisoSerasa.completarComZeroEsquerda(ToolString.refina((String)pessoaArquivoSerasa.getPessoa().getComplemento().getCnpj()), 14));
            sb.append("01");
            sb.append(UtilityArquisoSerasa.verificarDataInicioCliente(pessoaArquivoSerasa.getPessoa()));
            sb.append(UtilityArquisoSerasa.verificarTempoCliente(pessoaArquivoSerasa.getPessoa(), arquivoSerasa));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 38));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 34));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 1));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 30));
            sb.append("\n");
            ++quantidadeRegistroPessoa;
        }
        return sb;
    }

    private static StringBuilder buildDetailTitulo(ArquivoSerasa arquivoSerasa) {
        StringBuilder sb = new StringBuilder();
        for (TituloArquivoSerasa tituloArquivoSerasa : arquivoSerasa.getTituloArquivoSerasa()) {
            sb.append("01");
            sb.append(UtilityArquisoSerasa.buscarCnpjEmpresaCliente(tituloArquivoSerasa));
            sb.append("05");
            sb.append(UtilityArquisoSerasa.buscarNumeroTitulo(tituloArquivoSerasa));
            sb.append(UtilityArquisoSerasa.buscarDataEmissaoTitulo(tituloArquivoSerasa));
            sb.append(UtilityArquisoSerasa.buscarValorTitulo(tituloArquivoSerasa));
            sb.append(UtilityArquisoSerasa.buscarDataVencimentoTitulo(tituloArquivoSerasa));
            sb.append(UtilityArquisoSerasa.buscarDataPagamentoTitulo(tituloArquivoSerasa.getBaixaTitulo()));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 34));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 1));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 24));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 2));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 1));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 1));
            sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 2));
            sb.append("\n");
            ++quantidadeRegistroTitulo;
        }
        return sb;
    }

    private static StringBuilder buildTrailerFile() {
        StringBuilder sb = new StringBuilder();
        sb.append("99");
        sb.append(UtilityArquisoSerasa.completarComZeroEsquerda(String.valueOf(quantidadeRegistroPessoa), 11));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 44));
        sb.append(UtilityArquisoSerasa.completarComZeroEsquerda(String.valueOf(quantidadeRegistroTitulo), 11));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 11));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 11));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 10));
        sb.append(UtilityArquisoSerasa.completarComBrancoDireita("", 30));
        sb.append("\n");
        return sb;
    }
}

