/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.arquivoserasa;

import com.touchcomp.basementortools.tools.date.ToolDate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.service.impl.arquivoserasa.UtilityArquisoSerasa;
import mentorcore.tools.DateUtil;

public class UtilCriarArquivoSerasaConciliacao {
    static void criarArquivoSerasaConciliacao(File arquivo, File caminho) throws FileNotFoundException, IOException {
        PrintWriter p = new PrintWriter(new File(caminho.getAbsolutePath()));
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)UtilCriarArquivoSerasaConciliacao.buildConciliacao(arquivo));
        p.write(sb.toString());
        p.flush();
        p.close();
    }

    private static StringBuilder buildConciliacao(File arquivo) throws FileNotFoundException, IOException {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        StringBuilder sb = new StringBuilder();
        Date dataFinal = null;
        while (buffer.ready()) {
            String linha = buffer.readLine();
            switch (linha.substring(0, 2)) {
                case "00": {
                    sb.append(linha);
                    dataFinal = DateUtil.strToDate(linha.substring(44, 52), "yyyyMMdd");
                    sb.append("\n");
                    break;
                }
                case "01": {
                    sb.append(UtilCriarArquivoSerasaConciliacao.atualizarDadosConciliacao(linha, dataFinal));
                    sb.append("\n");
                    break;
                }
                case "99": {
                    sb.append(linha);
                    sb.append("\n");
                    break;
                }
            }
        }
        return sb;
    }

    private static String atualizarDadosConciliacao(String linha, Date dataFinal) {
        Object linhaAtualizada = linha.substring(0, 36);
        Long titulo = Long.valueOf(linha.substring(18, 28).trim());
        if (UtilCriarArquivoSerasaConciliacao.verificarTituloExclusao(titulo)) {
            linhaAtualizada = (String)linhaAtualizada + "9999999999999";
            linhaAtualizada = (String)linhaAtualizada + linha.substring(49, 57);
            linhaAtualizada = (String)linhaAtualizada + UtilityArquisoSerasa.formatarDatas8Digitos(dataFinal);
        } else {
            linhaAtualizada = (String)linhaAtualizada + linha.substring(36, 57);
            linhaAtualizada = (String)linhaAtualizada + UtilCriarArquivoSerasaConciliacao.verificarDataLiquidacao(titulo, dataFinal);
        }
        return (String)linhaAtualizada + linha.substring(65, 130);
    }

    private static boolean verificarTituloExclusao(Long titulo) {
        Long idTitulo = CoreDAOFactory.getInstance().getDAOArquivoSerasa().pesquisarTituloDoTituloExcluido(titulo);
        return idTitulo == null;
    }

    private static String verificarDataLiquidacao(Long titulo, Date dataFinal) {
        Object[] result = CoreDAOFactory.getInstance().getDAOArquivoSerasa().pesquisarBaixaDoTitulo(titulo, dataFinal);
        if (result == null) {
            return UtilityArquisoSerasa.completarComBrancoDireita("", 8);
        }
        Date dataLiquidacao = (Date)result[0];
        Short diasTolerancia = (Short)result[1];
        if (dataLiquidacao != null) {
            if (diasTolerancia != null && diasTolerancia > 0) {
                dataLiquidacao = ToolDate.previousDays((Date)dataLiquidacao, (int)diasTolerancia.shortValue());
            }
            return UtilityArquisoSerasa.formatarDatas8Digitos(dataLiquidacao);
        }
        return UtilityArquisoSerasa.completarComBrancoDireita("", 8);
    }
}

