/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.arquivoserasa;

import com.touchcomp.basementor.model.vo.ArquivoSerasa;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ItemLogDadosTitulo;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.Periodicidade;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloArquivoSerasa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import mentorcore.database.mentor.CoreBdUtil;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.query.Query;

class UtilityArquisoSerasa {
    UtilityArquisoSerasa() {
    }

    static String formatarDatas8Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("yyyyMMdd");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "00000000";
    }

    static String verificarPeriodicidade(Periodicidade periodicidade) {
        String p = "";
        if (periodicidade.getCodigo().equalsIgnoreCase("0")) {
            p = "D";
        } else if (periodicidade.getCodigo().trim().equalsIgnoreCase("1")) {
            p = "M";
        } else if (periodicidade.getCodigo().trim().equalsIgnoreCase("2")) {
            p = "S";
        } else if (periodicidade.getCodigo().trim().equals("3")) {
            p = "Q";
        }
        return p;
    }

    static String completarComBrancoDireita(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.rightPad((String)st, (int)tam, (String)" ");
    }

    static String completarComZeroEsquerda(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.leftPad((String)st, (int)tam, (String)"0");
    }

    static String verificarDataInicioCliente(Pessoa pessoa) {
        if (pessoa.getDataInicioRelacionamento() != null) {
            return UtilityArquisoSerasa.formatarDatas8Digitos(pessoa.getDataInicioRelacionamento());
        }
        return UtilityArquisoSerasa.formatarDatas8Digitos(pessoa.getDataCadastro());
    }

    static String verificarTempoCliente(Pessoa pessoa, ArquivoSerasa arquivoSerasa) {
        Date dataInicioCliente;
        Date dataInicial = arquivoSerasa.getDataInicial();
        Date date = dataInicioCliente = pessoa.getDataInicioRelacionamento() != null ? pessoa.getDataInicioRelacionamento() : pessoa.getDataCadastro();
        if (pessoa.getAtivo() != null && pessoa.getAtivo() == 1) {
            GregorianCalendar gTempoRelacionamento = new GregorianCalendar();
            GregorianCalendar gDataArquivo = new GregorianCalendar();
            gTempoRelacionamento.setTime(dataInicioCliente);
            gDataArquivo.setTime(dataInicial);
            int yearRel = gTempoRelacionamento.get(1);
            int yearArq = gDataArquivo.get(1);
            if (yearArq - yearRel >= 2) {
                return "1";
            }
            return "2";
        }
        return "3";
    }

    static String buscarCnpjEmpresaCliente(TituloArquivoSerasa tituloArquivoSerasa) {
        System.out.println("\n\n\nTITULO SERASA: " + tituloArquivoSerasa.getIdentificador() + "\n\n\n");
        String cnpjEmpresaCliente = "";
        cnpjEmpresaCliente = tituloArquivoSerasa.getBaixaTitulo() != null ? UtilityArquisoSerasa.getCnpjBaixa(tituloArquivoSerasa.getBaixaTitulo()) : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() != null ? UtilityArquisoSerasa.getCnpjLogTitulos(tituloArquivoSerasa.getLogTitulos()) : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() == null ? UtilityArquisoSerasa.getCnpjItemLogTitulos(tituloArquivoSerasa.getLogTitulos().getItemLogDadosTitulo()) : UtilityArquisoSerasa.getCnpjTitulo(tituloArquivoSerasa.getTitulo())));
        return UtilityArquisoSerasa.completarComZeroEsquerda(ToolString.refina((String)cnpjEmpresaCliente), 14);
    }

    static String buscarNumeroTitulo(TituloArquivoSerasa tituloArquivoSerasa) {
        String numeroTitulo = tituloArquivoSerasa.getBaixaTitulo() != null ? tituloArquivoSerasa.getBaixaTitulo().getTitulo().getIdentificador().toString() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() != null ? tituloArquivoSerasa.getLogTitulos().getTitulo().getIdentificador().toString() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() == null ? tituloArquivoSerasa.getLogTitulos().getItemLogDadosTitulo().getNumeroTitulo().toString() : tituloArquivoSerasa.getTitulo().getIdentificador().toString()));
        return UtilityArquisoSerasa.completarComBrancoDireita(numeroTitulo, 10);
    }

    static String buscarDataEmissaoTitulo(TituloArquivoSerasa tituloArquivoSerasa) {
        Date dataEmissaoTitulo = tituloArquivoSerasa.getBaixaTitulo() != null ? tituloArquivoSerasa.getBaixaTitulo().getTitulo().getDataEmissao() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() != null ? tituloArquivoSerasa.getLogTitulos().getTitulo().getDataEmissao() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() == null ? tituloArquivoSerasa.getLogTitulos().getItemLogDadosTitulo().getDataEmissao() : tituloArquivoSerasa.getTitulo().getDataEmissao()));
        return UtilityArquisoSerasa.formatarDatas8Digitos(dataEmissaoTitulo);
    }

    static String buscarValorTitulo(TituloArquivoSerasa tituloArquivoSerasa) {
        Double valorTitulo = tituloArquivoSerasa.getBaixaTitulo() != null ? tituloArquivoSerasa.getBaixaTitulo().getTitulo().getValor() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() != null ? tituloArquivoSerasa.getLogTitulos().getTitulo().getValor() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() == null ? tituloArquivoSerasa.getLogTitulos().getItemLogDadosTitulo().getValor() : tituloArquivoSerasa.getTitulo().getValor()));
        if (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() == null) {
            return "9999999999999";
        }
        String valor = ContatoFormatUtil.formataNumero((Number)valorTitulo, (int)2);
        valor = ToolString.refina((String)valor);
        return UtilityArquisoSerasa.completarComZeroEsquerda(valor, 13);
    }

    static String buscarDataVencimentoTitulo(TituloArquivoSerasa tituloArquivoSerasa) {
        Date dataVencimentoTitulo = tituloArquivoSerasa.getBaixaTitulo() != null ? tituloArquivoSerasa.getBaixaTitulo().getTitulo().getDataVencimento() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() != null ? tituloArquivoSerasa.getLogTitulos().getTitulo().getDataVencimento() : (tituloArquivoSerasa.getLogTitulos() != null && tituloArquivoSerasa.getLogTitulos().getTitulo() == null ? tituloArquivoSerasa.getLogTitulos().getItemLogDadosTitulo().getDataVencimento() : tituloArquivoSerasa.getTitulo().getDataVencimento()));
        return UtilityArquisoSerasa.formatarDatas8Digitos(dataVencimentoTitulo);
    }

    static String buscarDataPagamentoTitulo(BaixaTitulo baixaTitulo) {
        if (baixaTitulo != null) {
            Date dataPagamento = baixaTitulo.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao();
            if (baixaTitulo.getTitulo().getCarteiraCobranca().getDiasToleranciaVencimento() > 0) {
                dataPagamento = ToolDate.previousDays((Date)baixaTitulo.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao(), (int)baixaTitulo.getTitulo().getCarteiraCobranca().getDiasToleranciaVencimento().shortValue());
            }
            return UtilityArquisoSerasa.formatarDatas8Digitos(dataPagamento);
        }
        return UtilityArquisoSerasa.completarComBrancoDireita("", 8);
    }

    static String verificarTipoCliente(String cpfCnpj) {
        if (ToolMethods.isEquals((Object)cpfCnpj.length(), (Object)11)) {
            return "1";
        }
        if (ToolMethods.isEquals((Object)cpfCnpj.length(), (Object)14)) {
            return "2";
        }
        return "3";
    }

    private static String getCnpjBaixa(BaixaTitulo baixaTitulo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  b.titulo.pessoa.complemento.cnpj  from BaixaTitulo b  where b.identificador = :idBaixa");
        q.setLong("idBaixa", baixaTitulo.getIdentificador().longValue());
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private static String getCnpjLogTitulos(LogTitulos logTitulos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  b.titulo.pessoa.complemento.cnpj  from LogTitulos b  where b.identificador = :idLogTitulos");
        q.setLong("idLogTitulos", logTitulos.getIdentificador().longValue());
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private static String getCnpjItemLogTitulos(ItemLogDadosTitulo logTitulos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  b.pessoa.complemento.cnpj  from ItemLogDadosTitulo b  where b.identificador = :idLogTitulos");
        q.setLong("idLogTitulos", logTitulos.getIdentificador().longValue());
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }

    private static String getCnpjTitulo(Titulo titulo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select  b.pessoa.complemento.cnpj  from Titulo b  where b.identificador = :idTitulo");
        q.setLong("idTitulo", titulo.getIdentificador().longValue());
        q.setMaxResults(1);
        return (String)q.uniqueResult();
    }
}

