/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.atualizacaoformulacoeslinprod;

import com.touchcomp.basementor.model.vo.AtualizacaoFormLinProdItens;
import com.touchcomp.basementor.model.vo.AtualizacaoFormulacoesLinProd;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import org.apache.commons.beanutils.BeanUtils;

public class ServiceAtualizacaoFormulacoesLinProd
extends CoreService {
    public static final String PESQUISAR_FORM_CONTEM_GRADE = "processarPesquisarFormContemGrade";
    public static final String PROCESSAR_SALVAR_NOVAS_FORMULACOES = "processarSalvarNovasFormulacoes";
    public static final String DELETAR_NOVAS_FORMULACOES = "deletarSalvarNovasFormulacoes";

    public List processarPesquisarFormContemGrade(CoreRequestContext cq) {
        List itens = (List)cq.getAttribute("itens");
        for (AtualizacaoFormLinProdItens iten : itens) {
            List grades = CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().pesquisarFormContemGradeCorAtivas(iten.getGradeCorAnt());
            iten.setGradesFormAfetadas(grades);
        }
        return itens;
    }

    public Object processarSalvarNovasFormulacoes(CoreRequestContext cq) throws Exception {
        AtualizacaoFormulacoesLinProd vo = (AtualizacaoFormulacoesLinProd)cq.getAttribute("vo");
        for (AtualizacaoFormLinProdItens iten : vo.getItens()) {
            ArrayList<GradeFormulaProduto> novasGrades = new ArrayList<GradeFormulaProduto>();
            for (GradeFormulaProduto gradesFormAfetada : iten.getGradesFormAfetadas()) {
                GradeFormulaProduto clonada = (GradeFormulaProduto)BeanUtils.cloneBean((Object)gradesFormAfetada);
                this.changeItem(clonada, iten.getGradeCorAnt(), iten.getGradeCorAtu(), iten.getPercAjuste());
                clonada.setAtivo(Short.valueOf((short)1));
                clonada.setDataCadastro(new Date());
                gradesFormAfetada.setAtivo(Short.valueOf((short)0));
                gradesFormAfetada.setFormulacaoPrincipal(Short.valueOf((short)0));
                clonada.setIdentificador(null);
                for (ItemGradeFormulaProduto item : clonada.getItemGradeFormulaProduto()) {
                    item.setIdentificador(null);
                    item.setGradeFormulaProduto(clonada);
                }
                for (ItemGradeFormulaProduto item : clonada.getItemPerda()) {
                    item.setIdentificador(null);
                    item.setGradeFormulaProduto(clonada);
                }
                for (ItemGradeFormulaProduto item : clonada.getItemSobra()) {
                    item.setIdentificador(null);
                    item.setGradeFormulaProduto(clonada);
                }
                for (ItemGradeFormulaProduto item : clonada.getGradeFormProdTpSpedProd()) {
                    item.setIdentificador(null);
                    item.setGradeFormulaProduto(clonada);
                }
                novasGrades.add(clonada);
            }
            iten.setGradesFormGeradas(novasGrades);
        }
        return CoreDAOFactory.getInstance().getDAOAtualizacaoFormulacoesLinProd().saveOrUpdate(vo);
    }

    public Object deletarSalvarNovasFormulacoes(CoreRequestContext cq) throws ExceptionDatabase {
        AtualizacaoFormulacoesLinProd vo = (AtualizacaoFormulacoesLinProd)cq.getAttribute("vo");
        for (AtualizacaoFormLinProdItens iten : vo.getItens()) {
            for (GradeFormulaProduto gradesFormAfetada : iten.getGradesFormAfetadas()) {
                gradesFormAfetada.setAtivo(Short.valueOf((short)1));
                this.changeItem(gradesFormAfetada, iten.getGradeCorAnt(), iten.getGradeCorAtu(), iten.getPercAjuste() * -1.0);
                CoreDAOFactory.getInstance().getDAOGradeFormulaProduto().saveOrUpdate(gradesFormAfetada);
            }
        }
        return null;
    }

    private void changeItem(GradeFormulaProduto clonada, GradeCor gradeCorAnt, GradeCor gradeCorAtu, Double percAjuste) {
        for (ItemGradeFormulaProduto item : clonada.getItemGradeFormulaProduto()) {
            if (!item.getGradeCor().equals((Object)gradeCorAnt)) continue;
            item.setGradeCor(gradeCorAtu);
            item.setQuantidade(Double.valueOf(item.getQuantidade() + item.getQuantidade() * percAjuste / 100.0));
        }
    }
}

