/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.avaliacaoestoqueproduto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueFabricante;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueGC;
import com.touchcomp.basementor.model.vo.GrupoAnaliseEstoqueGCPer;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

class UtilAvaliacaoEstoqueProduto {
    UtilAvaliacaoEstoqueProduto() {
    }

    Object avaliarEstoqueProdutos(List<GrupoAnaliseEstoqueGC> grades, List<Empresa> empresas) {
        ArrayList toRet = new ArrayList();
        for (GrupoAnaliseEstoqueGC analise : grades) {
            Date dataIn = DateUtil.previousDays(analise.getDataFinal(), analise.getDiasAnalise());
            analise.setDataInicial(dataIn);
            List saidas = this.processarSaidas(analise.getGradeCor(), dataIn, analise.getDataFinal(), empresas);
            analise.setPeriodos(saidas);
            this.setQuantidadeTotal(analise);
            this.setLeadTime(analise, empresas);
            if (analise.getInformarManualmente() != null && analise.getInformarManualmente() == 1) continue;
            this.processarEstoque(analise);
        }
        return toRet;
    }

    Object getGradesProdutosPorTipoItemSped(List tipoItemSped, List subEspecies, List fabricantes) {
        List produtos = this.getProdutos(tipoItemSped, subEspecies, fabricantes);
        List<GradeCor> grades = this.verificarGrades(produtos);
        ArrayList<GrupoAnaliseEstoqueGC> toRet = new ArrayList<GrupoAnaliseEstoqueGC>();
        Iterator<GradeCor> iterator = grades.iterator();
        while (iterator.hasNext()) {
            GradeCor o;
            GradeCor gc = o = iterator.next();
            GrupoAnaliseEstoqueGC a = new GrupoAnaliseEstoqueGC();
            a.setGradeCor(gc);
            toRet.add(a);
        }
        return toRet;
    }

    private List<GradeCor> verificarGrades(List<Produto> produtos) {
        ArrayList<GradeCor> resultado = new ArrayList<GradeCor>();
        for (Produto produto : produtos) {
            List principaisAtivas = produto.getGradesProduto().stream().flatMap(g -> g.getGradesCores().stream()).filter(c -> ToolMethods.isEquals((Object)c.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)c.getGradePrincipal(), (Object)EnumConstantsMentorSimNao.SIM.getValue())).collect(Collectors.toList());
            if (!principaisAtivas.isEmpty()) {
                resultado.addAll(principaisAtivas);
                continue;
            }
            List ativas = produto.getGradesProduto().stream().flatMap(g -> g.getGradesCores().stream()).filter(c -> ToolMethods.isEquals((Object)c.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue())).collect(Collectors.toList());
            resultado.addAll(ativas);
        }
        return resultado;
    }

    private List getProdutos(List tiposItemSped, List subespecies, List fabricantes) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(Produto.class);
        Disjunction dis1 = Restrictions.disjunction();
        for (Object o : tiposItemSped) {
            dis1.add((Criterion)Restrictions.eq((String)"tipoIemSped", o));
        }
        Disjunction dis2 = Restrictions.disjunction();
        for (Object o : subespecies) {
            dis2.add((Criterion)Restrictions.eq((String)"subEspecie", o));
        }
        Disjunction dis3 = Restrictions.disjunction();
        for (Object o : fabricantes) {
            GrupoAnaliseEstoqueFabricante g = (GrupoAnaliseEstoqueFabricante)o;
            dis3.add((Criterion)Restrictions.eq((String)"fabricante", (Object)g.getFabricante()));
        }
        c.add((Criterion)dis2);
        c.add((Criterion)dis1);
        c.add((Criterion)dis3);
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        return c.list();
    }

    private List getGrades(List tiposItemSped, List subespecies, List fabricantes) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(GradeCor.class);
        c.createAlias("produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        Disjunction dis1 = Restrictions.disjunction();
        for (Object o : tiposItemSped) {
            dis1.add((Criterion)Restrictions.eq((String)"p.tipoIemSped", o));
        }
        Disjunction dis2 = Restrictions.disjunction();
        for (Object o : subespecies) {
            dis2.add((Criterion)Restrictions.eq((String)"p.subEspecie", o));
        }
        Disjunction dis3 = Restrictions.disjunction();
        for (Object o : fabricantes) {
            GrupoAnaliseEstoqueFabricante g = (GrupoAnaliseEstoqueFabricante)o;
            dis3.add((Criterion)Restrictions.eq((String)"p.fabricante", (Object)g.getFabricante()));
        }
        c.add((Criterion)dis2);
        c.add((Criterion)dis1);
        c.add((Criterion)dis3);
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"p.ativo", (Object)1));
        return c.list();
    }

    private List processarSaidas(GradeCor gc, Date dataIn, Date dataFim, List<Empresa> empresas) {
        LinkedList<GrupoAnaliseEstoqueGCPer> toRet = new LinkedList<GrupoAnaliseEstoqueGCPer>();
        List saidas = ((ServiceSaldoEstoqueImpl)ConfApplicationContext.getBean(ServiceSaldoEstoqueImpl.class)).getProdutosMovimentosDataInicialFinalEmpresas(gc, dataIn, dataFim, empresas);
        for (HashMap h : saidas) {
            Date dataSaldo = (Date)h.get("DATA_MOVIMENTACAO");
            Double quantidadeSaida = (Double)h.get("QUANTIDADE");
            GrupoAnaliseEstoqueGCPer current = new GrupoAnaliseEstoqueGCPer();
            current.setQuantidade(quantidadeSaida);
            current.setDataConsumo(dataSaldo);
            toRet.add(current);
        }
        return toRet;
    }

    public void processarEstoque(GrupoAnaliseEstoqueGC analise) {
        int count = 0;
        count = analise.getDiasAnalise() == null ? 0 : analise.getDiasAnalise();
        double variacao = 0.0;
        for (GrupoAnaliseEstoqueGCPer a : analise.getPeriodos()) {
            System.out.println(a.getQuantidade() + " - " + analise.getMediaConsumo() + " = " + (a.getQuantidade() - analise.getMediaConsumo()));
            variacao += Math.pow(a.getQuantidade() - analise.getMediaConsumo(), 2.0);
        }
        double desvio = Math.sqrt(variacao / (double)(count - 1));
        double estoqueSeg = analise.getFatorSeguranca() * desvio * Math.sqrt((double)analise.getLeadTime().intValue() * 1.0 / (double)analise.getTempoCobertura().intValue());
        double ressuprimento = analise.getMediaConsumo() * (double)analise.getLeadTime().intValue() + estoqueSeg;
        double maximo = (estoqueSeg + analise.getMediaConsumo()) * (double)analise.getLeadTime().intValue();
        if (analise.getNumeroInteiro() == 1) {
            estoqueSeg = ToolFormatter.arrredondarNumero((Double)estoqueSeg, (int)0, (int)0);
            ressuprimento = ToolFormatter.arrredondarNumero((Double)ressuprimento, (int)0, (int)0);
            maximo = ToolFormatter.arrredondarNumero((Double)maximo, (int)0, (int)0);
        }
        analise.setEstoqueMinimo(Double.valueOf(estoqueSeg));
        analise.setEstoqueRessuprimento(Double.valueOf(ressuprimento));
        analise.setEstoqueMaximo(Double.valueOf(maximo));
    }

    private void setQuantidadeTotal(GrupoAnaliseEstoqueGC analise) {
        double total = 0.0;
        for (GrupoAnaliseEstoqueGCPer a : analise.getPeriodos()) {
            total += a.getQuantidade().doubleValue();
        }
        analise.setQuantidadeTotal(Double.valueOf(total));
        analise.setMediaConsumo(Double.valueOf(total / (double)analise.getDiasAnalise().intValue()));
    }

    private void setLeadTime(GrupoAnaliseEstoqueGC analise, List<Empresa> empresas) {
        Integer leadTimeFound = null;
        if (analise.getTipoLeadTime() == 1) {
            leadTimeFound = CoreDAOFactory.getInstance().getDAOLeadTimeFornProduto().getLeadTimeMinimo(analise.getGradeCor(), empresas);
        } else if (analise.getTipoLeadTime() == 2) {
            Double aux = CoreDAOFactory.getInstance().getDAOLeadTimeFornProduto().getLeadTimeMedio(analise.getGradeCor(), empresas);
            aux = aux != null ? Double.valueOf(Math.ceil(aux)) : Double.valueOf(0.0);
            leadTimeFound = (int)aux.doubleValue();
        } else {
            leadTimeFound = CoreDAOFactory.getInstance().getDAOLeadTimeFornProduto().getLeadTimeMaximo(analise.getGradeCor(), empresas);
        }
        if (leadTimeFound != null && leadTimeFound > 0) {
            analise.setLeadTime(leadTimeFound);
        }
    }

    private void mesclar(List saidas, List saidasNota) {
        for (Object o1 : saidasNota) {
            HashMap h1 = (HashMap)o1;
            HashMap found = null;
            Date data1 = (Date)h1.get("DATA_MOVIMENTACAO");
            for (Object o2 : saidas) {
                HashMap h2 = (HashMap)o2;
                Date data2 = (Date)h2.get("DATA_MOVIMENTACAO");
                if (!data1.equals(data2)) continue;
                found = h2;
                break;
            }
            if (found != null) {
                Double d1 = (Double)h1.get("QUANTIDADE");
                Double d2 = (Double)found.get("QUANTIDADE");
                h1.put("QUANTIDADE", d1 + d2);
                saidas.add(h1);
                continue;
            }
            saidas.add(h1);
        }
    }
}

