/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.baixabem;

import com.touchcomp.basementor.model.vo.BaixaBem;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.BemTipoDepreciacao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaBemDepreciacao;
import com.touchcomp.basementor.model.vo.TipoBem;
import com.touchcomp.basementor.model.vo.TipoDepreciacao;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;

class UtilBaixaBem {
    UtilBaixaBem() {
    }

    static BaixaBem saveBaixaBem(BaixaBem baixaBem) throws ExceptionService {
        UtilBaixaBem.desvinculaComponentesSemBaixa(baixaBem);
        return (BaixaBem)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBaixaBem(), baixaBem);
    }

    static JasperPrint gerarListagemBaixasBens(HashMap params, String reportPath) throws ExceptionService {
        Short filtrarDataBaixa = (Short)params.get("FILTRAR_DATA_BAIXA");
        Date dataInicial = (Date)params.get("DATA_INICIAL");
        Date dataFinal = (Date)params.get("DATA_FINAL");
        Short filtrarEmpresa = (Short)params.get("FILTRAR_EMPRESA");
        Long empresaInicial = (Long)params.get("EMPRESA_INICIAL");
        Long empresaFinal = (Long)params.get("EMPRESA_FINAL");
        Short filtrarBem = (Short)params.get("FILTRAR_BEM");
        Long bemInicial = (Long)params.get("BEM_INICIAL");
        Long bemFinal = (Long)params.get("BEM_FINAL");
        List<BaixaBem> baixasBem = CoreDAOFactory.getInstance().getDAOBaixaBem().gerarListagemBaixasBens(filtrarDataBaixa, dataInicial, dataFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarBem, bemInicial, bemFinal);
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", reportPath);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", baixasBem);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
    }

    private static List<Lancamento> getLancamentos(Bem bem, Double valorDepreciacao, PlanoConta planoContaLucro, PlanoConta planoContaPrejuizo, Double valorLucroPrejuizo, Empresa empresa) throws ExceptionService {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        if (valorDepreciacao != 0.0) {
            Lancamento lancamento = CompLancamentoBase.newLancamento((Empresa)empresa);
            lancamento.setHistorico("Valor deprecia\u00e7\u00e3o parcial de baixa referente ao Bem: " + bem.getIdentificador() + " - " + bem.getDescricao());
            PlanoContaBemDepreciacao planoContaBemDepreciacao = null;
            if (bem.getBensTipoDepreciacao() != null && !bem.getBensTipoDepreciacao().isEmpty() && (planoContaBemDepreciacao = UtilBaixaBem.getPlanoContaBemDepr(((BemTipoDepreciacao)bem.getBensTipoDepreciacao().get(0)).getTipoDepreciacao(), bem.getTipoBem())) == null) {
                throw new ExceptionService("Informe no cadastro do Tipo Deprecia\u00e7\u00e3o: " + ((BemTipoDepreciacao)bem.getBensTipoDepreciacao().get(0)).getTipoDepreciacao().getDescricao() + ", as contas cont\u00e1beis referente ao Tipo Bem: " + bem.getTipoBem().getDescricao());
            }
            if (planoContaBemDepreciacao != null) {
                lancamento.setPlanoContaCred(planoContaBemDepreciacao.getPlanoContaDepreciacao());
                lancamento.setPlanoContaDeb(planoContaBemDepreciacao.getPlanoContaDespesa());
                lancamento.setValor(valorDepreciacao);
                lancamentos.add(lancamento);
            }
        }
        if (valorLucroPrejuizo != 0.0) {
            Lancamento lancamentoLucroPrejuizo = CompLancamentoBase.newLancamento((Empresa)empresa);
            lancamentoLucroPrejuizo.setHistorico("Valor " + (planoContaLucro != null ? "lucro " : "prejuizo ") + "referente a baixa do Bem: " + bem.getIdentificador() + " - " + bem.getDescricao());
            lancamentoLucroPrejuizo.setPlanoContaCred(planoContaPrejuizo);
            lancamentoLucroPrejuizo.setPlanoContaDeb(planoContaLucro);
            lancamentoLucroPrejuizo.setValor(valorLucroPrejuizo);
            lancamentos.add(lancamentoLucroPrejuizo);
        }
        if (lancamentos != null && lancamentos.size() > 0) {
            return lancamentos;
        }
        return null;
    }

    private static PlanoContaBemDepreciacao getPlanoContaBemDepr(TipoDepreciacao tipoDepreciacao, TipoBem tipoBem) {
        for (PlanoContaBemDepreciacao planoContaBemDepreciacao : tipoDepreciacao.getPlanoContaBemDepr()) {
            if (!planoContaBemDepreciacao.getTipoBem().equals((Object)tipoBem)) continue;
            return planoContaBemDepreciacao;
        }
        return null;
    }

    private static void desvinculaComponentesSemBaixa(BaixaBem baixaBem) throws ExceptionService {
        for (Bem bem : baixaBem.getBem().getComponentes()) {
            if (UtilBaixaBem.hasBaixa(bem, baixaBem.getBaixasComponentesBem()).booleanValue()) continue;
            bem.setBemPrincipal(null);
            CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBem(), bem);
        }
    }

    private static Boolean hasBaixa(Bem bem, List<BaixaBem> baixasComponentesBem) {
        for (BaixaBem baixaBem : baixasComponentesBem) {
            if (!baixaBem.getBem().getIdentificador().equals(bem.getIdentificador()) || baixaBem.getPercentualBaixa() == null || !(baixaBem.getPercentualBaixa() > 0.0)) continue;
            return true;
        }
        return false;
    }
}

