/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.balanceteversosrazao;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.Lancamento;
import java.util.Date;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;

public class UtilBalanceteVersosRazaoContabil {
    public DefaultMutableTreeNode montarTreeBalancete(List dados) throws ExceptionService {
        DefaultMutableTreeNode df = new DefaultMutableTreeNode(this.getFirstSaldoCantabil());
        this.montaGrupoInternal(df, dados, 1);
        return df;
    }

    private void montaGrupoInternal(DefaultMutableTreeNode contaPrincipal, List<SaldoContaContabil> saldoContabil, int counter) {
        int i = 0;
        for (i = 0; i < saldoContabil.size(); ++i) {
            SaldoContaContabil current = saldoContabil.get(i);
            saldoContabil.remove(current);
            i = -1;
            DefaultMutableTreeNode d = new DefaultMutableTreeNode(current);
            this.setPreviousNode(contaPrincipal, d);
            this.montaGrupoInternal(d, saldoContabil, counter + 1);
        }
    }

    private void setPreviousNode(DefaultMutableTreeNode contaPrincipal, DefaultMutableTreeNode d) {
        if (((SaldoContaContabil)contaPrincipal.getUserObject()).getMarca().equals(EnumConstSinteticoAnalitico.ANALITICO.getValueInt()) && ((SaldoContaContabil)d.getUserObject()).getMarca().equals(EnumConstSinteticoAnalitico.ANALITICO.getValueInt())) {
            contaPrincipal.add(d);
        } else if (((SaldoContaContabil)d.getUserObject()).getMarca().equals(EnumConstSinteticoAnalitico.ANALITICO.getValueInt()) && ((SaldoContaContabil)contaPrincipal.getUserObject()).getMarca().equals(EnumConstSinteticoAnalitico.ANALITICO.getValueInt())) {
            ((DefaultMutableTreeNode)contaPrincipal.getParent()).add(d);
        } else if (((SaldoContaContabil)contaPrincipal.getUserObject()).getMarca().equals(EnumConstSinteticoAnalitico.SINTETICO.getValueInt()) && ((SaldoContaContabil)d.getUserObject()).getMarca().equals(EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) {
            contaPrincipal.add(d);
        } else if ((contaPrincipal = this.sequenciaGrupoConta(contaPrincipal, d)) != null) {
            contaPrincipal.add(d);
        }
    }

    private DefaultMutableTreeNode sequenciaGrupoConta(DefaultMutableTreeNode contaPrincipal, DefaultMutableTreeNode d) {
        DefaultMutableTreeNode grupoPai = null;
        for (TreeNode o : contaPrincipal.getPath()) {
            char[] st1;
            int count = 0;
            DefaultMutableTreeNode old = (DefaultMutableTreeNode)o;
            if (!((SaldoContaContabil)old.getUserObject()).getMarca().equals(EnumConstSinteticoAnalitico.SINTETICO.getValueInt())) continue;
            char[] st = ((SaldoContaContabil)old.getUserObject()).getCodigoPlanoConta().substring(0, 5).toCharArray();
            if (st[4] == (st1 = ((SaldoContaContabil)d.getUserObject()).getCodigoPlanoConta().substring(0, 5).toCharArray())[4]) {
                ++count;
            }
            if (st[3] == st1[3]) {
                ++count;
            }
            if (st[2] == st1[2]) {
                ++count;
            }
            if (st[1] == st1[1]) {
                ++count;
            }
            if (st[0] == st1[0]) {
                ++count;
            }
            if (count > 3) {
                grupoPai = old;
                continue;
            }
            if (!((SaldoContaContabil)old.getUserObject()).getCodigoPlanoConta().equals("0000000000")) continue;
            return old;
        }
        return grupoPai != null && grupoPai.getParent() != null ? (DefaultMutableTreeNode)grupoPai.getParent() : grupoPai;
    }

    List getLancamentosTreeBalancete(Date dataInicial, Date dataFinal, Long idGrupoEmpresa, EnumConstantsTipoSaldo tipoSaldo, Long idCentroResultadoInicial, Long idCentroResultadoFinal, Long idPlanoContaCred, Long idPlanoContaDeb) {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(Lancamento.class);
        c.createAlias("loteContabil", "l");
        c.createAlias("l.grupoEmpresa", "gr");
        c.createAlias("centroResultadoContFin", "centro", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("planoContaDeb", "pcDeb", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("planoContaCred", "pcCred", JoinType.LEFT_OUTER_JOIN);
        c.add(Restrictions.between((String)"l.dataLote", (Object)dataInicial, (Object)dataFinal));
        c.add((Criterion)Restrictions.eq((String)"gr.identificador", (Object)idGrupoEmpresa));
        if (tipoSaldo.value == EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO.value) {
            c.add(Restrictions.between((String)"centro.identificador", (Object)idCentroResultadoInicial, (Object)idCentroResultadoFinal));
        }
        c.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"pcDeb.identificador", (Object)idPlanoContaDeb), (Criterion)Restrictions.eq((String)"pcCred.identificador", (Object)idPlanoContaCred)));
        c.addOrder(Order.asc((String)"l.dataLote"));
        return c.list();
    }

    private SaldoContaContabil getFirstSaldoCantabil() {
        SaldoContaContabil vo = new SaldoContaContabil();
        vo.setCodigoPlanoConta("0000000000");
        vo.setDescricaoPlanoConta("CONTAS BALANCETE");
        vo.setMarca(Integer.valueOf(EnumConstSinteticoAnalitico.SINTETICO.getValueInt()));
        return vo;
    }
}

