/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.boletotitulo;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataParamsBIUser;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.utilities.CoreUtilityFactory;
import org.jboleto.JBoletoBean;

public class ServiceBoletoTitulo
extends CoreService {
    private static final TLogger logger = TLogger.get(ServiceBoletoTitulo.class);
    public static final String SALVAR_E_GERAR_BOLETO_TITULO = "salvarEGerarBoletoTitulo";
    public static final String SALVAR_BOLETO_TITULO = "salvarBoletoTitulo";
    public static final String GERAR_BOLETO_TITULO = "gerarBoletoTitulo";
    public static final String DESATIVA_AND_DESVINCULA_TITULO_BOLETO = "desativarAndDesvinculaTituloBoleto";

    public HashMap salvarEGerarBoletoTitulo(CoreRequestContext r) throws ExceptionService {
        List boletosTitulos = (List)r.getAttribute("boletos");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Short tipoNumero = (Short)r.getAttribute("tipoNumero");
        ArrayList<BoletoTitulo> boletos = new ArrayList<BoletoTitulo>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageErro());
        Boolean criado = true;
        for (Object o : boletosTitulos) {
            BoletoTitulo bb = (BoletoTitulo)o;
            Titulo t = bb.getTitulo();
            if (this.verificarExistTitulo(t)) {
                try {
                    bb.setAtivo(Short.valueOf((short)1));
                    bb = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), bb);
                    CoreBdUtil.getInstance().getSession().flush();
                    bb.setCodigoBarras(CoreUtilityFactory.getUtilityBoleto().getCodigoBarras(bb, tipoNumero));
                    bb = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), bb);
                    boletos.add(bb);
                }
                catch (ExceptionGeracaoTitulos | ExceptionService ex) {
                    logger.error(ex.getMessage());
                    bb.setAtivo(Short.valueOf((short)0));
                    try {
                        bb = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), bb);
                    }
                    catch (ExceptionService ex1) {
                        logger.error(ex.getMessage());
                    }
                    criado = false;
                    sb.append(t.getIdentificador());
                    sb.append(", ");
                }
                continue;
            }
            criado = false;
            sb.append(t.getIdentificador());
        }
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        if (!criado.booleanValue()) {
            retorno.put("BOLETOS_ERROS", sb.toString());
        }
        if (boletos != null && !boletos.isEmpty()) {
            r.setAttribute("boletos", boletos);
            r.setAttribute("usuario", usuario);
            r.setAttribute("empresa", empresa);
            DataOutputBI data = (DataOutputBI)this.gerarBoletoTitulo(r);
            retorno.put("BOLETOS_CORRETOS", data);
            retorno.put("BOLETOS", boletos);
        }
        return retorno;
    }

    public HashMap salvarBoletoTitulo(CoreRequestContext r) throws ExceptionService {
        List boletosTitulos = (List)r.getAttribute("boletos");
        Short tipoNumero = (Short)r.getAttribute("tipoNumero");
        ArrayList<BoletoTitulo> boletos = new ArrayList<BoletoTitulo>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageErro());
        Boolean criado = true;
        for (Object o : boletosTitulos) {
            BoletoTitulo bb = (BoletoTitulo)o;
            Titulo t = bb.getTitulo();
            if (this.verificarExistTitulo(t)) {
                try {
                    bb.setAtivo(Short.valueOf((short)1));
                    bb = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), bb);
                    CoreBdUtil.getInstance().getSession().flush();
                    bb.setCodigoBarras(CoreUtilityFactory.getUtilityBoleto().getCodigoBarras(bb, tipoNumero));
                    bb = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), bb);
                    boletos.add(bb);
                }
                catch (ExceptionGeracaoTitulos | ExceptionService ex) {
                    logger.error(ex.getMessage());
                    bb.setAtivo(Short.valueOf((short)0));
                    try {
                        bb = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), bb);
                    }
                    catch (ExceptionService ex1) {
                        logger.error(ex.getMessage());
                    }
                    criado = false;
                    sb.append(t.getIdentificador());
                    sb.append(", ");
                }
                continue;
            }
            criado = false;
            sb.append(t.getIdentificador());
        }
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        if (!criado.booleanValue()) {
            retorno.put("BOLETOS_ERROS", sb.toString());
        }
        if (boletos != null && !boletos.isEmpty()) {
            retorno.put("BOLETOS", boletos);
        }
        return retorno;
    }

    private boolean verificarExistTitulo(Titulo titulo) throws ExceptionService {
        BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOBoletoTitulo().getVOClass());
        b.and().equal("titulo", titulo);
        b.and().equal("ativo", (short)1);
        List listBoleto = CoreService.executeSearch(b);
        return listBoleto == null || listBoleto.isEmpty();
    }

    public List<DataOutputBI> gerarBoletoTitulo(CoreRequestContext r) throws ExceptionService {
        List listBoletoTitulo = (List)r.getAttribute("boletos");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Grupo grupoUsuarios = (Grupo)r.getAttribute("grupoUsuarios");
        Short tipoNumero = (Short)r.getAttribute("tipoNumero");
        ArrayList<BusinessIntelligence> listBIBoletos = new ArrayList<BusinessIntelligence>();
        ArrayList aux = new ArrayList();
        ArrayList<BoletoTitulo> boletos = new ArrayList<BoletoTitulo>();
        ArrayList<DataOutputBI> listDataOutput = new ArrayList<DataOutputBI>();
        if (listBoletoTitulo != null && !listBoletoTitulo.isEmpty()) {
            for (BoletoTitulo boletoTitulo : listBoletoTitulo) {
                if (listBIBoletos.contains(boletoTitulo.getCarteiraCobranca().getBiVincCarteiraCobranca())) continue;
                listBIBoletos.add(boletoTitulo.getCarteiraCobranca().getBiVincCarteiraCobranca());
            }
            for (BusinessIntelligence businessIntelligence : listBIBoletos) {
                boletos = new ArrayList();
                HashMap<String, Object> hs = new HashMap<String, Object>();
                hs.put("bi", businessIntelligence);
                for (BoletoTitulo bol : listBoletoTitulo) {
                    if (bol.getCarteiraCobranca().getBiVincCarteiraCobranca() == null) {
                        throw new ExceptionService("A Carteira de Cobran\u00e7a " + bol.getCarteiraCobranca().toString() + " n\u00e3o possui nenhum BI de impress\u00e3o de Boleto vinculado!");
                    }
                    if (bol.getCarteiraCobranca().getBiVincCartCobEnvioMassa() == null) {
                        throw new ExceptionService("A Carteira de Cobran\u00e7a " + bol.getCarteiraCobranca().toString() + " n\u00e3o possui nenhum BI de impress\u00e3o de Boleto Envio em Massa vinculado!");
                    }
                    if (!businessIntelligence.equals((Object)bol.getCarteiraCobranca().getBiVincCarteiraCobranca())) continue;
                    boletos.add(bol);
                }
                hs.put("boletos", boletos);
                aux.add(hs);
            }
            try {
                for (HashMap hashMap : aux) {
                    BusinessIntelligence bi = (BusinessIntelligence)hashMap.get("bi");
                    List boletoPorBanco = (List)hashMap.get("boletos");
                    ArrayList<JBoletoBean> listJBoletoBean = new ArrayList<JBoletoBean>();
                    for (BoletoTitulo b : boletoPorBanco) {
                        JBoletoBean j = CoreUtilityFactory.getUtilityBoleto().gerarBoletoBI(b, tipoNumero);
                        listJBoletoBean.add(j);
                    }
                    listDataOutput.add(this.gerarJasperBoleto(listJBoletoBean, bi, empresa, usuario, grupoUsuarios));
                }
            }
            catch (ExceptionGeracaoTitulos ex) {
                logger.error(ex.getMessage());
                throw new ExceptionService("Erro ao gerar os Boletos de Cobran\u00e7a.\n" + ex.getMessage());
            }
        } else {
            throw new ExceptionService("Pesquisa ao menos um boleto de cobran\u00e7a!");
        }
        return listDataOutput;
    }

    public void desativarAndDesvinculaTituloBoleto(CoreRequestContext r) throws ExceptionService {
        BoletoTitulo boleto = (BoletoTitulo)r.getAttribute("boleto");
        CoreDAOFactory.getInstance().getDAOBoletoTitulo().deletarTituloBoleto(boleto);
    }

    private DataOutputBI gerarJasperBoleto(List<JBoletoBean> listJBoletoBean, BusinessIntelligence bi, Empresa empresa, Usuario usuario, Grupo grupoUsuarios) throws ExceptionService {
        try {
            DataOutputBI out = ((ServiceBuildBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBuildBusinessIntelligenceImpl.class)).gerarConverterFormatoImpBI(bi, ConstEnumFormImprBI.PDF, EnumConstTipoSistema.INDIFERE, CompBIDefaultParams.getDefParamsMap((Empresa)empresa, (Usuario)usuario, (Grupo)grupoUsuarios, (Object[])new Object[0]), DataParamsBIUser.newInst().setItOutros("LIST_BOLETO", this.getDadosBoleto(listJBoletoBean)));
            return out;
        }
        catch (ExceptionBuildBI ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService(ex);
        }
    }

    private String getMessageErro() {
        return "Alguns boletos n\u00e3o foram criados por j\u00e1 existirem boletos ativos ou foram criados como inativos e n\u00e3o geraram c\u00f3digos de barras, pois a carteira de cobran\u00e7a do t\u00edtulo n\u00e3o permite essa opera\u00e7\u00e3o! \n Titulos: ";
    }

    private Object getDadosBoleto(List<JBoletoBean> listJBoletoBean) {
        ArrayList lista = new ArrayList();
        for (JBoletoBean j : listJBoletoBean) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("agencia", j.getAgencia());
            h.put("aceite", j.getAceite());
            h.put("acrescimo", j.getAcrescimo());
            h.put("agenciaCodCedenteFormato", j.getAgenciaCodCedenteFormato());
            h.put("bairroCedente", j.getBairroCedente());
            h.put("bairroSacado", j.getBairroSacado());
            h.put("caminho", j.getCaminho());
            h.put("carteira", j.getCarteira());
            h.put("cedente", j.getCedente());
            h.put("cepSacado", j.getCepSacado());
            h.put("cepCedente", j.getCepCedente());
            h.put("cidadeCedente", j.getCidadeCedente());
            h.put("cidadeSacado", j.getCidadeSacado());
            h.put("codCedenteBB", j.getCodCedenteBB());
            h.put("codCliente", j.getCodCliente());
            h.put("codigoBarras", j.getCodigoBarras());
            h.put("codigoFornecidoAgencia", j.getCodigoFornecidoAgencia());
            h.put("codigoOperacao", j.getCodigoOperacao());
            h.put("contaCorrente", j.getContaCorrente());
            h.put("cpfCedente", j.getCpfCedente());
            h.put("cpfSacado", j.getCpfSacado());
            h.put("dataDocumento", j.getDataDocumento());
            h.put("dataProcessamento", j.getDataProcessamento());
            h.put("dataVencimento", j.getDataVencimento());
            h.put("dvContaCorrente", j.getDvContaCorrente());
            h.put("dvAgencia", j.getDvAgencia());
            h.put("dvCodigoFornecidoAgencia", j.getDvCodigoFornecidoAgencia());
            h.put("dvNossoNumero", j.getDvNossoNumero());
            h.put("enderecoCedente", j.getEnderecoCedente());
            h.put("enderecoSacado", j.getEnderecoSacado());
            h.put("enderecoCodBar", j.getEnderecoCodBar());
            h.put("especieDocumento", j.getEspecieDocumento());
            h.put("fatorVencimento", j.getFatorVencimento());
            h.put("ios", j.getIos());
            h.put("IOS", j.getIOS());
            h.put("instrucao1", j.getInstrucao1());
            h.put("instrucao2", j.getInstrucao2());
            h.put("instrucao3", j.getInstrucao3());
            h.put("instrucao4", j.getInstrucao4());
            h.put("instrucao5", j.getInstrucao5());
            h.put("imagemMarketing", j.getImagemMarketing());
            h.put("linhaDigitavel", j.getLinhaDigitavel());
            h.put("localPagamento", j.getLocalPagamento());
            h.put("localPagamento2", j.getLocalPagamento2());
            h.put("modalidadeCobranca", j.getModalidadeCobranca());
            h.put("moeda", j.getMoeda());
            h.put("numConvenio", j.getNumConvenio());
            h.put("nossoNumero", j.getNossoNumero());
            h.put("nrBanco", j.getNrBanco());
            h.put("nomeSacado", j.getNomeSacado());
            h.put("noDocumento", j.getNoDocumento());
            h.put("nossoNumeroCedente", j.getNossoNumeroCedente());
            h.put("nossoNumeroFormato", j.getNossoNumeroFormato());
            h.put("numeroCedente", j.getNumeroCedente());
            h.put("numeroParcela", j.getNumeroParcela());
            h.put("numeroSacado", j.getNumeroSacado());
            h.put("qtdMoeda", j.getQtdMoeda());
            h.put("tipoSaida", j.getTipoSaida());
            h.put("tituloBoletoHtml", j.getTituloBoletoHtml());
            h.put("ufCedente", j.getUfCedente());
            h.put("ufSacado", j.getUfSacado());
            h.put("valorDescontos", j.getValorDescontos());
            h.put("valorBoleto", j.getValorBoleto());
            h.put("valorMoeda", j.getValorMoeda());
            h.put("valorTitulo", j.getValorTitulo());
            h.put("juros", j.getValorJuros());
            h.put("valorCobrado", j.getValorCobrado());
            lista.add(h);
        }
        return lista;
    }
}

